/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.testobject.impl;

import com.kms.katalon.core.testobject.FormDataBodyParameter;
import com.kms.katalon.core.testobject.HttpBodyContent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLConnection;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;

public class HttpFormDataBodyContent
implements HttpBodyContent {
    private static final String DEFAULT_CHARSET = "US-ASCII";
    private MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
    private HttpEntity multipartEntity;
    private String charset = "US-ASCII";

    public HttpFormDataBodyContent(List<FormDataBodyParameter> parameters) throws FileNotFoundException {
        this.multipartEntityBuilder.setContentType(ContentType.MULTIPART_FORM_DATA);
        for (FormDataBodyParameter parameter : parameters) {
            if (parameter.getType().equals("File")) {
                this.multipartEntityBuilder.addBinaryBody(parameter.getName(), (InputStream)new FileInputStream(parameter.getValue()), ContentType.create((String)this.getFileContentType(parameter)), FilenameUtils.getName((String)parameter.getValue()));
                continue;
            }
            String contentType = parameter.getContentType();
            if (StringUtils.isEmpty((CharSequence)contentType)) {
                this.multipartEntityBuilder.addTextBody(parameter.getName(), parameter.getValue());
                continue;
            }
            this.multipartEntityBuilder.addTextBody(parameter.getName(), parameter.getValue(), ContentType.create((String)contentType));
        }
        this.multipartEntity = this.multipartEntityBuilder.build();
    }

    private String getFileContentType(FormDataBodyParameter parameter) {
        try {
            if (StringUtils.isEmpty((CharSequence)parameter.getContentType())) {
                URLConnection connection = new File(parameter.getValue()).toURI().toURL().openConnection();
                return connection.getContentType();
            }
            return parameter.getContentType();
        }
        catch (IOException iOException) {
            return ContentType.DEFAULT_BINARY.getMimeType();
        }
    }

    @Override
    public String getContentType() {
        return this.multipartEntity.getContentType().getValue();
    }

    @Override
    public long getContentLength() {
        return 0L;
    }

    @Override
    public String getContentEncoding() {
        return null;
    }

    @Override
    public InputStream getInputStream() throws IOException, UnsupportedOperationException {
        return this.multipartEntity.getContent();
    }

    @Override
    public void writeTo(OutputStream outstream) throws IOException {
        this.multipartEntity.writeTo(outstream);
    }

    public String getCharset() {
        return this.charset;
    }
}

