/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.util;

import com.kms.katalon.core.util.ConsoleCommandExecutor;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ConsoleCommandBuilder {
    private static final String PATH = "PATH";
    private String beforeCommand;
    private String command;
    private String workingDir;
    private boolean redirectError;
    private Map<String, String> envs = new HashMap<String, String>();
    private String path = "";

    private ConsoleCommandBuilder() {
    }

    public static ConsoleCommandBuilder create(String command) {
        return new ConsoleCommandBuilder().command(command);
    }

    public ConsoleCommandBuilder command(String command) {
        this.command = StringUtils.defaultString((String)command);
        return this;
    }

    public ConsoleCommandBuilder path(String path) {
        this.path = StringUtils.defaultString((String)path);
        return this;
    }

    public ConsoleCommandBuilder addPath(String additionalPath) {
        if (StringUtils.isBlank((CharSequence)additionalPath)) {
            return this;
        }
        this.path = String.valueOf(this.path) + File.pathSeparator + additionalPath;
        return this;
    }

    public ConsoleCommandBuilder envs(Map<String, String> envs) {
        this.envs = envs;
        return this;
    }

    public ConsoleCommandBuilder env(String name, String value) {
        this.envs.put(name, value);
        return this;
    }

    public ConsoleCommandBuilder useSystemEnvs() {
        this.beforeCommand = ConsoleCommandExecutor.getSourcesLoadingCommand();
        return this;
    }

    public ConsoleCommandBuilder workingDir(String workingDir) {
        this.workingDir = workingDir;
        return this;
    }

    public ConsoleCommandBuilder redirectError() {
        return this.redirectError(true);
    }

    public ConsoleCommandBuilder redirectError(boolean redirectError) {
        this.redirectError = redirectError;
        return this;
    }

    private String buildCommand() {
        return StringUtils.isNotBlank((CharSequence)this.beforeCommand) ? String.valueOf(this.beforeCommand) + "; " + this.command : this.command;
    }

    public Process exec() throws IOException {
        this.envs.put(PATH, this.path);
        return ConsoleCommandExecutor.exec(this.buildCommand(), this.workingDir, this.redirectError, this.envs);
    }

    public List<String> execSync() throws IOException, InterruptedException {
        this.envs.put(PATH, this.path);
        return ConsoleCommandExecutor.execSync(this.buildCommand(), this.workingDir, this.redirectError, this.envs);
    }

    public String first() throws IOException, InterruptedException {
        this.envs.put(PATH, this.path);
        List<String> results = ConsoleCommandExecutor.execSync(this.buildCommand(), this.workingDir, this.redirectError, this.envs);
        return results != null && !results.isEmpty() ? results.get(0) : null;
    }
}

