/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.util;

import com.kms.katalon.core.configuration.RunConfiguration;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class FileUtil {
    private static final String ANY_EXTENSION = "*";

    public static File[] getFiles(File folder, String suffix, Date origin) throws IOException {
        final ArrayList filePaths = new ArrayList();
        FileUtil.enumFiles(folder, suffix, origin, new FileProcessor(){

            @Override
            public void process(File f) {
                filePaths.add(f);
            }
        });
        return filePaths.toArray(new File[0]);
    }

    public static void enumFiles(File folder, String suffix, Date origin, FileProcessor fileProcessor) throws IOException {
        if (!folder.isDirectory()) {
            return;
        }
        ArrayList<File> files = new ArrayList<File>();
        files.addAll(Arrays.asList(folder.listFiles()));
        int i = 0;
        while (i < files.size()) {
            File file = (File)files.get(i);
            if (file.isDirectory()) {
                files.addAll(Arrays.asList(file.listFiles()));
            } else if (FileUtil.isFileSatisfy(file, suffix, origin)) {
                fileProcessor.process(file);
            }
            ++i;
        }
    }

    private static boolean isFileSatisfy(File file, String suffix, Date origin) throws IOException {
        boolean satisfyName;
        String fileName = file.getName();
        boolean bl = satisfyName = suffix.equals(ANY_EXTENSION) ? true : fileName.endsWith(suffix);
        if (!satisfyName) {
            return false;
        }
        return FileUtil.isFileCreateAfter(file, origin);
    }

    public static boolean isFileCreateAfter(File file, Date time) throws IOException {
        if (time == null) {
            return true;
        }
        return time.getTime() < Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]).creationTime().toMillis();
    }

    public static int countAllFiles(File folder, String suffix, Date origin) throws IOException {
        final int[] count = new int[1];
        FileUtil.enumFiles(folder, suffix, origin, new FileProcessor(){

            @Override
            public void process(File f) {
                count[0] = count[0] + 1;
            }
        });
        return count[0];
    }

    public static boolean isValidPath(String path) {
        return path != null && new File(path).exists();
    }

    public static boolean fileExists(String root, String pattern) {
        return FileUtil.findFileByName(root, pattern) != null;
    }

    public static File findFileByName(String root, String pattern) {
        return FileUtil.findFile(root, file -> file.getName().matches(pattern));
    }

    public static File findFile(String root, FileFilter filter) {
        return FileUtil.find(root, filter, FileType.FILE);
    }

    public static List<File> findAllFiles(String root, FileFilter filter) {
        return FileUtil.findAll(root, filter, FileType.FILE);
    }

    public static File findFolderByName(String root, String pattern) {
        return FileUtil.findFolder(root, file -> file.getName().matches(pattern));
    }

    public static File findFolder(String root, FileFilter filter) {
        return FileUtil.find(root, filter, FileType.FOLDER);
    }

    public static List<File> findAllFolders(String root, FileFilter filter) {
        return FileUtil.findAll(root, filter, FileType.FOLDER);
    }

    public static File find(String root, FileFilter filter) {
        return FileUtil.find(root, filter, FileType.ANY);
    }

    public static File find(String root, FileFilter filter, FileType type) {
        List<File> matches = FileUtil.findAll(root, filter, type);
        return matches.isEmpty() ? null : matches.get(0);
    }

    public static List<File> findAll(String root, FileFilter filter) {
        return FileUtil.findAll(root, filter, FileType.ANY);
    }

    public static List<File> findAll(String root, final FileFilter filter, final FileType type) {
        if (StringUtils.isBlank((String)root) || !new File(root).exists()) {
            return Collections.emptyList();
        }
        File rootFile = new File(root);
        String[] directories = rootFile.list(new FilenameFilter(){

            @Override
            public boolean accept(File parentFolder, String name) {
                boolean typeCheck;
                File file = new File(parentFolder, name);
                boolean bl = typeCheck = type == FileType.ANY || type == FileType.FILE && !file.isDirectory() || type == FileType.FOLDER && file.isDirectory();
                return filter.test(file) && typeCheck;
            }
        });
        return Arrays.asList(directories).stream().map(subDirectory -> new File(root, (String)subDirectory)).collect(Collectors.toList());
    }

    public static File getFile(String path) {
        File file = new File(path);
        if (file.isAbsolute()) {
            return file;
        }
        if (StringUtils.isNotBlank((String)RunConfiguration.getProjectDir())) {
            return new File(RunConfiguration.getProjectDir(), path);
        }
        return null;
    }

    public static interface FileFilter {
        public boolean test(File var1);
    }

    public static interface FileProcessor {
        public void process(File var1);
    }

    public static enum FileType {
        FILE,
        FOLDER,
        ANY;

    }
}

