/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.util;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.kms.katalon.core.network.HttpClientProxyBuilder;
import com.kms.katalon.core.preferences.ProxyPreferences;
import com.kms.katalon.core.util.HttpClientException;
import com.kms.katalon.logging.LogUtil;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.text.MessageFormat;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;

public class HttpClientUtil {
    public static String executeRequest(HttpUriRequest httpRequest, boolean isSilent) throws ParseException, IOException, URISyntaxException, GeneralSecurityException, HttpClientException {
        HttpClientProxyBuilder httpClientProxyBuilder = HttpClientProxyBuilder.create(ProxyPreferences.getAuthProxyInformation(), httpRequest.getURI().toURL().toString());
        CloseableHttpClient httpClient = httpClientProxyBuilder.getClientBuilder().build();
        HttpResponse httpResponse = httpClient.execute(httpRequest);
        int statusCode = httpResponse.getStatusLine().getStatusCode();
        HttpEntity entity = httpResponse.getEntity();
        String responseString = "";
        if (entity != null) {
            responseString = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (Charset)StandardCharsets.UTF_8);
        }
        if (statusCode == 200 || statusCode == 201 || statusCode == 204) {
            return responseString;
        }
        if (500 <= statusCode && statusCode <= 599) {
            throw new HttpClientException(String.valueOf(statusCode));
        }
        if (!isSilent) {
            LogUtil.logError((String)MessageFormat.format("Unexpected response, URL: {0}, Status: {1}, Response: {2}", httpRequest.getURI().toString(), statusCode, responseString));
        }
        throw new HttpClientException(responseString);
    }

    public static <T> T executeRequest(HttpUriRequest httpRequest, boolean isSilent, Class<T> returnType) throws ParseException, HttpClientException, IOException, URISyntaxException, GeneralSecurityException {
        String responseString = HttpClientUtil.executeRequest(httpRequest, isSilent);
        Gson gson = new GsonBuilder().create();
        return (T)gson.fromJson(responseString, returnType);
    }

    public static <T> T executeRequest(HttpUriRequest httpRequest, Class<T> returnType) throws ParseException, HttpClientException, IOException, URISyntaxException, GeneralSecurityException {
        String responseString = HttpClientUtil.executeRequest(httpRequest, false);
        Gson gson = new GsonBuilder().create();
        return (T)gson.fromJson(responseString, returnType);
    }

    public static <T> T executeRequest(HttpUriRequest httpRequest, boolean isSilent, TypeToken<T> typeToken) throws ParseException, HttpClientException, IOException, URISyntaxException, GeneralSecurityException {
        String responseString = HttpClientUtil.executeRequest(httpRequest, isSilent);
        Gson gson = new GsonBuilder().create();
        return (T)gson.fromJson(responseString, typeToken.getType());
    }

    public static <T> T executeRequest(HttpUriRequest httpRequest, TypeToken<T> typeToken) throws ParseException, HttpClientException, IOException, URISyntaxException, GeneralSecurityException {
        String responseString = HttpClientUtil.executeRequest(httpRequest, false);
        Gson gson = new GsonBuilder().create();
        return (T)gson.fromJson(responseString, typeToken.getType());
    }
}

