/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.util;

import com.kms.katalon.core.util.MimetypesFileTypeMapUtil;
import java.io.File;
import java.io.IOException;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Paths;
import javax.activation.MimetypesFileTypeMap;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class MimeTypeUtil {
    private MimeTypeUtil() {
    }

    public static String getMimeType(String filePath) {
        String mimeType = null;
        mimeType = MimetypesFileTypeMapUtil.getContentType(FilenameUtils.getExtension((String)filePath));
        if (StringUtils.isNotBlank((CharSequence)mimeType)) {
            return mimeType;
        }
        try {
            mimeType = Files.probeContentType(Paths.get(filePath, new String[0]));
            if (StringUtils.isNotBlank((CharSequence)mimeType)) {
                return mimeType;
            }
        }
        catch (IOException iOException) {}
        mimeType = URLConnection.guessContentTypeFromName(filePath);
        if (StringUtils.isNotBlank((CharSequence)mimeType)) {
            return mimeType;
        }
        try {
            URLConnection connection = new File(filePath).toURI().toURL().openConnection();
            mimeType = connection.getContentType();
            if (StringUtils.isNotBlank((CharSequence)mimeType) && !StringUtils.equals((CharSequence)mimeType, (CharSequence)"content/unknown")) {
                return mimeType;
            }
        }
        catch (IOException iOException) {}
        MimetypesFileTypeMap mimeTypesMap = new MimetypesFileTypeMap();
        mimeType = mimeTypesMap.getContentType(filePath);
        if (StringUtils.isNotBlank((CharSequence)mimeType)) {
            return mimeType;
        }
        return mimeType;
    }
}

