/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.util;

import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.util.NameUtil;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.Capabilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestCloudPropertyUtil {
    private static TestCloudPropertyUtil _instance;
    public static final String TEST_CLOUD_KATALON_OPTION = "katalon:option";
    private static final String TC_RUN_FROM_TEST_CLOUD = "runFromTestCloud";
    private static final String SAUCE_LABS_DOC_LINK = "https://docs.saucelabs.com";
    private static final String REMOTE_DRIVER_PROPERTY = "Remote";
    private boolean isRunFromTestCloud = false;
    private static final Logger log;

    static {
        log = LoggerFactory.getLogger(TestCloudPropertyUtil.class);
    }

    private TestCloudPropertyUtil() {
    }

    public static TestCloudPropertyUtil getInstance() {
        if (_instance == null) {
            _instance = new TestCloudPropertyUtil();
        }
        return _instance;
    }

    public boolean isRunFromTestCloud() {
        return this.isRunFromTestCloud;
    }

    public boolean isRunFromTestCloud(Capabilities desiredCapabilities) {
        boolean runFromTestCloud;
        Map katalonOptions = (Map)desiredCapabilities.getCapability(TEST_CLOUD_KATALON_OPTION);
        if (katalonOptions == null || katalonOptions.isEmpty()) {
            this.isRunFromTestCloud = false;
            return false;
        }
        this.isRunFromTestCloud = runFromTestCloud = katalonOptions.getOrDefault(TC_RUN_FROM_TEST_CLOUD, false).booleanValue();
        return runFromTestCloud;
    }

    public boolean isRunFromTestCloud(Map<String, Object> desiredCapabilities) {
        boolean runFromTestCloud;
        Map katalonOptions = (Map)desiredCapabilities.get(TEST_CLOUD_KATALON_OPTION);
        if (katalonOptions == null || katalonOptions.isEmpty()) {
            this.isRunFromTestCloud = false;
            return false;
        }
        this.isRunFromTestCloud = runFromTestCloud = katalonOptions.getOrDefault(TC_RUN_FROM_TEST_CLOUD, false).booleanValue();
        return runFromTestCloud;
    }

    public Map<String, Object> hideTestCloudSensitiveDesiredCapabilities(Map<String, Object> displayCapabilities) {
        Iterator<Map.Entry<String, Object>> iterator = displayCapabilities.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> entry = iterator.next();
            String key = entry.getKey();
            Object value = entry.getValue();
            if (this.containsKeys(key, "app", "lt:options", "LT:Options", "accessKey", "username", "user", "apikey", "jwt", "secret")) {
                iterator.remove();
            }
            if (!(value instanceof Map)) continue;
            Map<String, Object> subCap = (Map<String, Object>)value;
            subCap = this.hideTestCloudSensitiveDesiredCapabilities(subCap);
        }
        return displayCapabilities;
    }

    private boolean containsKeys(String searchKey, String ... keys) {
        String[] stringArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            if (searchKey.equals(key)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void setRunFromTestCloud(Map<String, Object> desiredCapabilities) {
        Map katalonOptions = (Map)desiredCapabilities.get(TEST_CLOUD_KATALON_OPTION);
        this.isRunFromTestCloud = katalonOptions == null || katalonOptions.isEmpty() ? false : katalonOptions.getOrDefault(TC_RUN_FROM_TEST_CLOUD, false);
    }

    public boolean containsSensitiveName(String name) {
        return name.contains("lt://") || name.contains("storage:filename");
    }

    public String hideTestCloudSensitiveName(String name) {
        String censor;
        String sensitiveStr;
        int lastIdx;
        int beginIdx;
        if (RunConfiguration.getDriverPreferencesProperties(REMOTE_DRIVER_PROPERTY) == null || RunConfiguration.getDriverPreferencesProperties(REMOTE_DRIVER_PROPERTY).isEmpty()) {
            return name;
        }
        if (!TestCloudPropertyUtil.getInstance().isRunFromTestCloud(RunConfiguration.getDriverPreferencesProperties(REMOTE_DRIVER_PROPERTY))) {
            return name;
        }
        if (name.toLowerCase().contains("lt://")) {
            try {
                beginIdx = name.indexOf("lt://");
                lastIdx = name.lastIndexOf("\"");
                if (beginIdx != 0 && lastIdx != 0 && lastIdx > beginIdx) {
                    sensitiveStr = name.substring(beginIdx, lastIdx);
                    censor = NameUtil.censor((String)sensitiveStr, (int)sensitiveStr.length());
                    name = name.replace(sensitiveStr, censor);
                }
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
        }
        if (name.toLowerCase().contains("storage:filename")) {
            try {
                beginIdx = name.indexOf("storage:filename");
                lastIdx = name.lastIndexOf("\"");
                if (beginIdx != 0 && lastIdx != 0 && lastIdx > beginIdx) {
                    sensitiveStr = name.substring(beginIdx, lastIdx);
                    censor = NameUtil.censor((String)sensitiveStr, (int)sensitiveStr.length());
                    name = name.replace(sensitiveStr, censor);
                }
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
        }
        return name;
    }

    public String hideSauceLabsDocumentLink(String message) {
        if (!this.isRunFromTestCloud) {
            return message;
        }
        if (StringUtils.containsAny((CharSequence)message, (CharSequence[])new CharSequence[]{"Sauce", "SauceLabs", "saucelabs", "sauce", "Sauce Labs RDC"})) {
            message = NameUtil.censor((String)message, (String)"Sauce Labs RDC", (int)4);
            message = NameUtil.censor((String)message, (String)"SauceLabs", (int)3);
            message = NameUtil.censor((String)message, (String)"Sauce", (int)3);
            message = NameUtil.censor((String)message, (String)"saucelabs", (int)3);
            message = NameUtil.censor((String)message, (String)"sauce", (int)3);
            message = NameUtil.censor((String)message, (String)"api.us-west-1", (int)3);
            message = NameUtil.censor((String)message, (String)"api.eu-central-1", (int)3);
            message = NameUtil.censor((String)message, (String)"api.apac-southeast-1", (int)3);
            message = NameUtil.censor((String)message, (String)"us-east-1", (int)3);
        }
        if (message.contains(SAUCE_LABS_DOC_LINK)) {
            message = NameUtil.censor((String)message, (String)SAUCE_LABS_DOC_LINK, (int)3);
        }
        if (StringUtils.containsAny((CharSequence)message, (CharSequence[])new CharSequence[]{"lambda", "lambdatest", "lambdaTest", "LambdaTest"})) {
            message = NameUtil.censor((String)message, (String)"lambdatest", (int)3);
            message = NameUtil.censor((String)message, (String)"lambdaTest", (int)3);
            message = NameUtil.censor((String)message, (String)"LambdaTest", (int)3);
            message = NameUtil.censor((String)message, (String)"lambda", (int)3);
        }
        return message;
    }

    public void hideConfigurationData(Map<String, String> configurationData) {
        if (configurationData.containsKey("remoteWebDriverUrl")) {
            configurationData.remove("remoteWebDriverUrl");
        }
    }
}

