/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.util.internal;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.kms.katalon.core.constants.StringConstants;
import java.io.Reader;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import org.assertj.core.util.Arrays;

public class JsonUtil {
    public static String toJson(Object src) {
        return JsonUtil.toJson(src, true);
    }

    public static String toJson(Object src, boolean prettyPrint) {
        return JsonUtil.toJson(src, prettyPrint, false);
    }

    public static String toJson(Object src, boolean prettyPrint, boolean excludeFieldsWithoutExposeAnnotation) {
        Gson gson;
        GsonBuilder gsonBuilder = new GsonBuilder();
        if (prettyPrint || excludeFieldsWithoutExposeAnnotation) {
            if (prettyPrint) {
                gsonBuilder = gsonBuilder.setPrettyPrinting();
            }
            if (excludeFieldsWithoutExposeAnnotation) {
                gsonBuilder = gsonBuilder.excludeFieldsWithoutExposeAnnotation();
            }
            gson = gsonBuilder.create();
        } else {
            gson = new Gson();
        }
        return gson.toJson(src);
    }

    public static String toJson(Object src, Type typeOfSrc) {
        return JsonUtil.toJson(src, typeOfSrc, true);
    }

    public static String toJson(Object src, Type typeOfSrc, boolean prettyPrint) {
        Gson gson = prettyPrint ? new GsonBuilder().setPrettyPrinting().create() : new Gson();
        return gson.toJson(src, typeOfSrc);
    }

    public static <T> List<T> fromJsonArray(String json, Class<T[]> arrayType) {
        T[] items = JsonUtil.fromJson(json, arrayType);
        return Arrays.asList(items);
    }

    public static <T> T fromJson(String json, Type typeOfT) throws IllegalArgumentException {
        try {
            return (T)new Gson().fromJson(json, typeOfT);
        }
        catch (JsonSyntaxException e) {
            throw new IllegalArgumentException(MessageFormat.format(StringConstants.EXC_MSG_INVALID_JSON_SYNTAX, e.getMessage()));
        }
    }

    public static <T> T fromJson(Reader reader, Type typeOfT) throws IllegalArgumentException {
        try {
            return (T)new Gson().fromJson(reader, typeOfT);
        }
        catch (JsonSyntaxException e) {
            throw new IllegalArgumentException(MessageFormat.format(StringConstants.EXC_MSG_INVALID_JSON_SYNTAX, e.getMessage()));
        }
    }

    public static <T> T fromJson(Reader reader, Class<T> classOfT) throws IllegalArgumentException {
        try {
            return (T)new Gson().fromJson(reader, classOfT);
        }
        catch (JsonSyntaxException e) {
            throw new IllegalArgumentException(MessageFormat.format(StringConstants.EXC_MSG_INVALID_JSON_SYNTAX, e.getMessage()));
        }
    }

    public static <T> T fromJson(String json, Class<T> classOfT) throws IllegalArgumentException {
        try {
            return (T)new Gson().fromJson(json, classOfT);
        }
        catch (JsonSyntaxException e) {
            throw new IllegalArgumentException(MessageFormat.format(StringConstants.EXC_MSG_INVALID_JSON_SYNTAX, e.getMessage()));
        }
    }

    public static JsonObject toJsonObject(Object src) {
        Gson gson = new Gson();
        return gson.toJsonTree(src).getAsJsonObject();
    }

    public static void mergeJsonObject(JsonObject src, JsonObject dst) {
        for (Map.Entry entry : src.entrySet()) {
            dst.add((String)entry.getKey(), (JsonElement)entry.getValue());
        }
    }

    public static boolean isValidJsonObject(String json) {
        Object parsedObject;
        block3: {
            try {
                parsedObject = new Gson().fromJson(json, Object.class);
                if (parsedObject != null) break block3;
                return false;
            }
            catch (JsonSyntaxException jsonSyntaxException) {
                return false;
            }
        }
        Class<?> type = parsedObject.getClass();
        return Map.class.isAssignableFrom(type);
    }
}

