/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.validation.dialog;

import com.kms.katalon.composer.components.impl.dialogs.AbstractDialog;
import com.kms.katalon.validation.domain.IValidationSurvey;
import com.kms.katalon.validation.domain.ValidationSurveyOption;
import com.kms.katalon.validation.domain.ValidationSurveyQuestion;
import com.kms.katalon.validation.exception.UseCaseException;
import com.kms.katalon.validation.usecase.adapter.IGatherMultipleChoiceSurveyResultUseCase;
import com.kms.katalon.validation.usecase.adapter.input.GatherMultiplechoiceSurveyResultInput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class MultipleChoiceSurveyDialog
extends AbstractDialog {
    private IValidationSurvey surveyInfo;
    private IGatherMultipleChoiceSurveyResultUseCase gatherMultipleChoiceSurveyResultUseCase;
    private boolean userDidNotWantToSeeSurveysLikeThis = false;

    public MultipleChoiceSurveyDialog(Shell parentShell, IValidationSurvey surveyInfo, IGatherMultipleChoiceSurveyResultUseCase gatherMultipleChoiceSurveyResultUseCase) {
        super(parentShell);
        this.surveyInfo = surveyInfo;
        this.gatherMultipleChoiceSurveyResultUseCase = gatherMultipleChoiceSurveyResultUseCase;
    }

    protected Control createDialogContainer(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout glContainer = new GridLayout();
        glContainer.verticalSpacing = 5;
        container.setLayout((Layout)glContainer);
        Composite contentComposite = new Composite(container, 0);
        GridLayout glContent = new GridLayout(1, false);
        glContent.verticalSpacing = 10;
        glContent.marginLeft = 15;
        contentComposite.setLayout((Layout)glContent);
        Label lblQuestionMsg = new Label(contentComposite, 64);
        GridData gdLblQuestionMsg = new GridData(4, 128, true, false, 1, 1);
        gdLblQuestionMsg.widthHint = 550;
        lblQuestionMsg.setText(this.surveyInfo.getText());
        lblQuestionMsg.setLayoutData((Object)gdLblQuestionMsg);
        Composite chckComposite = new Composite(container, 64);
        GridLayout glChckComposite = new GridLayout();
        glChckComposite.verticalSpacing = 10;
        chckComposite.setLayout((Layout)glChckComposite);
        this.surveyInfo.getQuestions().forEach(question -> this.buildQuestionComposite(chckComposite, (ValidationSurveyQuestion)question, 1));
        return container;
    }

    private Composite buildQuestionComposite(Composite parentComposite, ValidationSurveyQuestion question, int currentLevel) {
        Composite questionComposite = new Composite(parentComposite, 0);
        GridLayout gLQuestionComposite = new GridLayout();
        gLQuestionComposite.marginLeft = 10 * currentLevel;
        GridData gdQuestionComposite = new GridData(4, 128, true, false);
        gdQuestionComposite.widthHint = 550 - 10 * currentLevel;
        questionComposite.setLayout((Layout)gLQuestionComposite);
        questionComposite.setLayoutData((Object)gdQuestionComposite);
        Label lblQuestion = new Label(questionComposite, 64);
        lblQuestion.setText(question.getContent());
        GridData gdQuestion = new GridData(4, 128, true, false);
        lblQuestion.setLayoutData((Object)gdQuestion);
        Group optionComposite = new Group(questionComposite, 0);
        GridLayout optionCompositeGridLayout = new GridLayout();
        optionCompositeGridLayout.marginLeft = 10 * currentLevel + 15;
        GridData optionCompositeGdData = new GridData(4, 128, true, false);
        optionComposite.setLayout((Layout)optionCompositeGridLayout);
        optionComposite.setLayoutData((Object)optionCompositeGdData);
        List options = question.getOptions();
        ArrayList<Button> btnOptions = new ArrayList<Button>();
        int i = 0;
        while (i < options.size()) {
            int currentOption = i;
            ValidationSurveyOption option = (ValidationSurveyOption)options.get(currentOption);
            Button btnOption2 = new Button((Composite)optionComposite, 80);
            GridData gdBtnOption = new GridData(4, 128, true, false, 1, 1);
            gdBtnOption.widthHint = 550 - (10 * currentLevel + 15);
            btnOption2.setLayoutData((Object)gdBtnOption);
            btnOption2.setText(option.getOptionText());
            this.attachComputeResultHandlerToButton(currentLevel, currentOption, btnOption2);
            if (option.isUserCanInputText()) {
                Text txtUserElaboratedText = new Text((Composite)optionComposite, 2114);
                GridData gdUserElaboratedText = new GridData(4, 4, true, false);
                gdUserElaboratedText.heightHint = 40;
                txtUserElaboratedText.setLayoutData((Object)gdUserElaboratedText);
                String userElaboratedInputMessage = StringUtils.isEmpty((CharSequence)option.getUserInputPlaceHolder()) ? "" : option.getUserInputPlaceHolder();
                txtUserElaboratedText.setMessage(userElaboratedInputMessage);
                this.attachComputeResultHandlerToTextBox(currentLevel, currentOption, txtUserElaboratedText);
            }
            List<Composite> subQuestionsComposite = this.buildSubQuestionsComposite(currentLevel, (Composite)optionComposite, option);
            btnOption2.setData(subQuestionsComposite);
            btnOptions.add(btnOption2);
            ++i;
        }
        btnOptions.forEach(btnOption -> this.attachSubQuestionsVisibilityHandlerToButton((List<Button>)btnOptions, (Button)btnOption));
        return questionComposite;
    }

    private void attachSubQuestionsVisibilityHandlerToButton(List<Button> bntOptions, Button btnOption) {
        btnOption.addSelectionListener((SelectionListener)new SubQuestionVisibilityHandler(bntOptions, btnOption));
    }

    private void attachComputeResultHandlerToTextBox(final int currentLevel, final int currentOption, final Text txtUserElaboratedText) {
        txtUserElaboratedText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String userElaboratedText = txtUserElaboratedText.getText();
                if (!StringUtils.isEmpty((CharSequence)userElaboratedText)) {
                    MultipleChoiceSurveyDialog.this.computeResult(currentLevel, currentOption, userElaboratedText);
                }
            }
        });
    }

    private void attachComputeResultHandlerToButton(final int currentLevel, final int currentOption, Button btnOption) {
        btnOption.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MultipleChoiceSurveyDialog.this.computeResult(currentLevel, currentOption, "");
            }
        });
    }

    private List<Composite> buildSubQuestionsComposite(int currentLevel, Composite optionComposite, ValidationSurveyOption option) {
        if (option.getSubQuestions() != null) {
            ValidationSurveyQuestion subQuestion = option.getSubQuestions();
            Composite subQuestionComposite = this.buildQuestionComposite(optionComposite, subQuestion, currentLevel + 1);
            this.controlCompositeVisibility(subQuestionComposite, false);
            return Arrays.asList(subQuestionComposite);
        }
        return new ArrayList<Composite>();
    }

    private void controlCompositeVisibility(Composite subQuestionComposite, boolean shouldShow) {
        ((GridData)subQuestionComposite.getLayoutData()).exclude = !shouldShow;
        subQuestionComposite.setVisible(shouldShow);
        subQuestionComposite.getParent().pack();
        this.redrawComposite();
    }

    private void redrawComposite() {
        this.getShell().pack();
    }

    private void computeResult(int currentLevel, int currentOption, String userElaboratedText) {
        try {
            GatherMultiplechoiceSurveyResultInput input = new GatherMultiplechoiceSurveyResultInput(Integer.valueOf(currentLevel), Integer.valueOf(currentOption), userElaboratedText);
            this.gatherMultipleChoiceSurveyResultUseCase.computeResult(input);
        }
        catch (UseCaseException e1) {
            System.out.println(e1.getMessage());
        }
    }

    protected void registerControlModifyListeners() {
    }

    protected void setInput() {
    }

    public IGatherMultipleChoiceSurveyResultUseCase getGatherMultipleChoiceSurveyResultUseCase() {
        return this.gatherMultipleChoiceSurveyResultUseCase;
    }

    protected Point getInitialLocation(Point initialSize) {
        Display display = PlatformUI.getWorkbench().getDisplay();
        Rectangle screen = display.getMonitors()[0].getBounds();
        return new Point(screen.width, 0);
    }

    protected Button createCheckboxButton(Composite parent, int id, String label, boolean defaultButton) {
        Shell shell;
        ++((GridLayout)parent.getLayout()).numColumns;
        Button button = new Button(parent, 32);
        button.setText(label);
        button.setFont(JFaceResources.getDialogFont());
        button.setData((Object)id);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MultipleChoiceSurveyDialog.this.buttonPressed((Integer)event.widget.getData());
            }
        });
        if (defaultButton && (shell = parent.getShell()) != null) {
            shell.setDefaultButton(button);
        }
        this.setButtonLayoutData(button);
        return button;
    }

    protected boolean isResizable() {
        return true;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        parent.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Button btnUserDoNotWantToSeeSurveysLikeThis = this.createCheckboxButton(parent, 3, "I don't want to see surveys like this", false);
        btnUserDoNotWantToSeeSurveysLikeThis.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MultipleChoiceSurveyDialog.this.userDidNotWantToSeeSurveysLikeThis = true;
            }
        });
        Label spacer = new Label(parent, 0);
        spacer.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        GridLayout layout = (GridLayout)parent.getLayout();
        ++layout.numColumns;
        layout.makeColumnsEqualWidth = false;
        this.createButton(parent, 1, "Cancel", false);
        this.createButton(parent, 0, "Send", true);
        this.redrawComposite();
    }

    public boolean userNotWantToSeeSurveysLikeThis() {
        return this.userDidNotWantToSeeSurveysLikeThis;
    }

    private class SubQuestionVisibilityHandler
    implements SelectionListener {
        private Button button;
        private List<Button> buttons;

        public SubQuestionVisibilityHandler(List<Button> buttons, Button button) {
            this.button = button;
            this.buttons = buttons;
        }

        public void widgetSelected(SelectionEvent e) {
            boolean shouldShow = this.button.getSelection();
            List subQuestionsComposite = (List)this.button.getData();
            subQuestionsComposite.forEach(c -> MultipleChoiceSurveyDialog.this.controlCompositeVisibility((Composite)c, shouldShow));
            this.buttons.stream().filter(btn -> !btn.equals(this.button)).forEach(btn -> {
                List subQ = (List)btn.getData();
                subQ.forEach(c -> MultipleChoiceSurveyDialog.this.controlCompositeVisibility((Composite)c, false));
            });
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

