/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.validation.mechanism;

import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.composer.validation.dialog.MultipleChoiceSurveyDialog;
import com.kms.katalon.tracking.validation.adapter.IValidationService;
import com.kms.katalon.validation.datasource.adapter.IFilterSurveysDataSource;
import com.kms.katalon.validation.datasource.adapter.IGetSpecificationFileDataSource;
import com.kms.katalon.validation.datasource.adapter.IInsertEventIntoDatabaseDataSource;
import com.kms.katalon.validation.datasource.adapter.IParseSpecificationFileToSurveysDataSource;
import com.kms.katalon.validation.datasource.provider.ValidationDataSourceProvider;
import com.kms.katalon.validation.domain.IValidationSurvey;
import com.kms.katalon.validation.domain.ValidationSurveyType;
import com.kms.katalon.validation.exception.UseCaseException;
import com.kms.katalon.validation.exception.ValidationException;
import com.kms.katalon.validation.usecase.adapter.IFilterSurveysUseCase;
import com.kms.katalon.validation.usecase.adapter.IGatherMultipleChoiceSurveyResultUseCase;
import com.kms.katalon.validation.usecase.adapter.IGetSpecificationFileUseCase;
import com.kms.katalon.validation.usecase.adapter.IInsertEventIntoDatabaseUseCase;
import com.kms.katalon.validation.usecase.adapter.IParseSpecificationFileToSurveysUseCase;
import com.kms.katalon.validation.usecase.adapter.input.FilterSurveysUseCaseInput;
import com.kms.katalon.validation.usecase.adapter.input.GetSpecificationFileInput;
import com.kms.katalon.validation.usecase.adapter.input.InsertEventIntoDatabaseInput;
import com.kms.katalon.validation.usecase.adapter.input.ParseSpecificationFileToSurveysInput;
import com.kms.katalon.validation.usecase.adapter.output.GatherMultiplechoiceSurveyResultOutput;
import com.kms.katalon.validation.usecase.adapter.output.GetSpecificationFileOutput;
import com.kms.katalon.validation.usecase.adapter.output.ParseSpecificationFileToSurveysOutput;
import com.kms.katalon.validation.usecase.impl.FilterSurveysUseCase;
import com.kms.katalon.validation.usecase.impl.GatherMultipleChoiceSurveyResultUseCase;
import com.kms.katalon.validation.usecase.impl.GetSpecificationFileUseCase;
import com.kms.katalon.validation.usecase.impl.InsertEventIntoDatabaseUseCase;
import com.kms.katalon.validation.usecase.impl.ParseSpecificationFileToSurveysUseCase;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.swt.widgets.Display;

public class ValidationMechanism
implements IValidationService {
    private static ValidationMechanism _instance;
    private IGetSpecificationFileUseCase getSpecificationFileUseCase;
    private IInsertEventIntoDatabaseUseCase insertEventIntoDatabaseUseCase;
    private IParseSpecificationFileToSurveysUseCase parseSpecificationFileToSurveysUseCase;
    private IFilterSurveysUseCase filterSurveysUseCase;
    private String pathToValidationInfoStorage = "";
    private List<IValidationSurvey> surveys = Collections.emptyList();

    public static ValidationMechanism getInstance() {
        if (_instance == null) {
            _instance = new ValidationMechanism();
        }
        return _instance;
    }

    private ValidationMechanism() {
    }

    public void initialize(String userDir) throws ValidationException {
        try {
            this.pathToValidationInfoStorage = String.valueOf(userDir) + File.separator + "validation";
            new File(this.pathToValidationInfoStorage).mkdirs();
            ValidationDataSourceProvider.getInstance().initializeDataSources(this.pathToValidationInfoStorage);
            this.initializeGetSpecificationFileUseCase();
            this.initializeInsertEventIntoDatabaseUseCase();
            this.initializeFilterSurveysUseCase();
            this.initializeParseSpecificationFileToSurveysUseCase();
            String specificationFileLocation = this.getSpecificationFileUseCase().getAbsolutePath();
            this.parseSpecificationFileToSurveysUseCase(specificationFileLocation);
        }
        catch (Exception e) {
            throw new ValidationException(e);
        }
    }

    private void initializeInsertEventIntoDatabaseUseCase() {
        IInsertEventIntoDatabaseDataSource insertEventIntoDatabaseDataSource = ValidationDataSourceProvider.getInstance().insertEventIntoDatabaseDataSource();
        this.insertEventIntoDatabaseUseCase = new InsertEventIntoDatabaseUseCase(insertEventIntoDatabaseDataSource);
    }

    private void initializeFilterSurveysUseCase() {
        IFilterSurveysDataSource filterSurveysDataSource = ValidationDataSourceProvider.getInstance().filterSurveysDataSource();
        this.filterSurveysUseCase = new FilterSurveysUseCase(filterSurveysDataSource);
    }

    private void initializeGetSpecificationFileUseCase() {
        IGetSpecificationFileDataSource getSpecificationFileDataSource = ValidationDataSourceProvider.getInstance().getSpecificationFileDataSource();
        this.getSpecificationFileUseCase = new GetSpecificationFileUseCase(getSpecificationFileDataSource);
    }

    private void initializeParseSpecificationFileToSurveysUseCase() {
        IParseSpecificationFileToSurveysDataSource parseSpecificationFileToSurveysDataSource = ValidationDataSourceProvider.getInstance().parseSpecificationFileToSurveysDataSource();
        this.parseSpecificationFileToSurveysUseCase = new ParseSpecificationFileToSurveysUseCase(parseSpecificationFileToSurveysDataSource);
    }

    private File getSpecificationFileUseCase() throws ValidationException {
        GetSpecificationFileOutput output;
        try {
            String validationEndpoint = ApplicationInfo.getAppProperty((String)"validation_endpoint");
            File tmpFile = Files.createTempFile("specification", "", new FileAttribute[0]).toFile();
            tmpFile.deleteOnExit();
            if (validationEndpoint == null) {
                validationEndpoint = "https://backend.katalon.com/validation_endpoint";
                ApplicationInfo.setAppProperty((String)"validation_endpoint", (String)validationEndpoint, (boolean)true);
            }
            GetSpecificationFileInput input = new GetSpecificationFileInput(validationEndpoint, "", tmpFile.getAbsolutePath());
            output = this.getSpecificationFileUseCase.getSpecificationFile(input);
        }
        catch (UseCaseException | IOException e) {
            throw new ValidationException((Exception)e);
        }
        return output.getSpecificationFile();
    }

    public void insertEventIntoDatabaseUseCase(String eventName, Object ... properties) throws ValidationException {
        InsertEventIntoDatabaseInput input = new InsertEventIntoDatabaseInput(eventName, properties);
        try {
            this.insertEventIntoDatabaseUseCase.insertEvent(input);
        }
        catch (UseCaseException e) {
            throw new ValidationException(e);
        }
    }

    public Map<String, Object[]> triggerSurveysAndGetUserResponseEvents(String eventName) throws ValidationException {
        List<IValidationSurvey> filteredSurveys = this.filterSurveysUseCase(eventName);
        final HashMap<String, Object[]> surveyResponsesMap = new HashMap<String, Object[]>();
        for (final IValidationSurvey survey : filteredSurveys) {
            Display.getDefault().syncExec((Runnable)new UseCaseExecutingRunnable<UseCaseException>(){

                @Override
                public void runThrows() throws UseCaseException {
                    if (survey.getType().equals((Object)ValidationSurveyType.MULTIPLE_CHOICE)) {
                        MultipleChoiceSurveyDialog surveyDialog = new MultipleChoiceSurveyDialog(Display.getDefault().getActiveShell(), survey, (IGatherMultipleChoiceSurveyResultUseCase)new GatherMultipleChoiceSurveyResultUseCase(survey));
                        surveyDialog.setBlockOnOpen(true);
                        if (surveyDialog.open() == 0) {
                            ValidationMechanism.this.markSurveyAsShown(survey.getSurveyId());
                            GatherMultiplechoiceSurveyResultOutput output = surveyDialog.getGatherMultipleChoiceSurveyResultUseCase().getMultipleChoiceSurveyResult();
                            Map results = output.getResult();
                            List<Object> properties = this.extractEventProperties(surveyResponsesMap, surveyDialog, output, results);
                            surveyResponsesMap.put(output.getSurveyId(), properties.toArray());
                        }
                    }
                }

                private List<Object> extractEventProperties(Map<String, Object[]> surveyResponsesMap2, MultipleChoiceSurveyDialog surveyDialog, GatherMultiplechoiceSurveyResultOutput output, Map<String, Object> results) {
                    if (surveyDialog.userNotWantToSeeSurveysLikeThis()) {
                        surveyResponsesMap2.put("ksv_userDidNotWantToSeeSurveysLikeThis", null);
                    }
                    ArrayList<Object> properties = new ArrayList<Object>();
                    properties.add("survey");
                    properties.add(output.getVersion());
                    results.entrySet().stream().forEach(e -> {
                        properties.add(e.getKey());
                        properties.add(e.getValue());
                    });
                    return properties;
                }
            });
        }
        return surveyResponsesMap;
    }

    private void markSurveyAsShown(String surveyId) {
        Properties validationProperties = ValidationDataSourceProvider.getInstance().getValidationProperties();
        validationProperties.setProperty(surveyId, "true");
    }

    private List<IValidationSurvey> filterSurveysUseCase(String eventName) throws ValidationException {
        List<IValidationSurvey> allSurveys = this.getAllSurveys();
        FilterSurveysUseCaseInput input = new FilterSurveysUseCaseInput(allSurveys, eventName);
        try {
            return this.filterSurveysUseCase.filterSurveys(input).getFilteredSurveys();
        }
        catch (UseCaseException e) {
            throw new ValidationException(e);
        }
    }

    private void parseSpecificationFileToSurveysUseCase(String path) throws ValidationException {
        ParseSpecificationFileToSurveysOutput output;
        ParseSpecificationFileToSurveysInput input = new ParseSpecificationFileToSurveysInput(path);
        try {
            output = this.parseSpecificationFileToSurveysUseCase.parseSpecificationFileToSurveys(input);
        }
        catch (UseCaseException e) {
            throw new ValidationException(e);
        }
        this.surveys = output.getSurveys();
    }

    private List<IValidationSurvey> getAllSurveys() {
        return this.surveys;
    }

    public void closeValidationMechanism() throws ValidationException {
        try {
            ValidationDataSourceProvider.getInstance().close();
        }
        catch (IOException | SQLException e) {
            throw new ValidationException(e);
        }
    }

    @FunctionalInterface
    private static interface UseCaseExecutingRunnable<E extends UseCaseException>
    extends Runnable {
        @Override
        default public void run() throws RuntimeException {
            try {
                this.runThrows();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        public void runThrows() throws E;
    }
}

