/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ansiconsole.listeners;

import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.console.IPatternMatchListenerDelegate;
import org.eclipse.ui.console.PatternMatchEvent;
import org.eclipse.ui.console.TextConsole;

public class SmartXPathPatternMatchListenerDelegate
implements IPatternMatchListenerDelegate {
    private static final String LOG_PREFIX = "[SMART_XPATH] Screenshot: ";
    private static final String SCREENSHOT_EXTENSION = ".png";
    private TextConsole console;

    public void connect(TextConsole console) {
        this.console = console;
    }

    public void disconnect() {
        this.console = null;
    }

    public void matchFound(PatternMatchEvent event) {
        try {
            String log = this.console.getDocument().get(event.getOffset(), event.getLength());
            String screenshotPath = String.valueOf(log.substring(LOG_PREFIX.length() - 1, log.lastIndexOf(SCREENSHOT_EXTENSION))) + SCREENSHOT_EXTENSION;
            screenshotPath = screenshotPath.trim();
            int screenshotPathOffset = event.getOffset() + LOG_PREFIX.length();
            IHyperlink hyperlink = SmartXPathPatternMatchListenerDelegate.makeHyperlink(screenshotPath);
            this.console.addHyperlink(hyperlink, screenshotPathOffset, screenshotPath.length());
        }
        catch (BadLocationException badLocationException) {}
    }

    private static IHyperlink makeHyperlink(final String screenshotPath) {
        return new IHyperlink(){

            public void linkExited() {
            }

            public void linkEntered() {
            }

            public void linkActivated() {
                try {
                    if (Desktop.isDesktopSupported()) {
                        File screenshotFile = new File(screenshotPath);
                        Desktop.getDesktop().open(screenshotFile);
                    }
                }
                catch (IOException e) {
                    MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)"Unable to open screenshot", (String)e.getClass().getSimpleName());
                }
            }
        };
    }
}

