/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.activation.plugin.plugin.basicreport;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.kms.katalon.activation.plugin.models.KStorePlugin;
import com.kms.katalon.activation.plugin.models.Plugin;
import com.kms.katalon.activation.plugin.service.KStorePluginDeserialization;
import com.kms.katalon.activation.plugin.util.PluginFactory;
import com.kms.katalon.custom.factory.CustomKeywordPluginFactory;
import com.kms.katalon.custom.keyword.CustomKeywordPlugin;
import com.kms.katalon.logging.LogUtil;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class InstallBasicReportPluginHandler {
    public void doInstallBasicReportPlugin() {
        try {
            if (!this.isBasicReportPluginInstalled()) {
                KStorePlugin plugin = this.getPlugin();
                CustomKeywordPlugin customKeywordPlugin = new CustomKeywordPlugin();
                customKeywordPlugin.setId(Long.toString(plugin.getId()));
                customKeywordPlugin.setPluginFile(plugin.getFile());
                CustomKeywordPluginFactory.getInstance().addPluginFile(plugin.getFile(), customKeywordPlugin);
                Plugin resolvedPlugin = new Plugin();
                resolvedPlugin.setName(plugin.getProduct().getName());
                resolvedPlugin.setOnline(false);
                resolvedPlugin.setFile(plugin.getFile());
                CustomKeywordPluginFactory.getInstance().addPluginFile(plugin.getFile(), customKeywordPlugin);
                PluginFactory.getInstance().addPlugin(resolvedPlugin);
            }
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e);
        }
    }

    private KStorePlugin getPlugin() throws IOException {
        Bundle bundle = FrameworkUtil.getBundle(InstallBasicReportPluginHandler.class);
        Path pluginFolderPath = new Path("/resources/basic-report");
        URL pluginFolderUrl = FileLocator.find((Bundle)bundle, (IPath)pluginFolderPath, null);
        File pluginFolder = FileUtils.toFile((URL)FileLocator.toFileURL((URL)pluginFolderUrl));
        File pluginDescriptionFile = FileUtils.getFile((File)pluginFolder, (String[])new String[]{"description.json"});
        String descriptionContent = FileUtils.readFileToString((File)pluginDescriptionFile);
        Gson gson = new GsonBuilder().registerTypeAdapter(KStorePlugin.class, (Object)new KStorePluginDeserialization()).setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
        KStorePlugin plugin = (KStorePlugin)gson.fromJson(descriptionContent, KStorePlugin.class);
        File pluginFile = FileUtils.getFile((File)pluginFolder, (String[])new String[]{"katalon-studio-report-plugin.jar"});
        plugin.setFile(pluginFile);
        return plugin;
    }

    private boolean isBasicReportPluginInstalled() {
        List<Plugin> plugins = PluginFactory.getInstance().getPlugins();
        return plugins.stream().filter(p -> p.getName().equals("katalon-studio-report-plugin.jar")).findFirst().isPresent();
    }
}

