/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.activation.plugin.service;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.kms.katalon.activation.plugin.constant.ActivationMessageConstants;
import com.kms.katalon.activation.plugin.models.KStoreClientException;
import com.kms.katalon.activation.plugin.models.KStoreClientExceptionWithInfo;
import com.kms.katalon.activation.plugin.models.KStoreCredentials;
import com.kms.katalon.activation.plugin.models.KStorePlugin;
import com.kms.katalon.activation.plugin.models.KStoreProduct;
import com.kms.katalon.activation.plugin.models.KStoreProductID;
import com.kms.katalon.activation.plugin.models.KatalonStoreToken;
import com.kms.katalon.activation.plugin.service.KStorePluginDeserialization;
import com.kms.katalon.activation.plugin.service.LogService;
import com.kms.katalon.activation.plugin.util.KStoreTokenService;
import com.kms.katalon.activation.plugin.util.KStoreUrls;
import com.kms.katalon.core.model.KatalonPackage;
import com.kms.katalon.core.network.HttpClientProxyBuilder;
import com.kms.katalon.core.network.ProxyInformation;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.execution.preferences.ProxyPreferences;
import com.kms.katalon.license.models.LicenseType;
import com.kms.katalon.logging.LogUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.text.ParseException;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.eclipse.swt.program.Program;

public class KStoreRestClient {
    private KStoreCredentials credentials;

    public KStoreRestClient(KStoreCredentials credentials) {
        this.credentials = credentials;
    }

    public List<KStorePlugin> getLatestPlugins(String appVersion, KatalonPackage katalonPackage, LicenseType licenseType) throws KStoreClientExceptionWithInfo {
        AtomicReference plugins = new AtomicReference();
        String url = KStoreUrls.getPluginsAPIUrl(appVersion, katalonPackage, licenseType);
        try {
            this.executeGetRequest(url, this.credentials, response -> {
                try {
                    HttpEntity entity = response.getEntity();
                    if (entity == null) {
                        throw new KStoreClientException("Failed to get latest plugin. No content returned from server.");
                    }
                    String responseContent = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
                    LogUtil.writeOutputLine((String)("Latest plugins responses: " + responseContent));
                    responseContent = responseContent.replace("{}", "null");
                    LogService.getInstance().logInfo("Katalon version: " + appVersion);
                    LogService.getInstance().logInfo("Plugin info URL: " + url);
                    plugins.set(this.parsePluginListJson(responseContent));
                }
                catch (Exception e) {
                    this.propagateIfInstanceOf(e, KStoreClientException.class);
                    throw new KStoreClientException("Unexpected error occurs during executing get latest plugins", e);
                }
            });
        }
        catch (Exception e) {
            if (StringUtils.containsIgnoreCase((CharSequence)e.getMessage(), (CharSequence)ActivationMessageConstants.KStore_ERROR_INVALID_CREDENTAILS)) {
                throw new KStoreClientExceptionWithInfo(e.getMessage(), this.credentials, url);
            }
            this.propagateIfInstanceOf(e, KStoreClientExceptionWithInfo.class);
            throw new KStoreClientExceptionWithInfo("Unexpected error occurs during executing get latest plugins", this.credentials, url, e);
        }
        return (List)plugins.get();
    }

    public List<KStoreProduct> getRecommendPlugins() throws KStoreClientException {
        AtomicReference products = new AtomicReference();
        try {
            this.executeGetRequest(KStoreUrls.getRecommendedPluginsAPIUrl(), this.credentials, response -> {
                try {
                    HttpEntity entity = response.getEntity();
                    if (entity == null) {
                        throw new KStoreClientException("Failed to get latest plugin. No content returned from server.");
                    }
                    String responseContent = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
                    responseContent = responseContent.replace("{}", "null");
                    products.set(this.parseProductListJson(responseContent));
                }
                catch (Exception e) {
                    this.propagateIfInstanceOf(e, KStoreClientException.class);
                    throw new KStoreClientException("Unexpected error occurs during executing get latest plugins", e);
                }
            });
        }
        catch (Exception e) {
            this.propagateIfInstanceOf(e, KStoreClientException.class);
            throw new KStoreClientException("Unexpected error occurs during executing get latest plugins", e);
        }
        return (List)products.get();
    }

    private List<KStorePlugin> parsePluginListJson(String json) throws ParseException {
        Gson gson = new GsonBuilder().registerTypeAdapter(KStorePlugin.class, (Object)new KStorePluginDeserialization()).setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
        Type listType = new TypeToken<List<KStorePlugin>>(){}.getType();
        return (List)gson.fromJson(json, listType);
    }

    private List<KStoreProduct> parseProductListJson(String json) throws ParseException {
        Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
        Type listType = new TypeToken<List<KStoreProduct>>(){}.getType();
        return (List)gson.fromJson(json, listType);
    }

    public void downloadPlugin(KStorePlugin plugin, File downloadFile) throws KStoreClientException {
        try {
            this.executeGetRequest(KStoreUrls.getPluginDownloadAPIUrl(plugin), this.credentials, response -> {
                try {
                    HttpEntity entity = response.getEntity();
                    if (entity == null) {
                        throw new KStoreClientException("Failed to download plugin. No content returned from server.");
                    }
                    FileOutputStream outstream = new FileOutputStream(downloadFile);
                    entity.writeTo((OutputStream)outstream);
                    outstream.close();
                }
                catch (Exception e) {
                    this.propagateIfInstanceOf(e, KStoreClientException.class);
                    throw new KStoreClientException("Unexpected error occurs during executing download plugin", e);
                }
            });
        }
        catch (Exception e) {
            this.propagateIfInstanceOf(e, KStoreClientException.class);
            throw new KStoreClientException("Unexpected error occurs during executing download plugin", e);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AuthenticationResult authenticate() throws KStoreClientException {
        try {
            post = new HttpPost(KStoreUrls.getAuthenticateAPIUrl());
            this.addAuthenticationHeaders(this.credentials, (HttpRequestBase)post);
            content = this.credentials.toJSON();
            requestEntity = new StringEntity(content, StandardCharsets.UTF_8.name());
            post.setEntity((HttpEntity)requestEntity);
            post.setHeader("Accept", "application/json");
            post.setHeader("Content-type", "application/json");
            var4_5 = null;
            var5_7 = null;
            try {
                block19: {
                    client = this.getHttpClient(KStoreUrls.getAuthenticateAPIUrl());
                    try {
                        block18: {
                            response = client.execute((HttpUriRequest)post);
                            try {
                                statusCode = response.getStatusLine().getStatusCode();
                                result = new AuthenticationResult();
                                if (statusCode == 200) {
                                    result.setAuthenticated(true);
                                    responseEntity = response.getEntity();
                                    if (responseEntity != null) {
                                        token = EntityUtils.toString((HttpEntity)responseEntity, (Charset)StandardCharsets.UTF_8);
                                        result.setToken(token);
                                    }
                                    v0 = result;
                                    if (response == null) break block18;
                                }
                                ** GOTO lbl-1000
                            }
                            catch (Throwable var4_6) {
                                if (response == null) throw var4_6;
                                response.close();
                                throw var4_6;
                            }
                            response.close();
                        }
                        if (client == null) return v0;
                    }
                    catch (Throwable var5_8) {
                        if (var4_5 == null) {
                            var4_5 = var5_8;
                        } else if (var4_5 != var5_8) {
                            var4_5.addSuppressed(var5_8);
                        }
                        if (client == null) throw var4_5;
                        client.close();
                        throw var4_5;
                    }
                    client.close();
                    return v0;
lbl-1000:
                    // 1 sources

                    {
                        if (statusCode != 401) ** GOTO lbl-1000
                        result.setAuthenticated(false);
                        result.setToken("");
                        v1 = result;
                        if (response == null) break block19;
                    }
                    response.close();
                }
                if (client == null) return v1;
                client.close();
                return v1;
lbl-1000:
                // 1 sources

                {
                    throw new KStoreClientException(String.format("Invalid Request. Status Code: %d. Message: %s", new Object[]{response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase()}));
                }
            }
            catch (Throwable var5_9) {
                if (var4_5 == null) {
                    var4_5 = var5_9;
                    throw var4_5;
                }
                if (var4_5 == var5_9) throw var4_5;
                var4_5.addSuppressed(var5_9);
                throw var4_5;
            }
        }
        catch (Exception e) {
            this.propagateIfInstanceOf(e, KStoreClientException.class);
            throw new KStoreClientException("Unexpected error occurs during executing authenticate", e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void postRecommended(List<Long> productsID) throws KStoreClientException {
        try {
            HttpPost post = new HttpPost(KStoreUrls.getInstallRecommendedPluginsAPIUrl());
            this.addAuthenticationHeaders(this.credentials, (HttpRequestBase)post);
            KStoreProductID ks = new KStoreProductID(productsID);
            String content = JsonUtil.toJson((Object)ks);
            StringEntity requestEntity = new StringEntity(content);
            post.setEntity((HttpEntity)requestEntity);
            post.setHeader("Accept", "application/json");
            post.setHeader("Content-type", "application/json");
            Throwable throwable = null;
            Object var7_9 = null;
            try {
                CloseableHttpClient client = this.getHttpClient(KStoreUrls.getInstallRecommendedPluginsAPIUrl());
                try {
                    try (CloseableHttpResponse response = client.execute((HttpUriRequest)post);){
                        int statusCode = response.getStatusLine().getStatusCode();
                        if (statusCode != 200) throw new KStoreClientException(String.format("Invalid Request. Status Code: %d. Message: %s", response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase()));
                        LogUtil.logInfo((String)"Successful");
                    }
                    if (client == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (client == null) throw throwable;
                    client.close();
                    throw throwable;
                }
                client.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            this.propagateIfInstanceOf(e, KStoreClientException.class);
            throw new KStoreClientException("Unexpected error occurs during executing authenticate", e);
        }
    }

    public void goToSearchPluginPage() throws KStoreClientException {
        try {
            KatalonStoreToken token = this.getToken();
            if (token != null) {
                String searchPluginPageUrl = KStoreUrls.getSearchPluginPageUrl(token.getToken());
                Program.launch((String)searchPluginPageUrl);
            }
        }
        catch (Exception e) {
            this.propagateIfInstanceOf(e, KStoreClientException.class);
            throw new KStoreClientException("Unexpected error occurs during opening Search Plugins page", e);
        }
    }

    public void goToManagePluginsPage() throws KStoreClientException {
        try {
            KatalonStoreToken token = this.getToken();
            if (token != null) {
                String managePluginsPageUrl = KStoreUrls.getManagePluginPageUrl(token.getToken());
                Program.launch((String)managePluginsPageUrl);
            }
        }
        catch (Exception e) {
            this.propagateIfInstanceOf(e, KStoreClientException.class);
            throw new KStoreClientException("Unexpected error occurs during opening Manage Plugins page", e);
        }
    }

    public void goToManageApiKeysPage() throws KStoreClientException {
        try {
            KatalonStoreToken token = this.getToken();
            if (token != null) {
                String manageApiKeysPageUrl = KStoreUrls.getManageApiKeysPageUrl(token.getToken());
                Program.launch((String)manageApiKeysPageUrl);
            }
        }
        catch (Exception e) {
            this.propagateIfInstanceOf(e, KStoreClientException.class);
            throw new KStoreClientException("Unexpected error occurs during opening Manage API Keys page", e);
        }
    }

    public void goToProductPage(KStoreProduct product) throws KStoreClientException {
        try {
            KatalonStoreToken token = this.getToken();
            if (token != null) {
                String productPageUrl = KStoreUrls.getProductPageUrl(product, token.getToken());
                Program.launch((String)productPageUrl);
            }
        }
        catch (Exception e) {
            this.propagateIfInstanceOf(e, KStoreClientException.class);
            throw new KStoreClientException("Unexpected error occurs during opening Manage Plugins page", e);
        }
    }

    public void goToProductReviewPage(KStoreProduct product) throws KStoreClientException {
        try {
            KatalonStoreToken token = this.getToken();
            if (token != null) {
                String productReviewPageUrl = KStoreUrls.getProductReviewPageUrl(product, token.getToken());
                Program.launch((String)productReviewPageUrl);
            }
        }
        catch (Exception e) {
            this.propagateIfInstanceOf(e, KStoreClientException.class);
            throw new KStoreClientException("Unexpected error occurs during opening Manage Plugins page", e);
        }
    }

    public void goToProductPricingPage(KStoreProduct product) throws KStoreClientException {
        try {
            KatalonStoreToken token = this.getToken();
            if (token != null) {
                String productPricingPageUrl = KStoreUrls.getProductPricingPageUrl(product, token.getToken());
                Program.launch((String)productPricingPageUrl);
            }
        }
        catch (Exception e) {
            this.propagateIfInstanceOf(e, KStoreClientException.class);
            throw new KStoreClientException("Unexpected error occurs during opening Manage Plugins page", e);
        }
    }

    private KatalonStoreToken getToken() throws IOException, KStoreClientException, GeneralSecurityException {
        KatalonStoreToken token = KStoreTokenService.getInstance().getToken();
        if (token == null || KStoreTokenService.getInstance().isTokenExpired(token)) {
            AuthenticationResult authenticateResult = this.authenticate();
            if (authenticateResult.isAuthenticated()) {
                String tokenString = authenticateResult.getToken();
                token = KStoreTokenService.getInstance().createNewToken(tokenString);
            } else {
                token = null;
            }
        }
        return token;
    }

    private void executeGetRequest(String url, KStoreCredentials credentials, OnRequestSuccessHandler requestSuccessHandler) throws URISyntaxException, IOException, GeneralSecurityException, KStoreClientException {
        HttpGet get = new HttpGet(url);
        this.addAuthenticationHeaders(credentials, (HttpRequestBase)get);
        CloseableHttpClient client = this.getHttpClient(url);
        CloseableHttpResponse response = client.execute((HttpUriRequest)get);
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode != 200) {
            if (statusCode == 401) {
                throw new KStoreClientException(ActivationMessageConstants.KStore_ERROR_INVALID_CREDENTAILS);
            }
            throw new KStoreClientException(String.format("Invalid Request. Status Code: %d. Message: %s", statusCode, response.getStatusLine().getReasonPhrase()));
        }
        requestSuccessHandler.handleRequestSuccess(response);
        IOUtils.closeQuietly((Closeable)client);
        IOUtils.closeQuietly((Closeable)response);
    }

    private <X extends Throwable> void propagateIfInstanceOf(Throwable throwable, Class<X> declaredType) throws X {
        if (throwable != null && declaredType.isInstance(throwable)) {
            throw (Throwable)declaredType.cast(throwable);
        }
    }

    private CloseableHttpClient getHttpClient(String url) throws URISyntaxException, IOException, GeneralSecurityException {
        return HttpClientProxyBuilder.create((ProxyInformation)ProxyPreferences.getAuthProxyInformation(), (String)url).getClientBuilder().build();
    }

    private void addAuthenticationHeaders(KStoreCredentials credentials, HttpRequestBase request) {
        credentials.getAuthHeaders().entrySet().stream().forEach(entry -> request.addHeader((String)entry.getKey(), (String)entry.getValue()));
    }

    public class AuthenticationResult {
        private boolean isAuthenticated;
        private String token;

        public boolean isAuthenticated() {
            return this.isAuthenticated;
        }

        public void setAuthenticated(boolean isAuthenticated) {
            this.isAuthenticated = isAuthenticated;
        }

        public String getToken() {
            return this.token;
        }

        public void setToken(String token) {
            this.token = token;
        }
    }

    private static interface OnRequestSuccessHandler {
        public void handleRequestSuccess(CloseableHttpResponse var1) throws KStoreClientException;
    }
}

