/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.activation.plugin.util;

import com.kms.katalon.activation.plugin.models.KStorePlugin;
import com.kms.katalon.activation.plugin.models.KStoreProduct;
import com.kms.katalon.application.utils.VersionUtil;
import com.kms.katalon.core.model.KatalonPackage;
import com.kms.katalon.license.models.LicenseType;
import org.apache.commons.lang3.StringUtils;

public class KStoreUrls {
    private static final String STORE_URL_PROPERTY_KEY = "storeUrl";
    private static final String DEVELOPMENT_URL = "https://store-staging.katalon.com";
    private static final String PRODUCTION_URL = "https://store.katalon.com";

    public static String getSearchPluginPageUrl(String token) {
        return String.valueOf(KStoreUrls.getKatalonStoreUrl()) + "?token=" + token;
    }

    public static String getManagePluginPageUrl(String token) {
        return String.valueOf(KStoreUrls.getKatalonStoreUrl()) + "/manage/products?token=" + token;
    }

    public static String getManageApiKeysPageUrl(String token) {
        return String.valueOf(KStoreUrls.getKatalonStoreUrl()) + "/settings?token=" + token;
    }

    public static String getProductReviewPageUrl(KStoreProduct product, String token) {
        return String.valueOf(KStoreUrls.getProductPageUrl(product, token)) + "#rating-content";
    }

    public static String getProductPricingPageUrl(KStoreProduct product, String token) {
        return String.valueOf(KStoreUrls.getProductPageUrl(product, token)) + "#pricing-content";
    }

    public static String getProductPageUrl(KStoreProduct product, String token) {
        return String.valueOf(KStoreUrls.getKatalonStoreUrl()) + product.getUrl() + "?token=" + token;
    }

    public static String getAuthenticateAPIUrl() {
        return String.valueOf(KStoreUrls.getKatalonStoreAPIUrl()) + "/authenticate";
    }

    public static String getPluginsAPIUrl(String appVersion, KatalonPackage katalonPackage, LicenseType licenseType) {
        String url = String.valueOf(KStoreUrls.getKatalonStoreAPIUrl()) + "/products/ks?appVersion=" + appVersion + "&appType=" + katalonPackage.getPackageName() + "&licenseType=" + licenseType.name();
        return url;
    }

    public static String getPluginDownloadAPIUrl(KStorePlugin plugin) {
        return plugin.getDownloadUrl();
    }

    public static String getRecommendedPluginsAPIUrl() {
        return String.valueOf(KStoreUrls.getKatalonStoreAPIUrl()) + "/products/ks/recommended";
    }

    public static String getInstallRecommendedPluginsAPIUrl() {
        return String.valueOf(KStoreUrls.getKatalonStoreAPIUrl()) + "/products/ks/recommended-plugins/install";
    }

    public static String getKatalonStoreAPIUrl() {
        return String.valueOf(KStoreUrls.getKatalonStoreUrl()) + "/api";
    }

    public static String getKatalonStoreUrl() {
        String storeUrlArgument = KStoreUrls.getStoreUrlArgument();
        if (!StringUtils.isBlank((CharSequence)storeUrlArgument)) {
            return storeUrlArgument;
        }
        if (VersionUtil.isStagingBuild() || VersionUtil.isDevelopmentBuild()) {
            return DEVELOPMENT_URL;
        }
        return PRODUCTION_URL;
    }

    private static String getStoreUrlArgument() {
        return System.getProperty(STORE_URL_PROPERTY_KEY);
    }
}

