/*
 * Decompiled with CFR 0.152.
 */
package cucumber.eclipse.editor.editors;

import gherkin.formatter.Formatter;
import gherkin.formatter.model.Background;
import gherkin.formatter.model.Examples;
import gherkin.formatter.model.ExamplesTableRow;
import gherkin.formatter.model.Feature;
import gherkin.formatter.model.Scenario;
import gherkin.formatter.model.ScenarioOutline;
import gherkin.formatter.model.Step;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class PopupMenuFindStepFormatter
implements Formatter {
    private List<String> resolvedStepNames = new ArrayList<String>();
    private int stepLineNumber;

    public PopupMenuFindStepFormatter(int stepLineNumber) {
        this.stepLineNumber = stepLineNumber;
    }

    public void background(Background background) {
    }

    public void close() {
    }

    public void done() {
    }

    public void eof() {
    }

    public void examples(Examples examples) {
        if (this.resolvedStepNames.isEmpty()) {
            return;
        }
        ExamplesTableRow examplesHeader = (ExamplesTableRow)examples.getRows().get(0);
        int i = 1;
        while (i < examples.getRows().size()) {
            ExamplesTableRow exampleLine = (ExamplesTableRow)examples.getRows().get(i);
            String resolvedStep = this.getResolvedStepForExample(examplesHeader, exampleLine);
            if (!this.resolvedStepNames.contains(resolvedStep)) {
                this.resolvedStepNames.add(resolvedStep);
            }
            ++i;
        }
    }

    public void feature(Feature feature) {
    }

    public void scenario(Scenario scenario) {
    }

    public void scenarioOutline(ScenarioOutline scenarioOutline) {
    }

    public void step(Step step) {
        String stepString = String.valueOf(step.getKeyword()) + step.getName();
        if (this.stepLineNumber == step.getLine()) {
            this.resolvedStepNames.add(stepString);
        }
    }

    public void syntaxError(String state, String event, List<String> legalEvents, String uri, Integer line) {
    }

    public void uri(String uri) {
    }

    private Map<String, String> getExampleVariablesMap(ExamplesTableRow header, ExamplesTableRow values) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        int i = 0;
        while (i < header.getCells().size()) {
            result.put((String)header.getCells().get(i), (String)values.getCells().get(i));
            ++i;
        }
        return result;
    }

    private String getResolvedStepForExample(ExamplesTableRow examplesHeader, ExamplesTableRow exampleLine) {
        Map<String, String> variables = this.getExampleVariablesMap(examplesHeader, exampleLine);
        String stepString = this.resolvedStepNames.get(0);
        if (variables != null) {
            for (Map.Entry<String, String> variable : variables.entrySet()) {
                stepString = stepString.replace("<" + variable.getKey() + ">", variable.getValue());
            }
        }
        return stepString;
    }

    public List<String> getResolvedStepNames() {
        return this.resolvedStepNames;
    }

    public void endOfScenarioLifeCycle(Scenario arg0) {
    }

    public void startOfScenarioLifeCycle(Scenario arg0) {
    }
}

