/*
 * Decompiled with CFR 0.152.
 */
package cucumber.eclipse.editor.editors;

import gherkin.formatter.model.Background;
import gherkin.formatter.model.BasicStatement;
import gherkin.formatter.model.DescribedStatement;
import gherkin.formatter.model.Examples;
import gherkin.formatter.model.Feature;
import gherkin.formatter.model.Scenario;
import gherkin.formatter.model.ScenarioOutline;
import gherkin.formatter.model.Step;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;

public class PositionedElement {
    private BasicStatement statement;
    private int endOffset = -1;
    private IDocument document;
    private List<PositionedElement> children = new ArrayList<PositionedElement>();

    PositionedElement(IDocument doc, BasicStatement stmt) {
        this.statement = stmt;
        this.document = doc;
    }

    void addChild(PositionedElement child) {
        this.children.add(child);
    }

    private static int getDocumentLine(int line) {
        return line - 1;
    }

    void setEndLine(int lineNo) {
        try {
            this.endOffset = this.document.getLineOffset(PositionedElement.getDocumentLine(lineNo)) + this.document.getLineLength(PositionedElement.getDocumentLine(lineNo));
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public BasicStatement getStatement() {
        return this.statement;
    }

    public List<PositionedElement> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public boolean isBackground() {
        return this.statement instanceof Background;
    }

    public boolean isExamples() {
        return this.statement instanceof Examples;
    }

    public boolean isFeature() {
        return this.statement instanceof Feature;
    }

    public boolean isScenarioOutline() {
        return this.statement instanceof ScenarioOutline;
    }

    public boolean isScenario() {
        return this.statement instanceof Scenario;
    }

    public boolean isStep() {
        return this.statement instanceof Step;
    }

    public boolean isStepContainer() {
        return this.isBackground() || this.isScenarioOutline() || this.isScenario();
    }

    public Position toPosition() throws BadLocationException {
        int offset = this.document.getLineOffset(PositionedElement.getDocumentLine(this.statement.getLine()));
        if (this.endOffset == -1) {
            this.endOffset = offset + this.document.getLineLength(PositionedElement.getDocumentLine(this.statement.getLine()));
        }
        return new Position(offset, this.endOffset - offset);
    }

    public String toString() {
        String result;
        if (this.statement instanceof DescribedStatement) {
            result = ((DescribedStatement)this.statement).getName();
            if ("".equals(result)) {
                result = this.statement.getKeyword();
            }
        } else {
            result = this.statement instanceof Step ? String.valueOf(((Step)this.statement).getKeyword()) + ((Step)this.statement).getName() : this.statement.toString();
        }
        return result;
    }
}

