/*
 * Decompiled with CFR 0.152.
 */
package cucumber.eclipse.editor.markers;

import cucumber.eclipse.editor.Activator;
import cucumber.eclipse.editor.editors.DocumentUtil;
import cucumber.eclipse.editor.editors.Editor;
import cucumber.eclipse.editor.editors.GherkinModel;
import cucumber.eclipse.editor.editors.PositionedElement;
import cucumber.eclipse.editor.snippet.ExtensionRegistryStepGeneratorProvider;
import cucumber.eclipse.editor.snippet.SnippetApplicator;
import cucumber.eclipse.editor.steps.ExtensionRegistryStepProvider;
import gherkin.formatter.model.Step;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class StepCreationMarkerResolutionGenerator
implements IMarkerResolutionGenerator {
    public IMarkerResolution[] getResolutions(IMarker marker) {
        Set<cucumber.eclipse.steps.integration.Step> steps;
        HashSet<IFile> files = new HashSet<IFile>();
        ExtensionRegistryStepProvider prof = new ExtensionRegistryStepProvider((IFile)marker.getResource());
        try {
            steps = prof.getSteps(null);
        }
        catch (CoreException e) {
            e.printStackTrace();
            return new IMarkerResolution[0];
        }
        for (cucumber.eclipse.steps.integration.Step step : steps) {
            files.add((IFile)step.getSource());
        }
        ArrayList filesList = new ArrayList(files);
        Collections.sort(filesList, new Comparator<IFile>(){

            @Override
            public int compare(IFile o1, IFile o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        IMarkerResolution[] resolutions = new IMarkerResolution[filesList.size()];
        int i = 0;
        while (i < resolutions.length) {
            resolutions[i] = new StepCreationMarkerResolution((IFile)filesList.get(i));
            ++i;
        }
        return resolutions;
    }

    private static class StepCreationMarkerResolution
    implements IMarkerResolution {
        private final IFile stepFile;

        public StepCreationMarkerResolution(IFile stepFile) {
            this.stepFile = stepFile;
        }

        public void run(IMarker marker) {
            IFile featureFile = (IFile)marker.getResource();
            ExtensionRegistryStepGeneratorProvider generatorProvider = new ExtensionRegistryStepGeneratorProvider();
            try {
                GherkinModel model = StepCreationMarkerResolution.getCurrentModel(featureFile);
                PositionedElement element = model.getStepElement(marker.getAttribute("charStart", 0));
                Step step = (Step)element.getStatement();
                new SnippetApplicator(generatorProvider).generateSnippet(step, this.stepFile);
            }
            catch (IOException exception) {
                StepCreationMarkerResolution.logException(marker, exception);
            }
            catch (CoreException exception) {
                StepCreationMarkerResolution.logException(marker, (Exception)((Object)exception));
            }
            catch (BadLocationException exception) {
                StepCreationMarkerResolution.logException(marker, (Exception)((Object)exception));
            }
        }

        public String getLabel() {
            return String.format("Create step in %s", this.stepFile.getName());
        }

        private static GherkinModel getCurrentModel(IFile featureFile) throws IOException, CoreException {
            GherkinModel model = StepCreationMarkerResolution.getModelFromOpenEditor(featureFile);
            if (model == null) {
                model = StepCreationMarkerResolution.getModelFromFile(featureFile);
            }
            return model;
        }

        private static GherkinModel getModelFromOpenEditor(IFile featureFile) throws PartInitException {
            IEditorReference[] editorReferences;
            IEditorReference[] iEditorReferenceArray = editorReferences = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
            int n = editorReferences.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorPart editor;
                FileEditorInput fileEditorInput;
                IEditorReference editorReference = iEditorReferenceArray[n2];
                if (editorReference.getEditorInput() instanceof FileEditorInput && featureFile.equals((Object)(fileEditorInput = (FileEditorInput)editorReference.getEditorInput()).getFile()) && (editor = editorReference.getEditor(false)) instanceof Editor) {
                    return ((Editor)editor).getModel();
                }
                ++n2;
            }
            return null;
        }

        private static GherkinModel getModelFromFile(IFile featureFile) throws IOException, CoreException {
            GherkinModel model = new GherkinModel();
            model.updateFromDocument(DocumentUtil.read(featureFile.getContents(), featureFile.getCharset()));
            return model;
        }

        private static void logException(IMarker marker, Exception exception) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "cucumber.eclipse.editor", String.format("Couldn't create step for %s", marker), (Throwable)exception));
        }
    }
}

