/*
 * Decompiled with CFR 0.152.
 */
package cucumber.eclipse.editor.preferences;

import cucumber.eclipse.editor.Activator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class CucumberUserSettingsPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Composite composite = null;
    private CLabel descLabel = null;
    private String description = "Cucumber User Settings";
    private String cucumberImage = "icons/cukes.gif";
    private String groupLabelName = "Root package name(s) of your jar/pom-dependency:";
    private String groupToolTip = "Add Root Package Name(s)[Comma(,) separated] exists in your project class-path as a JAR/POM-Dependency contains all Step-Definitions-files";
    private Text packageTextBox = null;
    public static String packageNameText = null;
    private Label exampleLabel = null;
    private String exampleLabelName = "...(e.g. com.proj1.bdd, org.proj2.bdd,...etc)";

    public CucumberUserSettingsPage() {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        this.composite = new Composite(parent, 0);
        this.composite.setLayout((Layout)new GridLayout(1, false));
        this.descLabel = new CLabel(this.composite, 0);
        this.descLabel.setAlignment(16384);
        this.descLabel.setText(CucumberUserSettingsPage.getString(this.description));
        this.descLabel.setImage(CucumberUserSettingsPage.getImage(this.cucumberImage));
        Group packageGroup = new Group(this.composite, 16);
        packageGroup.setLayout((Layout)new GridLayout(2, false));
        packageGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        packageGroup.setText(this.groupLabelName);
        packageGroup.setToolTipText(this.groupToolTip);
        this.packageTextBox = new Text((Composite)packageGroup, 2048);
        this.packageTextBox.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.packageTextBox.setToolTipText(this.groupToolTip);
        this.packageTextBox.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                packageNameText = CucumberUserSettingsPage.this.packageTextBox.getText();
            }
        });
        this.packageTextBox.pack();
        this.exampleLabel = new Label((Composite)packageGroup, 0);
        this.exampleLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.exampleLabel.setAlignment(131072);
        this.exampleLabel.setText(this.exampleLabelName);
        FontData[] fontData = this.exampleLabel.getFont().getFontData();
        fontData[0].setStyle(2);
        this.exampleLabel.setFont(new Font((Device)this.exampleLabel.getDisplay(), fontData[0]));
        this.exampleLabel.setForeground(this.composite.getDisplay().getSystemColor(16));
        this.exampleLabel.pack();
        packageGroup.pack();
        this.composite.pack();
        this.initializeValues();
        return this.composite;
    }

    private void initializeValues() {
        IPreferenceStore store = this.getPreferenceStore();
        this.packageTextBox.setText(store.getString("cucumber.eclipse.editor.add_package"));
    }

    public boolean performOk() {
        boolean result = super.performOk();
        if (result) {
            this.storeValues();
        }
        return result;
    }

    protected void performDefaults() {
        this.packageTextBox.setText("");
        super.performDefaults();
    }

    private void storeValues() {
        IPreferenceStore store = this.getPreferenceStore();
        store.setValue("cucumber.eclipse.editor.add_package", this.getText(this.packageTextBox));
    }

    private String getText(Text textBox) {
        packageNameText = textBox.getText().trim();
        return packageNameText.length() > 0 ? packageNameText : "";
    }

    public static Image getImage(String imagePath) {
        LocalResourceManager manager = new LocalResourceManager(JFaceResources.getResources());
        ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"cucumber.eclipse.editor", (String)imagePath);
        Image image = manager.createImage(imageDescriptor);
        return image;
    }

    public String getPackageName() {
        IPreferenceStore store = this.getPreferenceStore();
        return store.getString("cucumber.eclipse.editor.add_package");
    }

    public Boolean getOnlyPackages() {
        IPreferenceStore store = this.getPreferenceStore();
        return store.getBoolean("cucumber.eclipse.editor.only_search_package");
    }

    public String getOnlySpecificPackage() {
        IPreferenceStore store = this.getPreferenceStore();
        return store.getString("cucumber.eclipse.editor.only_search_specific_package");
    }

    public static String getString(String key) {
        return key;
    }

    public void init(IWorkbench workbench) {
    }
}

