/*
 * Decompiled with CFR 0.152.
 */
package cucumber.eclipse.editor.wizard;

import cucumber.eclipse.editor.util.Utils;
import cucumber.eclipse.editor.wizard.NewStepDefFileWizardPage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class NewStepDefFileWizard
extends Wizard
implements INewWizard {
    private NewStepDefFileWizardPage c_stepDefPage;
    private static final String CUCUMBER_PACKAGE = "import cucumber.api.java.en.";
    private static final String ANNOTATION_START = "  @";
    private static final String ANNOTATION_CONTENT_START = "(\"^you are in ";
    private static final String ANNOTATION_CONTENT_END = " annotation$\")";
    private static final String METHOD_START = "  public void ";
    private static final String METHOD_SIGNATURE = "() ";
    private static final String METHOD_EXCEPTION = "throws Throwable";
    private static final String METHOD_DEFINITION = " {\n  }\n\n";
    private static final String PACKAGE_KEYWORD = "package ";
    private static final String CLASS_DECLARATION = "public class ";
    private static final String CLASS_START = " {\n";
    private static final String CLASS_END = "}\n";

    public NewStepDefFileWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.c_stepDefPage = new NewStepDefFileWizardPage();
        this.addPage((IWizardPage)this.c_stepDefPage);
    }

    public boolean performFinish() {
        String containerName = this.c_stepDefPage.getSourceFolder();
        String className = this.c_stepDefPage.getClassName();
        String packageName = this.c_stepDefPage.getPackageName();
        try {
            return this.doFinish(containerName, packageName, className, null, null, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            e.printStackTrace();
            return true;
        }
    }

    private boolean doFinish(String containerName, String packageName, String className, String xmlPath, List<IMethod> methods, IProgressMonitor monitor) throws CoreException {
        boolean result = true;
        if (className.contains(".java")) {
            className = className.replaceAll(".java", "");
        }
        if (result) {
            IFile file = this.createFile(containerName, packageName, String.valueOf(className) + ".java", this.createJavaContentStream(className, methods), monitor);
            if (file != null) {
                Utils.openFile(this.getShell(), file, monitor);
            } else {
                result = false;
            }
        }
        return result;
    }

    private IFile createFile(String containerName, String packageName, String fileName, InputStream contentStream, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Creating " + fileName, 2);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        String fullPath = fileName;
        if (packageName != null && !"".equals(packageName)) {
            fullPath = String.valueOf(packageName.replace(".", File.separator)) + File.separatorChar + fileName;
        }
        Path absolutePath = new Path(String.valueOf(containerName) + File.separatorChar + fullPath);
        IFile result = root.getFile((IPath)absolutePath);
        Utils.createFileWithDialog(this.getShell(), result, contentStream);
        return result;
    }

    private InputStream createJavaContentStream(String className, List<IMethod> testMethods) {
        StringBuilder imports = new StringBuilder();
        StringBuilder methods = new StringBuilder();
        if (className.contains(".java")) {
            className = className.replaceAll(".java", "");
        }
        String[] stringArray = NewStepDefFileWizardPage.ANNOTATIONS;
        int n = NewStepDefFileWizardPage.ANNOTATIONS.length;
        int n2 = 0;
        while (n2 < n) {
            String a = stringArray[n2];
            if (!"".equals(a) && this.c_stepDefPage.containsAnnotation(a)) {
                imports.append(CUCUMBER_PACKAGE + a + ";\n");
                methods.append(ANNOTATION_START + a + ANNOTATION_CONTENT_START + a + ANNOTATION_CONTENT_END + "\n" + METHOD_START + this.toMethod(a) + METHOD_SIGNATURE + METHOD_EXCEPTION + METHOD_DEFINITION);
            }
            ++n2;
        }
        String contents = PACKAGE_KEYWORD + this.c_stepDefPage.getPackage() + ";\n\n" + imports + "\n" + CLASS_DECLARATION + className + CLASS_START + methods + CLASS_END;
        return new ByteArrayInputStream(contents.getBytes());
    }

    private String toMethod(String a) {
        return String.valueOf(Character.toLowerCase(a.charAt(0))) + a.substring(1);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }
}

