/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.mobile.device;

import com.kms.katalon.core.mobile.constants.StringConstants;
import com.kms.katalon.core.util.ConsoleCommandExecutor;
import com.kms.katalon.execution.mobile.device.MobileDeviceInfo;
import com.kms.katalon.logging.LogUtil;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.eclipse.core.runtime.Platform;

public class IosDeviceInfo
extends MobileDeviceInfo {
    private static final String RELATIVE_PATH_TO_TOOLS_FOLDER = "resources/tools/";
    private static final String PATH = "PATH";
    private static final String PRODUCT_TYPE_INFO_PREFIX = "ProductType:";
    private static final String PRODUCT_VERSION_INFO_PREFIX = "ProductVersion:";
    private static final String DEVICE_NAME_INFO_PREFIX = "DeviceName:";
    private static final String DEVICE_CLASS_INFO_PREFIX = "DeviceClass:";
    public static final String DEVICECONSOLE = "deviceconsole";
    public static final String DEVICE_CONSOLE_FOLDER_RELATIVE_PATH = "resources/tools/deviceconsole";
    protected String deviceClass = "";
    protected String deviceName = "";
    protected String deviceOSVersion = "";
    protected String deviceType = "";

    public IosDeviceInfo(String deviceId) throws IOException, InterruptedException {
        super(deviceId);
        this.initDeviceInfos(deviceId);
    }

    public static List<String> executeCommand(String command) throws IOException, InterruptedException {
        Map<String, String> env = IosDeviceInfo.getIosAdditionalEnvironmentVariables();
        return ConsoleCommandExecutor.execSync((String)command, (boolean)false, env);
    }

    protected void initDeviceInfos(String deviceId) throws IOException, InterruptedException {
        List<String> pairedInfos = IosDeviceInfo.executeCommand("idevicepair validate -u " + deviceId);
        String pairedString = StringUtils.join(pairedInfos, (String)"\n");
        if (!StringUtils.containsIgnoreCase((CharSequence)pairedString, (CharSequence)"SUCCESS")) {
            LogUtil.printErrorLine((String)pairedString);
        }
        List<String> deviceInfos = IosDeviceInfo.executeCommand("ideviceinfo -u " + deviceId);
        for (String deviceInfo : deviceInfos) {
            if (deviceInfo.contains(DEVICE_CLASS_INFO_PREFIX)) {
                this.deviceClass = deviceInfo.substring(DEVICE_CLASS_INFO_PREFIX.length(), deviceInfo.length()).trim();
                continue;
            }
            if (deviceInfo.contains(DEVICE_NAME_INFO_PREFIX)) {
                this.deviceName = deviceInfo.substring(DEVICE_NAME_INFO_PREFIX.length(), deviceInfo.length()).trim();
                continue;
            }
            if (deviceInfo.contains(PRODUCT_VERSION_INFO_PREFIX)) {
                this.deviceOSVersion = deviceInfo.substring(PRODUCT_VERSION_INFO_PREFIX.length(), deviceInfo.length()).trim();
                continue;
            }
            if (!deviceInfo.contains(PRODUCT_TYPE_INFO_PREFIX)) continue;
            this.deviceType = deviceInfo.substring(PRODUCT_TYPE_INFO_PREFIX.length(), deviceInfo.length()).trim();
        }
        if (StringUtils.isEmpty((CharSequence)this.deviceName)) {
            LogUtil.printErrorLine((String)StringUtils.join(deviceInfos, (String)"\n"));
        }
    }

    @Override
    public String getDeviceName() {
        return this.deviceName;
    }

    @Override
    public String getDisplayName() {
        String displayName = String.valueOf(this.deviceClass) + " " + this.deviceName + " " + this.deviceOSVersion;
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{displayName})) {
            return displayName;
        }
        return "<unrecognized device>";
    }

    @Override
    public String getDeviceManufacturer() {
        return StringConstants.KW_MANUFACTURER_APPLE;
    }

    @Override
    public String getDeviceModel() {
        return this.deviceType;
    }

    @Override
    public String getDeviceOS() {
        return StringConstants.KW_OS_IOS;
    }

    @Override
    public String getDeviceOSVersion() {
        return this.deviceOSVersion;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.deviceId).append((Object)this.deviceClass).append((Object)this.deviceName).append((Object)this.deviceOSVersion).append((Object)this.deviceType).toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IosDeviceInfo other = (IosDeviceInfo)obj;
        return new EqualsBuilder().append((Object)this.deviceId, (Object)other.deviceId).append((Object)this.deviceClass, (Object)other.deviceClass).append((Object)this.deviceName, (Object)other.deviceName).append((Object)this.deviceOSVersion, (Object)other.deviceOSVersion).append((Object)this.deviceType, (Object)other.deviceType).isEquals();
    }

    public static File getDeviceConsoleFolder() throws IOException {
        return IosDeviceInfo.getResourceFolder(DEVICE_CONSOLE_FOLDER_RELATIVE_PATH);
    }

    public static File getToolsFolder() throws IOException {
        return IosDeviceInfo.getResourceFolder(RELATIVE_PATH_TO_TOOLS_FOLDER);
    }

    public static File getDeviceConsoleExecutablePath() throws IOException {
        return new File(IosDeviceInfo.getResourceFolder(DEVICE_CONSOLE_FOLDER_RELATIVE_PATH), DEVICECONSOLE);
    }

    @Override
    protected Map<String, String> getEnvironmentVariables() throws IOException, InterruptedException {
        return IosDeviceInfo.getIosAdditionalEnvironmentVariables();
    }

    public static Map<String, String> getIosAdditionalEnvironmentVariables() throws IOException, InterruptedException {
        IosDeviceInfo.makeDeviceConsoleExecutable();
        HashMap<String, String> additionalEnvironmentVariables = new HashMap<String, String>();
        additionalEnvironmentVariables.put(PATH, String.valueOf(StringUtils.defaultString((String)System.getenv(PATH))) + ":/usr/local/bin");
        return additionalEnvironmentVariables;
    }

    public static void makeDeviceConsoleExecutable() throws IOException, InterruptedException {
        if (!"macosx".equals(Platform.getOS())) {
            return;
        }
        File deviceConsoleBinary = IosDeviceInfo.getDeviceConsoleExecutablePath();
        if (!deviceConsoleBinary.isFile()) {
            return;
        }
        IosDeviceInfo.makeFileExecutable(deviceConsoleBinary);
    }

    @Override
    public boolean isEmulator() {
        return false;
    }
}

