/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.mobile.driver;

import com.kms.katalon.core.mobile.constants.StringConstants;
import com.kms.katalon.execution.configuration.AbstractDriverConnector;
import com.kms.katalon.execution.mobile.device.MobileDeviceInfo;
import com.kms.katalon.execution.mobile.util.MobileExecutionUtil;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public abstract class MobileDriverConnector
extends AbstractDriverConnector {
    private static final String APPIUM_LOG_FILE_NAME = "appium.log";
    protected MobileDeviceInfo device;

    public MobileDriverConnector(String configurationFolderPath) throws IOException {
        this(configurationFolderPath, null);
    }

    public MobileDriverConnector(String configurationFolderPath, MobileDeviceInfo device) throws IOException {
        super(configurationFolderPath);
        this.setDevice(device);
    }

    public String getDeviceId() {
        if (this.device == null) {
            return "";
        }
        return this.device.getDeviceId();
    }

    public MobileDeviceInfo getDevice() {
        return this.device;
    }

    public void setDevice(MobileDeviceInfo device) {
        this.device = device;
    }

    public Map<String, Object> getSystemProperties() {
        Map systemProperties = super.getSystemProperties();
        systemProperties.put("appiumLogFile", APPIUM_LOG_FILE_NAME);
        systemProperties.put("appiumDirectory", this.getAppiumDirectory());
        systemProperties.put("appiumLogLevel", this.getAppiumLogLevel());
        this.setDeviceSystemProperties(systemProperties);
        return systemProperties;
    }

    private String getAppiumDirectory() {
        return MobileExecutionUtil.findAppiumDir();
    }

    private String getAppiumLogLevel() {
        String appiumLogLevel = this.getMobilePreferenceStore().getString("mobile.appiumLogLevel");
        return StringUtils.isNotBlank((String)appiumLogLevel) ? appiumLogLevel : "info";
    }

    private ScopedPreferenceStore getMobilePreferenceStore() {
        return PreferenceStoreManager.getPreferenceStore((String)"com.kms.katalon.composer.mobile");
    }

    private void setDeviceSystemProperties(Map<String, Object> systemProperties) {
        if (this.device == null) {
            return;
        }
        systemProperties.putAll(this.device.getDeviceSystemProperties());
    }

    public String getSettingFileName() {
        return String.valueOf(StringConstants.MOBILE_PROPERTY_FILE_NAME) + "." + this.getDriverType().toString().toLowerCase();
    }

    protected void loadDriverProperties() throws IOException {
        super.loadDriverProperties();
    }

    public String toString() {
        LinkedHashMap tempMap = new LinkedHashMap(this.getUserConfigProperties());
        return ((Object)tempMap).toString();
    }

    public String getDefaultDeviceId() {
        return StringUtils.defaultString((String)((String)this.getUserConfigProperties().get("deviceId")), (String)"");
    }

    public void updateDefaultDeviceId() {
        this.getUserConfigProperties().put("deviceId", this.getDeviceId());
    }
}

