/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testsuite.collection.handler;

import com.kms.katalon.composer.components.impl.util.EntityPartUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.testsuite.collection.constant.ComposerTestsuiteCollectionMessageConstants;
import com.kms.katalon.composer.testsuite.collection.constant.ImageConstants;
import com.kms.katalon.composer.testsuite.collection.part.TestSuiteCollectionCompositePart;
import com.kms.katalon.composer.testsuite.collection.part.TestSuiteCollectionPart;
import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.ReportController;
import com.kms.katalon.controller.TestSuiteCollectionController;
import com.kms.katalon.dal.exception.DALException;
import com.kms.katalon.entity.report.ReportCollectionEntity;
import com.kms.katalon.entity.testsuite.TestSuiteCollectionEntity;
import com.kms.katalon.tracking.service.Trackings;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MCompositePart;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class OpenTestSuiteCollectionHandler {
    private static final String TEST_SUITE_COLLECTION_BUNDLE_URI = "bundleclass://" + FrameworkUtil.getBundle(OpenTestSuiteCollectionHandler.class).getSymbolicName() + "/";
    private static final String REPORT_BUNDLE_ID = "bundleclass://com.kms.katalon.composer.report/";
    private static final String TEST_SUITE_COLLECTION_COMPOSITE_PART_URI = String.valueOf(TEST_SUITE_COLLECTION_BUNDLE_URI) + TestSuiteCollectionCompositePart.class.getName();
    private static final String TEST_SUITE_COLLECTION_PART_URI = String.valueOf(TEST_SUITE_COLLECTION_BUNDLE_URI) + TestSuiteCollectionPart.class.getName();
    private static final String TEST_SUITE_COLLECTION_RESULT_PART_URI = "bundleclass://com.kms.katalon.composer.report/com.kms.katalon.composer.report.parts.ReportCollectionPart";
    private static final String DEFAULT_CONTAINER_DATA = String.valueOf(100);
    @Inject
    private EModelService modelService;
    @Inject
    private MApplication application;
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private EPartService partService;
    @Inject
    private IEclipseContext context;

    @PostConstruct
    public void registerEventHandler() {
        this.eventBroker.subscribe("EXPLORER/OPEN_SELECTED_ITEM", new EventHandler(){

            public void handleEvent(Event event) {
                Object object = event.getProperty("org.eclipse.e4.data");
                if (object != null && object instanceof TestSuiteCollectionEntity) {
                    OpenTestSuiteCollectionHandler.this.execute((TestSuiteCollectionEntity)object);
                }
            }
        });
    }

    protected void execute(TestSuiteCollectionEntity testSuiteCollectionEntity) {
        MCompositePart compositePart = null;
        try {
            MPartStack stack = (MPartStack)this.modelService.find("com.kms.katalon.composer.content", (MUIElement)this.application);
            if (stack != null) {
                String resultPartId;
                MPart resultPart;
                String mainPartId;
                MPart mainPart;
                String subPartStackId;
                MPartStack subPartStack;
                String testSuiteCollectionCompositePartId = EntityPartUtil.getTestSuiteCollectionPartId((String)testSuiteCollectionEntity.getId());
                compositePart = (MCompositePart)this.modelService.find(testSuiteCollectionCompositePartId, (MUIElement)stack);
                if (compositePart == null) {
                    compositePart = (MCompositePart)this.modelService.createModelElement(MCompositePart.class);
                    compositePart.setElementId(testSuiteCollectionCompositePartId);
                    compositePart.setLabel(testSuiteCollectionEntity.getName());
                    compositePart.setCloseable(true);
                    compositePart.setContributionURI(TEST_SUITE_COLLECTION_COMPOSITE_PART_URI);
                    compositePart.setIconURI(ImageConstants.URL_16_TEST_SUITE_COLLECTION);
                    compositePart.setObject((Object)testSuiteCollectionEntity);
                    compositePart.setTooltip(testSuiteCollectionEntity.getIdForDisplay());
                    stack.getChildren().add(compositePart);
                }
                if ((subPartStack = (MPartStack)this.modelService.find(subPartStackId = String.valueOf(testSuiteCollectionCompositePartId) + ".partStack", (MUIElement)compositePart)) == null) {
                    subPartStack = (MPartStack)this.modelService.createModelElement(MPartStack.class);
                    subPartStack.setElementId(subPartStackId);
                    subPartStack.setContainerData(DEFAULT_CONTAINER_DATA);
                    compositePart.getChildren().add(subPartStack);
                }
                if ((mainPart = (MPart)this.modelService.find(mainPartId = String.valueOf(testSuiteCollectionCompositePartId) + ".partStack.testSuiteCollectionPart", (MUIElement)subPartStack)) == null) {
                    mainPart = (MPart)this.modelService.createModelElement(MPart.class);
                    mainPart.setElementId(mainPartId);
                    mainPart.setContributionURI(TEST_SUITE_COLLECTION_PART_URI);
                    mainPart.setContainerData(DEFAULT_CONTAINER_DATA);
                    mainPart.getTags().add("NoMove");
                    this.context.set(TestSuiteCollectionEntity.class, (Object)testSuiteCollectionEntity);
                    subPartStack.getChildren().add(mainPart);
                }
                if ((resultPart = (MPart)this.modelService.find(resultPartId = String.valueOf(testSuiteCollectionCompositePartId) + ".partStack.result", (MUIElement)subPartStack)) == null) {
                    resultPart = (MPart)this.modelService.createModelElement(MPart.class);
                    resultPart.setElementId(resultPartId);
                    resultPart.setContributionURI(TEST_SUITE_COLLECTION_RESULT_PART_URI);
                    resultPart.setContainerData(DEFAULT_CONTAINER_DATA);
                    resultPart.getTags().add("NoMove");
                    ReportCollectionEntity lastRunReport = ReportController.getInstance().getLastRunReportCollectionEntity(testSuiteCollectionEntity);
                    this.context.set(ReportCollectionEntity.class, (Object)lastRunReport);
                    subPartStack.getChildren().add(resultPart);
                }
                this.partService.activate((MPart)compositePart);
                this.partService.activate(mainPart);
                this.partService.activate(resultPart);
                subPartStack.setSelectedElement((MUIElement)mainPart);
                stack.setSelectedElement((MUIElement)compositePart);
                TestSuiteCollectionCompositePart testSuiteCollectionCompositePart = (TestSuiteCollectionCompositePart)((Object)compositePart.getObject());
                testSuiteCollectionCompositePart.initComponent();
                Trackings.trackOpenObject((String)"testSuiteCollection");
            }
        }
        catch (Exception e) {
            if (compositePart != null && compositePart.isVisible()) {
                this.partService.hidePart(compositePart, true);
            }
            LoggerSingleton.logError((Throwable)e);
            MessageDialog.openError(null, (String)ComposerTestsuiteCollectionMessageConstants.ERROR_TITLE, (String)ComposerTestsuiteCollectionMessageConstants.HAND_ERROR_MSG_UNABLE_TO_OPEN_TEST_SUITE_COLLECTION);
        }
    }

    @Inject
    @Optional
    private void execute(@UIEventTopic(value="TEST_SUITE_COLLECTION/OPEN") Object eventData) {
        if (ProjectController.getInstance().getCurrentProject() == null) {
            return;
        }
        if (!(eventData instanceof String)) {
            return;
        }
        try {
            this.execute(TestSuiteCollectionController.getInstance().getTestRunByDisplayId((String)eventData));
        }
        catch (DALException dALException) {
            MessageDialog.openError(null, (String)GlobalStringConstants.WARN, (String)ComposerTestsuiteCollectionMessageConstants.HAND_UNDABLE_TO_OPEN_TEST_SUITE_COLLECTION);
        }
    }
}

