/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testsuite.collection.handler;

import com.kms.katalon.composer.components.dialogs.CWizardDialog;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.event.EventServiceAdapter;
import com.kms.katalon.composer.components.impl.tree.TestSuiteCollectionTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.components.wizard.RenameWizard;
import com.kms.katalon.composer.testsuite.collection.constant.ComposerTestsuiteCollectionMessageConstants;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.TestSuiteCollectionController;
import com.kms.katalon.entity.testsuite.TestSuiteCollectionEntity;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class RenameTestSuiteCollectionHandler {
    @Inject
    private IEventBroker eventBroker;
    @Named(value="activeShell")
    private Shell parentShell;

    @PostConstruct
    public void registerEventHandler() {
        this.eventBroker.subscribe("EXPLORER/RENAME_SELECTED_ITEM", (EventHandler)new EventServiceAdapter(){

            public void handleEvent(Event event) {
                Object object = this.getObject(event);
                if (object instanceof TestSuiteCollectionTreeEntity var3_4) {
                    RenameTestSuiteCollectionHandler.this.execute((TestSuiteCollectionTreeEntity)testSuiteCollectionTree);
                }
            }
        });
    }

    private void execute(TestSuiteCollectionTreeEntity testSuiteCollectionTree) {
        try {
            if (!(testSuiteCollectionTree.getObject() instanceof TestSuiteCollectionEntity)) {
                return;
            }
            this.rename(testSuiteCollectionTree);
            this.eventBroker.send("EXPLORER/REFRESH_TREE_ENTITY", (Object)testSuiteCollectionTree.getParent());
            this.eventBroker.post("EXPLORER/SET_SELECTED_ITEM", (Object)testSuiteCollectionTree);
        }
        catch (Exception e) {
            MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)ComposerTestsuiteCollectionMessageConstants.HDL_MSG_UNABLE_TO_RENAME_TEST_SUITE_COLLECTION, (String)e.getMessage());
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private void rename(TestSuiteCollectionTreeEntity testSuiteCollectionTree) throws Exception {
        TestSuiteCollectionEntity testSuiteCollectionEntity = (TestSuiteCollectionEntity)testSuiteCollectionTree.getObject();
        RenameWizard renameWizard = new RenameWizard((ITreeEntity)testSuiteCollectionTree, this.getSibblingNames(testSuiteCollectionEntity));
        if (new CWizardDialog(this.parentShell, (IWizard)renameWizard).open() != 0) {
            return;
        }
        String newName = renameWizard.getNewNameValue();
        if (testSuiteCollectionEntity.getName().equals(newName)) {
            return;
        }
        String oldIdForDisplay = testSuiteCollectionEntity.getIdForDisplay();
        TestSuiteCollectionController.getInstance().renameTestSuiteCollection(newName, testSuiteCollectionEntity);
        this.eventBroker.post("EXPLORER/RENAMED_SELECTED_ITEM", (Object)new Object[]{oldIdForDisplay, testSuiteCollectionEntity.getIdForDisplay()});
    }

    private List<String> getSibblingNames(TestSuiteCollectionEntity testRunEntity) throws Exception {
        List sibblingNames = FolderController.getInstance().getChildNames(testRunEntity.getParentFolder());
        sibblingNames.remove(testRunEntity.getName());
        return sibblingNames;
    }
}

