/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testsuite.collection.part;

import com.kms.katalon.composer.components.impl.event.EventServiceAdapter;
import com.kms.katalon.composer.components.impl.util.EntityPartUtil;
import com.kms.katalon.composer.components.impl.util.EventUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.part.IComposerPartEvent;
import com.kms.katalon.composer.components.part.SavableCompositePart;
import com.kms.katalon.composer.testsuite.collection.constant.ComposerTestsuiteCollectionMessageConstants;
import com.kms.katalon.composer.testsuite.collection.constant.ImageConstants;
import com.kms.katalon.composer.testsuite.collection.part.TestSuiteCollectionPart;
import com.kms.katalon.composer.testsuite.collection.part.TestSuiteCollectionResultPart;
import com.kms.katalon.controller.ReportController;
import com.kms.katalon.entity.report.ReportCollectionEntity;
import com.kms.katalon.entity.testsuite.TestSuiteCollectionEntity;
import com.kms.katalon.tracking.service.Trackings;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.e4.ui.model.application.ui.basic.MCompositePart;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Composite;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class TestSuiteCollectionCompositePart
extends EventServiceAdapter
implements IComposerPartEvent,
SavableCompositePart {
    private static final int COMPOSITE_SIZE = 1;
    private static final int SUB_PARTSTACK_SIZE = 2;
    private static final int CHILD_MAIN_PART_INDEX = 0;
    private static final int CHILD_RESULT_PART_INDEX = 1;
    @Inject
    private MDirtyable dirty;
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private EPartService partService;
    private MCompositePart compositePart;
    private MPartStack subPartStack;
    private CTabFolder tabFolder;
    private TestSuiteCollectionEntity testSuiteCollection;
    private TestSuiteCollectionPart testSuiteCollectionMainPart;
    private TestSuiteCollectionResultPart testSuiteCollectionResultPart;

    @PostConstruct
    public void init(Composite parent, MCompositePart compositePart) {
        this.dirty.setDirty(false);
        this.compositePart = compositePart;
        this.testSuiteCollection = (TestSuiteCollectionEntity)compositePart.getObject();
        this.initListeners();
    }

    public void initComponent() {
        if (this.compositePart.getChildren().size() != 1 || !(this.compositePart.getChildren().get(0) instanceof MPartStack)) {
            return;
        }
        this.subPartStack = (MPartStack)this.compositePart.getChildren().get(0);
        if (this.subPartStack.getChildren().size() == 2) {
            for (MStackElement stackElement : this.subPartStack.getChildren()) {
                if (!(stackElement instanceof MPart)) continue;
                Object part = ((MPart)stackElement).getObject();
                if (part instanceof TestSuiteCollectionPart) {
                    this.testSuiteCollectionMainPart = (TestSuiteCollectionPart)part;
                    continue;
                }
                this.testSuiteCollectionResultPart = new TestSuiteCollectionResultPart(part);
            }
        }
        this.initTabFolder();
    }

    private void initListeners() {
        this.eventBroker.subscribe("EXPLORER/RENAMED_SELECTED_ITEM", (EventHandler)this);
        this.eventBroker.subscribe("EXPLORER/DELETED_SELECTED_ITEM", (EventHandler)this);
        this.eventBroker.subscribe("TEST_SUITE_COLLECTION/FINISHED", (EventHandler)this);
    }

    private void initTabFolder() {
        if (this.subPartStack.getWidget() instanceof CTabFolder) {
            this.tabFolder = (CTabFolder)this.subPartStack.getWidget();
            this.tabFolder.setTabPosition(1024);
            this.tabFolder.setBorderVisible(false);
            this.tabFolder.setMaximizeVisible(false);
            this.tabFolder.setMinimizeVisible(false);
            if (this.tabFolder.getItemCount() == 2) {
                CTabItem mainPart = this.tabFolder.getItem(0);
                mainPart.setText(ComposerTestsuiteCollectionMessageConstants.PA_TAB_MAIN);
                mainPart.setImage(ImageConstants.IMG_16_MAIN);
                mainPart.setShowClose(false);
                CTabItem resultPart = this.tabFolder.getItem(1);
                resultPart.setText(ComposerTestsuiteCollectionMessageConstants.PA_TAB_RESULT);
                resultPart.setImage(ImageConstants.IMG_16_REPORT);
                resultPart.setShowClose(false);
            }
            this.tabFolder.layout();
        }
    }

    @PreDestroy
    public void onClose() {
        EventUtil.post((String)"PROPERTIES/ENTITY", null);
        this.compositePart.getChildren().clear();
        this.eventBroker.unsubscribe((EventHandler)this);
    }

    public String getEntityId() {
        return this.testSuiteCollection.getId();
    }

    @Inject
    @Optional
    public void onSelect(@UIEventTopic(value="org/eclipse/e4/ui/LifeCycle/bringToTop") Event event) {
        if (this.testSuiteCollection == null) {
            return;
        }
        MPart part = EventUtil.getPart((Event)event);
        if (part == null || !StringUtils.startsWith((CharSequence)part.getElementId(), (CharSequence)EntityPartUtil.getTestSuiteCollectionPartId((String)this.testSuiteCollection.getId()))) {
            return;
        }
        EventUtil.post((String)"PROPERTIES/ENTITY", (Object)this.testSuiteCollection);
    }

    @Inject
    @Optional
    public void onChangeEntityProperties(@UIEventTopic(value="PROPERTIES/ENTITY_UPDATED") Event event) {
        Object eventData = EventUtil.getData((Event)event);
        if (!(eventData instanceof TestSuiteCollectionEntity)) {
            return;
        }
        TestSuiteCollectionEntity updatedEntity = (TestSuiteCollectionEntity)eventData;
        if (!StringUtils.equals((CharSequence)updatedEntity.getIdForDisplay(), (CharSequence)this.getEntityId())) {
            return;
        }
        this.testSuiteCollection.setTag(updatedEntity.getTag());
        this.testSuiteCollection.setDescription(updatedEntity.getDescription());
    }

    public void handleEvent(Event event) {
        switch (event.getTopic()) {
            case "EXPLORER/RENAMED_SELECTED_ITEM": {
                Object[] objects = this.getObjects(event);
                if (objects == null || objects.length != 2) {
                    return;
                }
                if (!ObjectUtils.equals((Object)this.testSuiteCollection.getIdForDisplay(), (Object)objects[1])) break;
                this.updatePartIds(this.testSuiteCollection);
                break;
            }
            case "EXPLORER/DELETED_SELECTED_ITEM": {
                this.eventBroker.unsubscribe((EventHandler)this);
                this.partService.hidePart((MPart)this.compositePart, true);
                break;
            }
            case "TEST_SUITE_COLLECTION/UPDATED": {
                Object[] objects = this.getObjects(event);
                if (objects == null || objects.length != 2) {
                    return;
                }
                if (!this.testSuiteCollection.equals(objects[1])) break;
                this.updatePartIds(this.testSuiteCollection);
                break;
            }
            case "TEST_SUITE_COLLECTION/FINISHED": {
                Object object = event.getProperty("org.eclipse.e4.data");
                if (object == null || !(object instanceof TestSuiteCollectionEntity)) break;
                TestSuiteCollectionEntity eventTestSuiteCollection = (TestSuiteCollectionEntity)object;
                this.handleTestSuiteCollectionExecutionFinished(eventTestSuiteCollection);
            }
        }
    }

    private void updatePartIds(TestSuiteCollectionEntity updatedEntity) {
        String newCompositePartId = EntityPartUtil.getTestSuiteCollectionPartId((String)this.testSuiteCollection.getId());
        if (!newCompositePartId.equals(this.compositePart.getElementId())) {
            this.compositePart.setElementId(newCompositePartId);
            this.compositePart.setLabel(this.testSuiteCollection.getName());
            MPartStack partStack = (MPartStack)this.compositePart.getChildren().get(0);
            partStack.setElementId(String.valueOf(newCompositePartId) + ".partStack");
            this.testSuiteCollectionMainPart.getMPart().setElementId(String.valueOf(newCompositePartId) + ".partStack.testSuiteCollectionPart");
            this.testSuiteCollectionResultPart.getMPart().setElementId(String.valueOf(newCompositePartId) + ".partStack.result");
        }
    }

    private void handleTestSuiteCollectionExecutionFinished(TestSuiteCollectionEntity executedTestSuiteCollection) {
        if (executedTestSuiteCollection.getId().equals(this.testSuiteCollection.getId())) {
            try {
                ReportCollectionEntity report = ReportController.getInstance().getLastRunReportCollectionEntity(executedTestSuiteCollection);
                this.testSuiteCollectionResultPart.updateReport(report);
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
            }
        }
    }

    public List<MPart> getChildParts() {
        ArrayList<MPart> childrenParts = new ArrayList<MPart>();
        childrenParts.add(this.testSuiteCollectionMainPart.getMPart());
        childrenParts.add(this.testSuiteCollectionResultPart.getMPart());
        return childrenParts;
    }

    public void save() throws Exception {
        this.testSuiteCollectionMainPart.save();
        Trackings.trackSaveObject((String)"testSuiteCollection");
    }

    public void setDirty(boolean isDirty) {
        this.dirty.setDirty(isDirty);
    }

    public boolean isDirty() {
        return this.compositePart.isDirty();
    }
}

