/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testsuite.collection.part;

import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.application.utils.LicenseUtil;
import com.kms.katalon.composer.components.controls.HelpToolBarForMPart;
import com.kms.katalon.composer.components.impl.constants.ComposerComponentsImplMessageConstants;
import com.kms.katalon.composer.components.impl.control.CMenu;
import com.kms.katalon.composer.components.impl.control.CTableViewer;
import com.kms.katalon.composer.components.impl.control.HotkeyActiveListener;
import com.kms.katalon.composer.components.impl.control.ImageButton;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.editors.DefaultTableColumnViewerEditor;
import com.kms.katalon.composer.components.impl.event.EventServiceAdapter;
import com.kms.katalon.composer.components.impl.handler.KSEFeatureAccessHandler;
import com.kms.katalon.composer.components.impl.tree.TestSuiteCollectionTreeEntity;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.impl.util.MenuUtils;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.part.IComposerPartEvent;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.util.ColumnViewerUtil;
import com.kms.katalon.composer.execution.handlers.AbstractExecutionHandler;
import com.kms.katalon.composer.explorer.util.TransferTypeCollection;
import com.kms.katalon.composer.testsuite.collection.constant.ComposerTestsuiteCollectionMessageConstants;
import com.kms.katalon.composer.testsuite.collection.constant.ImageConstants;
import com.kms.katalon.composer.testsuite.collection.listeners.TestSuiteTableDragListener;
import com.kms.katalon.composer.testsuite.collection.listeners.TestSuiteTableDropListener;
import com.kms.katalon.composer.testsuite.collection.part.AbstractTestSuiteCollectionUIDescriptionView;
import com.kms.katalon.composer.testsuite.collection.part.ExpandableTestSuiteCollectionComposite;
import com.kms.katalon.composer.testsuite.collection.part.TestSuiteCollectionCompositePart;
import com.kms.katalon.composer.testsuite.collection.part.job.TestSuiteCollectionBuilderJob;
import com.kms.katalon.composer.testsuite.collection.part.provider.TableViewerProvider;
import com.kms.katalon.composer.testsuite.collection.part.provider.TestSuiteRunConfigLabelProvider;
import com.kms.katalon.composer.testsuite.collection.part.provider.ToolbarItemListener;
import com.kms.katalon.composer.testsuite.collection.part.support.ExecutionProfileEditingSupport;
import com.kms.katalon.composer.testsuite.collection.part.support.RunConfigurationChooserEditingSupport;
import com.kms.katalon.composer.testsuite.collection.part.support.RunConfigurationDataEditingSupport;
import com.kms.katalon.composer.testsuite.collection.part.support.RunEnabledEditingSupport;
import com.kms.katalon.composer.testsuite.collection.part.support.TestSuiteIdEditingSupport;
import com.kms.katalon.composer.testsuite.collection.transfer.TestSuiteRunConfigurationTransfer;
import com.kms.katalon.composer.testsuite.collection.view.TestSuiteCollectionViewFactory;
import com.kms.katalon.constants.DocumentationMessageConstants;
import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.TestSuiteCollectionController;
import com.kms.katalon.dal.exception.DALException;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testsuite.RunConfigurationDescription;
import com.kms.katalon.entity.testsuite.TestSuiteCollectionEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.entity.testsuite.TestSuiteRunConfiguration;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.SerializationUtils;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.ui.MGenericTile;
import org.eclipse.e4.ui.model.application.ui.basic.MCompositePart;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class TestSuiteCollectionPart
extends EventServiceAdapter
implements TableViewerProvider,
IComposerPartEvent {
    private static final int MINIMUM_COMPOSITE_SIZE = 300;
    private static final String HK_NEW = "M1+N";
    private static final String HK_DEL = "Delete";
    private static final String HK_MOVE_ITEMS_UP = "M1+ARROW_UP";
    private static final String HK_MOVE_ITEMS_DOWN = "M1+ARROW_DOWN";
    private static final String HK_EXECUTE = "M1+E";
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private EPartService partService;
    private MPart mpart;
    private TestSuiteCollectionEntity originalTestSuite;
    private TestSuiteCollectionEntity cloneTestSuite;
    private CTableViewer tableViewer;
    private TableColumn tblclmnNo;
    private TableColumn tblclmnId;
    private TableColumn tblclmnEnviroment;
    private TableColumn tblclmnRunWithData;
    private TableColumn tblclmnProfile;
    private TableColumn tblclmnRun;
    private long lastModified;
    private ToolItem toolItemExecute;
    private ImageButton btnExpandExecutionInformation;
    private ToolbarItemListener selectionListener;
    private Composite toolbarComposite;
    private Composite testSuiteTableComposite;
    private Composite compositeExecution;
    private Composite compositeExecutionHeader;
    private Composite compositeExecutionInformation;
    private boolean isExecutionInfoCompositeExpanded;
    private Button btnSequential;
    private Button btnParallel;
    private Label lblExecutionInformation;
    private CMenu menu;
    private Callable<Boolean> enableWhenItemSelected;
    private TestSuiteCollectionCompositePart parentCompositePart;
    private Listener layoutExecutionInformationCompositeListener = new Listener(){

        public void handleEvent(org.eclipse.swt.widgets.Event event) {
            TestSuiteCollectionPart.this.isExecutionInfoCompositeExpanded = !TestSuiteCollectionPart.this.isExecutionInfoCompositeExpanded;
            TestSuiteCollectionPart.this.layoutExecutionInfo();
        }
    };
    private Spinner spnMaxConcurrentThread;
    private Spinner spnDelayBetweenInstances;
    private Composite customViews;
    private Composite parent;
    private Map<String, ExpandableTestSuiteCollectionComposite> viewCompositeMap = new HashMap<String, ExpandableTestSuiteCollectionComposite>();

    @PostConstruct
    public void initialize(Composite parent, TestSuiteCollectionEntity testSuiteCollection, MPart mpart) {
        MCompositePart compositePart;
        this.mpart = mpart;
        this.isExecutionInfoCompositeExpanded = true;
        this.parent = parent;
        this.registerEventListeners();
        if (mpart.getParent().getParent() instanceof MGenericTile && (MGenericTile)mpart.getParent().getParent() instanceof MCompositePart && (compositePart = (MCompositePart)((MGenericTile)mpart.getParent().getParent())).getObject() instanceof TestSuiteCollectionCompositePart) {
            this.parentCompositePart = (TestSuiteCollectionCompositePart)((Object)compositePart.getObject());
        }
        new HelpToolBarForMPart(mpart, DocumentationMessageConstants.TEST_SUITE_COLLECTION);
        this.createControls();
        this.registerControlModifyListeners();
        this.updateTestSuiteCollections(testSuiteCollection);
    }

    private void registerEventListeners() {
        this.eventBroker.subscribe("EXPLORER/RENAMED_SELECTED_ITEM", (EventHandler)this);
        this.eventBroker.subscribe("EXPLORER/DELETED_SELECTED_ITEM", (EventHandler)this);
        this.eventBroker.subscribe("TEST_SUITE_COLLECTION/UPDATED", (EventHandler)this);
        this.eventBroker.subscribe("TESTSUITE/UPDATED", (EventHandler)this);
    }

    private IFileInfo getFileInfo(TestSuiteCollectionEntity testSuiteCollection) {
        return EFS.getLocalFileSystem().fromLocalFile(testSuiteCollection.toFile()).fetchInfo();
    }

    private void updateTestSuiteCollections(TestSuiteCollectionEntity testSuiteCollection) {
        if (testSuiteCollection == null) {
            this.close();
        }
        this.originalTestSuite = testSuiteCollection;
        this.cloneTestSuite = (TestSuiteCollectionEntity)SerializationUtils.clone((Serializable)this.originalTestSuite);
        this.cloneTestSuite.reuseWrappers(this.originalTestSuite);
        this.updateInput();
        this.lastModified = this.getFileInfo(this.originalTestSuite).getLastModified();
        this.createViewsFromViewFactory();
    }

    private void updateInput() {
        this.tableViewer.setInput((Object)this.cloneTestSuite.getTestSuiteRunConfigurations());
        this.updateExecutionInfoInput();
        this.updateRunColumn();
        this.setDirty(false);
    }

    private void updateExecutionInfoInput() {
        this.setStatusForRadioExecutionMode(this.cloneTestSuite.getExecutionMode());
        this.spnMaxConcurrentThread.setSelection(this.cloneTestSuite.getMaxConcurrentInstances());
        this.spnDelayBetweenInstances.setSelection(this.cloneTestSuite.getDelayBetweenInstances());
    }

    private void setStatusForRadioExecutionMode(TestSuiteCollectionEntity.ExecutionMode mode) {
        if (mode == TestSuiteCollectionEntity.ExecutionMode.PARALLEL) {
            this.btnParallel.setSelection(true);
            this.btnSequential.setSelection(false);
            this.spnMaxConcurrentThread.setEnabled(true);
            this.spnDelayBetweenInstances.setEnabled(true);
        } else {
            this.btnSequential.setSelection(true);
            this.btnParallel.setSelection(false);
            this.spnMaxConcurrentThread.setEnabled(false);
            this.spnDelayBetweenInstances.setEnabled(false);
        }
    }

    private void registerControlModifyListeners() {
        this.tblclmnRun.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean isAllRunEnabled = !TestSuiteCollectionPart.this.cloneTestSuite.isAllRunEnabled();
                TestSuiteCollectionPart.this.cloneTestSuite.enableRunForAll(isAllRunEnabled);
                TestSuiteCollectionPart.this.updateRunColumnHeader(isAllRunEnabled);
                TestSuiteCollectionPart.this.tableViewer.refresh();
                TestSuiteCollectionPart.this.markDirty();
            }
        });
        this.tableViewer.getTable().addListener(40, new Listener(){

            public void handleEvent(org.eclipse.swt.widgets.Event event) {
                TestSuiteCollectionPart.this.checkUpdated();
            }
        });
        this.btnExpandExecutionInformation.addListener(3, this.layoutExecutionInformationCompositeListener);
        this.lblExecutionInformation.addListener(3, this.layoutExecutionInformationCompositeListener);
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.getSource() == TestSuiteCollectionPart.this.btnSequential && TestSuiteCollectionPart.this.cloneTestSuite.getExecutionMode() != TestSuiteCollectionEntity.ExecutionMode.SEQUENTIAL) {
                    TestSuiteCollectionPart.this.cloneTestSuite.setExecutionMode(TestSuiteCollectionEntity.ExecutionMode.SEQUENTIAL);
                    TestSuiteCollectionPart.this.setStatusForRadioExecutionMode(TestSuiteCollectionPart.this.cloneTestSuite.getExecutionMode());
                    TestSuiteCollectionPart.this.markDirty();
                    return;
                }
                if (e.getSource() == TestSuiteCollectionPart.this.btnParallel && TestSuiteCollectionPart.this.cloneTestSuite.getExecutionMode() != TestSuiteCollectionEntity.ExecutionMode.PARALLEL) {
                    TestSuiteCollectionPart.this.cloneTestSuite.setExecutionMode(TestSuiteCollectionEntity.ExecutionMode.PARALLEL);
                    TestSuiteCollectionPart.this.setStatusForRadioExecutionMode(TestSuiteCollectionPart.this.cloneTestSuite.getExecutionMode());
                    TestSuiteCollectionPart.this.markDirty();
                }
            }
        };
        this.btnSequential.addSelectionListener((SelectionListener)selectionListener);
        this.btnParallel.addSelectionListener((SelectionListener)selectionListener);
        this.spnMaxConcurrentThread.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TestSuiteCollectionPart.this.cloneTestSuite.setMaxConcurrentInstances(TestSuiteCollectionPart.this.spnMaxConcurrentThread.getSelection());
                TestSuiteCollectionPart.this.markDirty();
            }
        });
        this.spnDelayBetweenInstances.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TestSuiteCollectionPart.this.cloneTestSuite.setDelayBetweenInstances(TestSuiteCollectionPart.this.spnDelayBetweenInstances.getSelection());
                TestSuiteCollectionPart.this.markDirty();
            }
        });
    }

    private void createControls() {
        this.parent.setLayout((Layout)new GridLayout(1, false));
        this.createGeneralInformationComposite();
        this.createCustomViewComposite();
        this.createToolbarComposite();
        this.createTableComposite();
    }

    private void createCustomViewComposite() {
        this.customViews = new Composite(this.parent, 0);
        this.customViews.setBackground(ColorUtil.getCompositeBackgroundColor());
        GridLayout glCustomViews = new GridLayout(1, true);
        glCustomViews.marginHeight = 0;
        glCustomViews.marginWidth = 0;
        this.customViews.setLayout((Layout)glCustomViews);
        this.customViews.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
    }

    private void createViewsFromViewFactory() {
        TestSuiteCollectionViewFactory.getInstance().getSortedBuilders().forEach(entryBuilder -> {
            String name = entryBuilder.getName();
            if (this.viewCompositeMap.get(name) == null) {
                AbstractTestSuiteCollectionUIDescriptionView descView = entryBuilder.getView(this.getTestSuiteCollection(), this.getMPart(), this.getMPart());
                ExpandableTestSuiteCollectionComposite view = new ExpandableTestSuiteCollectionComposite(this.customViews, name, descView);
                this.viewCompositeMap.put(name, view);
            }
        });
    }

    private void createGeneralInformationComposite() {
        this.compositeExecution = new Composite(this.parent, 0);
        this.compositeExecution.setBackground(ColorUtil.getCompositeBackgroundColor());
        this.compositeExecution.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        GridLayout glCompositeInformation = new GridLayout(1, false);
        glCompositeInformation.marginWidth = 0;
        glCompositeInformation.marginHeight = 0;
        glCompositeInformation.verticalSpacing = 0;
        this.compositeExecution.setLayout((Layout)glCompositeInformation);
        this.compositeExecutionHeader = new Composite(this.compositeExecution, 0);
        GridLayout glCompositeInformationHeader = new GridLayout(2, false);
        glCompositeInformationHeader.marginWidth = 0;
        glCompositeInformationHeader.marginHeight = 0;
        this.compositeExecutionHeader.setLayout((Layout)glCompositeInformationHeader);
        this.compositeExecutionHeader.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.compositeExecutionHeader.setCursor(this.compositeExecutionHeader.getDisplay().getSystemCursor(21));
        this.btnExpandExecutionInformation = new ImageButton(this.compositeExecutionHeader, 0);
        this.btnExpandExecutionInformation.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.redrawBtnExpandGeneralInfo();
        this.lblExecutionInformation = new Label(this.compositeExecutionHeader, 0);
        this.lblExecutionInformation.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.lblExecutionInformation.setFont(JFaceResources.getFontRegistry().getBold(""));
        this.lblExecutionInformation.setText(ComposerTestsuiteCollectionMessageConstants.LBL_EXECUTION_INFO);
        this.compositeExecutionInformation = new Composite(this.compositeExecution, 0);
        GridLayout glCompositeInformationDetails = new GridLayout(1, true);
        glCompositeInformationDetails.marginLeft = 45;
        glCompositeInformationDetails.horizontalSpacing = 40;
        this.compositeExecutionInformation.setLayout((Layout)glCompositeInformationDetails);
        this.compositeExecutionInformation.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 1, 1));
        Composite compositeTestSuiteCollectionExecutionMode = new Composite(this.compositeExecutionInformation, 0);
        GridData gdCompositeTestSuiteCollectionExecutionMode = new GridData(4, 4, true, false, 1, 1);
        gdCompositeTestSuiteCollectionExecutionMode.minimumWidth = 300;
        compositeTestSuiteCollectionExecutionMode.setLayoutData((Object)gdCompositeTestSuiteCollectionExecutionMode);
        GridLayout glCompositeTestSuiteCollectionExecutionMode = new GridLayout(2, false);
        glCompositeTestSuiteCollectionExecutionMode.verticalSpacing = 10;
        compositeTestSuiteCollectionExecutionMode.setLayout((Layout)glCompositeTestSuiteCollectionExecutionMode);
        Label lblTestSuiteCollectionExecutionMode = new Label(compositeTestSuiteCollectionExecutionMode, 0);
        GridData gdLblTestSuiteCollectionExecutionMode = new GridData(16384, 128, false, false, 1, 1);
        gdLblTestSuiteCollectionExecutionMode.widthHint = 100;
        gdLblTestSuiteCollectionExecutionMode.verticalIndent = 5;
        lblTestSuiteCollectionExecutionMode.setLayoutData((Object)gdLblTestSuiteCollectionExecutionMode);
        lblTestSuiteCollectionExecutionMode.setText(ComposerTestsuiteCollectionMessageConstants.LBL_TEST_SUTE_COLLECTION_EXECUTION_MODE);
        Composite compositeExecutionRadioGroup = new Composite(compositeTestSuiteCollectionExecutionMode, 0);
        compositeExecutionRadioGroup.setLayoutData((Object)new GridData(4, 128, true, false));
        compositeExecutionRadioGroup.setLayout((Layout)new GridLayout());
        this.btnSequential = new Button(compositeExecutionRadioGroup, 16);
        this.btnSequential.setText(ComposerTestsuiteCollectionMessageConstants.BTN_TEST_SUITE_COLLECTION_EXECUTION_MODE_SEQUENTIAL);
        this.btnSequential.setLayoutData((Object)new GridData(16384, 128, false, false));
        Composite cpstParallel = new Composite(compositeExecutionRadioGroup, 0);
        GridLayout glParallel = new GridLayout(5, false);
        glParallel.marginWidth = 0;
        glParallel.marginHeight = 0;
        cpstParallel.setLayout((Layout)glParallel);
        cpstParallel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.btnParallel = new Button(cpstParallel, 16);
        this.btnParallel.setText(ComposerTestsuiteCollectionMessageConstants.BTN_TEST_SUITE_COLLECTION_EXECUTION_MODE_PARALLEL);
        Label lblMaxConcurrentThread = new Label(cpstParallel, 0);
        lblMaxConcurrentThread.setText("Max concurrent instances: ");
        GridData gdLblMaxInstances = new GridData(16384, 0x1000000, false, false);
        gdLblMaxInstances.horizontalIndent = 20;
        lblMaxConcurrentThread.setLayoutData((Object)gdLblMaxInstances);
        this.spnMaxConcurrentThread = new Spinner(cpstParallel, 2048);
        this.spnMaxConcurrentThread.setMinimum(1);
        this.spnMaxConcurrentThread.setMaximum(1000);
        GridData gdTxtConcurrentThread = new GridData(16384, 0x1000000, false, false);
        gdTxtConcurrentThread.widthHint = 70;
        this.spnMaxConcurrentThread.setLayoutData((Object)gdTxtConcurrentThread);
        Label lblDelay = new Label(cpstParallel, 0);
        lblDelay.setText(ComposerTestsuiteCollectionMessageConstants.LBL_DELAY_BETWEEN_INSTANCES);
        GridData gdLblDelay = new GridData(16384, 0x1000000, false, false);
        gdLblDelay.horizontalIndent = 20;
        lblDelay.setLayoutData((Object)gdLblDelay);
        this.spnDelayBetweenInstances = new Spinner(cpstParallel, 2048);
        this.spnDelayBetweenInstances.setMinimum(0);
        this.spnDelayBetweenInstances.setMaximum(999);
        GridData gdTxtDelay = new GridData(16384, 0x1000000, false, false);
        gdTxtDelay.widthHint = 70;
        this.spnDelayBetweenInstances.setLayoutData((Object)gdTxtDelay);
    }

    private void layoutExecutionInfo() {
        Display.getDefault().timerExec(10, new Runnable(){

            @Override
            public void run() {
                TestSuiteCollectionPart.this.compositeExecutionInformation.setVisible(TestSuiteCollectionPart.this.isExecutionInfoCompositeExpanded);
                if (!TestSuiteCollectionPart.this.isExecutionInfoCompositeExpanded) {
                    ((GridData)TestSuiteCollectionPart.this.compositeExecutionInformation.getLayoutData()).exclude = true;
                    TestSuiteCollectionPart.this.compositeExecution.setSize(TestSuiteCollectionPart.this.compositeExecution.getSize().x, TestSuiteCollectionPart.this.compositeExecution.getSize().y - TestSuiteCollectionPart.this.testSuiteTableComposite.getSize().y - TestSuiteCollectionPart.this.toolbarComposite.getSize().y);
                } else {
                    ((GridData)TestSuiteCollectionPart.this.compositeExecutionInformation.getLayoutData()).exclude = false;
                }
                TestSuiteCollectionPart.this.compositeExecution.layout(true, true);
                TestSuiteCollectionPart.this.compositeExecution.getParent().layout();
                TestSuiteCollectionPart.this.redrawBtnExpandGeneralInfo();
            }
        });
    }

    private void redrawBtnExpandGeneralInfo() {
        this.btnExpandExecutionInformation.getParent().setRedraw(false);
        this.btnExpandExecutionInformation.setImage(this.isExecutionInfoCompositeExpanded ? ImageConstants.IMG_16_ARROW_DOWN : ImageConstants.IMG_16_ARROW_RIGHT);
        this.btnExpandExecutionInformation.getParent().setRedraw(true);
    }

    private void createToolbarComposite() {
        this.toolbarComposite = new Composite(this.parent, 0);
        this.toolbarComposite.setLayout((Layout)new GridLayout(1, false));
        this.toolbarComposite.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        ToolBar toolBar = new ToolBar(this.toolbarComposite, 0x820000);
        toolBar.setForeground(ColorUtil.getToolBarForegroundColor());
        toolBar.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.selectionListener = new ToolbarItemListener(this);
        this.createToolItemWithSelectionListener(toolBar, GlobalStringConstants.ADD, ImageConstants.IMG_16_ADD, this.selectionListener);
        this.createToolItemWithSelectionListener(toolBar, GlobalStringConstants.REMOVE, ImageConstants.IMG_16_REMOVE, this.selectionListener);
        this.createToolItemWithSelectionListener(toolBar, GlobalStringConstants.UP, ImageConstants.IMG_16_UP, this.selectionListener);
        this.createToolItemWithSelectionListener(toolBar, GlobalStringConstants.DOWN, ImageConstants.IMG_16_DOWN, this.selectionListener);
        this.toolItemExecute = this.createToolItemWithSelectionListener(toolBar, ComposerTestsuiteCollectionMessageConstants.PA_ACTION_EXECUTE_TEST_SUITE_COLLECTION, ImageConstants.IMG_16_EXECUTE, this.selectionListener);
        this.createToolItemWithSelectionListener(toolBar, ComposerTestsuiteCollectionMessageConstants.PA_ACTION_ANALYTICS_CREATE_TEST_PLAN, ImageConstants.IMG_16_ADD, this.selectionListener);
    }

    private ToolItem createToolItemWithSelectionListener(ToolBar toolbar, String name, Image image, SelectionAdapter selectionListener) {
        ToolItem toolItem = new ToolItem(toolbar, 0);
        toolItem.setText(name);
        toolItem.setImage(image);
        toolItem.addSelectionListener((SelectionListener)selectionListener);
        return toolItem;
    }

    private void createTableComposite() {
        this.testSuiteTableComposite = new Composite(this.parent, 0);
        this.testSuiteTableComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TableColumnLayout tableLayout = new TableColumnLayout();
        this.testSuiteTableComposite.setLayout((Layout)tableLayout);
        this.tableViewer = new CTableViewer(this.testSuiteTableComposite, 67586);
        Table testSuiteWrapperTable = this.tableViewer.getTable();
        testSuiteWrapperTable.setLinesVisible(ControlUtils.shouldLineVisble((Display)testSuiteWrapperTable.getDisplay()));
        testSuiteWrapperTable.setHeaderVisible(true);
        TableViewerColumn tbvcNo = new TableViewerColumn((TableViewer)this.tableViewer, 0);
        this.tblclmnNo = tbvcNo.getColumn();
        this.tblclmnNo.setText(GlobalStringConstants.NO_);
        tbvcNo.setLabelProvider((CellLabelProvider)new TestSuiteRunConfigLabelProvider(this, 0));
        tableLayout.setColumnData((Widget)this.tblclmnNo, (ColumnLayoutData)new ColumnPixelData(50));
        TableViewerColumn tbvcId = new TableViewerColumn((TableViewer)this.tableViewer, 0);
        this.tblclmnId = tbvcId.getColumn();
        this.tblclmnId.setText(GlobalStringConstants.ID);
        tbvcId.setEditingSupport((EditingSupport)new TestSuiteIdEditingSupport(this));
        tbvcId.setLabelProvider((CellLabelProvider)new TestSuiteRunConfigLabelProvider(this, 1));
        tableLayout.setColumnData((Widget)this.tblclmnId, (ColumnLayoutData)new ColumnWeightData(50, 300));
        TableViewerColumn tbvcRunWith = new TableViewerColumn((TableViewer)this.tableViewer, 0);
        this.tblclmnEnviroment = tbvcRunWith.getColumn();
        this.tblclmnEnviroment.setText(ComposerTestsuiteCollectionMessageConstants.PA_TABLE_COLUMN_RUN_WITH);
        tbvcRunWith.setEditingSupport((EditingSupport)new RunConfigurationChooserEditingSupport(this));
        tbvcRunWith.setLabelProvider((CellLabelProvider)new TestSuiteRunConfigLabelProvider(this, 2));
        tableLayout.setColumnData((Widget)this.tblclmnEnviroment, (ColumnLayoutData)new ColumnWeightData(20, 70));
        TableViewerColumn tbvcRunWithData = new TableViewerColumn((TableViewer)this.tableViewer, 0);
        this.tblclmnRunWithData = tbvcRunWithData.getColumn();
        this.tblclmnRunWithData.setText(ComposerTestsuiteCollectionMessageConstants.PA_TABLE_COLUMN_RUN_CONFIGURATION_DATA);
        tbvcRunWithData.setEditingSupport((EditingSupport)new RunConfigurationDataEditingSupport(this));
        tbvcRunWithData.setLabelProvider((CellLabelProvider)new TestSuiteRunConfigLabelProvider(this, 3));
        tableLayout.setColumnData((Widget)this.tblclmnRunWithData, (ColumnLayoutData)new ColumnWeightData(20, 100));
        TableViewerColumn tbvcProfile = new TableViewerColumn((TableViewer)this.tableViewer, 0);
        this.tblclmnProfile = tbvcProfile.getColumn();
        this.tblclmnProfile.setText(ComposerTestsuiteCollectionMessageConstants.PA_TABLE_COLUMN_PROFILE);
        tbvcProfile.setLabelProvider((CellLabelProvider)new TestSuiteRunConfigLabelProvider(this, 4));
        tbvcProfile.setEditingSupport((EditingSupport)new ExecutionProfileEditingSupport(this));
        tableLayout.setColumnData((Widget)this.tblclmnProfile, (ColumnLayoutData)new ColumnWeightData(40, 200));
        TableViewerColumn tbvcRun = new TableViewerColumn((TableViewer)this.tableViewer, 0);
        this.tblclmnRun = tbvcRun.getColumn();
        this.tblclmnRun.setText(GlobalStringConstants.RUN);
        tbvcRun.setEditingSupport((EditingSupport)new RunEnabledEditingSupport(this));
        tbvcRun.setLabelProvider((CellLabelProvider)new TestSuiteRunConfigLabelProvider(this, 5));
        tableLayout.setColumnData((Widget)this.tblclmnRun, (ColumnLayoutData)new ColumnWeightData(10, 70));
        this.tblclmnProfile.addListener(11, this.tableDidMountListener(tableLayout));
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        DefaultTableColumnViewerEditor.create((CTableViewer)this.tableViewer);
        this.tableViewer.enableTooltipSupport();
        this.createTableMenu(this.tableViewer.getTable());
        this.setTableViewerSelection(this.tableViewer);
        ColumnViewerUtil.setTableActivation((TableViewer)this.tableViewer);
        this.hookDropTestSuiteEvent();
        this.hookDragTestSuiteEvent();
    }

    private Listener tableDidMountListener(final TableColumnLayout tableLayout) {
        return new Listener(){

            public void handleEvent(org.eclipse.swt.widgets.Event event) {
                tableLayout.setColumnData((Widget)TestSuiteCollectionPart.this.tblclmnId, (ColumnLayoutData)new ColumnPixelData(TestSuiteCollectionPart.this.tblclmnId.getWidth()));
                tableLayout.setColumnData((Widget)TestSuiteCollectionPart.this.tblclmnEnviroment, (ColumnLayoutData)new ColumnPixelData(TestSuiteCollectionPart.this.tblclmnEnviroment.getWidth()));
                tableLayout.setColumnData((Widget)TestSuiteCollectionPart.this.tblclmnRunWithData, (ColumnLayoutData)new ColumnPixelData(TestSuiteCollectionPart.this.tblclmnRunWithData.getWidth()));
                tableLayout.setColumnData((Widget)TestSuiteCollectionPart.this.tblclmnProfile, (ColumnLayoutData)new ColumnPixelData(TestSuiteCollectionPart.this.tblclmnProfile.getWidth()));
                TestSuiteCollectionPart.this.tblclmnProfile.removeListener(11, (Listener)this);
            }
        };
    }

    private void hookDragTestSuiteEvent() {
        int operations = 3;
        DragSource dragSource = new DragSource((Control)this.tableViewer.getTable(), operations);
        dragSource.setTransfer(new Transfer[]{new TestSuiteRunConfigurationTransfer()});
        dragSource.addDragListener((DragSourceListener)new TestSuiteTableDragListener(this));
    }

    private void hookDropTestSuiteEvent() {
        DropTarget dt = new DropTarget((Control)this.tableViewer.getTable(), 3);
        List treeEntityTransfers = TransferTypeCollection.getInstance().getTreeEntityTransfer();
        treeEntityTransfers.add(new TestSuiteRunConfigurationTransfer());
        dt.setTransfer(treeEntityTransfers.toArray(new Transfer[treeEntityTransfers.size()]));
        dt.addDropListener((DropTargetListener)new TestSuiteTableDropListener(this));
    }

    private void createTableMenu(Table table) {
        this.menu = new CMenu((Control)table, (HotkeyActiveListener)this.selectionListener);
        table.setMenu((Menu)this.menu);
        this.enableWhenItemSelected = new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return !TestSuiteCollectionPart.this.tableViewer.getSelection().isEmpty();
            }
        };
        this.menu.createMenuItem(GlobalStringConstants.ADD, HK_NEW);
        this.menu.createMenuItem(GlobalStringConstants.REMOVE, HK_DEL, this.enableWhenItemSelected);
        new MenuItem((Menu)this.menu, 2);
        this.menu.createMenuItem(GlobalStringConstants.UP, HK_MOVE_ITEMS_UP, this.enableWhenItemSelected);
        this.menu.createMenuItem(GlobalStringConstants.DOWN, HK_MOVE_ITEMS_DOWN, this.enableWhenItemSelected);
        new MenuItem((Menu)this.menu, 2);
        this.menu.createMenuItem(ComposerTestsuiteCollectionMessageConstants.PA_ACTION_EXECUTE_TEST_SUITE_COLLECTION, HK_EXECUTE, (Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return TestSuiteCollectionPart.this.cloneTestSuite.isAnyRunEnabled();
            }
        }, 8);
    }

    @Override
    public TableViewer getTableViewer() {
        return this.tableViewer;
    }

    @Override
    public List<TestSuiteRunConfiguration> getTableItems() {
        return this.cloneTestSuite.getTestSuiteRunConfigurations();
    }

    @Override
    public void markDirty() {
        this.parentCompositePart.setDirty(true);
    }

    public void setDirty(boolean dirty) {
        this.parentCompositePart.setDirty(dirty);
    }

    @Override
    public boolean containsTestSuite(TestSuiteEntity testSuite) {
        for (TestSuiteRunConfiguration wrapper : this.getTableItems()) {
            if (!ObjectUtils.equals((Object)testSuite, (Object)wrapper.getConfiguration())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void updateRunColumn() {
        this.updateRunColumnHeader(this.cloneTestSuite.isAllRunEnabled());
    }

    private void updateRunColumnHeader(boolean runAllEnabled) {
        if (runAllEnabled) {
            this.tblclmnRun.setImage(ImageConstants.IMG_16_CHECKED);
            return;
        }
        this.tblclmnRun.setImage(ImageConstants.IMG_16_UNCHECKED);
    }

    public void handleEvent(Event event) {
        switch (event.getTopic()) {
            case "EXPLORER/RENAMED_SELECTED_ITEM": {
                Object[] objects = this.getObjects(event);
                if (objects == null || objects.length != 2) {
                    return;
                }
                if (!ObjectUtils.equals((Object)this.originalTestSuite.getIdForDisplay(), (Object)objects[1])) break;
                this.updateTestSuiteCollections(this.originalTestSuite);
                break;
            }
            case "EXPLORER/DELETED_SELECTED_ITEM": {
                Object object = this.getObject(event);
                if (!(object instanceof String)) {
                    return;
                }
                String folderId = (String)object;
                if (!this.originalTestSuite.getIdForDisplay().startsWith(folderId)) break;
                this.close();
                break;
            }
            case "TESTSUITE/UPDATED": {
                this.tableViewer.refresh();
            }
            case "TEST_SUITE_COLLECTION/UPDATED": {
                Object[] objects = this.getObjects(event);
                if (objects == null || objects.length != 2) {
                    return;
                }
                if (!this.originalTestSuite.equals(objects[1])) break;
                this.updateTestSuiteCollections(this.originalTestSuite);
            }
        }
    }

    @PreDestroy
    public void close() {
        this.eventBroker.unsubscribe((EventHandler)this);
    }

    @Focus
    public void focus() {
        this.checkUpdated();
    }

    private void checkUpdated() {
        if (this.lastModified != this.getFileInfo(this.originalTestSuite).getLastModified()) {
            this.updateTestSuiteCollections(this.originalTestSuite);
        }
    }

    @Persist
    public void save() {
        TestSuiteCollectionEntity backup = (TestSuiteCollectionEntity)SerializationUtils.clone((Serializable)this.originalTestSuite);
        backup.reuseWrappers(this.originalTestSuite);
        this.originalTestSuite.reuseWrappers(this.cloneTestSuite);
        try {
            TestSuiteCollectionController.getInstance().updateTestSuiteCollection(this.originalTestSuite);
            this.updateTestSuiteCollections(this.originalTestSuite);
            this.refreshTreeEntity();
            this.setDirty(false);
        }
        catch (DALException e) {
            MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)ComposerTestsuiteCollectionMessageConstants.PA_MSG_UNABLE_TO_UPDATE_TEST_SUITE_COLLECTION, (String)e.getMessage());
            this.originalTestSuite.reuseWrappers(backup);
        }
    }

    private void refreshTreeEntity() {
        try {
            TestSuiteCollectionTreeEntity tsCollectionTreeEntity = TreeEntityUtil.getTestSuiteCollectionTreeEntity((TestSuiteCollectionEntity)this.originalTestSuite, (ProjectEntity)ProjectController.getInstance().getCurrentProject());
            this.eventBroker.send("EXPLORER/REFRESH_TREE_ENTITY", (Object)tsCollectionTreeEntity);
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    @Override
    public void executeTestRun() {
        if (this.parentCompositePart.isDirty()) {
            MessageDialog.openInformation(null, (String)GlobalStringConstants.INFO, (String)ComposerTestsuiteCollectionMessageConstants.INFO_MESSAGE_SAVE_BEFORE_EXECUTE);
            return;
        }
        if (this.originalTestSuite.isEmpty()) {
            if (MessageDialog.openConfirm(null, (String)ComposerTestsuiteCollectionMessageConstants.DIA_TITLE_INFORMATION, (String)ComposerTestsuiteCollectionMessageConstants.JOB_MSG_EMPTY_TEST_SUITE_COLLECTION)) {
                this.selectionListener.executeAction(ToolbarItemListener.ActionId.ADD.getId());
            }
            return;
        }
        if (!this.isValidRunConfigurationData()) {
            return;
        }
        boolean doNotShowCustomKeyworsWarningDialog = ApplicationInfo.getDoNotShowCustomKeyworsWarningDialog();
        ProjectController projectController = ProjectController.getInstance();
        if (!doNotShowCustomKeyworsWarningDialog && LicenseUtil.isFreeLicense() && (projectController.hasCustomKeywords() || projectController.hasPluginKeywords())) {
            int returnedCode = KSEFeatureAccessHandler.showProjectContainsCustomKeywordsWarningDialog();
            if (returnedCode == 2) {
                Program.launch((String)ComposerComponentsImplMessageConstants.URL_PRICING_PAGE);
                return;
            }
            if (returnedCode != 3) {
                return;
            }
        }
        AbstractExecutionHandler.openConsoleLog();
        this.toolItemExecute.setEnabled(false);
        TestSuiteCollectionBuilderJob job = new TestSuiteCollectionBuilderJob(this.originalTestSuite);
        job.schedule();
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                UISynchronizeService.syncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        (this).TestSuiteCollectionPart.this.toolItemExecute.setEnabled(true);
                    }
                });
            }
        });
    }

    private boolean isValidRunConfigurationData() {
        List runConfigs = this.originalTestSuite.getTestSuiteRunConfigurations();
        for (TestSuiteRunConfiguration config : runConfigs) {
            boolean noConfigurationData;
            RunConfigurationDescription configDescription = config.getConfiguration();
            boolean bl = noConfigurationData = configDescription.getRunConfigurationData() == null || configDescription.getRunConfigurationData().isEmpty();
            if (!config.isRunEnabled() || !configDescription.isRequireConfigurationData() || !noConfigurationData) continue;
            MessageDialog.openInformation(null, (String)GlobalStringConstants.INFO, (String)MessageFormat.format(ComposerTestsuiteCollectionMessageConstants.INFO_MESSAGE_ADD_EXECUTION_CONFIGURATION_DATA, configDescription.getRunConfigurationId()));
            return false;
        }
        return true;
    }

    @Override
    public TestSuiteCollectionEntity getTestSuiteCollection() {
        return this.originalTestSuite;
    }

    private void setTableViewerSelection(CTableViewer tableViewer) {
        tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TestSuiteCollectionPart.this.createDynamicGotoSubMenu();
            }
        });
    }

    private void createDynamicGotoSubMenu() {
        ControlUtils.removeOldOpenMenuItem((Menu)this.menu);
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        List<TestSuiteEntity> testSuiteEntities = this.getListTestSuiteFromSelection(selection);
        SelectionAdapter openSubMenuSelection = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object menu = e.getSource();
                if (!(menu instanceof MenuItem)) {
                    return;
                }
                TestSuiteEntity testSuiteEntity = TestSuiteCollectionPart.this.getTestSuiteFromMenuItem((MenuItem)menu);
                if (testSuiteEntity != null) {
                    TestSuiteCollectionPart.this.eventBroker.send("TESTSUITE/OPEN", (Object)testSuiteEntity);
                }
            }
        };
        if (testSuiteEntities.size() == 1) {
            ControlUtils.createOpenMenuWhenSelectOnlyOne((CMenu)this.menu, (FileEntity)((FileEntity)testSuiteEntities.get(0)), this.enableWhenItemSelected, (SelectionAdapter)openSubMenuSelection);
            return;
        }
        MenuUtils.createOpenTestArtifactsMenu(this.getMapFileEntityToSelectionAdapter(testSuiteEntities, openSubMenuSelection), (Menu)this.menu);
    }

    private TestSuiteEntity getTestSuiteFromMenuItem(MenuItem selectedMenuItem) {
        if (selectedMenuItem.getData() instanceof TestSuiteEntity) {
            return (TestSuiteEntity)selectedMenuItem.getData();
        }
        return null;
    }

    private List<TestSuiteEntity> getListTestSuiteFromSelection(IStructuredSelection selection) {
        ArrayList<TestSuiteEntity> testSuiteEntities = new ArrayList<TestSuiteEntity>();
        for (Object object : selection.toList()) {
            TestSuiteEntity testSuiteEntity;
            if (!(object instanceof TestSuiteRunConfiguration) || testSuiteEntities.contains(testSuiteEntity = ((TestSuiteRunConfiguration)object).getTestSuiteEntity())) continue;
            testSuiteEntities.add(testSuiteEntity);
        }
        return testSuiteEntities;
    }

    private HashMap<FileEntity, SelectionAdapter> getMapFileEntityToSelectionAdapter(List<? extends FileEntity> fileEntities, SelectionAdapter openTestSuite) {
        HashMap<FileEntity, SelectionAdapter> map = new HashMap<FileEntity, SelectionAdapter>();
        for (FileEntity fileEntity : fileEntities) {
            if (!(fileEntity instanceof TestSuiteEntity)) continue;
            map.put(fileEntity, openTestSuite);
        }
        return map;
    }

    public String getEntityId() {
        return this.originalTestSuite.getIdForDisplay();
    }

    @Inject
    @Optional
    public void onSelect(@UIEventTopic(value="org/eclipse/e4/ui/LifeCycle/bringToTop") Event event) {
    }

    @Inject
    @Optional
    public void onChangeEntityProperties(@UIEventTopic(value="PROPERTIES/ENTITY_UPDATED") Event event) {
    }

    @PreDestroy
    public void onClose() {
    }

    public MPart getMPart() {
        return this.mpart;
    }
}

