/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.collector;

import com.kms.katalon.core.helper.LogRecordHelper;
import com.kms.katalon.core.logging.XmlLogRecord;
import com.kms.katalon.core.logging.model.ILogRecord;
import com.kms.katalon.core.logging.model.TestSuiteLogRecord;
import com.kms.katalon.core.setting.VideoRecorderSetting;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.execution.collector.ExecutionInfo;
import com.kms.katalon.execution.configuration.IRunConfiguration;
import com.kms.katalon.execution.setting.ExecutionSettingStore;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExecutionInfoCollector {
    private static ExecutionInfoCollector _instance;

    public static ExecutionInfoCollector getInstance() {
        if (_instance == null) {
            _instance = new ExecutionInfoCollector();
        }
        return _instance;
    }

    public ExecutionInfo collect(IRunConfiguration runConfig, TestSuiteLogRecord testSuiteLogRecord, List<XmlLogRecord> testSteps) {
        Map<String, Object> generalProps = runConfig.getExecutionSetting().getGeneralProperties();
        Map reportProps = (Map)generalProps.get("report");
        boolean isEnableScreenshot = (Boolean)reportProps.get("screenCaptureOption");
        VideoRecorderSetting recordingSettings = (VideoRecorderSetting)reportProps.get("videoRecorderOption");
        String recordingLevel = recordingSettings.isUseBrowserRecorder() ? "browser" : "screen";
        ExecutionInfo executionInfo = new ExecutionInfo(isEnableScreenshot, recordingSettings.isEnable(), recordingLevel);
        executionInfo.setKeywordsUsage(this.collectKeywordsUsage(testSuiteLogRecord, testSteps));
        executionInfo.setUsingApplitools(this.collectApplitoolUsage(testSuiteLogRecord, testSteps));
        return executionInfo;
    }

    public ExecutionInfo collect() {
        boolean isEnabelScreenshot = true;
        boolean isEnableVideoRecording = false;
        String recordingLevel = "";
        try {
            ExecutionSettingStore executionStore = ExecutionSettingStore.getStore();
            isEnabelScreenshot = executionStore.getScreenCaptureOption();
            isEnableVideoRecording = executionStore.getVideoRecorderSetting().isEnable();
            recordingLevel = executionStore.getVideoRecorderSetting().isUseBrowserRecorder() ? "browser" : "screen";
        }
        catch (IOException iOException) {}
        return new ExecutionInfo(isEnabelScreenshot, isEnableVideoRecording, recordingLevel);
    }

    private Map<String, Boolean> collectKeywordsUsage(TestSuiteLogRecord testSuiteLogRecord, List<XmlLogRecord> testSteps) {
        try {
            if (testSuiteLogRecord != null) {
                ILogRecord[] childRecords;
                HashMap<String, Boolean> allKeywordsUsages = new HashMap<String, Boolean>();
                ILogRecord[] iLogRecordArray = childRecords = testSuiteLogRecord.getChildRecords();
                int n = childRecords.length;
                int n2 = 0;
                while (n2 < n) {
                    ILogRecord logRecordI = iLogRecordArray[n2];
                    try {
                        String rawKeywordsUsage = LogRecordHelper.getProperty((ILogRecord)logRecordI, (String)"keywordsUsage");
                        Map keywordsUsage = (Map)JsonUtil.fromJson((String)rawKeywordsUsage, Map.class);
                        keywordsUsage.forEach((platform, hasUsed) -> {
                            boolean isAlreadyUsed = allKeywordsUsages.containsKey(platform) ? (Boolean)allKeywordsUsages.get(platform) : false;
                            allKeywordsUsages.put((String)platform, hasUsed != false || isAlreadyUsed);
                        });
                    }
                    catch (Exception exception) {}
                    ++n2;
                }
                return allKeywordsUsages;
            }
            if (testSteps != null) {
                if (testSteps.isEmpty()) {
                    return new HashMap<String, Boolean>();
                }
                XmlLogRecord endTestCaseLogRecord = testSteps.get(testSteps.size() - 1);
                String rawKeywordsUsage = (String)endTestCaseLogRecord.getProperties().get("keywordsUsage");
                return (Map)JsonUtil.fromJson((String)rawKeywordsUsage, Map.class);
            }
        }
        catch (Exception exception) {
            return null;
        }
        return null;
    }

    private boolean collectApplitoolUsage(TestSuiteLogRecord testSuiteLogRecord, List<XmlLogRecord> testSteps) {
        boolean isUsed;
        block8: {
            block9: {
                isUsed = false;
                try {
                    if (testSuiteLogRecord != null) {
                        ILogRecord[] childRecords;
                        ILogRecord[] iLogRecordArray = childRecords = testSuiteLogRecord.getChildRecords();
                        int n = childRecords.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ILogRecord logRecordI = iLogRecordArray[n2];
                            try {
                                String applitoolUsage = LogRecordHelper.getProperty((ILogRecord)logRecordI, (String)"applitools");
                                isUsed = Boolean.parseBoolean(applitoolUsage);
                                if (isUsed) {
                                    return isUsed;
                                }
                            }
                            catch (Exception exception) {}
                            ++n2;
                        }
                        return isUsed;
                    }
                    if (testSteps == null) break block8;
                    if (!testSteps.isEmpty()) break block9;
                    return false;
                }
                catch (Exception exception) {
                    return false;
                }
            }
            XmlLogRecord endTestCaseLogRecord = testSteps.get(testSteps.size() - 1);
            String applitoolUsage = (String)endTestCaseLogRecord.getProperties().get("applitools");
            return Boolean.parseBoolean(applitoolUsage);
        }
        return isUsed;
    }
}

