/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.console.entity;

import com.katalon.platform.api.controller.TestCaseController;
import com.katalon.platform.api.exception.ResourceException;
import com.katalon.platform.api.model.ProjectEntity;
import com.katalon.platform.api.model.TestCaseEntity;
import com.katalon.platform.api.service.ApplicationManager;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.entity.util.EntityTagUtil;
import com.kms.katalon.execution.console.entity.StringConsoleOption;
import com.kms.katalon.logging.LogUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class TagsLauncherOptionParserDescription {
    public static TestSuiteEntity getTestCaseWithTags(StringConsoleOption option, TestSuiteEntity testSuite) {
        TestCaseController testCaseController = (TestCaseController)ApplicationManager.getInstance().getControllerManager().getController(TestCaseController.class);
        ProjectEntity currentProject = ApplicationManager.getInstance().getProjectManager().getCurrentProject();
        List<TestCaseEntity> testCases = testSuite.getTestSuiteTestCaseLinks().stream().map(a -> a.getTestCaseId()).map(b -> {
            try {
                return testCaseController.getTestCase(currentProject, b);
            }
            catch (ResourceException e) {
                LogUtil.logError((Throwable)e);
                return null;
            }
        }).filter(c -> c != null).collect(Collectors.toList());
        List<TestCaseEntity> filteredTestCases = TagsLauncherOptionParserDescription.onPreExecution(option, testCases);
        Set intersection = filteredTestCases.stream().map(b -> b.getId()).collect(Collectors.toSet());
        testSuite.setTestSuiteTestCaseLinks(testSuite.getTestSuiteTestCaseLinks().stream().filter(a -> intersection.contains(a.getTestCaseId())).collect(Collectors.toList()));
        return testSuite;
    }

    private static boolean hasTags(String entityTagValues, String searchTagValues) {
        if (StringUtils.isBlank((CharSequence)searchTagValues)) {
            return true;
        }
        if (StringUtils.isBlank((CharSequence)entityTagValues)) {
            return false;
        }
        Set searchTags = EntityTagUtil.parse((String)searchTagValues).stream().map(tag -> tag.toLowerCase()).collect(Collectors.toSet());
        Set entityTags = EntityTagUtil.parse((String)entityTagValues).stream().map(tag -> tag.toLowerCase()).collect(Collectors.toSet());
        return entityTags.containsAll(searchTags);
    }

    private static List<TestCaseEntity> onPreExecution(StringConsoleOption tagConsoleOption, List<TestCaseEntity> arg0) {
        ArrayList<TestCaseEntity> filteredTestCases = new ArrayList<TestCaseEntity>();
        if (tagConsoleOption.getValue() == null) {
            return arg0;
        }
        System.out.println("----------------- TEST CASE TAGS PLUGIN START FILTERING -----------------");
        arg0.stream().forEach(a -> {
            if (TagsLauncherOptionParserDescription.hasTags(a.getTags(), ((String)tagConsoleOption.getValue()).toString())) {
                System.out.println(String.valueOf(a.getId()) + " is a test case to be run");
                filteredTestCases.add((TestCaseEntity)a);
            } else {
                System.out.println(String.valueOf(a.getId()) + " is filtered out ");
            }
        });
        System.out.println("----------------- TEST CASE TAGS PLUGIN FINISH FILTERING -----------------");
        return filteredTestCases;
    }
}

