/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.entity;

import com.katalon.platform.api.exception.ResourceException;
import com.katalon.platform.api.extension.DynamicQueryingTestSuiteDescription;
import com.kms.katalon.controller.FilterController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.controller.TestSuiteController;
import com.kms.katalon.core.testdata.TestData;
import com.kms.katalon.core.testdata.TestDataInfo;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.link.TestSuiteTestCaseLink;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testsuite.FilteringTestSuiteEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.execution.console.entity.ConsoleOption;
import com.kms.katalon.execution.console.entity.ConsoleOptionContributor;
import com.kms.katalon.execution.constants.StringConstants;
import com.kms.katalon.execution.entity.DefaultRerunSetting;
import com.kms.katalon.execution.entity.EmailConfig;
import com.kms.katalon.execution.entity.EmailSettings;
import com.kms.katalon.execution.entity.ExecutedEntity;
import com.kms.katalon.execution.entity.IExecutedEntity;
import com.kms.katalon.execution.entity.ReportLocationSetting;
import com.kms.katalon.execution.entity.Reportable;
import com.kms.katalon.execution.entity.Rerunable;
import com.kms.katalon.execution.entity.TestCaseBindingExecutedEntity;
import com.kms.katalon.execution.entity.TestCaseExecutedEntity;
import com.kms.katalon.execution.entity.WebServiceExecutionSettings;
import com.kms.katalon.execution.exception.ExecutionException;
import com.kms.katalon.execution.platform.DynamicQueryingTestSuiteExtensionProvider;
import com.kms.katalon.execution.platform.ExecutionPlatformServiceProvider;
import com.kms.katalon.execution.util.MailUtil;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class TestSuiteExecutedEntity
extends ExecutedEntity
implements Reportable,
Rerunable,
ConsoleOptionContributor {
    public static final String IS_RERUN_IMMEDIATELY = "rerunTestFailImmediately";
    public static final String RETRY_COUNT = "retryCount";
    private List<IExecutedEntity> executedItems;
    private Map<String, TestData> testDataMap = new HashMap<String, TestData>();
    private WebServiceExecutionSettings webServiceSettings = new WebServiceExecutionSettings();
    private ReportLocationSetting reportLocationSetting = new ReportLocationSetting();
    private int failedThreshold = -1;
    private DefaultRerunSetting rerunSetting;
    private boolean isInCollection;
    private boolean useDdtAtTCLevel = false;
    private String testSuiteCollectionId;
    private EmailSettings emailSettings = new EmailSettings();

    public String getTestSuiteCollectionId() {
        return this.testSuiteCollectionId;
    }

    public void setTestSuiteCollectionId(String testSuiteCollectionId) {
        this.testSuiteCollectionId = testSuiteCollectionId;
    }

    public boolean isInCollection() {
        return this.isInCollection;
    }

    public void setInCollection(boolean isInCollection) {
        this.isInCollection = isInCollection;
    }

    public EmailSettings getEmailSettings() {
        return this.emailSettings;
    }

    public TestSuiteExecutedEntity() {
        this.rerunSetting = new DefaultRerunSetting();
        this.executedItems = new ArrayList<IExecutedEntity>();
    }

    public TestSuiteExecutedEntity(TestSuiteEntity testSuite) throws Exception {
        this();
        this.setTestSuite(testSuite);
    }

    public TestSuiteExecutedEntity(TestSuiteEntity testSuite, Rerunable rerunnable) throws Exception {
        this(testSuite);
        this.rerunSetting.setPreviousRerunTimes(rerunnable.getPreviousRerunTimes());
        this.rerunSetting.setRemainingRerunTimes(rerunnable.getRemainingRerunTimes());
        this.rerunSetting.setRerunFailedTestCaseOnly(rerunnable.isRerunFailedTestCasesOnly());
        this.rerunSetting.setRerunFailedTestCaseAndTestDataOnly(rerunnable.isRerunFailedTestCasesAndTestDataOnly());
        this.rerunSetting.setRerunImmediately(rerunnable.isRerunImmediately());
    }

    public void setTestSuite(TestSuiteEntity testSuite) throws Exception {
        this.updateEntity((FileEntity)testSuite);
        this.getEmailConfig(testSuite.getProject()).addRecipients(MailUtil.splitRecipientsString(testSuite.getMailRecipient()));
        this.rerunSetting.setRemainingRerunTimes(testSuite.getNumberOfRerun());
        this.rerunSetting.setRerunFailedTestCaseOnly(testSuite.isRerunFailedTestCasesOnly());
        this.rerunSetting.setRerunFailedTestCaseAndTestDataOnly(testSuite.isRerunFailedTestCasesAndTestDataOnly());
        this.rerunSetting.setRerunImmediately(testSuite.isRerunImmediately());
    }

    public void prepareTestCases() throws Exception {
        TestSuiteEntity testSuite = (TestSuiteEntity)this.getEntity();
        List<IExecutedEntity> executedItems = testSuite instanceof FilteringTestSuiteEntity ? this.loadTestCasesForFilteringTestSuite((FilteringTestSuiteEntity)testSuite, "") : this.loadTestCases(testSuite, "");
        this.verifyIfUseDDTAtTCLevel(executedItems);
        this.setTestCaseExecutedEntities(executedItems);
    }

    public void prepareTestCasesWithTestSuiteQuery(String testSuiteQuery) throws Exception {
        TestSuiteEntity testSuite = (TestSuiteEntity)this.getEntity();
        List<IExecutedEntity> executedItems = testSuite instanceof FilteringTestSuiteEntity ? this.loadTestCasesForFilteringTestSuite((FilteringTestSuiteEntity)testSuite, testSuiteQuery) : this.loadTestCases(testSuite, testSuiteQuery);
        this.setTestCaseExecutedEntities(executedItems);
    }

    private List<IExecutedEntity> loadTestCasesForFilteringTestSuite(FilteringTestSuiteEntity testSuite, String testSuiteQuery) throws IOException, ExecutionException, ResourceException {
        DynamicQueryingTestSuiteExtensionProvider dynamicQueryingTestSuiteProvider = ExecutionPlatformServiceProvider.getInstance().getPlatformService(DynamicQueryingTestSuiteExtensionProvider.class);
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        DynamicQueryingTestSuiteDescription selectedQueryingDescription = dynamicQueryingTestSuiteProvider.getSelectedDynamicQueryingDescription(project, testSuite);
        List<TestCaseEntity> filteredTestCases = dynamicQueryingTestSuiteProvider.getFilteredTestCases(project, testSuite, selectedQueryingDescription, StringUtils.defaultIfEmpty((String)testSuiteQuery, (String)testSuite.getFilteringText()));
        ArrayList<IExecutedEntity> testCaseBindingExecutedEntities = new ArrayList<IExecutedEntity>();
        for (TestCaseEntity testCase : filteredTestCases) {
            TestCaseBindingExecutedEntity testCaseBindingExecutedEntity = new TestCaseBindingExecutedEntity(testCase);
            testCaseBindingExecutedEntities.add(testCaseBindingExecutedEntity);
        }
        return testCaseBindingExecutedEntities;
    }

    private List<IExecutedEntity> loadTestCases(TestSuiteEntity testSuite, String testSuiteQuery) throws Exception {
        String projectDir = testSuite.getProject().getFolderLocation();
        this.testDataMap.clear();
        for (TestSuiteTestCaseLink testCaseLink : TestSuiteController.getInstance().getTestSuiteTestCaseRun(testSuite)) {
            TestCaseEntity testCase = TestCaseController.getInstance().getTestCaseByDisplayId(testCaseLink.getTestCaseId());
            if (testCase == null) {
                throw new IllegalArgumentException(MessageFormat.format(StringConstants.UTIL_EXC_TEST_CASE_X_NOT_FOUND, testCaseLink.getTestCaseId()));
            }
            if (!FilterController.getInstance().isMatched((FileEntity)testCase, testSuiteQuery)) continue;
            if (testCaseLink.isUsingDataBindingAtTestSuiteLevel()) {
                TestCaseExecutedEntity testCaseExecutedEntity = new TestCaseExecutedEntity(testCase);
                testCaseExecutedEntity.setLoopTimes(1);
                this.prepareTestCaseExecutedEntity(projectDir, testCaseLink, testCaseExecutedEntity);
                this.getExecutedItems().add(testCaseExecutedEntity);
                continue;
            }
            this.useDdtAtTCLevel = true;
            TestCaseBindingExecutedEntity testCaseBindingExecutedEntity = new TestCaseBindingExecutedEntity(testCase);
            this.getExecutedItems().add(testCaseBindingExecutedEntity);
        }
        return this.executedItems;
    }

    private void prepareTestCaseExecutedEntity(String projectDir, TestSuiteTestCaseLink testCaseLink, TestCaseExecutedEntity testCaseExecutedEntity) throws Exception {
        List testDataLinkUsedList = TestSuiteController.getInstance().getTestDataLinkUsedInTestCase(testCaseLink);
        if (testDataLinkUsedList.size() <= 0) {
            return;
        }
        this.prepareTestCaseExecutedEntityBody(testCaseExecutedEntity, testCaseExecutedEntity.getTestDataExecutions(), testCaseLink.getTestCaseId(), testDataLinkUsedList, projectDir, this.testDataMap);
    }

    @Override
    public List<IExecutedEntity> getExecutedItems() {
        return this.executedItems;
    }

    public void setTestCaseExecutedEntities(List<IExecutedEntity> testCaseExecutedEntities) {
        this.executedItems = testCaseExecutedEntities;
    }

    @Override
    public int getTotalTestCases() {
        int total = 0;
        for (IExecutedEntity testCaseExecutionEntity : this.getExecutedItems()) {
            if (testCaseExecutionEntity instanceof TestCaseExecutedEntity) {
                total += ((TestCaseExecutedEntity)testCaseExecutionEntity).getLoopTimes();
                continue;
            }
            if (!(testCaseExecutionEntity instanceof TestCaseBindingExecutedEntity)) continue;
            total += ((TestCaseBindingExecutedEntity)testCaseExecutionEntity).getTestCaseExecutedEntity().getLoopTimes();
        }
        return total;
    }

    public Map<String, TestData> getTestDataMap() {
        return this.testDataMap;
    }

    public void setTestDataMap(Map<String, TestData> testDataMap) {
        this.testDataMap = testDataMap;
    }

    @Override
    public ReportLocationSetting getReportLocationSetting() {
        return this.reportLocationSetting;
    }

    public void setReportLocation(ReportLocationSetting reportLocation) {
        this.reportLocationSetting = reportLocation;
    }

    @Override
    public int mainTestCaseDepth() {
        return 1;
    }

    @Override
    public boolean isRerunFailedTestCasesOnly() {
        return this.rerunSetting.isRerunFailedTestCasesOnly();
    }

    public DefaultRerunSetting getRerunSetting() {
        return this.rerunSetting;
    }

    public void setRerunSetting(DefaultRerunSetting rerunSetting) {
        this.rerunSetting = rerunSetting;
    }

    @Override
    public int getPreviousRerunTimes() {
        return this.rerunSetting.getPreviousRerunTimes();
    }

    @Override
    public int getRemainingRerunTimes() {
        return this.rerunSetting.getRemainingRerunTimes();
    }

    public void setEmailConfig(EmailConfig emailConfig) {
        this.emailSettings.setEmailConfig(emailConfig);
    }

    @Override
    public EmailConfig getEmailConfig(ProjectEntity project) {
        return this.emailSettings.getEmailConfig(project);
    }

    public WebServiceExecutionSettings getWebServiceSettings() {
        return this.webServiceSettings;
    }

    public void setWebServiceSettings(WebServiceExecutionSettings webServiceSettings) {
        this.webServiceSettings = webServiceSettings;
    }

    @Override
    public List<ConsoleOption<?>> getConsoleOptionList() {
        ArrayList consoleOptionList = new ArrayList();
        consoleOptionList.addAll(this.reportLocationSetting.getConsoleOptionList());
        consoleOptionList.addAll(this.emailSettings.getConsoleOptionList());
        consoleOptionList.addAll(this.rerunSetting.getConsoleOptionList());
        consoleOptionList.addAll(this.webServiceSettings.getConsoleOptionList());
        return consoleOptionList;
    }

    @Override
    public void setArgumentValue(ConsoleOption<?> consoleOption, String argumentValue) throws Exception {
        this.reportLocationSetting.setArgumentValue(consoleOption, argumentValue);
        this.emailSettings.setArgumentValue(consoleOption, argumentValue);
        this.rerunSetting.setArgumentValue(consoleOption, argumentValue);
        this.webServiceSettings.setArgumentValue(consoleOption, argumentValue);
    }

    @Override
    public Map<String, String> getCollectedDataInfo() {
        HashMap<String, String> collectedInfo = new HashMap<String, String>();
        for (TestData testDataUsed : this.testDataMap.values()) {
            TestDataInfo testDataInfo = testDataUsed.getDataInfo();
            if (testDataInfo == null) continue;
            collectedInfo.put(testDataInfo.getKey(), testDataInfo.getInfo());
        }
        return collectedInfo;
    }

    @Override
    public Map<String, Object> getAttributes() {
        Map<String, Object> attributes = super.getAttributes();
        attributes.put(IS_RERUN_IMMEDIATELY, this.isRerunImmediately());
        attributes.put(RETRY_COUNT, this.rerunSetting.getRemainingRerunTimes());
        return attributes;
    }

    @Override
    public Rerunable mergeWith(Rerunable rerunable) {
        return this;
    }

    @Override
    public boolean isRerunFailedTestCasesAndTestDataOnly() {
        return this.rerunSetting.isRerunFailedTestCasesAndTestDataOnly();
    }

    @Override
    public boolean isRerunImmediately() {
        return this.rerunSetting.isRerunImmediately();
    }

    public DefaultRerunSetting.RetryStrategyValue getRetryStrategy() {
        if (this.isRerunFailedTestCasesAndTestDataOnly() || this.isRerunFailedTestCasesOnly()) {
            return DefaultRerunSetting.RetryStrategyValue.FAILED_EXECUTIONS;
        }
        if (this.isRerunImmediately()) {
            return DefaultRerunSetting.RetryStrategyValue.IMMEDIATELY;
        }
        return DefaultRerunSetting.RetryStrategyValue.ALL_EXECUTIONS;
    }

    @Override
    public int getFailedThreshold() {
        return this.failedThreshold;
    }

    public void setFailedThreshold(int value) {
        this.failedThreshold = value;
    }

    public boolean isUseDdtAtTCLevel() {
        return this.useDdtAtTCLevel;
    }

    public void setUseDdtAtTCLevel(boolean useDdtAtTCLevel) {
        this.useDdtAtTCLevel = useDdtAtTCLevel;
    }

    public void verifyIfUseDDTAtTCLevel(List<IExecutedEntity> executedItems) {
        boolean isUseDdtAtTcLvl = false;
        for (IExecutedEntity testCaseExecuted : executedItems) {
            boolean isUseDataBinding;
            if (!(testCaseExecuted instanceof TestCaseBindingExecutedEntity)) continue;
            TestCaseEntity testCase = (TestCaseEntity)((TestCaseBindingExecutedEntity)testCaseExecuted).getEntity();
            boolean bl = isUseDataBinding = !testCase.getVariables().isEmpty() && !TestCaseController.getInstance().isNotUsingDataBinding(testCase);
            if (!isUseDataBinding) continue;
            isUseDdtAtTcLvl = true;
            break;
        }
        this.useDdtAtTCLevel = isUseDdtAtTcLvl;
    }
}

