/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.launcher;

import com.kms.katalon.application.utils.MachineUtil;
import com.kms.katalon.core.logging.model.TestStatus;
import com.kms.katalon.execution.entity.IExecutedEntity;
import com.kms.katalon.execution.integration.ReportIntegrationContribution;
import com.kms.katalon.execution.integration.ReportIntegrationFactory;
import com.kms.katalon.execution.launcher.ObservableLauncher;
import com.kms.katalon.execution.launcher.listener.LauncherEvent;
import com.kms.katalon.execution.launcher.listener.LauncherListener;
import com.kms.katalon.execution.launcher.listener.LauncherNotifiedObject;
import com.kms.katalon.execution.launcher.result.ExecutionEntityResult;
import com.kms.katalon.execution.launcher.result.LauncherStatus;
import com.kms.katalon.logging.LogUtil;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;

abstract class BasicLauncher
implements ObservableLauncher {
    private LauncherStatus status = LauncherStatus.WAITING;
    private List<LauncherListener> listeners;
    private String message;
    private String executionUUID = UUID.randomUUID().toString();
    private boolean areEmailsSent;

    public boolean getAreEmailsSent() {
        return this.areEmailsSent;
    }

    public void setAreEmailsSent(boolean areEmailsSent) {
        this.areEmailsSent = areEmailsSent;
    }

    protected BasicLauncher() {
        this.listeners = new LinkedList<LauncherListener>();
        this.setMessage("");
    }

    protected void notifyLauncherChanged(LauncherEvent event, Object object) {
        ArrayList<LauncherListener> copiedLauncherListeners = new ArrayList<LauncherListener>(this.listeners);
        for (LauncherListener l : copiedLauncherListeners) {
            l.handleLauncherEvent(event, new LauncherNotifiedObject(this.getId(), object));
        }
    }

    protected void notifyProccess(Object event, IExecutedEntity executedEntity, ExecutionEntityResult result) {
        result.setExecutedEntity(executedEntity);
        result.setEvent(event);
        result.setSessionId(this.executionUUID);
        for (Map.Entry<String, ReportIntegrationContribution> reportContributorEntry : ReportIntegrationFactory.getInstance().getIntegrationContributorMap().entrySet()) {
            reportContributorEntry.getValue();
            try {
                reportContributorEntry.getValue().notifyProccess(event, result);
            }
            catch (Exception e) {
                LogUtil.logError((Throwable)e);
            }
        }
    }

    public String getMachineId() {
        return MachineUtil.getMachineId();
    }

    @Override
    public void addListener(LauncherListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeListener(LauncherListener l) {
        this.listeners.remove(l);
    }

    @Override
    public LauncherStatus getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(LauncherStatus status) {
        this.setStatus(status, "");
    }

    public void setStatus(LauncherStatus status, String message) {
        this.setMessage(message);
        this.status = status;
        this.notifyLauncherChanged(LauncherEvent.UPDATE_STATUS, (Object)status);
    }

    protected void onUpdateResult(TestStatus.TestStatusValue testStatusValue) {
        this.notifyLauncherChanged(LauncherEvent.UPDATE_RESULT, testStatusValue);
    }

    public String getMessage() {
        return this.message;
    }

    private void setMessage(String message) {
        this.message = message;
    }

    @Override
    public String getExecutionUUID() {
        return this.executionUUID;
    }

    public void setExecutionUUID(String executionUUID) {
        if (StringUtils.isEmpty((String)executionUUID)) {
            return;
        }
        this.executionUUID = executionUUID;
    }
}

