/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.launcher;

import com.katalon.platform.api.execution.TestSuiteExecutionContext;
import com.kms.katalon.application.utils.VersionUtil;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.ReportController;
import com.kms.katalon.core.logging.model.TestStatus;
import com.kms.katalon.core.logging.model.TestSuiteCollectionLogRecord;
import com.kms.katalon.core.logging.model.TestSuiteLogRecord;
import com.kms.katalon.core.model.RunningMode;
import com.kms.katalon.core.reporting.ReportUtil;
import com.kms.katalon.core.setting.ReportBundleSettingStore;
import com.kms.katalon.core.util.ApplicationRunningMode;
import com.kms.katalon.dal.exception.DALException;
import com.kms.katalon.entity.report.ReportCollectionEntity;
import com.kms.katalon.entity.report.ReportItemDescription;
import com.kms.katalon.entity.testsuite.RunConfigurationDescription;
import com.kms.katalon.entity.testsuite.TestSuiteCollectionEntity;
import com.kms.katalon.execution.addon.ExecutionBundleActivator;
import com.kms.katalon.execution.configuration.AbstractRunConfiguration;
import com.kms.katalon.execution.constants.ExecutionMessageConstants;
import com.kms.katalon.execution.constants.StringConstants;
import com.kms.katalon.execution.entity.EmailConfig;
import com.kms.katalon.execution.entity.Reportable;
import com.kms.katalon.execution.entity.TestSuiteCollectionExecutedEntity;
import com.kms.katalon.execution.entity.TestSuiteCollectionExecutionContextImpl;
import com.kms.katalon.execution.handler.OrganizationHandler;
import com.kms.katalon.execution.integration.ReportIntegrationContribution;
import com.kms.katalon.execution.integration.ReportIntegrationFactory;
import com.kms.katalon.execution.launcher.BasicLauncher;
import com.kms.katalon.execution.launcher.ILauncher;
import com.kms.katalon.execution.launcher.ReportableLauncher;
import com.kms.katalon.execution.launcher.SubConsoleLauncher;
import com.kms.katalon.execution.launcher.SubLauncher;
import com.kms.katalon.execution.launcher.listener.LauncherEvent;
import com.kms.katalon.execution.launcher.listener.LauncherListener;
import com.kms.katalon.execution.launcher.listener.LauncherNotifiedObject;
import com.kms.katalon.execution.launcher.manager.LauncherManager;
import com.kms.katalon.execution.launcher.provider.ExportReportProvider;
import com.kms.katalon.execution.launcher.result.ExecutionEntityResult;
import com.kms.katalon.execution.launcher.result.ILauncherResult;
import com.kms.katalon.execution.launcher.result.LauncherStatus;
import com.kms.katalon.execution.launcher.result.TestSuiteCollectionLauncherResult;
import com.kms.katalon.execution.platform.TestSuiteCollectionExecutionEvent;
import com.kms.katalon.execution.setting.EmailVariableBinding;
import com.kms.katalon.execution.util.MailUtil;
import com.kms.katalon.feature.FeatureServiceConsumer;
import com.kms.katalon.feature.IFeatureService;
import com.kms.katalon.feature.KSEFeature;
import com.kms.katalon.logging.LogUtil;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class TestSuiteCollectionLauncher
extends BasicLauncher
implements LauncherListener {
    public static final int MAX_NUMBER_INSTANCES_IN_PARALLEL_MODE = 8;
    protected List<ReportableLauncher> subLaunchers;
    private TestSuiteCollectionLauncherResult result;
    protected TestSuiteCollectionLauncherManager subLauncherManager;
    private LauncherManager parentManager;
    private Thread watchDog;
    private TestSuiteCollectionExecutedEntity executedEntity;
    private TestSuiteCollectionEntity.ExecutionMode executionMode;
    private ReportCollectionEntity reportCollection;
    private Date startTime;
    private Date endTime;
    private int threshold;
    private int originalThreshold;
    private IFeatureService featureService = FeatureServiceConsumer.getServiceInstance();

    public TestSuiteCollectionLauncher(TestSuiteCollectionExecutedEntity executedEntity, LauncherManager parentManager, List<ReportableLauncher> subLaunchers, TestSuiteCollectionEntity.ExecutionMode executionMode, ReportCollectionEntity reportCollection, String execytionUUID) {
        super.setExecutionUUID(execytionUUID);
        this.subLauncherManager = new TestSuiteCollectionLauncherManager();
        this.subLaunchers = subLaunchers;
        for (ReportableLauncher subLauncher : subLaunchers) {
            subLauncher.setExecutionUUID(super.getExecutionUUID());
        }
        this.result = new TestSuiteCollectionLauncherResult(this, executedEntity.getTotalTestCases());
        this.parentManager = parentManager;
        this.executedEntity = executedEntity;
        this.executionMode = executionMode;
        this.reportCollection = reportCollection;
        this.originalThreshold = -1;
        for (ReportableLauncher subLauncher : subLaunchers) {
            subLauncher.setTestSuiteCollectionEntity(this.getTestSuiteCollectionEntity());
        }
        this.addListenerForChildren(subLaunchers);
    }

    private void addListenerForChildren(List<? extends ReportableLauncher> subLaunchers) {
        for (ReportableLauncher reportableLauncher : subLaunchers) {
            reportableLauncher.addListener(this);
            reportableLauncher.setParentLauncher(this);
        }
    }

    @Override
    public void start() throws IOException {
        this.setStatus(LauncherStatus.RUNNING);
        this.preStarting();
        this.scheduleSubLaunchers();
        this.subLauncherManager.startWatchDog();
        this.startWatchDog();
        this.startTime = new Date();
        this.sendTrackingActivity();
        this.fireTestSuiteExecutionEvent("KATALON_EXECUTION/TEST_SUITE_COLLECTION_STARTED");
    }

    private void sendTrackingActivity() {
        ReportIntegrationContribution analyticsProvider = ReportIntegrationFactory.getInstance().getAnalyticsProvider();
        String machineId = this.getMachineId();
        String sessionId = this.getExecutionUUID();
        Date startTime = this.getStartTime();
        Date endTime = this.getEndTime();
        String ksVersion = VersionUtil.getCurrentVersion().getVersion();
        Long organizationId = OrganizationHandler.getOrganizationId();
        ExecutorService executors = Executors.newFixedThreadPool(2);
        executors.submit(() -> analyticsProvider.sendTrackingActivity(organizationId, machineId, sessionId, startTime, endTime, ksVersion));
    }

    private void scheduleSubLaunchers() {
        ArrayList<ReportableLauncher> copiedSubLaunchers = new ArrayList<ReportableLauncher>(this.subLaunchers);
        for (ReportableLauncher launcher : copiedSubLaunchers) {
            this.subLauncherManager.addLauncher(launcher);
            launcher.setManager(this.subLauncherManager);
        }
    }

    protected void preStarting() {
        this.threshold = this.parentManager.getFailedThreshold();
        if (this.threshold > 0) {
            this.originalThreshold = this.threshold;
        }
    }

    private void startWatchDog() {
        this.watchDog = new Thread(new Runnable(){

            @Override
            public void run() {
                while (TestSuiteCollectionLauncher.this.subLauncherManager.isAnyLauncherRunning()) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                }
                TestSuiteCollectionLauncher.this.endTime = new Date();
                TestSuiteCollectionLogRecord logRecord = TestSuiteCollectionLauncher.this.prepareReport();
                Map<String, Object> overridingVariables = TestSuiteCollectionLauncher.this.subLaunchers.get(0).getRunConfig().getOverridingGlobalVariables();
                overridingVariables.putAll(EmailVariableBinding.getVariablesForTestSuiteCollectionEmailSettings(TestSuiteCollectionLauncher.this.executedEntity.getEntity()));
                TestSuiteCollectionLauncher.this.sendReportEmail(TestSuiteCollectionLauncher.this.reportCollection, logRecord, overridingVariables);
                TestSuiteCollectionLauncher.this.setStatus(LauncherStatus.UPLOAD_REPORT);
                TestSuiteCollectionLauncher.this.uploadReportToIntegratingProduct(logRecord);
                TestSuiteCollectionLauncher.this.setStatus(LauncherStatus.DONE);
                TestSuiteCollectionLauncher.this.postExecution();
            }
        });
        this.watchDog.start();
    }

    private TestSuiteCollectionLogRecord prepareReport() {
        try {
            ReportBundleSettingStore reportBundleSettingStore;
            ArrayList<TestSuiteLogRecord> suiteLogRecords = new ArrayList<TestSuiteLogRecord>();
            for (ReportableLauncher subLauncher : this.subLaunchers) {
                TestSuiteLogRecord suiteLogRecord = subLauncher.getTestSuiteLogRecord();
                if (suiteLogRecord == null) continue;
                suiteLogRecords.add(suiteLogRecord);
            }
            TestSuiteCollectionLogRecord suiteCollectionLogRecord = new TestSuiteCollectionLogRecord();
            suiteCollectionLogRecord.setId(this.executedEntity.getEntity().getIdForDisplay());
            suiteCollectionLogRecord.setName(this.executedEntity.getEntity().getName());
            suiteCollectionLogRecord.setTestSuiteRecords(suiteLogRecords);
            suiteCollectionLogRecord.setStartTime(this.startTime != null ? this.startTime.getTime() : 0L);
            suiteCollectionLogRecord.setEndTime(this.endTime != null ? this.endTime.getTime() : 0L);
            this.collectResult(suiteLogRecords);
            suiteCollectionLogRecord.setTotalPassedTestCases(String.valueOf(this.result.getNumPasses()));
            suiteCollectionLogRecord.setTotalFailedTestCases(String.valueOf(this.result.getNumFailures()));
            suiteCollectionLogRecord.setTotalErrorTestCases(String.valueOf(this.result.getNumErrors()));
            suiteCollectionLogRecord.setTotalTestCases(String.valueOf(this.result.getExecutedTestCases()));
            suiteCollectionLogRecord.setReportFolder(this.reportCollection.getParentFolder().getLocation());
            if (this.featureService.canUse(KSEFeature.EXPORT_JUNIT_REPORT)) {
                ReportUtil.writeJUnitReport((TestSuiteCollectionLogRecord)suiteCollectionLogRecord, (File)this.getReportFolder());
            }
            if (this.featureService.canUse(KSEFeature.AUTO_EXPORT_TEST_SUITE_COLLECTION_HTML) && (reportBundleSettingStore = new ReportBundleSettingStore(ProjectController.getInstance().getCurrentProject().getFolderLocation())).canGenerateHTLM()) {
                ExportReportProvider provider = new ExportReportProvider();
                provider.exportTestSuiteCollection(suiteCollectionLogRecord, this.getReportFolder(), this.reportCollection.getProject().getFolderLocation(), this.reportCollection.getIdForDisplay(), "HTML");
            }
            this.prepareIntegrationReport(suiteCollectionLogRecord);
            return suiteCollectionLogRecord;
        }
        catch (Exception e) {
            LogUtil.printAndLogError((Throwable)e);
            return null;
        }
    }

    private void collectResult(List<TestSuiteLogRecord> suiteLogRecords) {
        int totalPasses = 0;
        int totalFailures = 0;
        int totalErrors = 0;
        int totalIncompletes = 0;
        int totalSkips = 0;
        for (TestSuiteLogRecord record : suiteLogRecords) {
            totalPasses += record.getTotalPassedTestCases();
            totalFailures += record.getTotalFailedTestCases();
            totalIncompletes += record.getTotalIncompleteTestCases();
            totalErrors += record.getTotalErrorTestCases();
            totalSkips += record.getTotalSkippedTestCases();
        }
        this.result.setNumPasses(totalPasses);
        this.result.setNumFailures(totalFailures);
        this.result.setNumErrors(totalErrors);
        this.result.setNumIncomplete(totalIncompletes);
        this.result.setNumSkips(totalSkips);
    }

    private boolean isSuiteCollectionContainsCompleteSuiteLog(TestSuiteCollectionLogRecord suiteCollectionLogRecord, ReportIntegrationContribution contribution) {
        List<TestSuiteLogRecord> completedSuiteLogRecord = this.getCompletedTestSuites(suiteCollectionLogRecord.getTestSuiteRecords());
        return completedSuiteLogRecord != null && (completedSuiteLogRecord == null || !completedSuiteLogRecord.isEmpty()) || contribution.shouldUploadReportWhenIncomplete();
    }

    private void prepareIntegrationReport(TestSuiteCollectionLogRecord suiteCollectionLogRecord) {
        if (!(this.getExecutedEntity() instanceof Reportable)) {
            return;
        }
        for (Map.Entry<String, ReportIntegrationContribution> reportContributorEntry : ReportIntegrationFactory.getInstance().getIntegrationContributorMap().entrySet()) {
            ReportIntegrationContribution contribution = reportContributorEntry.getValue();
            String integratingProductName = reportContributorEntry.getKey();
            this.setStatus(LauncherStatus.PREPARE_INTEGRATION_REPORT, MessageFormat.format(ExecutionMessageConstants.TestSuiteCollectionLauncher_MSG_PREPARING_INTEGRATION_REPORT, integratingProductName));
            if (!this.isSuiteCollectionContainsCompleteSuiteLog(suiteCollectionLogRecord, contribution)) {
                return;
            }
            try {
                LogUtil.logInfo((String)MessageFormat.format(ExecutionMessageConstants.TestSuiteCollectionLauncher_MSG_PREPARING_INTEGRATION_REPORT, integratingProductName));
                reportContributorEntry.getValue().generateIntegrationReportForTestSuiteCollection(suiteCollectionLogRecord);
                LogUtil.logInfo((String)MessageFormat.format(ExecutionMessageConstants.TestSuiteCollectionLauncher_MSG_DONE_PREPARING_INTEGRATION_REPORT, integratingProductName));
            }
            catch (Exception e) {
                LogUtil.logError((Throwable)e, (String)MessageFormat.format(ExecutionMessageConstants.TestSuiteCollectionLauncher_MSG_UNABLE_TO_GENERATE_INTEGRATION_REPORT, integratingProductName, ExceptionUtils.getStackTrace((Throwable)e)));
            }
        }
    }

    private List<TestSuiteLogRecord> getCompletedTestSuites(List<TestSuiteLogRecord> suiteLogRecords) {
        if (suiteLogRecords == null) {
            return null;
        }
        ArrayList<TestSuiteLogRecord> completedSuiteLogRecords = new ArrayList<TestSuiteLogRecord>();
        for (TestSuiteLogRecord testSuiteTmp : suiteLogRecords) {
            if (!testSuiteTmp.isCompleted()) continue;
            completedSuiteLogRecords.add(testSuiteTmp);
        }
        return completedSuiteLogRecords;
    }

    private void uploadReportToIntegratingProduct(TestSuiteCollectionLogRecord collectionLogRecord) {
        try {
            if (!(this.getExecutedEntity() instanceof Reportable)) {
                return;
            }
            TestSuiteCollectionLogRecord allCompletedCollectionLogRecord = collectionLogRecord.clone();
            for (Map.Entry<String, ReportIntegrationContribution> reportContributorEntry : ReportIntegrationFactory.getInstance().getIntegrationContributorMap().entrySet()) {
                boolean shoulUploadWhenIncomplete = true;
                ReportIntegrationContribution contribution = reportContributorEntry.getValue();
                List<TestSuiteLogRecord> completedSuiteLogRecords = this.getCompletedTestSuites(collectionLogRecord.getTestSuiteRecords());
                if (!contribution.shouldUploadReportWhenIncomplete()) {
                    shoulUploadWhenIncomplete = false;
                }
                if (!this.isSuiteCollectionContainsCompleteSuiteLog(collectionLogRecord, contribution)) {
                    return;
                }
                allCompletedCollectionLogRecord.setTestSuiteRecords(completedSuiteLogRecords);
                String integratingProductName = reportContributorEntry.getKey();
                this.setStatus(LauncherStatus.UPLOAD_REPORT, MessageFormat.format(StringConstants.LAU_MESSAGE_UPLOADING_RPT, integratingProductName));
                try {
                    LogUtil.logInfo((String)MessageFormat.format(StringConstants.LAU_PRT_SENDING_RPT_TO, integratingProductName));
                    reportContributorEntry.getValue().uploadTestSuiteCollectionResult(shoulUploadWhenIncomplete ? collectionLogRecord : allCompletedCollectionLogRecord);
                    LogUtil.logInfo((String)MessageFormat.format(StringConstants.LAU_PRT_REPORT_SENT, integratingProductName));
                }
                catch (Exception e) {
                    LogUtil.logError((Throwable)e, (String)MessageFormat.format(StringConstants.MSG_RP_ERROR_TO_SEND_INTEGRATION_REPORT, integratingProductName, ExceptionUtils.getStackTrace((Throwable)e)));
                }
            }
        }
        catch (Exception e) {
            LogUtil.printAndLogError((Throwable)e);
        }
    }

    private void sendReportEmail(ReportCollectionEntity reportEntity, TestSuiteCollectionLogRecord logRecord, Map<String, Object> overridingVariables) {
        try {
            EmailConfig emailConfig = this.executedEntity.getEmailConfig(ProjectController.getInstance().getCurrentProject());
            if (this.canSendReport(emailConfig)) {
                Map<String, Object> variables = EmailVariableBinding.getVariablesForTestSuiteCollectionEmail(logRecord);
                variables.putAll(overridingVariables);
                this.setStatus(LauncherStatus.SENDING_REPORT, StringConstants.LAU_MESSAGE_SENDING_EMAIL);
                LogUtil.logInfo((String)MessageFormat.format(StringConstants.LAU_PRT_SENDING_EMAIL_RPT_TO, Arrays.toString(emailConfig.getTos())));
                MailUtil.sendSummaryMailForTestSuiteCollection(emailConfig, reportEntity, variables);
                LogUtil.logInfo((String)StringConstants.LAU_PRT_EMAIL_SENT);
                this.setAreEmailsSent(true);
            }
        }
        catch (Exception e) {
            LogUtil.printAndLogError((Throwable)e);
            this.setAreEmailsSent(false);
        }
    }

    private boolean canSendReport(EmailConfig emailConfig) {
        return this.featureService.canUse(KSEFeature.TEST_SUITE_COLLECTION_EXECUTION_EMAIL) && emailConfig != null && emailConfig.isSendTestSuiteCollectionReportEnabled();
    }

    protected File getReportFolder() {
        return new File(this.reportCollection.getParentFolder().getLocation());
    }

    protected void postExecution() {
        this.schedule();
        this.sendTrackingActivity();
        this.fireTestSuiteExecutionEvent("KATALON_EXECUTION/TEST_SUITE_COLLECTION_FINISHED");
    }

    protected void schedule() {
        try {
            this.parentManager.stopRunningAndSchedule(this);
        }
        catch (InterruptedException e) {
            LogUtil.logError((Throwable)e);
        }
    }

    @Override
    public void setStatus(LauncherStatus status) {
        super.setStatus(status);
        if (LauncherStatus.DONE == status || LauncherStatus.TERMINATED == status) {
            ExecutionEntityResult executionResult = new ExecutionEntityResult();
            executionResult.setEnd(true);
            this.notifyProccess((Object)status, this.executedEntity, executionResult);
        }
    }

    @Override
    public void stop() {
        this.setStatus(LauncherStatus.TERMINATED);
        if (this.watchDog != null && this.watchDog.isAlive()) {
            this.watchDog.interrupt();
        }
        this.subLauncherManager.stopAllLauncher();
        this.postExecution();
    }

    @Override
    public void clean() {
        for (ReportableLauncher launcher : this.subLaunchers) {
            launcher.clean();
        }
    }

    @Override
    public String getId() {
        return this.executedEntity.getId();
    }

    @Override
    public String getName() {
        return String.valueOf(this.executedEntity.getSourceId()) + " - " + this.executedEntity.getId();
    }

    @Override
    public ILauncherResult getResult() {
        return this.result;
    }

    private void addNewLauncher(SubLauncher subLauncher) {
        ReportableLauncher subReportableLauncher = (ReportableLauncher)((Object)subLauncher);
        if (this.subLaunchers.contains(subReportableLauncher)) {
            return;
        }
        this.subLaunchers.add(subReportableLauncher);
        subReportableLauncher.addListener(this);
        subReportableLauncher.setParentLauncher(this);
        ILauncherResult subLauncherResult = subLauncher.getResult();
        TestSuiteCollectionLauncherResult newResult = new TestSuiteCollectionLauncherResult(this, this.result.getTotalTestCases() + subLauncherResult.getTotalTestCases());
        newResult.setNumPasses(this.result.getNumPasses() + subLauncherResult.getNumPasses());
        newResult.setNumFailures(this.result.getNumFailures() + subLauncherResult.getNumFailures());
        newResult.setNumIncomplete(this.result.getNumIncomplete() + subLauncherResult.getNumIncomplete());
        newResult.setNumErrors(this.result.getNumErrors() + subLauncherResult.getNumErrors());
        this.result = newResult;
        this.reportCollection.getReportItemDescriptions().add(ReportItemDescription.from((String)subReportableLauncher.getReportEntity().getIdForDisplay(), (RunConfigurationDescription)subLauncher.getRunConfigurationDescription()));
        try {
            ReportController.getInstance().updateReportCollection(this.reportCollection);
        }
        catch (DALException e) {
            LogUtil.logError((Throwable)e);
        }
        this.onNewLauncherAdded();
    }

    protected void onNewLauncherAdded() {
    }

    @Override
    public void handleLauncherEvent(LauncherEvent event, LauncherNotifiedObject object) {
        if (event == LauncherEvent.UPDATE_RESULT) {
            TestStatus.TestStatusValue statusValue = (TestStatus.TestStatusValue)object.getObject();
            switch (statusValue) {
                case ERROR: {
                    this.result.increaseErrors();
                    break;
                }
                case FAILED: {
                    this.result.increaseFailures();
                    break;
                }
                case PASSED: {
                    this.result.increasePasses();
                    break;
                }
                case SKIPPED: {
                    this.result.increaseSkips();
                    break;
                }
            }
            this.onUpdateResult(statusValue);
        } else if (event == LauncherEvent.UPDATE_STATUS) {
            LauncherStatus status = (LauncherStatus)((Object)object.getObject());
            ILauncher launcher = this.findLauncher(object);
            if (launcher != null) {
                switch (status) {
                    case RUNNING: {
                        LogUtil.logInfo((String)MessageFormat.format(ExecutionMessageConstants.LAU_PRT_RUNNING_LAUNCHER, launcher.getName()));
                        if (!this.hasFailedThreshold()) break;
                        LogUtil.logInfo((String)MessageFormat.format(ExecutionMessageConstants.LAU_PRT_LAUNCHER_THRESHOLD_INFO, launcher.getName(), this.threshold));
                        break;
                    }
                }
            }
        }
    }

    protected TestSuiteCollectionExecutionEvent fireTestSuiteExecutionEvent(String eventName) {
        ArrayList<TestSuiteExecutionContext> testSuiteContexts = new ArrayList<TestSuiteExecutionContext>();
        for (ReportableLauncher subLauncher : this.subLaunchers) {
            testSuiteContexts.add(subLauncher.getTestSuiteExecutionContext());
        }
        TestSuiteCollectionExecutionContextImpl executionContext = TestSuiteCollectionExecutionContextImpl.Builder.create(this.getId(), this.executedEntity.getSourceId()).withReportId(this.reportCollection.getIdForDisplay()).withTestSuiteContexts(testSuiteContexts).withProjectLocation(this.executedEntity.getEntity().getProject().getFolderLocation()).withStartTime(this.startTime != null ? this.startTime.getTime() : 0L).withEndTime(this.endTime != null ? this.endTime.getTime() : 0L).build();
        TestSuiteCollectionExecutionEvent eventObject = new TestSuiteCollectionExecutionEvent(eventName, executionContext);
        ExecutionBundleActivator.getInstance().getEventBroker().post(eventName, (Object)eventObject);
        return eventObject;
    }

    public List<ReportableLauncher> getSubLaunchers() {
        return Collections.unmodifiableList(this.subLaunchers);
    }

    private TestSuiteCollectionEntity getTestSuiteCollectionEntity() {
        return this.getExecutedEntity().getEntity();
    }

    public TestSuiteCollectionExecutedEntity getExecutedEntity() {
        return this.executedEntity;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    protected Map<String, Object> getIntegratedContributionsTrackingData() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Map<String, ReportIntegrationContribution> contributions = ReportIntegrationFactory.getInstance().getIntegrationContributorMap();
        for (Map.Entry<String, ReportIntegrationContribution> element : contributions.entrySet()) {
            ReportIntegrationContribution contribution = element.getValue();
            if (!contribution.isNeededTrackingData()) continue;
            result.putAll(contribution.getTrackingProperties());
        }
        return result;
    }

    private ILauncher findLauncher(LauncherNotifiedObject object) {
        String launcherId = object.getLauncherId();
        ILauncher launcher = null;
        if (StringUtils.isNotBlank((CharSequence)launcherId)) {
            launcher = this.subLauncherManager.getLauncher(launcherId);
        }
        return launcher;
    }

    private boolean hasFailedThreshold() {
        return this.originalThreshold > 0;
    }

    @Override
    public int getRemainingFailedThreshold() {
        return this.originalThreshold - this.threshold;
    }

    public class TestSuiteCollectionLauncherManager
    extends LauncherManager {
        private Thread watchDog;

        private void logReadyToStartMessage(ILauncher launcher, LocalTime timestamp) {
            String msg = MessageFormat.format(ExecutionMessageConstants.TestSuiteCollectionLauncher_MSG_TEST_SUITE_READY_TO_START, launcher.getName(), timestamp);
            if (ApplicationRunningMode.get() == RunningMode.GUI) {
                LogUtil.logInfo((String)msg);
            } else {
                LogUtil.printOutputLine((String)msg);
            }
        }

        @Override
        protected boolean isLauncherReadyToRun(ILauncher launcher) {
            if (TestSuiteCollectionLauncher.this.hasFailedThreshold() && TestSuiteCollectionLauncher.this.threshold <= 0) {
                return false;
            }
            if (TestSuiteCollectionLauncher.this.executionMode == TestSuiteCollectionEntity.ExecutionMode.PARALLEL) {
                return this.getRunningLaunchers().size() < TestSuiteCollectionLauncher.this.executedEntity.getEntity().getMaxConcurrentInstances();
            }
            return this.getRunningLaunchers().isEmpty();
        }

        protected void startWatchDog() {
            this.watchDog = new Thread(new Runnable(){
                LocalTime lastRun;

                @Override
                public void run() {
                    while (TestSuiteCollectionLauncherManager.this.getWaitingLaunchers().size() + TestSuiteCollectionLauncherManager.this.getRunningLaunchers().size() > 0) {
                        LocalTime now = LocalTime.now();
                        ILauncher launcher = null;
                        if (TestSuiteCollectionLauncherManager.this.getWaitingLaunchers().size() > 0) {
                            launcher = TestSuiteCollectionLauncherManager.this.getWaitingLaunchers().get(0);
                        }
                        boolean isAfterDelay = true;
                        if (this.lastRun != null) {
                            isAfterDelay = now.isAfter(this.lastRun.plusSeconds(((TestSuiteCollectionLauncherManager)TestSuiteCollectionLauncherManager.this).TestSuiteCollectionLauncher.this.executedEntity.getEntity().getDelayBetweenInstances()));
                        }
                        if (!isAfterDelay) {
                            try {
                                Thread.sleep(10L);
                                continue;
                            }
                            catch (InterruptedException interruptedException) {
                                return;
                            }
                        }
                        if (launcher == null || !TestSuiteCollectionLauncherManager.this.isLauncherReadyToRun(launcher)) continue;
                        this.lastRun = now;
                        TestSuiteCollectionLauncherManager.this.logReadyToStartMessage(launcher, now);
                        TestSuiteCollectionLauncherManager.this.removeLauncherFromWaitingList(launcher);
                        TestSuiteCollectionLauncherManager.this.addLauncherToRunningList(launcher);
                        TestSuiteCollectionLauncherManager.this.updateRunConfigForFailedThreshold(launcher);
                        try {
                            launcher.start();
                        }
                        catch (IOException iOException) {}
                    }
                }
            });
            if (TestSuiteCollectionLauncher.this.executedEntity.getEntity().getDelayBetweenInstances() > 0) {
                this.watchDog.start();
            }
        }

        @Override
        protected void updateRunConfigForFailedThreshold(ILauncher launcher) {
            SubConsoleLauncher sLauncher;
            if (TestSuiteCollectionLauncher.this.hasFailedThreshold() && launcher instanceof SubConsoleLauncher && (sLauncher = (SubConsoleLauncher)launcher).getRunConfig() instanceof AbstractRunConfiguration) {
                AbstractRunConfiguration runConfig = (AbstractRunConfiguration)sLauncher.getRunConfig();
                try {
                    runConfig.setFailedTestThreshold(TestSuiteCollectionLauncher.this.threshold);
                    runConfig.generateExecutionProperties();
                }
                catch (Exception exception) {}
            }
        }

        @Override
        public String getChildrenLauncherStatus(int consoleWidth) {
            return super.getChildrenLauncherStatus(consoleWidth);
        }

        @Override
        protected void schedule() {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                LogUtil.logError((Throwable)e);
            }
            if (TestSuiteCollectionLauncher.this.executedEntity.getEntity().getDelayBetweenInstances() == 0) {
                super.schedule();
            }
        }

        @Override
        public void addLauncher(ILauncher subLauncher) {
            TestSuiteCollectionLauncher.this.addNewLauncher((SubLauncher)subLauncher);
            super.addLauncher(subLauncher);
        }

        @Override
        protected void updateFailedThreshold(ILauncher launcher) {
            if (TestSuiteCollectionLauncher.this.hasFailedThreshold()) {
                ILauncherResult launcherResult = launcher.getResult();
                int result = launcherResult.getNumErrors() + launcherResult.getNumFailures() + launcherResult.getNumRetryErrorsAndFailures();
                TestSuiteCollectionLauncher.this.threshold -= result;
                if (TestSuiteCollectionLauncher.this.threshold <= 0) {
                    this.removeAllWaitingLaunchers();
                }
            }
        }
    }
}

