/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.launcher.provider;

import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.core.logging.model.TestSuiteCollectionLogRecord;
import com.kms.katalon.core.logging.model.TestSuiteLogRecord;
import com.kms.katalon.core.reporting.ReportUtil;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.util.SAXReaderProvider;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public class ExportReportProvider {
    public static final String HTML_FORMAT = "HTML";
    public static final String PASSED_LOG_BACKGROUND_COLOR = "#5bb135";
    public static final String FAILED_LOG_BACKGROUND_COLOR = "#ce2c2c";
    public static final String FAILED_STATUS_BACKGROUND_COLOR = "#f19696";
    public static final String INCOMPLETE_STATUS_BACKGROUND_COLOR = "#f2bc70";
    private static final String DEFAULT_COMPOSITE_BACKGROUND_COLOR = "#f0f0f0";

    public File exportTestSuiteCollection(TestSuiteCollectionLogRecord suiteCollectionLogRecord, File exportLocation, String projectDirLocation, String reportId, String formatType) throws IOException, URISyntaxException {
        switch (formatType) {
            case "HTML": {
                try {
                    SAXReader reader = SAXReaderProvider.newInstance();
                    Document document = reader.read(new File(projectDirLocation, String.valueOf(reportId) + ".rp"));
                    Element rootElement = document.getRootElement();
                    String reportIdTimeStamp = rootElement.element("name").getStringValue();
                    ArrayList tsInfoItems = new ArrayList();
                    for (TestSuiteLogRecord testSuiteLogRecord : suiteCollectionLogRecord.getTestSuiteRecords()) {
                        try {
                            String relativeReportDirLocation = this.buildRelativeTSReportPath(projectDirLocation, reportIdTimeStamp, suiteCollectionLogRecord, testSuiteLogRecord);
                            String reportDirLocationHashCode = StringUtils.substringAfterLast((String)testSuiteLogRecord.getLogFolder(), (String)File.separator);
                            String htmlFileName = String.valueOf(reportDirLocationHashCode) + ".html";
                            String reportDirLocation = new File(testSuiteLogRecord.getLogFolder()).toURI().getPath();
                            String relativeLocationName = StringUtils.substringAfter((String)reportDirLocation, (String)GlobalMessageConstants.ROOT_FOLDER_NAME_REPORT);
                            String testSuiteId = "Test Suites".concat(relativeLocationName);
                            testSuiteId = StringUtils.substringBeforeLast((String)testSuiteId, (String)"/");
                            testSuiteId = StringUtils.substringBeforeLast((String)testSuiteId, (String)"/");
                            HashMap<String, String> tsInfoItem = new HashMap<String, String>();
                            tsInfoItem.put("report_location", relativeReportDirLocation);
                            tsInfoItem.put("report", String.valueOf(relativeReportDirLocation) + htmlFileName);
                            tsInfoItem.put("id", testSuiteId);
                            tsInfoItem.put("environment", testSuiteLogRecord.getBrowser());
                            String status = this.getStatus(testSuiteLogRecord);
                            tsInfoItem.put("status", status);
                            tsInfoItem.put("fail_on_total", this.getFailOnTotal(testSuiteLogRecord));
                            tsInfoItem.put("status_color", this.getStatusColor(status));
                            tsInfoItem.put("fail_color", this.getFailColor(testSuiteLogRecord));
                            tsInfoItems.add(tsInfoItem);
                        }
                        catch (Exception e) {
                            throw new IOException(e);
                        }
                    }
                    return ReportUtil.writeTSCollectionHTMLReport((String)new File(reportId).getName(), (String)JsonUtil.toJson(tsInfoItems, (boolean)false), (File)exportLocation, (boolean)true);
                }
                catch (DocumentException | SAXException ex) {
                    throw new IOException(ex);
                }
            }
        }
        return null;
    }

    private int getTotalFailedTestCases(TestSuiteLogRecord testSuiteLogRecord) {
        if (testSuiteLogRecord == null) {
            return 0;
        }
        return testSuiteLogRecord.getTotalFailedTestCases() + testSuiteLogRecord.getTotalErrorTestCases();
    }

    private String getFailOnTotal(TestSuiteLogRecord testSuiteLogRecord) {
        if (testSuiteLogRecord == null) {
            return "";
        }
        return String.valueOf(this.getTotalFailedTestCases(testSuiteLogRecord)) + " / " + testSuiteLogRecord.getTotalTestCases();
    }

    private String getFailColor(TestSuiteLogRecord testSuiteLogRecord) {
        if (testSuiteLogRecord == null) {
            return "";
        }
        if (this.getTotalFailedTestCases(testSuiteLogRecord) > 0) {
            return FAILED_STATUS_BACKGROUND_COLOR;
        }
        return "";
    }

    private String getStatus(TestSuiteLogRecord logRecord) {
        if (logRecord == null) {
            return "NOT_STARTED";
        }
        if (logRecord.getTotalIncompleteTestCases() > 0) {
            return "INCOMPLETE";
        }
        return "COMPLETE";
    }

    private String getStatusColor(String status) {
        if (StringUtils.equals((CharSequence)status, (CharSequence)"NOT_STARTED")) {
            return DEFAULT_COMPOSITE_BACKGROUND_COLOR;
        }
        if (StringUtils.equals((CharSequence)status, (CharSequence)"INCOMPLETE")) {
            return INCOMPLETE_STATUS_BACKGROUND_COLOR;
        }
        return "";
    }

    private String buildRelativeTSReportPath(String projectDirLocation, String reportIdTimeStamp, TestSuiteCollectionLogRecord suiteCollectionLogRecord, TestSuiteLogRecord testSuiteLogRecord) {
        String reportTimestampFolderLocation = Paths.get(projectDirLocation, GlobalMessageConstants.ROOT_FOLDER_NAME_REPORT, reportIdTimeStamp).toString();
        String temp = StringUtils.substringAfter((String)suiteCollectionLogRecord.getReportFolder(), (String)reportTimestampFolderLocation).substring(1);
        temp = temp.replace(File.separator, String.valueOf('/'));
        temp = this.buildRelativeDots(temp);
        String reportDirLocation = new File(testSuiteLogRecord.getLogFolder()).toURI().getPath();
        return temp.concat(StringUtils.substringAfter((String)reportDirLocation, (String)reportIdTimeStamp).substring(1));
    }

    private String buildRelativeDots(String path) {
        String separator = String.valueOf('/');
        String[] splits = path.split(separator);
        if (splits.length > 0) {
            String relativeDots = "";
            int i = 0;
            while (i < splits.length) {
                relativeDots = String.valueOf(relativeDots) + "..".concat(separator);
                ++i;
            }
            return relativeDots;
        }
        return path;
    }
}

