/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.logging;

import com.kms.katalon.execution.logging.IOutputStream;
import com.kms.katalon.logging.LogManager;
import com.kms.katalon.logging.LogMode;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.logging.SystemLogger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.commons.io.IOUtils;

public class LaunchOutputStreamHandler
extends Thread
implements IOutputStream {
    private InputStream is;
    private SystemLogger logger;
    private boolean printAllowed;

    private LaunchOutputStreamHandler(InputStream is, SystemLogger logger, boolean printAllowed) {
        this.is = is;
        this.logger = logger;
        this.printAllowed = printAllowed;
    }

    @Override
    public void run() {
        block6: {
            InputStreamReader isr = null;
            BufferedReader br = null;
            try {
                try {
                    isr = new InputStreamReader(this.is, "UTF-8");
                    br = new BufferedReader(isr);
                    String line = null;
                    while ((line = br.readLine()) != null) {
                        if (!this.printAllowed) continue;
                        this.println(line);
                    }
                }
                catch (IOException iOException) {
                    IOUtils.closeQuietly(br);
                    IOUtils.closeQuietly(isr);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(br);
                IOUtils.closeQuietly(isr);
                throw throwable;
            }
            IOUtils.closeQuietly((Reader)br);
            IOUtils.closeQuietly((Reader)isr);
        }
    }

    @Override
    public synchronized void println(String line) {
        LogUtil.println((SystemLogger)this.logger, (String)line, (LogMode)LogMode.CONSOLE);
    }

    @Override
    public void close() throws IOException {
    }

    public static LaunchOutputStreamHandler outputHandlerFrom(InputStream is) {
        return new LaunchOutputStreamHandler(is, LogManager.getOutputLogger(), true);
    }

    public static LaunchOutputStreamHandler outputHandlerFrom(InputStream is, boolean printAllowed) {
        return new LaunchOutputStreamHandler(is, LogManager.getOutputLogger(), printAllowed);
    }

    public static LaunchOutputStreamHandler errorHandlerFrom(InputStream is) {
        return new LaunchOutputStreamHandler(is, LogManager.getErrorLogger(), true);
    }

    public static LaunchOutputStreamHandler errorHandlerFrom(InputStream is, boolean printAllowed) {
        return new LaunchOutputStreamHandler(is, LogManager.getErrorLogger(), printAllowed);
    }
}

