/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.setting;

import com.kms.katalon.core.setting.BundleSettingStore;
import com.kms.katalon.core.setting.ReportFormatType;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.execution.constants.ExecutionMessageConstants;
import com.kms.katalon.execution.util.EmailTemplateUtil;
import com.kms.katalon.execution.util.MailUtil;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.osgi.framework.FrameworkUtil;

public class EmailSettingStore
extends BundleSettingStore {
    private ScopedPreferenceStore mailPreferenceStore = PreferenceStoreManager.getPreferenceStore((String)"com.kms.katalon.execution");

    public EmailSettingStore(ProjectEntity projectEntity) {
        super(projectEntity.getFolderLocation(), FrameworkUtil.getBundle(EmailSettingStore.class).getSymbolicName(), false);
    }

    private String getStringFromSettingOrPrefs(String mailConfigSettingName) throws IOException {
        return this.getString(mailConfigSettingName, this.mailPreferenceStore.getString(mailConfigSettingName));
    }

    private boolean getBooleanFromSettingOrPrefs(String mailConfigSettingName) throws IOException {
        return this.getBoolean(mailConfigSettingName, this.mailPreferenceStore.getBoolean(mailConfigSettingName));
    }

    public boolean isEncryptionEnabled() throws IOException {
        return this.getBoolean("mailConfig.encryptionEnabled", false);
    }

    public void enableAuthenticationEncryption(boolean enabled) throws IOException {
        this.setProperty("mailConfig.encryptionEnabled", enabled);
    }

    public String getHost(boolean encryptionEnabled) throws IOException, GeneralSecurityException {
        return this.getStringProperty("mailConfig.host", "", encryptionEnabled);
    }

    public void setHost(String hostName, boolean encryptionEnabled) throws IOException, GeneralSecurityException {
        this.setStringProperty("mailConfig.host", hostName, encryptionEnabled);
    }

    public String getPort(boolean encryptionEnabled) throws IOException, GeneralSecurityException {
        return this.getStringProperty("mailConfig.port", "", encryptionEnabled);
    }

    public void setPort(String port, boolean encryptionEnabled) throws IOException, GeneralSecurityException {
        this.setStringProperty("mailConfig.port", port, encryptionEnabled);
    }

    public boolean isAddAttachment() throws IOException {
        return this.getBooleanFromSettingOrPrefs("mailConfig.attachment");
    }

    public void setIsAddAttachment(boolean isAddAttachment) throws IOException {
        this.setProperty("mailConfig.attachment", isAddAttachment);
    }

    public String getUsername(boolean encryptionEnabled) throws IOException, GeneralSecurityException {
        return this.getStringProperty("mailConfig.username", "", encryptionEnabled);
    }

    public void setUsername(String username, boolean encryptionEnabled) throws IOException, GeneralSecurityException {
        this.setStringProperty("mailConfig.username", username, encryptionEnabled);
    }

    public String getPassword(boolean encryptionEnabled) throws IOException, GeneralSecurityException {
        return this.getStringProperty("mailConfig.password", "", encryptionEnabled);
    }

    public void setPassword(String password, boolean encryptionEnabled) throws IOException, GeneralSecurityException {
        this.setStringProperty("mailConfig.password", password, encryptionEnabled);
    }

    public String getProtocol(boolean encryptionEnabled) throws IOException, GeneralSecurityException {
        return this.getStringProperty("mailConfig.securityProtocol", MailUtil.MailSecurityProtocolType.None.toString(), encryptionEnabled);
    }

    public void setProtocol(String protocol, boolean encryptionEnabled) throws IOException, GeneralSecurityException {
        this.setStringProperty("mailConfig.securityProtocol", protocol, encryptionEnabled);
    }

    public boolean useUsernameAsSender() throws IOException {
        return this.getBoolean("mailConfig.useUsernameAsSender", true);
    }

    public void setUseUsernameAsSender(boolean useUsernameAsSender) throws IOException {
        this.setProperty("mailConfig.useUsernameAsSender", useUsernameAsSender);
    }

    public String getSender() throws IOException {
        return this.getString("mailConfig.sender", "");
    }

    public void setSender(String sender) throws IOException {
        this.setProperty("mailConfig.sender", sender);
    }

    public String getRecipients(boolean encryptionEnabled) throws IOException, GeneralSecurityException {
        return this.getStringProperty("mailConfig.reportRecipients", "", encryptionEnabled);
    }

    public void setRecipients(String recipients, boolean encryptionEnabled) throws IOException, GeneralSecurityException {
        this.setStringProperty("mailConfig.reportRecipients", recipients, encryptionEnabled);
    }

    public String getSignature() throws IOException {
        return this.getStringFromSettingOrPrefs("mailConfig.signature");
    }

    public void setSignature(String signature) throws IOException {
        this.setProperty("mailConfig.signature", signature);
    }

    public String getEmailHTMLTemplateForTestSuite() throws IOException, URISyntaxException {
        String template = this.getString("mailConfig.htmlTemplate", this.getDefaultEmailHTMLTemplateForTestSuite());
        template = template.replace("https://www.katalon.com/wp-content/themes/katalon/images/logo-katalon.png", "https://raw.githubusercontent.com/katalon-studio/docs-images/master/katalon-studio/product-logo/logo-katalon.png");
        return template;
    }

    private String getDefaultEmailHTMLTemplateForTestSuite() throws IOException, URISyntaxException {
        return EmailTemplateUtil.getHTMLTemplateForTestSuite(this.getSignature());
    }

    public String getEmailHTMLTemplateForTestSuiteCollection() throws IOException, URISyntaxException {
        String template = this.getString("mailConfig.collectionHtmlTemplate", this.getDefaultEmailHTMLTemplateForTestSuiteCollection());
        template = template.replace("https://www.katalon.com/wp-content/themes/katalon/images/logo-katalon.png", "https://raw.githubusercontent.com/katalon-studio/docs-images/master/katalon-studio/product-logo/logo-katalon.png");
        return template;
    }

    private String getDefaultEmailHTMLTemplateForTestSuiteCollection() throws IOException, URISyntaxException {
        return EmailTemplateUtil.getEmailHTMLTemplateForTestSuiteCollection();
    }

    public void setHTMLTemplateForTestSuite(String htmlTemplate) throws IOException {
        this.setProperty("mailConfig.htmlTemplate", htmlTemplate);
    }

    public void setHTMLTemplateForTestSuiteCollection(String htmlTemplate) throws IOException {
        this.setProperty("mailConfig.collectionHtmlTemplate", htmlTemplate);
    }

    public String getEmailSubject() throws IOException {
        return this.getString("mailConfig.subject", ExecutionMessageConstants.PREF_DEFAULT_EMAIL_SUBJECT);
    }

    public void setEmailSubject(String subject) throws IOException {
        this.setProperty("mailConfig.subject", subject);
    }

    public String getEmailCc() throws IOException {
        return this.getStringFromSettingOrPrefs("mailConfig.cc");
    }

    public void setEmailCc(String cc) throws IOException {
        this.setProperty("mailConfig.cc", StringUtils.defaultString((String)cc));
    }

    public String getEmailBcc() throws IOException {
        return this.getStringFromSettingOrPrefs("mailConfig.bcc");
    }

    public void setEmailBcc(String bcc) throws IOException {
        this.setProperty("mailConfig.bcc", StringUtils.defaultString((String)bcc));
    }

    public List<ReportFormatType> getReportFormatOptions() throws IOException {
        String reportFormatOptAsJson = this.getString("mailConfig.reportFormat", "");
        if (StringUtils.isEmpty((CharSequence)reportFormatOptAsJson)) {
            return Arrays.asList(ReportFormatType.HTML, ReportFormatType.CSV);
        }
        return Arrays.asList((ReportFormatType[])JsonUtil.fromJson((String)reportFormatOptAsJson, ReportFormatType[].class));
    }

    public void setReportFormatOptions(List<ReportFormatType> reportFormatOptions) throws IOException {
        String reportFormatOptAsJson = JsonUtil.toJson((Object)reportFormatOptions.toArray(new ReportFormatType[0]));
        this.setProperty("mailConfig.reportFormat", reportFormatOptAsJson);
    }

    public boolean isSendEmailTestFailedOnly() throws IOException {
        return this.getBoolean("mailConfig.sendReportTestFailedOnly", false);
    }

    public void setSendEmailTestFailedOnly(boolean enabled) throws IOException {
        this.setProperty("mailConfig.sendReportTestFailedOnly", enabled);
    }

    public boolean isSendTestSuiteReportEnabled() throws IOException {
        return this.getBoolean("mailConfig.sendTestSuiteReport", true);
    }

    public void setSendTestSuiteReportEnabled(boolean enabled) throws IOException {
        this.setProperty("mailConfig.sendTestSuiteReport", enabled);
    }

    public boolean isSendTestSuiteCollectionReportEnabled() throws IOException {
        return this.getBoolean("mailConfig.sendTestSuiteCollectionReport", false);
    }

    public void setSendTestSuiteCollectionReportEnabled(boolean enabled) throws IOException {
        this.setProperty("mailConfig.sendTestSuiteCollectionReport", enabled);
    }

    public boolean isSkipInvidualTestSuiteReport() throws IOException {
        return this.getBoolean("mailConfig.skipIndividualTestSuiteReport", false);
    }

    public void setSkipIndividualTestSuiteReport(boolean enabled) throws IOException {
        this.setProperty("mailConfig.skipIndividualTestSuiteReport", enabled);
    }
}

