/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.setting;

import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.constants.CoreConstants;
import com.kms.katalon.core.setting.BundleSettingStore;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.project.ProjectType;
import java.io.IOException;

public class ExecutionDefaultSettingStore
extends BundleSettingStore {
    public static final boolean EXECUTION_DEFAULT_QUIT_DRIVERS_AFTER_EXECUTING_TEST_SUITE = true;
    public static final boolean EXECUTION_DEFAULT_QUIT_DRIVERS_AFTER_EXECUTING_TEST_CASE = false;
    public static final boolean EXECUTION_DEFAULT_OPEN_REPORT_REPORT_VALUE = false;
    public static final int EXECUTION_DEFAULT_TIMEOUT_VALUE = 30;
    public static final String EXECUTION_DEFAULT_CONFIGURATION_FOR_GENERIC_PROJECT = "Chrome";
    public static final String EXECUTION_DEFAULT_CONFIGURATION_FOR_WEBSERVICE_PROJECT = "Web Service";
    public static final Boolean DEFAULT_AUTO_APPLY_NEIGHBOR_XPATHS_ENABLED = false;
    public static final Boolean DEFAULT_SMART_WAIT_MODE = true;
    public static final Boolean DEFAULT_LOG_TEST_STEPS = CoreConstants.DEFAULT_LOG_TEST_STEPS;
    public static final Boolean DEFAULT_HIDE_HOST_NAME = CoreConstants.DEFAULT_HIDE_HOST_NAME;

    public static ExecutionDefaultSettingStore getStore() {
        ProjectEntity projectEntity = ProjectController.getInstance().getCurrentProject();
        if (projectEntity == null) {
            return null;
        }
        return new ExecutionDefaultSettingStore(projectEntity);
    }

    public ExecutionDefaultSettingStore(ProjectEntity projectEntity) {
        super(projectEntity.getFolderLocation(), "com.kms.katalon.execution", false);
    }

    public String getExecutionConfiguration() {
        String executionDefaultConfiguration = this.getDefaultExecutionConfiguration();
        try {
            return this.getString("execution.default.executionConfiguration", executionDefaultConfiguration);
        }
        catch (IOException iOException) {
            return executionDefaultConfiguration;
        }
    }

    public String getDefaultExecutionConfiguration() {
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        String executionDefaultConfiguration = project.getType() == ProjectType.WEBSERVICE ? EXECUTION_DEFAULT_CONFIGURATION_FOR_WEBSERVICE_PROJECT : EXECUTION_DEFAULT_CONFIGURATION_FOR_GENERIC_PROJECT;
        return executionDefaultConfiguration;
    }

    public void setExecutionConfiguration(String config) throws IOException {
        this.setProperty("execution.default.executionConfiguration", config);
    }

    public int getElementTimeout() {
        try {
            return this.getInt("execution.default.timeout", 30);
        }
        catch (IOException iOException) {
            return 30;
        }
    }

    public void setElementTimeout(int timeout) throws IOException {
        this.setProperty("execution.default.timeout", timeout);
    }

    public void setDefaultElementTimeout() throws IOException {
        this.setProperty("execution.default.timeout", 30);
    }

    public boolean isPostExecOpenReport() {
        try {
            return this.getBoolean("execution.default.openReportAfterExecuting", false);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public void setPostExecOpenReport(boolean isOpen) throws IOException {
        this.setProperty("execution.default.openReportAfterExecuting", isOpen);
    }

    public void setDefaultPostExecOpenReport() throws IOException {
        this.setProperty("execution.default.openReportAfterExecuting", false);
    }

    public boolean isPostTestCaseExecQuitDriver() {
        try {
            return this.getBoolean("execution.default.quitDriversAfterExecutingTestCase", false);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public void setPostTestCaseExecQuitDriver(boolean flag) throws IOException {
        this.setProperty("execution.default.quitDriversAfterExecutingTestCase", flag);
    }

    public void setDefaultPostTestCaseExecQuitDriver() throws IOException {
        this.setProperty("execution.default.quitDriversAfterExecutingTestCase", false);
    }

    public boolean isPostTestSuiteExecQuitDriver() {
        try {
            return this.getBoolean("execution.default.quitDriversAfterExecutingTestSuite", true);
        }
        catch (IOException iOException) {
            return true;
        }
    }

    public void setPostTestSuiteExecQuitDriver(boolean flag) throws IOException {
        this.setProperty("execution.default.quitDriversAfterExecutingTestSuite", flag);
    }

    public void setDefaultPostTestSuiteExecQuitDriver() throws IOException {
        this.setProperty("execution.default.quitDriversAfterExecutingTestSuite", true);
    }

    public void setDefaultApplyNeighborXpathsEnabled() throws IOException {
        this.setProperty("execution.default.autoApplyNeighborXpathsEnabled", DEFAULT_AUTO_APPLY_NEIGHBOR_XPATHS_ENABLED);
    }

    public void setApplyNeighborXpathsEnabled(Boolean value) throws IOException {
        this.setProperty("execution.default.autoApplyNeighborXpathsEnabled", value);
    }

    public Boolean isAutoApplyNeighborXpathsEnabled() {
        try {
            return this.getBoolean("execution.default.autoApplyNeighborXpathsEnabled", DEFAULT_AUTO_APPLY_NEIGHBOR_XPATHS_ENABLED);
        }
        catch (IOException iOException) {
            return DEFAULT_AUTO_APPLY_NEIGHBOR_XPATHS_ENABLED;
        }
    }

    public Boolean getDefaultAutoApplyNeighborXpathsEnabled() {
        return DEFAULT_AUTO_APPLY_NEIGHBOR_XPATHS_ENABLED;
    }

    public Boolean getAutoApplyNeighborXpathsEnabled() {
        try {
            return this.getBoolean("execution.default.autoApplyNeighborXpathsEnabled", DEFAULT_AUTO_APPLY_NEIGHBOR_XPATHS_ENABLED);
        }
        catch (IOException iOException) {
            return DEFAULT_AUTO_APPLY_NEIGHBOR_XPATHS_ENABLED;
        }
    }

    public Boolean getDefaultSmartWaitMode() {
        try {
            return this.getBoolean("execution.default.smartWaitMode", DEFAULT_SMART_WAIT_MODE);
        }
        catch (IOException iOException) {
            return DEFAULT_SMART_WAIT_MODE;
        }
    }

    public void setDefaultSmartWaitMode(Boolean value) throws IOException {
        this.setProperty("execution.default.smartWaitMode", value);
    }

    public Boolean getLogTestSteps() {
        try {
            return this.getBoolean("execution.logTestSteps", DEFAULT_LOG_TEST_STEPS);
        }
        catch (IOException iOException) {
            return DEFAULT_LOG_TEST_STEPS;
        }
    }

    public void setLogTestSteps(Boolean value) throws IOException {
        this.setProperty("execution.logTestSteps", value);
    }

    public Boolean getHideHostName() {
        try {
            return this.getBoolean("execution.hideHostName", DEFAULT_HIDE_HOST_NAME);
        }
        catch (IOException iOException) {
            return DEFAULT_HIDE_HOST_NAME;
        }
    }

    public void setHideHostName(Boolean value) throws IOException {
        this.setProperty("execution.hideHostName", value);
    }

    public String getVmArgs() {
        try {
            return this.getString("execution.launch.vmArgs", "");
        }
        catch (IOException iOException) {
            return "";
        }
    }

    public void setVmArgs(String vmArgs) throws IOException {
        this.setProperty("execution.launch.vmArgs", vmArgs);
    }
}

