/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.testcloud.configuration;

import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.core.webui.driver.WebUIDriverType;
import com.kms.katalon.entity.testsuite.RunConfigurationDescription;
import com.kms.katalon.execution.configuration.IRunConfiguration;
import com.kms.katalon.execution.console.entity.BooleanConsoleOption;
import com.kms.katalon.execution.console.entity.ConsoleOption;
import com.kms.katalon.execution.console.entity.IntegerConsoleOption;
import com.kms.katalon.execution.console.entity.StringConsoleOption;
import com.kms.katalon.execution.exception.ExecutionException;
import com.kms.katalon.execution.webui.configuration.contributor.WebUIRunConfigurationContributor;
import com.kms.katalon.integration.analytics.setting.AnalyticsSettingStore;
import com.kms.katalon.integration.testcloud.configuration.TestCloudRunConfiguration;
import com.kms.katalon.integration.testcloud.constant.IntegrationTestCloudMessageConstants;
import com.kms.katalon.integration.testcloud.entity.TestCloudEntity;
import com.kms.katalon.integration.testcloud.entity.TestCloudEnvironment;
import com.kms.katalon.integration.testcloud.entity.TestCloudMobileCapabilitiy;
import com.kms.katalon.integration.testcloud.entity.TestCloudMobileDevice;
import com.kms.katalon.integration.testcloud.exception.TestCloudAPIException;
import com.kms.katalon.integration.testcloud.model.APITestCloudEnvironment;
import com.kms.katalon.integration.testcloud.model.APITestCloudMobileDevice;
import com.kms.katalon.integration.testcloud.model.APITestCloudTunnel;
import com.kms.katalon.integration.testcloud.provider.TestCloudConfigurationProvider;
import com.kms.katalon.integration.testcloud.provider.TestCloudService;
import com.kms.katalon.integration.testcloud.util.TestCloudModelParser;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class TestCloudRunConfigurationContributor
extends WebUIRunConfigurationContributor {
    private static final int PREFERRED_ORDER = 12;
    private TestCloudEntity selectedEntity = new TestCloudEntity();
    private String deviceId;
    private Boolean isMissingMobileIdArg;
    private static final String INLCUDING_ARGUMENT_KEY_REGEX = "^-\\w+=\\w+";
    private static final String TESTCLOUD_MOBILE_DEVICE_ID_OPTION = "testcloudMobileDeviceId";
    private static final String TESTCLOUD_MOBILE_DEVICE_ID_SECOND_OPTION = "testcloudMobileDeviceID";
    private static final String TESTCLOUD_MOBILE_ID_OPTION = "testcloudMobileId";
    private static final String TESTCLOUD_MOBILE_ID_SECOND_OPTION = "testcloudMobileID";
    private static final String TESTCLOUD_ENVIRONMENT_ID_OPTION = "testcloudEnvironmentId";
    private static final String TESTCLOUD_ENVIRONMENT_ID_SECOND_OPTION = "testcloudEnvironmentID";
    private static final String TESTCLOUD_TUNNEL_OPTION = "testcloudTunnel";

    public String getId() {
        return WebUIDriverType.TESTCLOUD_DRIVER.toString();
    }

    public int getPreferredOrder() {
        return 12;
    }

    public IRunConfiguration getRunConfiguration(String projectDir) throws IOException, ExecutionException, InterruptedException {
        if (this.selectedEntity instanceof TestCloudEnvironment || this.selectedEntity instanceof TestCloudMobileDevice) {
            return this.getTestCloudConfiguration(projectDir, null, this.selectedEntity);
        }
        this.checkMissingMobileArguments();
        return new TestCloudRunConfiguration(projectDir);
    }

    public IRunConfiguration getRunConfiguration(String projectDir, RunConfigurationDescription runConfigurationDescription) throws IOException, ExecutionException, InterruptedException {
        IRunConfiguration runConfiguration = super.getRunConfiguration(projectDir, runConfigurationDescription);
        if (this.selectedEntity instanceof TestCloudEnvironment || this.selectedEntity instanceof TestCloudMobileDevice) {
            return this.getTestCloudConfiguration(projectDir, runConfiguration, this.selectedEntity);
        }
        this.checkMissingMobileArguments();
        Map runConfigurationData = runConfigurationDescription.getRunConfigurationData();
        if (runConfigurationData == null) {
            return null;
        }
        String rawEnvironmentInfo = (String)runConfigurationData.get("testCloudEnvironment");
        String rawMobileInfo = (String)runConfigurationData.get("testCloudMobile");
        if (!StringUtils.isEmpty((CharSequence)rawEnvironmentInfo)) {
            TestCloudEnvironment environment = (TestCloudEnvironment)JsonUtil.fromJson((String)rawEnvironmentInfo, TestCloudEnvironment.class);
            return this.getTestCloudConfiguration(projectDir, runConfiguration, environment);
        }
        if (!StringUtils.isEmpty((CharSequence)rawMobileInfo)) {
            TestCloudMobileDevice mobile = (TestCloudMobileDevice)JsonUtil.fromJson((String)rawMobileInfo, TestCloudMobileDevice.class);
            return this.getTestCloudConfiguration(projectDir, runConfiguration, mobile);
        }
        return null;
    }

    private void checkMissingMobileArguments() throws ExecutionException {
        if (this.isMissingMobileIdArg != null && this.isMissingMobileIdArg.booleanValue()) {
            throw new ExecutionException(IntegrationTestCloudMessageConstants.MSG_ERR_TESTCLOUD_MOBILE_ID_EMPTY);
        }
    }

    private IRunConfiguration getTestCloudConfiguration(String projectDir, IRunConfiguration runConfiguration, TestCloudEntity selectedEntity) throws IOException, ExecutionException {
        TestCloudRunConfiguration testCloudRunConfiguration = runConfiguration != null ? (TestCloudRunConfiguration)runConfiguration : new TestCloudRunConfiguration(projectDir);
        testCloudRunConfiguration.setTestCloudEnvironment(selectedEntity);
        testCloudRunConfiguration.setToken(this.fetchToken());
        return testCloudRunConfiguration;
    }

    private String fetchToken() throws ExecutionException {
        try {
            return TestCloudConfigurationProvider.getInstance().getToken();
        }
        catch (TestCloudAPIException e) {
            throw new ExecutionException((Throwable)e);
        }
    }

    private IntegerConsoleOption getTestCloudEnvironmentIdOption(final int initValue) {
        return new IntegerConsoleOption(){

            public String getOption() {
                return TestCloudRunConfigurationContributor.TESTCLOUD_ENVIRONMENT_ID_OPTION;
            }

            public boolean isRequired() {
                return false;
            }

            public Integer getValue() {
                return initValue;
            }
        };
    }

    private IntegerConsoleOption getTestCloudEnvironmentIdSecondOption(final int initValue) {
        return new IntegerConsoleOption(){

            public String getOption() {
                return TestCloudRunConfigurationContributor.TESTCLOUD_ENVIRONMENT_ID_SECOND_OPTION;
            }

            public boolean isRequired() {
                return false;
            }

            public Integer getValue() {
                return initValue;
            }
        };
    }

    private BooleanConsoleOption getTestCloudTunnelOption(final boolean initValue) {
        return new BooleanConsoleOption(){

            public String getOption() {
                return TestCloudRunConfigurationContributor.TESTCLOUD_TUNNEL_OPTION;
            }

            public boolean isRequired() {
                return false;
            }

            public Boolean getValue() {
                return initValue;
            }
        };
    }

    private StringConsoleOption getTestCloudMobileDeviceIdOption(final String initValue) {
        return new StringConsoleOption(){

            public String getOption() {
                return TestCloudRunConfigurationContributor.TESTCLOUD_MOBILE_DEVICE_ID_OPTION;
            }

            public boolean isRequired() {
                return false;
            }

            public String getValue() {
                return initValue;
            }
        };
    }

    private StringConsoleOption getTestCloudMobileDeviceIdSecondOption(final String initValue) {
        return new StringConsoleOption(){

            public String getOption() {
                return TestCloudRunConfigurationContributor.TESTCLOUD_MOBILE_DEVICE_ID_SECOND_OPTION;
            }

            public boolean isRequired() {
                return false;
            }

            public String getValue() {
                return initValue;
            }
        };
    }

    private StringConsoleOption getTestCloudMobileIdSecondOption(final String initValue) {
        return new StringConsoleOption(){

            public String getOption() {
                return TestCloudRunConfigurationContributor.TESTCLOUD_MOBILE_ID_SECOND_OPTION;
            }

            public boolean isRequired() {
                return false;
            }

            public String getValue() {
                return initValue;
            }
        };
    }

    private StringConsoleOption getTestCloudMobileIdOption(final String initValue) {
        return new StringConsoleOption(){

            public String getOption() {
                return TestCloudRunConfigurationContributor.TESTCLOUD_MOBILE_ID_OPTION;
            }

            public boolean isRequired() {
                return false;
            }

            public String getValue() {
                return initValue;
            }
        };
    }

    public List<ConsoleOption<?>> getConsoleOptionList() {
        return Arrays.asList(this.getTestCloudEnvironmentIdOption(0), this.getTestCloudEnvironmentIdSecondOption(0), this.getTestCloudMobileDeviceIdOption(""), this.getTestCloudMobileDeviceIdSecondOption(""), this.getTestCloudMobileIdOption(""), this.getTestCloudMobileIdSecondOption(""), this.getTestCloudTunnelOption(false));
    }

    public void setArgumentValue(ConsoleOption<?> consoleOption, String argumentValue) throws Exception {
        switch (consoleOption.getOption()) {
            case "testcloudEnvironmentID": 
            case "testcloudEnvironmentId": {
                int testCloudEnvironmentId = Integer.valueOf(argumentValue);
                APITestCloudEnvironment[] availableEnvironments = TestCloudService.getInstance().getEnvironments();
                Optional<APITestCloudEnvironment> selectedEnvironmentOpt = Arrays.asList(availableEnvironments).stream().filter(e -> e.getId() == testCloudEnvironmentId).findAny();
                if (!selectedEnvironmentOpt.isPresent()) {
                    throw new ExecutionException(MessageFormat.format(IntegrationTestCloudMessageConstants.MSG_ERR_TESTCLOUD_ENVIRONMENT_NOT_FOUND, testCloudEnvironmentId));
                }
                TestCloudEnvironment environment = TestCloudModelParser.parseAPITestCloudEnvironmentToTestCloudBrowser(selectedEnvironmentOpt.get());
                environment.setUsingTunnel(this.selectedEntity.isUsingTunnel());
                environment.setTimeout(TestCloudConfigurationProvider.getInstance().getOSTimeout(environment.getOs()));
                this.selectedEntity = environment;
                break;
            }
            case "testcloudMobileDeviceID": 
            case "testcloudMobileDeviceId": {
                this.validateArgumentValue(argumentValue, IntegrationTestCloudMessageConstants.MSG_ERR_TESTCLOUD_DEVICE_MOBILE_ID_EMPTY);
                this.deviceId = argumentValue;
                this.isMissingMobileIdArg = true;
                break;
            }
            case "testcloudMobileID": 
            case "testcloudMobileId": {
                this.validateArgumentValue(argumentValue, IntegrationTestCloudMessageConstants.MSG_ERR_TESTCLOUD_MOBILE_ID_EMPTY);
                this.checkEmptyArgumentsForMobileExecution(argumentValue);
                String testCloudMobileId = argumentValue;
                List<APITestCloudMobileDevice> availableMobileDevice = Arrays.asList(TestCloudService.getInstance().getMobileDevices());
                APITestCloudMobileDevice selectedDevice = null;
                Optional<TestCloudMobileCapabilitiy> selectedMobileOpt = Optional.empty();
                for (APITestCloudMobileDevice device : availableMobileDevice) {
                    if (!StringUtils.equals((CharSequence)device.getId(), (CharSequence)argumentValue)) continue;
                    selectedDevice = device;
                    selectedMobileOpt = device.getCapabilities().stream().filter(d -> StringUtils.equals((CharSequence)d.getDeviceId(), (CharSequence)this.deviceId)).findAny();
                    break;
                }
                this.checkTestCloudMobile(selectedDevice, testCloudMobileId);
                this.checkTestCloudMobileDevice(selectedMobileOpt);
                TestCloudMobileDevice mobile = TestCloudModelParser.parseAPITestCloudMobileDeviceToTestCloudMobileDevice(selectedDevice, selectedMobileOpt.get(), this.selectedEntity.isUsingTunnel());
                this.selectedEntity = mobile;
                break;
            }
            case "testcloudTunnel": {
                boolean usingTunnel = Boolean.valueOf(argumentValue);
                if (!usingTunnel) {
                    this.selectedEntity.setUsingTunnel(usingTunnel);
                    break;
                }
                Long organizationId = AnalyticsSettingStore.getStore().getOrganization().getId();
                APITestCloudTunnel[] availableTunnels = TestCloudService.getInstance().getTunnels(organizationId);
                if (availableTunnels == null || availableTunnels.length <= 0) {
                    throw new ExecutionException("No available TestCloud tunnel");
                }
                this.selectedEntity.setUsingTunnel(usingTunnel);
                break;
            }
        }
    }

    private void validateArgumentValue(String argumentValue, String errMsg) throws ExecutionException {
        Pattern pattern = Pattern.compile(INLCUDING_ARGUMENT_KEY_REGEX, 2);
        Matcher matcher = pattern.matcher(argumentValue.trim());
        if (matcher.find()) {
            throw new ExecutionException(errMsg);
        }
    }

    private void checkTestCloudMobileDevice(Optional<TestCloudMobileCapabilitiy> selectedMobileOpt) throws ExecutionException {
        if (!selectedMobileOpt.isPresent()) {
            throw new ExecutionException(MessageFormat.format(IntegrationTestCloudMessageConstants.MSG_ERR_TESTCLOUD_MOBILE_DEVICE_ID_NOT_FOUND, this.deviceId));
        }
    }

    private void checkTestCloudMobile(APITestCloudMobileDevice selectedDevice, String testCloudMobileId) throws ExecutionException {
        if (selectedDevice == null) {
            throw new ExecutionException(MessageFormat.format(IntegrationTestCloudMessageConstants.MSG_ERR_TESTCLOUD_MOBILE_ID_NOT_FOUND, testCloudMobileId));
        }
    }

    private void checkEmptyArgumentsForMobileExecution(String argumentValue) throws ExecutionException {
        if (StringUtils.isEmpty((CharSequence)this.deviceId)) {
            throw new ExecutionException(IntegrationTestCloudMessageConstants.MSG_ERR_TESTCLOUD_DEVICE_MOBILE_ID_EMPTY);
        }
        if (StringUtils.isEmpty((CharSequence)argumentValue)) {
            throw new ExecutionException(IntegrationTestCloudMessageConstants.MSG_ERR_TESTCLOUD_MOBILE_ID_EMPTY);
        }
        this.isMissingMobileIdArg = false;
    }

    public List<ConsoleOption<?>> getConsoleOptions(RunConfigurationDescription description) {
        TestCloudMobileDevice mobile = (TestCloudMobileDevice)JsonUtil.fromJson((String)((String)description.getRunConfigurationData().get("testCloudMobile")), TestCloudMobileDevice.class);
        TestCloudEnvironment environment = (TestCloudEnvironment)JsonUtil.fromJson((String)((String)description.getRunConfigurationData().get("testCloudEnvironment")), TestCloudEnvironment.class);
        if (environment != null) {
            return Arrays.asList(this.getTestCloudEnvironmentIdOption(environment.getId()), this.getTestCloudTunnelOption(environment.isUsingTunnel()));
        }
        return Arrays.asList(this.getTestCloudMobileDeviceIdOption(mobile.getMobileDeviceId()), this.getTestCloudMobileIdOption(mobile.getId()), this.getTestCloudTunnelOption(mobile.isUsingTunnel()));
    }
}

