/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.testcloud.driver;

import com.kms.katalon.core.driver.DriverType;
import com.kms.katalon.core.webui.driver.WebUIDriverType;
import com.kms.katalon.execution.webui.driver.RemoteWebDriverConnector;
import com.kms.katalon.integration.analytics.setting.AnalyticsSettingStore;
import com.kms.katalon.integration.testcloud.entity.TestCloudEntity;
import com.kms.katalon.integration.testcloud.exception.TestCloudAPIException;
import com.kms.katalon.integration.testcloud.model.APITestCloudTunnel;
import com.kms.katalon.integration.testcloud.provider.TestCloudAPIProvider;
import com.kms.katalon.integration.testcloud.provider.TestCloudService;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.util.CryptoUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.client.utils.URIBuilder;

public class TestCloudDriverConnector
extends RemoteWebDriverConnector {
    private String token;
    private TestCloudEntity testCloudEntity;

    public TestCloudDriverConnector(String configurationFolderPath) throws IOException {
        super(configurationFolderPath);
        this.remoteWebDriverConnectorType = RemoteWebDriverConnector.RemoteWebDriverConnectorType.Selenium;
    }

    public String getRemoteServerUrl() {
        if (this.token == null || this.token.isEmpty()) {
            throw new IllegalArgumentException("Missing token for Katalon TestCloud Execution");
        }
        try {
            String remoteServerURL = TestCloudAPIProvider.getTestCloudExecutionEndpoint(TestCloudService.getInstance().getTestCloudServer());
            URI uri = new URI(remoteServerURL);
            URIBuilder builder = new URIBuilder(uri);
            builder.setUserInfo("token", this.getToken());
            remoteServerURL = builder.build().toASCIIString();
            super.setRemoteServerUrl(remoteServerURL);
            return remoteServerURL;
        }
        catch (TestCloudAPIException | URISyntaxException e) {
            LogUtil.logError((Throwable)e);
            return null;
        }
    }

    public DriverType getDriverType() {
        return WebUIDriverType.TESTCLOUD_DRIVER;
    }

    public Map<String, Object> getSystemProperties() {
        Map systemProperties = super.getSystemProperties();
        systemProperties.putAll(this.testCloudEntity.getSystemPropertiesMap());
        try {
            String remoteServerUrl = this.getRemoteServerUrl();
            remoteServerUrl = CryptoUtil.encode((CryptoUtil.CrytoInfo)CryptoUtil.getDefault((String)this.getRemoteServerUrl()));
            systemProperties.put("remoteWebDriverUrl", remoteServerUrl);
            systemProperties.put("isEncrypted", true);
        }
        catch (UnsupportedEncodingException | GeneralSecurityException exception) {}
        return systemProperties;
    }

    public Map<String, Object> getUserConfigProperties() {
        Map configProperties = super.getUserConfigProperties();
        configProperties.putAll(this.testCloudEntity.toDesireCapabilitiesMap());
        HashMap<String, String> katalonOption = (HashMap<String, String>)configProperties.get("katalon:option");
        if (katalonOption == null) {
            katalonOption = new HashMap<String, String>();
        }
        Long organizationId = AnalyticsSettingStore.getStore().getOrganization().getId();
        katalonOption.put("organizationId", organizationId.toString());
        String tunnelId = "";
        if (this.testCloudEntity.isUsingTunnel()) {
            try {
                APITestCloudTunnel[] defaultTunnel = TestCloudService.getInstance().getTunnels(organizationId);
                if (defaultTunnel != null && defaultTunnel.length > 0) {
                    tunnelId = defaultTunnel[0].getId();
                }
            }
            catch (TestCloudAPIException exception) {
                LogUtil.logError((Throwable)exception);
            }
        }
        katalonOption.put("tunnelId", tunnelId);
        return configProperties;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public TestCloudEntity getTestCloudEntity() {
        return this.testCloudEntity;
    }

    public void setTestCloudEntity(TestCloudEntity testCloudEntity) {
        this.testCloudEntity = testCloudEntity;
    }
}

