/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.testcloud.provider;

import com.google.common.reflect.TypeToken;
import com.kms.katalon.core.util.Strings;
import com.kms.katalon.integration.analytics.entity.KatOneJwtTokenInfo;
import com.kms.katalon.integration.analytics.exceptions.AnalyticsApiException;
import com.kms.katalon.integration.analytics.providers.BaseTestOpsService;
import com.kms.katalon.integration.analytics.providers.TestOpsService;
import com.kms.katalon.integration.testcloud.exception.TestCloudAPIException;
import com.kms.katalon.integration.testcloud.model.APITestCloudConfiguration;
import com.kms.katalon.integration.testcloud.model.APITestCloudEnvironment;
import com.kms.katalon.integration.testcloud.model.APITestCloudMobileDevice;
import com.kms.katalon.integration.testcloud.model.APITestCloudOrganizationUsage;
import com.kms.katalon.integration.testcloud.model.APITestCloudTunnel;
import com.kms.katalon.integration.testcloud.provider.TestCloudAPIProvider;
import com.kms.katalon.license.models.AuthenticationToken;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;

public class TestCloudService
extends BaseTestOpsService<TestCloudService> {
    private String testCloudServer;
    private static TestCloudService instance;

    public String getTestCloudServer() {
        return (String)Strings.firstNonBlank((CharSequence[])new String[]{System.getProperty("testCloudServerUrl"), this.testCloudServer, "https://testcloud.katalon.com"});
    }

    public TestCloudService setTestCloudServer(String testCloudServer) {
        this.testCloudServer = testCloudServer;
        return this;
    }

    public static TestCloudService getInstance() {
        if (instance == null) {
            instance = new TestCloudService();
        }
        return instance;
    }

    protected static TestOpsService getBaseInstance() {
        return TestOpsService.getActiveInstance();
    }

    public TestCloudService setCredential(String apiKey) {
        TestCloudService.getBaseInstance().setCredential(apiKey);
        return this;
    }

    public AuthenticationToken requestTestCloudToken() throws TestCloudAPIException {
        try {
            return TestCloudService.getBaseInstance().requestKatOneToken(true);
        }
        catch (AnalyticsApiException error) {
            throw TestCloudAPIException.wrap(error);
        }
    }

    public <T> T sendTestCloudRequest(HttpUriRequest request, Class<T> returnType) throws TestCloudAPIException {
        return this.sendTestCloudRequest(request, returnType, false);
    }

    public <T> T sendTestCloudRequest(HttpUriRequest request, Class<T> returnType, boolean silent) throws TestCloudAPIException {
        return this.sendTestCloudRequest(request, TypeToken.of(returnType), silent);
    }

    public <T> T sendTestCloudRequest(HttpUriRequest request, TypeToken<T> returnType, boolean silent) throws TestCloudAPIException {
        try {
            return (T)this.sendRequestWithToken(request, returnType, this.requestTestCloudToken(), silent);
        }
        catch (Exception error) {
            throw TestCloudAPIException.wrap(error);
        }
    }

    public URIBuilder getTestCloudURIBuilder(String path) throws MalformedURLException, URISyntaxException {
        return this.getUriBuilder(this.getTestCloudServer(), path);
    }

    public void applyCommonHeaders(HttpUriRequest request, String host, boolean json) {
        super.applyCommonHeaders(request, host, json);
        request.setHeader("TC-Tenant", "Katalon");
        request.setHeader("TC-Channel", "KatalonStudio");
    }

    public APITestCloudEnvironment[] getEnvironments() throws TestCloudAPIException {
        try {
            URI uri = new URI(TestCloudAPIProvider.getTestCloudEnvironments(this.getTestCloudServer()));
            URIBuilder uriBuilder = new URIBuilder(uri);
            HttpGet httpGet = new HttpGet(uriBuilder.build().toASCIIString());
            return this.sendTestCloudRequest((HttpUriRequest)httpGet, APITestCloudEnvironment[].class);
        }
        catch (Exception exception) {
            throw TestCloudAPIException.wrap(exception);
        }
    }

    public APITestCloudMobileDevice[] getMobileDevices() throws TestCloudAPIException {
        try {
            URI uri = new URI(TestCloudAPIProvider.getTestCloudMobileDevices(this.getTestCloudServer()));
            URIBuilder uriBuilder = new URIBuilder(uri);
            HttpGet httpGet = new HttpGet(uriBuilder.build().toASCIIString());
            return this.sendTestCloudRequest((HttpUriRequest)httpGet, APITestCloudMobileDevice[].class);
        }
        catch (Exception exception) {
            throw TestCloudAPIException.wrap(exception);
        }
    }

    public APITestCloudConfiguration[] getConfigurations() throws TestCloudAPIException {
        try {
            URI uri = new URI(TestCloudAPIProvider.getTestCloudConfigurations(this.getTestCloudServer()));
            URIBuilder uriBuilder = new URIBuilder(uri);
            HttpGet httpGet = new HttpGet(uriBuilder.build().toASCIIString());
            return this.sendTestCloudRequest((HttpUriRequest)httpGet, APITestCloudConfiguration[].class);
        }
        catch (Exception exception) {
            throw TestCloudAPIException.wrap(exception);
        }
    }

    public APITestCloudConfiguration[] getConfigurations(String token) throws TestCloudAPIException {
        try {
            URI uri = new URI(TestCloudAPIProvider.getTestCloudConfigurations(this.getTestCloudServer()));
            URIBuilder uriBuilder = new URIBuilder(uri);
            HttpGet httpGet = new HttpGet(uriBuilder.build().toASCIIString());
            httpGet.setHeader("Authorization", "Bearer " + token);
            return (APITestCloudConfiguration[])this.sendRequest((HttpUriRequest)httpGet, APITestCloudConfiguration[].class);
        }
        catch (Exception exception) {
            throw TestCloudAPIException.wrap(exception);
        }
    }

    public APITestCloudTunnel[] getTunnels(Long organizationId) throws TestCloudAPIException {
        try {
            URI uri = new URI(TestCloudAPIProvider.getTestCloudTunnels(this.getTestCloudServer()));
            URIBuilder uriBuilder = new URIBuilder(uri);
            String username = ((KatOneJwtTokenInfo)this.requestTestCloudToken().parseAccessToken(KatOneJwtTokenInfo.class)).email;
            uriBuilder.addParameter("username", username);
            uriBuilder.addParameter("organizationId", organizationId.toString());
            HttpGet httpGet = new HttpGet(uriBuilder.build().toASCIIString());
            return this.sendTestCloudRequest((HttpUriRequest)httpGet, APITestCloudTunnel[].class);
        }
        catch (Exception exception) {
            throw TestCloudAPIException.wrap(exception);
        }
    }

    public APITestCloudOrganizationUsage getTestCloudOrganizationUsage(String orgId) throws TestCloudAPIException {
        try {
            URIBuilder uriBuilder = this.getKatOneUriBuilder("/v1/testcloud-usage/latest/" + orgId);
            HttpGet httpGet = new HttpGet(uriBuilder.build().toASCIIString());
            return this.sendTestCloudRequest((HttpUriRequest)httpGet, APITestCloudOrganizationUsage.class);
        }
        catch (Exception exception) {
            throw TestCloudAPIException.wrap(exception);
        }
    }
}

