/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.analytics.dialog;

import com.kms.katalon.composer.components.impl.dialogs.AbstractDialog;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.integration.analytics.constants.ComposerIntegrationAnalyticsMessageConstants;
import com.kms.katalon.integration.analytics.constants.ComposerAnalyticsStringConstants;
import com.kms.katalon.integration.analytics.entity.AnalyticsProject;
import com.kms.katalon.integration.analytics.entity.AnalyticsTeam;
import com.kms.katalon.integration.analytics.providers.TestOpsService;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewProjectDialog
extends AbstractDialog {
    private Text txtProject;
    private Job creatingJob;
    private AnalyticsProject analyticsProject;
    private AnalyticsTeam team;
    private boolean permissionCreateTeam;
    private TestOpsService customTestOpsService;

    public NewProjectDialog(Shell parentShell, AnalyticsTeam team) {
        this(parentShell, team, TestOpsService.getActiveInstance());
    }

    public NewProjectDialog(Shell parentShell, AnalyticsTeam team, TestOpsService customTestOpsService) {
        super(parentShell);
        this.team = team;
        this.customTestOpsService = customTestOpsService;
        this.permissionCreateTeam = this.team != null && (this.team.getRole().contains("OWNER") || this.team.getRole().contains("ADMIN"));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (this.permissionCreateTeam) {
            this.createButton(parent, 0, ComposerIntegrationAnalyticsMessageConstants.BTN_CREATE, true);
        }
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void okPressed() {
        this.createNewProject();
    }

    protected void registerControlModifyListeners() {
    }

    protected void setInput() {
        if (this.txtProject != null) {
            this.txtProject.setText("");
        }
    }

    protected void cancelPressed() {
        if (this.creatingJob != null && this.creatingJob.getState() == 4) {
            this.creatingJob.cancel();
        }
        super.cancelPressed();
    }

    protected Control createDialogContainer(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout glContainer = new GridLayout(3, false);
        glContainer.horizontalSpacing = 10;
        container.setLayout((Layout)glContainer);
        if (this.permissionCreateTeam) {
            Label lblNewProject = new Label(container, 0);
            lblNewProject.setText(ComposerIntegrationAnalyticsMessageConstants.LBL_NEW_PROJECT);
            this.txtProject = new Text(container, 0x800800);
            GridData txtProjectGridData = new GridData(4, 4, true, false, 2, 1);
            txtProjectGridData.widthHint = 300;
            this.txtProject.setLayoutData((Object)txtProjectGridData);
        } else {
            Label lblPermissions = new Label(container, 0);
            lblPermissions.setForeground(ColorUtil.getTextErrorColor());
            lblPermissions.setText(ComposerIntegrationAnalyticsMessageConstants.MSG_DLG_PRG_PREMISSTION_CREATE_PROJECT);
        }
        return container;
    }

    private boolean createNewProject() {
        this.getButton(0).setEnabled(false);
        final String newProjectName = this.txtProject.getText();
        this.creatingJob = new Job(ComposerIntegrationAnalyticsMessageConstants.MSG_DLG_PRG_CREATING_PROJECTS){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    NewProjectDialog.this.analyticsProject = NewProjectDialog.this.customTestOpsService.createProject(newProjectName, NewProjectDialog.this.team);
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                catch (Exception e) {
                    if (!monitor.isCanceled() && !NewProjectDialog.this.isDisposed()) {
                        UISynchronizeService.syncExec((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)ComposerAnalyticsStringConstants.ERROR, (String)e.getLocalizedMessage());
                            }
                        });
                    }
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                finally {
                    monitor.done();
                }
            }
        };
        this.creatingJob.setUser(false);
        this.creatingJob.schedule();
        this.creatingJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (NewProjectDialog.this.isDisposed()) {
                    return;
                }
                UISynchronizeService.syncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        NewProjectDialog.this.getButton(0).setEnabled(true);
                    }
                });
                if (!event.getResult().isOK()) {
                    return;
                }
                UISynchronizeService.syncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        NewProjectDialog.this.setReturnCode(0);
                        NewProjectDialog.this.close();
                    }
                });
            }
        });
        return true;
    }

    public String getDialogTitle() {
        return ComposerIntegrationAnalyticsMessageConstants.DIA_TITLE_CREATE_NEW_PROJECT;
    }

    public AnalyticsProject getAnalyticsProject() {
        return this.analyticsProject;
    }

    private boolean isDisposed() {
        Shell shell = this.getShell();
        return shell == null || shell.isDisposed();
    }
}

