/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.analytics.preferences;

import com.kms.katalon.application.utils.ActivationInfoCollector;
import com.kms.katalon.application.utils.ApplicationContext;
import com.kms.katalon.composer.components.dialogs.FieldEditorPreferencePageWithHelp;
import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.handler.KSEFeatureAccessHandler;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.util.ControlUtil;
import com.kms.katalon.composer.components.util.UITimeUtil;
import com.kms.katalon.composer.helpers.AuthenticationController;
import com.kms.katalon.composer.integration.analytics.constants.ComposerIntegrationAnalyticsMessageConstants;
import com.kms.katalon.composer.integration.analytics.dialog.NewProjectDialog;
import com.kms.katalon.constants.DocumentationMessageConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.util.Strings;
import com.kms.katalon.entity.integration.analytics.AnalyticsOrganization;
import com.kms.katalon.feature.FeatureServiceConsumer;
import com.kms.katalon.feature.IFeatureService;
import com.kms.katalon.feature.KSEFeature;
import com.kms.katalon.integration.analytics.constants.ComposerAnalyticsStringConstants;
import com.kms.katalon.integration.analytics.entity.AnalyticsProject;
import com.kms.katalon.integration.analytics.entity.AnalyticsTeam;
import com.kms.katalon.integration.analytics.exceptions.AnalyticsApiException;
import com.kms.katalon.integration.analytics.handler.AnalyticsAuthorizationHandler;
import com.kms.katalon.integration.analytics.providers.BaseTestOpsService;
import com.kms.katalon.integration.analytics.providers.TestOpsService;
import com.kms.katalon.integration.analytics.setting.AnalyticsSettingStore;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executors;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class AnalyticsPreferencesPage
extends FieldEditorPreferencePageWithHelp {
    @Inject
    private IEventBroker eventBroker;
    private Composite container;
    private Composite mainComposite;
    private Button btnRefresh;
    private Button btnConnect;
    private Button enableAnalyticsIntegration;
    private Button enableOverrideAuthentication;
    private Button enableTestCloudIntegration;
    private Button autoUploadTestReports;
    private Text txtServerUrl;
    private Text txtEmail;
    private Text txtPassword;
    private Link lblStatus;
    private Label lblStatusOnPremise;
    private Combo cbbOrganization;
    private Combo cbbProjects;
    private List<AnalyticsProject> projects = new ArrayList<AnalyticsProject>();
    private List<AnalyticsTeam> teams = new ArrayList<AnalyticsTeam>();
    private List<AnalyticsOrganization> organizationsOnPremise = new ArrayList<AnalyticsOrganization>();
    private AnalyticsProject selectProjectFromConfig;
    private AnalyticsTeam selectTeamFromConfig;
    private boolean canAccessProject = true;
    private Button btnCreate;
    private AnalyticsSettingStore analyticsSettingStore;
    private String email;
    private String password;
    private String testOpsServerUrl;
    private String adminServerUrl;
    private boolean isUseOnPremise = false;
    private AnalyticsOrganization organization;
    private GridData gdEnableOverrideAuthentication;
    private GridData gdBtnConnect;
    private GridData gdLblStatus;
    private IFeatureService featureService = FeatureServiceConsumer.getServiceInstance();
    private boolean isOnPremActivation;
    private Combo cbbTeams;
    private TestOpsService tempTestOpsService;

    public AnalyticsPreferencesPage() {
        this.analyticsSettingStore = new AnalyticsSettingStore(ProjectController.getInstance().getCurrentProject().getFolderLocation());
        this.isUseOnPremise = this.analyticsSettingStore.isOverrideAuthentication();
        this.isOnPremActivation = TestOpsService.getInstance().isOnPremUser();
        this.testOpsServerUrl = this.analyticsSettingStore.getServerEndpoint();
        this.adminServerUrl = this.analyticsSettingStore.getAuthenticationEndpoint();
        this.email = this.analyticsSettingStore.getEmail();
        this.password = this.analyticsSettingStore.getPassword();
        this.organization = this.analyticsSettingStore.getOrganization();
        if (this.email == null) {
            this.email = "";
        }
        if (this.password == null) {
            this.password = "";
        }
        if (this.testOpsServerUrl == null) {
            this.testOpsServerUrl = "";
        }
    }

    protected Control createContents(Composite parent) {
        this.container = new Composite(parent, 0);
        this.container.setLayout((Layout)new GridLayout(1, false));
        this.mainComposite = new Composite(this.container, 0);
        this.mainComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        GridLayout glMainComposite = new GridLayout(1, false);
        glMainComposite.marginWidth = 0;
        glMainComposite.marginHeight = 0;
        this.mainComposite.setLayout((Layout)glMainComposite);
        this.createAuthenticationGroup();
        this.createSelectGroup();
        this.addListeners();
        this.initialize();
        return this.container;
    }

    private void createAuthenticationGroup() {
        Group grpAuthentication = new Group(this.mainComposite, 0);
        grpAuthentication.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        GridLayout glGrpAuthentication = new GridLayout(2, false);
        glGrpAuthentication.horizontalSpacing = 15;
        grpAuthentication.setLayout((Layout)glGrpAuthentication);
        grpAuthentication.setText(ComposerIntegrationAnalyticsMessageConstants.LBL_AUTHENTICATE_GROUP);
        this.enableOverrideAuthentication = new Button((Composite)grpAuthentication, 32);
        this.gdEnableOverrideAuthentication = new GridData(4, 128, true, false, 2, 1);
        this.enableOverrideAuthentication.setLayoutData((Object)this.gdEnableOverrideAuthentication);
        this.enableOverrideAuthentication.setText(ComposerIntegrationAnalyticsMessageConstants.LBL_OVERRIDE_AUTHENTICATION);
        Label lblServerUrl = new Label((Composite)grpAuthentication, 0);
        lblServerUrl.setText(ComposerIntegrationAnalyticsMessageConstants.LBL_SERVER_URL);
        this.txtServerUrl = new Text((Composite)grpAuthentication, 2048);
        this.txtServerUrl.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblEmail = new Label((Composite)grpAuthentication, 0);
        lblEmail.setText(ComposerIntegrationAnalyticsMessageConstants.LBL_EMAIL);
        this.txtEmail = new Text((Composite)grpAuthentication, 2048);
        this.txtEmail.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblPassword = new Label((Composite)grpAuthentication, 0);
        lblPassword.setText(ComposerIntegrationAnalyticsMessageConstants.LBL_PASSWORD);
        this.txtPassword = new Text((Composite)grpAuthentication, 0x400800);
        this.txtPassword.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnConnect = new Button((Composite)grpAuthentication, 0);
        this.gdBtnConnect = new GridData(4, 0x1000000, false, false, 1, 1);
        this.btnConnect.setLayoutData((Object)this.gdBtnConnect);
        this.btnConnect.setText(ComposerIntegrationAnalyticsMessageConstants.BTN_FETCH_ORGANIZATION);
        this.lblStatusOnPremise = new Label((Composite)grpAuthentication, 64);
        this.gdLblStatus = new GridData(4, 0x1000000, false, false, 1, 1);
        this.lblStatusOnPremise.setLayoutData((Object)this.gdLblStatus);
        Label lblOrganization = new Label((Composite)grpAuthentication, 0);
        lblOrganization.setText(ComposerIntegrationAnalyticsMessageConstants.LBL_ORGANIZATION);
        this.cbbOrganization = new Combo((Composite)grpAuthentication, 8);
        this.cbbOrganization.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.enableAuthentication(false);
    }

    private void createSelectGroup() {
        Group grpSelect = new Group(this.mainComposite, 0);
        grpSelect.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        GridLayout glGrpSelect = new GridLayout(4, false);
        grpSelect.setLayout((Layout)glGrpSelect);
        grpSelect.setText(ComposerIntegrationAnalyticsMessageConstants.LBL_INTEGRATION);
        this.enableAnalyticsIntegration = new Button((Composite)grpSelect, 32);
        this.enableAnalyticsIntegration.setLayoutData((Object)new GridData(4, 128, true, false, 4, 1));
        this.enableAnalyticsIntegration.setText(ComposerIntegrationAnalyticsMessageConstants.LBL_ENABLE_PLATFORM_INTEGRATION);
        this.createTeamComposite(grpSelect);
        Label lblProject = new Label((Composite)grpSelect, 0);
        lblProject.setText(ComposerIntegrationAnalyticsMessageConstants.LBL_PROJECT);
        this.cbbProjects = new Combo((Composite)grpSelect, 8);
        this.cbbProjects.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.cbbProjects.setEnabled(false);
        this.btnCreate = new Button((Composite)grpSelect, 0);
        this.btnCreate.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.btnCreate.setText(ComposerIntegrationAnalyticsMessageConstants.BTN_NEW_PROJECT);
        this.btnCreate.setEnabled(false);
        Composite compConnect = new Composite((Composite)grpSelect, 0);
        compConnect.setLayoutData((Object)new GridData(4, 4, true, false, 4, 1));
        GridLayout glConnect = new GridLayout(4, false);
        glConnect.marginWidth = 0;
        compConnect.setLayout((Layout)glConnect);
        GridData gdBtn = new GridData(4, 0x1000000, false, false, 1, 1);
        gdBtn.widthHint = 120;
        this.btnRefresh = new Button(compConnect, 0);
        this.btnRefresh.setLayoutData((Object)gdBtn);
        this.btnRefresh.setText(ComposerIntegrationAnalyticsMessageConstants.BTN_FETCH_PROJECT);
        this.btnRefresh.setEnabled(false);
        Label lblHidden1 = new Label((Composite)grpSelect, 0);
        lblHidden1.setVisible(false);
        this.enableTestCloudIntegration = new Button((Composite)grpSelect, 32);
        this.enableTestCloudIntegration.setLayoutData((Object)new GridData(4, 128, true, false, 3, 1));
        this.enableTestCloudIntegration.setText(ComposerIntegrationAnalyticsMessageConstants.LBL_ENABLE_TESTCLOUD);
        this.enableTestCloudIntegration.setEnabled(false);
        Label lblHidden2 = new Label((Composite)grpSelect, 0);
        lblHidden2.setVisible(false);
        this.autoUploadTestReports = new Button((Composite)grpSelect, 32);
        this.autoUploadTestReports.setLayoutData((Object)new GridData(4, 128, true, false, 3, 1));
        this.autoUploadTestReports.setText(ComposerIntegrationAnalyticsMessageConstants.LBL_AUTO_UPLOAD_ALL_REPORTS);
        this.autoUploadTestReports.setEnabled(false);
        this.lblStatus = new Link(this.mainComposite, 64);
        GridData gdStatus = new GridData(4, 0x1000000, true, false, 1, 1);
        gdStatus.heightHint = 40;
        this.lblStatus.setLayoutData((Object)gdStatus);
    }

    private void createTeamComposite(Group grpSelect) {
        if (this.isOnPremActivation) {
            Label lblTeam = new Label((Composite)grpSelect, 0);
            lblTeam.setText(ComposerIntegrationAnalyticsMessageConstants.LBL_TEAM);
            this.cbbTeams = new Combo((Composite)grpSelect, 8);
            this.cbbTeams.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
            this.cbbTeams.setEnabled(false);
        }
    }

    protected void initialize() {
        this.hideOverrideAuthenticationIfNotEnterprise();
        super.initialize();
        if (this.isUseOnPremise) {
            this.loadInfoFromOnPremise();
        } else {
            this.loadInfoFromCloud();
        }
        if (this.isUseOnPremise) {
            this.fillData(false);
        } else if (this.isNoInfo() && this.analyticsSettingStore.isIntegrationEnabled()) {
            UITimeUtil.setTimeout(() -> {
                if (ControlUtil.isDisposed((Widget)this.mainComposite)) {
                    return;
                }
                this.katalonLogin();
            }, (long)500L);
        } else {
            this.fillData(false);
        }
    }

    protected void createFieldEditors() {
    }

    protected void performDefaults() {
        super.performDefaults();
        if (!this.isInitialized()) {
            return;
        }
        this.enableIntegration();
        this.uploadDataOnPremise();
        this.updateDataStore();
    }

    public boolean performOk() {
        if (!this.isInitialized()) {
            return true;
        }
        boolean integrationEnabled = this.enableAnalyticsIntegration.getSelection();
        if (!integrationEnabled) {
            this.uploadDataOnPremise();
            this.updateDataStore();
            this.refreshNavigationTree();
            this.applyOverridingConfigs();
            return true;
        }
        if (this.isOnPremActivation && this.cbbTeams.getSelectionIndex() == -1) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)ComposerAnalyticsStringConstants.ERROR, (String)ComposerIntegrationAnalyticsMessageConstants.REPORT_MSG_MUST_SET_TEAM);
            return false;
        }
        if (this.cbbProjects.getSelectionIndex() == -1) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)ComposerAnalyticsStringConstants.ERROR, (String)ComposerIntegrationAnalyticsMessageConstants.REPORT_MSG_MUST_SET_PROJECT);
            return false;
        }
        if (this.isUseOnPremise && (StringUtils.isBlank((CharSequence)this.txtPassword.getText()) || StringUtils.isBlank((CharSequence)this.txtServerUrl.getText()))) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)ComposerAnalyticsStringConstants.ERROR, (String)ComposerIntegrationAnalyticsMessageConstants.REPORT_MSG_MUST_ENTER_REQUIRED_INFORMATION);
            return false;
        }
        this.uploadDataOnPremise();
        this.updateDataStore();
        this.refreshNavigationTree();
        this.applyOverridingConfigs();
        return super.performOk();
    }

    private void applyOverridingConfigs() {
        TestOpsService overridingTestOpsService = TestOpsService.getOverridingInstance();
        overridingTestOpsService.assign((BaseTestOpsService)this.getTempTestOpsService());
        try {
            overridingTestOpsService.detectTestOpsServer();
        }
        catch (AnalyticsApiException error) {
            LoggerSingleton.logError((Throwable)error);
        }
        if (this.isUseOnPremise) {
            TestOpsService.switchToOverridingInstance();
        } else {
            TestOpsService.switchToDefaultInstance();
        }
    }

    private void refreshNavigationTree() {
        this.eventBroker.post("EXPLORER/RELOAD_DATA", (Object)true);
    }

    public boolean performCancel() {
        IEventBroker eventBroker = EventBrokerSingleton.getInstance().getEventBroker();
        eventBroker.post("SETTINGS/INTERGRATION/KATALON_ANALYTICS", (Object)this.isIntegratedSuccessfully());
        return super.performCancel();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("field_editor_value".equals(event.getProperty())) {
            this.handleFieldEditorValueChanged(event);
        }
        super.propertyChange(event);
    }

    private void handleFieldEditorValueChanged(PropertyChangeEvent event) {
        if (event.getSource() == this.enableAnalyticsIntegration) {
            this.enableIntegration();
        }
    }

    private void fillData(boolean fromKatalonLogin) {
        try {
            AnalyticsOrganization org;
            if (fromKatalonLogin) {
                this.enableAnalyticsIntegration.setSelection(true);
            } else {
                this.enableAnalyticsIntegration.setSelection(this.analyticsSettingStore.isIntegrationEnabled());
            }
            this.teams.clear();
            this.projects.clear();
            this.txtServerUrl.setText((String)Strings.firstNonBlank((CharSequence[])new String[]{this.analyticsSettingStore.getServerEndpointOnPremise(), this.analyticsSettingStore.getServerEndpointCloud()}));
            this.txtEmail.setText(this.email);
            this.txtPassword.setText(this.password);
            if (this.analyticsSettingStore.isOverrideAuthentication()) {
                this.enableOverrideAuthentication.setSelection(true);
                this.enableAuthentication(true);
                if (StringUtils.isEmpty((CharSequence)this.email) || StringUtils.isEmpty((CharSequence)this.password) || StringUtils.isEmpty((CharSequence)this.testOpsServerUrl)) {
                    this.setProgressMessageOnPremise(ComposerIntegrationAnalyticsMessageConstants.MSG_MUST_ENTER_CREDENTIAL, true);
                    return;
                }
            }
            if (Objects.nonNull(org = this.analyticsSettingStore.getOrganizationCloud()) && org.isSamlSSO()) {
                this.enableOverrideAuthentication.setEnabled(false);
                this.enableAuthentication(false);
                this.isUseOnPremise = false;
                this.organization = this.analyticsSettingStore.getOrganizationCloud();
            }
            this.organizationsOnPremise.clear();
            this.organizationsOnPremise.add(this.organization);
            this.cbbOrganization.setItems(AnalyticsAuthorizationHandler.getOrganizationNames(this.organizationsOnPremise).toArray(new String[0]));
            this.cbbOrganization.select(0);
            this.selectProjectFromConfig = this.analyticsSettingStore.getProject();
            this.selectTeamFromConfig = this.analyticsSettingStore.getTeam();
            this.enableTestCloudIntegration.setSelection(this.analyticsSettingStore.isTestCloudIntegrationEnabled());
            this.autoUploadTestReports.setSelection(this.analyticsSettingStore.isAutoUploadReportEnabled());
            if (this.enableAnalyticsIntegration.getSelection()) {
                Executors.newFixedThreadPool(1).submit(() -> {
                    UISynchronizeService.syncExec(() -> {
                        this.setProgressMessage(ComposerIntegrationAnalyticsMessageConstants.MSG_DLG_PRG_CONNECTING_TO_SERVER, false);
                        this.enableObject(false);
                    });
                    UISynchronizeService.syncExec(() -> {
                        try {
                            String token = AnalyticsAuthorizationHandler.getToken((TestOpsService)this.getTestOpsService(), (AnalyticsSettingStore)this.analyticsSettingStore);
                            if (StringUtils.isBlank((CharSequence)token)) {
                                this.setProgressMessage(ComposerIntegrationAnalyticsMessageConstants.MSG_REQUEST_TOKEN_ERROR, true);
                                this.enableObject(true);
                                return;
                            }
                            if (this.selectTeamFromConfig != null && this.selectProjectFromConfig != null && !this.isOnPremActivation) {
                                this.fetchOnCloudProjects();
                                this.canAccessProject = this.checkUserProjectAcessibility();
                                if (this.canAccessProject) {
                                    this.updateProjectsToComboBox();
                                    this.setProgressMessage("", false);
                                } else {
                                    this.setProgressMessage(ComposerIntegrationAnalyticsMessageConstants.VIEW_ERROR_MSG_PROJ_USER_CAN_NOT_ACCESS_PROJECT, true);
                                }
                                this.enableObject(true);
                                return;
                            }
                            this.getTeam(this.organization.getId());
                            if (this.teams != null && !this.teams.isEmpty()) {
                                this.canAccessProject = this.checkUserCanAccessProject();
                                if (!this.canAccessProject) {
                                    this.teams.add(this.selectTeamFromConfig);
                                    this.projects.add(this.selectProjectFromConfig);
                                    this.setProgressMessage(ComposerIntegrationAnalyticsMessageConstants.VIEW_ERROR_MSG_PROJ_USER_CAN_NOT_ACCESS_PROJECT, true);
                                    this.enableObject(true);
                                    return;
                                }
                                if (this.isOnPremActivation) {
                                    this.fetchOnPremProjects(this.teams.get(AnalyticsAuthorizationHandler.getDefaultTeamIndex((AnalyticsSettingStore)this.analyticsSettingStore, this.teams)));
                                    this.setSelectedDefaultTeam();
                                } else {
                                    this.fetchOnCloudProjects();
                                }
                                this.updateProjectsToComboBox();
                                this.setProgressMessage("", false);
                                this.enableObject(true);
                            } else if (this.selectTeamFromConfig != null && this.selectProjectFromConfig != null) {
                                this.canAccessProject = false;
                                this.teams.add(this.selectTeamFromConfig);
                                this.projects.add(this.selectProjectFromConfig);
                                this.setProgressMessage(ComposerIntegrationAnalyticsMessageConstants.VIEW_ERROR_MSG_PROJ_USER_CAN_NOT_ACCESS_PROJECT, true);
                                this.setSelectedDefaultTeam();
                            } else {
                                this.throwEmptyProjectOnTheOnPremTeam();
                            }
                        }
                        catch (Exception e) {
                            LoggerSingleton.logError((Throwable)e);
                        }
                    });
                });
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)ComposerAnalyticsStringConstants.ERROR, (String)e.getMessage());
        }
    }

    private void setSelectedDefaultTeam() {
        this.enableObject(true);
        this.cbbTeams.setItems(AnalyticsAuthorizationHandler.getTeamNames(this.teams).toArray(new String[this.teams.size()]));
        int indexSelectTeam = AnalyticsAuthorizationHandler.getDefaultTeamIndex((AnalyticsSettingStore)this.analyticsSettingStore, this.teams);
        this.cbbTeams.select(indexSelectTeam);
    }

    private void updateProjectsToComboBox() {
        if (this.isOnPremActivation) {
            this.setProjectsBasedOnTeam(this.teams.get(this.cbbTeams.getSelectionIndex()));
        } else {
            this.setProjectsBasedOnCloudOrg();
        }
    }

    private void getOrganizations() {
        try {
            this.organizationsOnPremise = AnalyticsAuthorizationHandler.getOrganizations((TestOpsService)this.getTestOpsService());
        }
        catch (Exception exception) {
            this.setProgressMessage(ComposerIntegrationAnalyticsMessageConstants.MSG_REQUEST_TOKEN_ERROR, true);
        }
    }

    private void getTeam(Long orgId) {
        try {
            this.teams = AnalyticsAuthorizationHandler.getTeams((TestOpsService)this.getTestOpsService(), (Long)orgId);
        }
        catch (Exception exception) {
            this.setProgressMessage(ComposerIntegrationAnalyticsMessageConstants.MSG_REQUEST_TOKEN_ERROR, true);
        }
    }

    private void fetchOnPremProjects(AnalyticsTeam team) {
        try {
            this.projects = AnalyticsAuthorizationHandler.getOnPremProjects((TestOpsService)this.getTestOpsService(), (AnalyticsTeam)team);
        }
        catch (Exception exception) {
            this.setProgressMessage(ComposerIntegrationAnalyticsMessageConstants.MSG_REQUEST_TOKEN_ERROR, true);
        }
    }

    private void fetchOnCloudProjects() {
        try {
            this.projects = AnalyticsAuthorizationHandler.getOnCloudProjects((TestOpsService)this.getTestOpsService(), (AnalyticsOrganization)this.organization);
        }
        catch (Exception exception) {
            this.setProgressMessage(ComposerIntegrationAnalyticsMessageConstants.MSG_REQUEST_TOKEN_ERROR, true);
        }
    }

    private void setProgressMessage(String message, boolean isError) {
        if (isError) {
            this.lblStatus.setForeground(ColorUtil.getTextErrorColor());
        } else {
            this.lblStatus.setForeground(ColorUtil.getTextRunningColor());
        }
        this.lblStatus.setText(message);
        this.lblStatus.getParent().layout();
    }

    private void setProgressMessageOnPremise(String message, boolean isError) {
        if (isError) {
            this.lblStatusOnPremise.setForeground(ColorUtil.getTextErrorColor());
        } else {
            this.lblStatusOnPremise.setForeground(ColorUtil.getTextRunningColor());
        }
        this.lblStatusOnPremise.setText(message);
        this.lblStatusOnPremise.getParent().layout();
    }

    private boolean checkUserProjectAcessibility() {
        return this.projects.stream().filter(p -> Objects.equals(p.getId(), this.selectProjectFromConfig.getId())).findAny().isPresent();
    }

    private boolean checkUserCanAccessProject() throws IOException {
        Long projectTeamId = this.selectProjectFromConfig.getTeamId();
        if (projectTeamId != null) {
            long currentTeamId = projectTeamId;
            for (AnalyticsTeam team : this.teams) {
                long teamId = team.getId();
                if (teamId != currentTeamId) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private void enableIntegration() {
        boolean isAnalyticsIntegrated = this.enableAnalyticsIntegration.getSelection();
        this.btnRefresh.setEnabled(isAnalyticsIntegrated);
        this.cbbProjects.setEnabled(isAnalyticsIntegrated);
        if (this.isOnPremActivation) {
            this.cbbTeams.setEnabled(isAnalyticsIntegrated);
        }
        if (this.canAccessProject && isAnalyticsIntegrated) {
            this.btnCreate.setEnabled(true);
        } else {
            this.btnCreate.setEnabled(false);
        }
        this.enableTestCloudIntegration.setEnabled(isAnalyticsIntegrated);
        this.autoUploadTestReports.setEnabled(isAnalyticsIntegrated);
    }

    private void enableAuthentication(boolean isEnable) {
        this.txtEmail.setEnabled(isEnable);
        this.txtPassword.setEnabled(isEnable);
        this.txtServerUrl.setEnabled(isEnable);
        this.cbbOrganization.setEnabled(isEnable);
        this.btnConnect.setEnabled(isEnable);
    }

    private boolean isIntegratedSuccessfully() {
        if (!this.isInitialized()) {
            return false;
        }
        boolean isAnalyticsIntegrated = this.enableAnalyticsIntegration.getSelection();
        if (!this.isOnPremActivation) {
            return isAnalyticsIntegrated && this.selectProjectFromConfig != null;
        }
        return isAnalyticsIntegrated && !this.teams.isEmpty();
    }

    private void uploadDataOnPremise() {
        try {
            boolean isOverrideAuthentication = this.enableOverrideAuthentication.getSelection();
            if (isOverrideAuthentication && this.isNoInfo()) {
                this.setProgressMessage(ComposerIntegrationAnalyticsMessageConstants.MSG_MUST_ENTER_CREDENTIAL, true);
            } else {
                if (this.enableOverrideAuthentication.getSelection()) {
                    this.analyticsSettingStore.setEmailOnPremise(this.txtEmail.getText());
                    this.analyticsSettingStore.setPasswordOnPremise(this.txtPassword.getText());
                    String server = this.txtServerUrl.getText().trim();
                    this.analyticsSettingStore.setServerEndPointOnPremise(server);
                    this.analyticsSettingStore.setOrganizationOnPremise(this.organizationsOnPremise.get(this.cbbOrganization.getSelectionIndex()));
                }
                this.analyticsSettingStore.setOverrideAuthentication(this.enableOverrideAuthentication.getSelection());
            }
        }
        catch (IOException | GeneralSecurityException e) {
            LoggerSingleton.logError((Throwable)e);
            MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)ComposerAnalyticsStringConstants.ERROR, (String)e.getMessage());
        }
    }

    private void updateDataStore() {
        try {
            boolean isIntegrated = this.isIntegratedSuccessfully();
            this.analyticsSettingStore.enableIntegration(isIntegrated);
            if (this.isOnPremActivation && !this.teams.isEmpty()) {
                this.analyticsSettingStore.setTeam(this.teams.get(this.cbbTeams.getSelectionIndex()));
            }
            if (!this.projects.isEmpty()) {
                AnalyticsProject project = this.projects.get(this.cbbProjects.getSelectionIndex());
                this.analyticsSettingStore.setProject(project);
                if (!this.isOnPremActivation) {
                    AnalyticsTeam team = new AnalyticsTeam();
                    team.setId(project.getTeamId());
                    this.analyticsSettingStore.setTeam(team);
                }
            }
            this.analyticsSettingStore.enableTestCloudIntegration(this.enableTestCloudIntegration.getSelection());
            this.analyticsSettingStore.enableAutoUploadReport(this.autoUploadTestReports.getSelection());
            this.analyticsSettingStore.removeProperties();
            IEventBroker eventBroker = EventBrokerSingleton.getInstance().getEventBroker();
            eventBroker.post("SETTINGS/INTERGRATION/KATALON_ANALYTICS", (Object)this.isIntegratedSuccessfully());
            eventBroker.send("START_PAGE/RELOAD", null);
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
            MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)ComposerAnalyticsStringConstants.ERROR, (String)e.getMessage());
        }
    }

    private boolean isNoInfo() {
        boolean hasAuthenticationInfo;
        if (this.organization == null) {
            return true;
        }
        boolean bl = this.enableOverrideAuthentication.getSelection() ? StringUtils.isNotBlank((CharSequence)this.txtServerUrl.getText()) && StringUtils.isNotBlank((CharSequence)this.txtPassword.getText()) : (hasAuthenticationInfo = this.getTestOpsService().getAdminToken().isNotEmpty());
        return !hasAuthenticationInfo || this.organization.getId() == null;
    }

    private boolean katalonLogin() {
        try {
            if (AuthenticationController.getInstance().requestAuthenOnline(this.getShell())) {
                this.organization = this.analyticsSettingStore.getOrganizationCloud();
                if (this.analyticsSettingStore.isOverrideAuthentication()) {
                    this.analyticsSettingStore.setOverrideAuthentication(false);
                }
                this.fillData(true);
                return true;
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
        return false;
    }

    private void addListeners() {
        if (this.isOnPremActivation) {
            this.cbbTeams.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AnalyticsPreferencesPage.this.cbbProjects.setEnabled(false);
                    AnalyticsPreferencesPage.this.cbbProjects.setItems(new String[0]);
                    Executors.newFixedThreadPool(1).submit(() -> {
                        UISynchronizeService.syncExec(() -> AnalyticsPreferencesPage.this.setProgressMessage(ComposerIntegrationAnalyticsMessageConstants.MSG_DLG_PRG_RETRIEVING_PROJECTS, false));
                        UISynchronizeService.syncExec(() -> {
                            String token;
                            AnalyticsTeam selectTeamFromUser = AnalyticsPreferencesPage.this.teams.get(AnalyticsPreferencesPage.this.cbbTeams.getSelectionIndex());
                            if (!AnalyticsPreferencesPage.this.canAccessProject) {
                                if (selectTeamFromUser.equals((Object)AnalyticsPreferencesPage.this.selectTeamFromConfig)) {
                                    AnalyticsPreferencesPage.this.setProgressMessage("", false);
                                    AnalyticsPreferencesPage.this.cbbProjects.setEnabled(true);
                                    return;
                                }
                                AnalyticsPreferencesPage.this.teams.remove(AnalyticsPreferencesPage.this.selectTeamFromConfig);
                                AnalyticsPreferencesPage.this.cbbTeams.setItems(AnalyticsAuthorizationHandler.getTeamNames(AnalyticsPreferencesPage.this.teams).toArray(new String[AnalyticsPreferencesPage.this.teams.size()]));
                                int indexSelectTeam = AnalyticsPreferencesPage.this.teams.indexOf(selectTeamFromUser);
                                AnalyticsPreferencesPage.this.cbbTeams.select(indexSelectTeam);
                                AnalyticsPreferencesPage.this.canAccessProject = true;
                            }
                            if (StringUtils.isNotBlank((CharSequence)(token = AnalyticsAuthorizationHandler.getToken((TestOpsService)AnalyticsPreferencesPage.this.getTestOpsService(), (AnalyticsSettingStore)AnalyticsPreferencesPage.this.analyticsSettingStore)))) {
                                AnalyticsPreferencesPage.this.fetchOnPremProjects(selectTeamFromUser);
                                AnalyticsPreferencesPage.this.cbbProjects.setEnabled(true);
                                AnalyticsPreferencesPage.this.setProgressMessage("", false);
                                AnalyticsPreferencesPage.this.setProjectsBasedOnTeam(selectTeamFromUser);
                            } else {
                                AnalyticsPreferencesPage.this.setProgressMessage(ComposerIntegrationAnalyticsMessageConstants.MSG_REQUEST_TOKEN_ERROR, true);
                                AnalyticsPreferencesPage.this.cbbProjects.setEnabled(true);
                            }
                        });
                    });
                }
            });
        }
        this.enableAnalyticsIntegration.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AnalyticsPreferencesPage.this.enableAnalyticsIntegration.getSelection()) {
                    boolean isNoInfo = AnalyticsPreferencesPage.this.isNoInfo();
                    if (isNoInfo && AnalyticsPreferencesPage.this.enableOverrideAuthentication.getSelection()) {
                        AnalyticsPreferencesPage.this.setProgressMessage(ComposerIntegrationAnalyticsMessageConstants.MSG_MUST_ENTER_CREDENTIAL, true);
                        AnalyticsPreferencesPage.this.enableAnalyticsIntegration.setSelection(false);
                    } else if (isNoInfo) {
                        boolean result = AnalyticsPreferencesPage.this.katalonLogin();
                        AnalyticsPreferencesPage.this.enableAnalyticsIntegration.setSelection(result);
                    } else {
                        AnalyticsPreferencesPage.this.enableIntegration();
                        if (AnalyticsPreferencesPage.this.enableAnalyticsIntegration.getSelection()) {
                            AnalyticsPreferencesPage.this.connect();
                        }
                    }
                    AnalyticsPreferencesPage.this.enableTestCloudIntegration.setSelection(AnalyticsPreferencesPage.this.analyticsSettingStore.isTestCloudIntegrationEnabled());
                    AnalyticsPreferencesPage.this.autoUploadTestReports.setSelection(AnalyticsPreferencesPage.this.analyticsSettingStore.isAutoUploadReportEnabled());
                } else {
                    AnalyticsPreferencesPage.this.enableIntegration();
                }
            }
        });
        this.enableOverrideAuthentication.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!AnalyticsPreferencesPage.this.featureService.canUse(KSEFeature.OVERRIDE_TESTOPS_AUTHENTICATION)) {
                    KSEFeatureAccessHandler.handleUnauthorizedAccess((KSEFeature)KSEFeature.OVERRIDE_TESTOPS_AUTHENTICATION);
                    AnalyticsPreferencesPage.this.enableOverrideAuthentication.setSelection(false);
                    return;
                }
                AnalyticsPreferencesPage.this.setProgressMessageOnPremise("", false);
                AnalyticsPreferencesPage.this.isUseOnPremise = AnalyticsPreferencesPage.this.enableOverrideAuthentication.getSelection();
                if (AnalyticsPreferencesPage.this.isUseOnPremise) {
                    AnalyticsPreferencesPage.this.loadInfoFromOnPremise();
                } else {
                    AnalyticsPreferencesPage.this.loadInfoFromCloud();
                }
                if (AnalyticsPreferencesPage.this.email == null) {
                    AnalyticsPreferencesPage.this.email = "";
                }
                if (AnalyticsPreferencesPage.this.password == null) {
                    AnalyticsPreferencesPage.this.password = "";
                }
                if (AnalyticsPreferencesPage.this.testOpsServerUrl == null) {
                    AnalyticsPreferencesPage.this.testOpsServerUrl = "";
                }
                if (AnalyticsPreferencesPage.this.adminServerUrl == null) {
                    AnalyticsPreferencesPage.this.adminServerUrl = "";
                }
                AnalyticsPreferencesPage.this.txtEmail.setText(AnalyticsPreferencesPage.this.email);
                AnalyticsPreferencesPage.this.txtPassword.setText(AnalyticsPreferencesPage.this.password);
                if (AnalyticsPreferencesPage.this.organization != null && !StringUtils.isEmpty((CharSequence)AnalyticsPreferencesPage.this.organization.getName())) {
                    AnalyticsPreferencesPage.this.organizationsOnPremise.clear();
                    AnalyticsPreferencesPage.this.organizationsOnPremise.add(AnalyticsPreferencesPage.this.organization);
                    if (!StringUtils.isEmpty((CharSequence)AnalyticsPreferencesPage.this.organization.getName())) {
                        AnalyticsPreferencesPage.this.cbbOrganization.setItems(AnalyticsAuthorizationHandler.getOrganizationNames(AnalyticsPreferencesPage.this.organizationsOnPremise).toArray(new String[AnalyticsPreferencesPage.this.organizationsOnPremise.size()]));
                        AnalyticsPreferencesPage.this.cbbOrganization.select(0);
                    } else {
                        AnalyticsPreferencesPage.this.cbbOrganization.setItems(new String[0]);
                    }
                }
                if (StringUtils.isEmpty((CharSequence)AnalyticsPreferencesPage.this.email) || StringUtils.isEmpty((CharSequence)AnalyticsPreferencesPage.this.password) || StringUtils.isEmpty((CharSequence)AnalyticsPreferencesPage.this.testOpsServerUrl) || StringUtils.isEmpty((CharSequence)AnalyticsPreferencesPage.this.adminServerUrl)) {
                    AnalyticsPreferencesPage.this.enableAnalyticsIntegration.setSelection(false);
                    AnalyticsPreferencesPage.this.enableIntegration();
                }
                AnalyticsPreferencesPage.this.enableAuthentication(AnalyticsPreferencesPage.this.enableOverrideAuthentication.getSelection());
            }
        });
        this.btnRefresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AnalyticsPreferencesPage.this.isUseOnPremise) {
                    if (AnalyticsPreferencesPage.this.cbbOrganization.getSelectionIndex() == -1) {
                        AnalyticsPreferencesPage.this.setProgressMessage(ComposerIntegrationAnalyticsMessageConstants.MSG_NO_ORGANIZATION, true);
                        return;
                    }
                    AnalyticsPreferencesPage.this.organization = AnalyticsPreferencesPage.this.organizationsOnPremise.get(AnalyticsPreferencesPage.this.cbbOrganization.getSelectionIndex());
                }
                AnalyticsPreferencesPage.this.selectTeamFromConfig = null;
                AnalyticsPreferencesPage.this.connect();
            }
        });
        this.btnConnect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!AnalyticsPreferencesPage.this.featureService.canUse(KSEFeature.OVERRIDE_TESTOPS_AUTHENTICATION)) {
                    KSEFeatureAccessHandler.handleUnauthorizedAccess((KSEFeature)KSEFeature.OVERRIDE_TESTOPS_AUTHENTICATION);
                    return;
                }
                AnalyticsPreferencesPage.this.email = AnalyticsPreferencesPage.this.txtEmail.getText();
                AnalyticsPreferencesPage.this.password = AnalyticsPreferencesPage.this.txtPassword.getText();
                AnalyticsPreferencesPage.this.adminServerUrl = AnalyticsPreferencesPage.this.testOpsServerUrl = AnalyticsPreferencesPage.this.txtServerUrl.getText().trim();
                if (StringUtils.isEmpty((CharSequence)AnalyticsPreferencesPage.this.email) || StringUtils.isEmpty((CharSequence)AnalyticsPreferencesPage.this.password) || StringUtils.isEmpty((CharSequence)AnalyticsPreferencesPage.this.testOpsServerUrl)) {
                    AnalyticsPreferencesPage.this.setProgressMessageOnPremise(ComposerIntegrationAnalyticsMessageConstants.MSG_MUST_ENTER_CREDENTIAL, true);
                } else {
                    AnalyticsPreferencesPage.this.updateTestOpsService();
                    AnalyticsPreferencesPage.this.connectOnPremise();
                }
            }
        });
        this.cbbOrganization.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AnalyticsPreferencesPage.this.isUseOnPremise) {
                    AnalyticsPreferencesPage.this.organization = AnalyticsPreferencesPage.this.organizationsOnPremise.get(AnalyticsPreferencesPage.this.cbbOrganization.getSelectionIndex());
                }
            }
        });
        this.btnCreate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AnalyticsPreferencesPage.this.isOnPremActivation) {
                    AnalyticsProject createdProject;
                    NewProjectDialog dialog;
                    AnalyticsTeam team = null;
                    if (AnalyticsPreferencesPage.this.teams != null && AnalyticsPreferencesPage.this.teams.size() > 0) {
                        team = AnalyticsPreferencesPage.this.teams.get(AnalyticsPreferencesPage.this.cbbTeams.getSelectionIndex());
                    }
                    if ((dialog = new NewProjectDialog(AnalyticsPreferencesPage.this.btnCreate.getDisplay().getActiveShell(), team, AnalyticsPreferencesPage.this.getTestOpsService())).open() == 0 && (createdProject = dialog.getAnalyticsProject()) != null) {
                        AnalyticsPreferencesPage.this.cbbProjects.setEnabled(false);
                        AnalyticsPreferencesPage.this.cbbProjects.setItems(new String[0]);
                        Executors.newFixedThreadPool(1).submit(() -> {
                            UISynchronizeService.syncExec(() -> AnalyticsPreferencesPage.this.setProgressMessage(ComposerIntegrationAnalyticsMessageConstants.MSG_DLG_PRG_RETRIEVING_PROJECTS, false));
                            UISynchronizeService.syncExec(() -> {
                                String token = AnalyticsAuthorizationHandler.getToken((TestOpsService)AnalyticsPreferencesPage.this.getTestOpsService(), (AnalyticsSettingStore)AnalyticsPreferencesPage.this.analyticsSettingStore);
                                if (StringUtils.isNotBlank((CharSequence)token)) {
                                    if (AnalyticsPreferencesPage.this.isOnPremActivation) {
                                        AnalyticsPreferencesPage.this.fetchOnPremProjects(AnalyticsPreferencesPage.this.teams.get(AnalyticsPreferencesPage.this.cbbTeams.getSelectionIndex()));
                                    } else {
                                        AnalyticsPreferencesPage.this.fetchOnCloudProjects();
                                    }
                                    if (AnalyticsPreferencesPage.this.projects == null) {
                                        AnalyticsPreferencesPage.this.cbbProjects.setEnabled(true);
                                        AnalyticsPreferencesPage.this.setProgressMessage(ComposerIntegrationAnalyticsMessageConstants.MSG_REQUEST_TOKEN_ERROR, true);
                                        return;
                                    }
                                    AnalyticsPreferencesPage.this.cbbProjects.setItems(AnalyticsAuthorizationHandler.getProjectNames(AnalyticsPreferencesPage.this.projects).toArray(new String[AnalyticsPreferencesPage.this.projects.size()]));
                                    AnalyticsPreferencesPage.this.cbbProjects.select(AnalyticsAuthorizationHandler.getProjectIndex((AnalyticsProject)createdProject, AnalyticsPreferencesPage.this.projects));
                                    AnalyticsPreferencesPage.this.cbbProjects.setEnabled(true);
                                    AnalyticsPreferencesPage.this.setProgressMessage("", false);
                                } else {
                                    AnalyticsPreferencesPage.this.setProgressMessage(ComposerIntegrationAnalyticsMessageConstants.MSG_REQUEST_TOKEN_ERROR, true);
                                    AnalyticsPreferencesPage.this.cbbProjects.setEnabled(true);
                                }
                            });
                        });
                    }
                } else {
                    String url = MessageFormat.format(ComposerIntegrationAnalyticsMessageConstants.LINK_TO_PROJECTS_PAGE_BY_ORG_ID, AnalyticsPreferencesPage.this.organization.getId().toString());
                    Program.launch((String)url);
                }
            }
        });
        this.lblStatus.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Program.launch((String)e.text);
            }
        });
    }

    private void connectOnPremise() {
        Executors.newFixedThreadPool(1).submit(() -> {
            UISynchronizeService.syncExec(() -> this.setProgressMessageOnPremise(ComposerIntegrationAnalyticsMessageConstants.MSG_DLG_PRG_CONNECTING_TO_SERVER, false));
            String token = AnalyticsAuthorizationHandler.getToken((TestOpsService)this.getTestOpsService(), (AnalyticsSettingStore)this.analyticsSettingStore);
            if (StringUtils.isBlank((CharSequence)token)) {
                UISynchronizeService.syncExec(() -> {
                    this.setProgressMessageOnPremise(ComposerIntegrationAnalyticsMessageConstants.MSG_REQUEST_TOKEN_ERROR, true);
                    this.organizationsOnPremise.clear();
                    this.cbbOrganization.setItems(new String[0]);
                });
                return;
            }
            this.getOrganizations();
            if (!this.organizationsOnPremise.isEmpty()) {
                UISynchronizeService.syncExec(() -> {
                    this.cbbOrganization.setItems(AnalyticsAuthorizationHandler.getOrganizationNames(this.organizationsOnPremise).toArray(new String[this.organizationsOnPremise.size()]));
                    this.cbbOrganization.select(0);
                    this.organization = this.organizationsOnPremise.get(0);
                    if (this.enableAnalyticsIntegration.getSelection()) {
                        this.btnRefresh.setEnabled(true);
                    }
                    this.setProgressMessageOnPremise(ComposerIntegrationAnalyticsMessageConstants.MSG_CONNECT_SUCCESS, false);
                });
            } else {
                UISynchronizeService.syncExec(() -> {
                    this.organizationsOnPremise.clear();
                    this.cbbOrganization.setItems(new String[0]);
                    this.setProgressMessageOnPremise(ComposerIntegrationAnalyticsMessageConstants.MSG_NO_ORGANIZATION, true);
                });
            }
        });
    }

    private void connect() {
        this.enableObject(false);
        if (this.isOnPremActivation) {
            this.cbbTeams.removeAll();
        }
        this.cbbProjects.removeAll();
        this.projects.clear();
        this.teams.clear();
        Executors.newFixedThreadPool(1).submit(() -> {
            UISynchronizeService.syncExec(() -> this.setProgressMessage(ComposerIntegrationAnalyticsMessageConstants.MSG_DLG_PRG_CONNECTING_TO_SERVER, false));
            String token = AnalyticsAuthorizationHandler.getToken((TestOpsService)this.getTestOpsService(), (AnalyticsSettingStore)this.analyticsSettingStore);
            if (StringUtils.isBlank((CharSequence)token)) {
                UISynchronizeService.syncExec(() -> {
                    this.setProgressMessage(ComposerIntegrationAnalyticsMessageConstants.MSG_REQUEST_TOKEN_ERROR, true);
                    this.enableObject(true);
                });
                return;
            }
            this.canAccessProject = true;
            this.getTeam(this.organization.getId());
            this.clearErorMsg();
            if (this.isOnPremActivation) {
                if (!this.teams.isEmpty()) {
                    UISynchronizeService.syncExec(() -> {
                        if (this.selectTeamFromConfig == null) {
                            this.selectTeamFromConfig = this.teams.get(AnalyticsAuthorizationHandler.getDefaultTeamIndex((AnalyticsSettingStore)this.analyticsSettingStore, this.teams));
                        }
                        this.fetchOnPremProjects(this.selectTeamFromConfig);
                        this.setProjectsBasedOnTeam(this.selectTeamFromConfig);
                    });
                } else {
                    this.throwEmptyProjectOnTheOnPremTeam();
                }
            } else {
                UISynchronizeService.syncExec(() -> {
                    this.fetchOnCloudProjects();
                    this.enableObject(true);
                    this.setProjectsBasedOnCloudOrg();
                    if (this.projects.isEmpty()) {
                        this.throwEmptyProjectOnTheOnCloudOrg();
                    }
                });
            }
        });
    }

    private void clearErorMsg() {
        UISynchronizeService.syncExec(() -> {
            if (this.isOnPremActivation) {
                this.setSelectedDefaultTeam();
            }
            this.setProgressMessage("", false);
        });
    }

    private void throwEmptyProjectOnTheOnPremTeam() {
        UISynchronizeService.syncExec(() -> {
            this.btnRefresh.setEnabled(true);
            String message = MessageFormat.format(ComposerIntegrationAnalyticsMessageConstants.LNK_REPORT_WARNING_MSG_NO_TEAM, this.analyticsSettingStore.getServerEndpoint(), Long.toString(this.organization.getId()));
            this.setProgressMessage(message, true);
        });
    }

    private void throwEmptyProjectOnTheOnCloudOrg() {
        this.btnRefresh.setEnabled(true);
        String message = MessageFormat.format(ComposerIntegrationAnalyticsMessageConstants.LNK_REPORT_WARNING_MSG_NO_PROJECTS_ON_CLOUD_ORG, Long.toString(this.organization.getId()));
        this.setProgressMessage(message, true);
    }

    private void enableObject(boolean isEnable) {
        if (this.isOnPremActivation) {
            this.cbbTeams.setEnabled(isEnable);
        }
        this.cbbProjects.setEnabled(isEnable);
        this.btnRefresh.setEnabled(isEnable);
        this.enableTestCloudIntegration.setEnabled(isEnable);
        this.autoUploadTestReports.setEnabled(isEnable);
    }

    private void updateProjectsCbbData(String role) {
        if (this.projects != null && !this.projects.isEmpty()) {
            this.cbbProjects.setItems(AnalyticsAuthorizationHandler.getProjectNames(this.projects).toArray(new String[this.projects.size()]));
            this.cbbProjects.select(AnalyticsAuthorizationHandler.getDefaultProjectIndex((AnalyticsSettingStore)this.analyticsSettingStore, this.projects));
        } else {
            this.setProgressMessage(ComposerIntegrationAnalyticsMessageConstants.LNK_REPORT_WARNING_MSG_NO_PROJECT, true);
            this.cbbProjects.clearSelection();
            this.cbbProjects.removeAll();
        }
        if (role.equals("USER") || !this.canAccessProject) {
            this.btnCreate.setEnabled(false);
        } else {
            this.btnCreate.setEnabled(true);
        }
    }

    private void setProjectsBasedOnTeam(AnalyticsTeam team) {
        this.updateProjectsCbbData(team.getRole());
    }

    private void setProjectsBasedOnCloudOrg() {
        this.updateProjectsCbbData(this.organization.getRole());
    }

    private void loadInfoFromCloud() {
        this.email = ActivationInfoCollector.isLicenseOffline() ? "" : ApplicationContext.getInstance().getUserId();
        this.testOpsServerUrl = this.analyticsSettingStore.getServerEndpointCloud();
        this.adminServerUrl = this.analyticsSettingStore.getAuthenticationEndpointCloud();
        this.organization = this.analyticsSettingStore.getOrganizationCloud();
        this.updateTestOpsService();
    }

    private void loadInfoFromOnPremise() {
        this.email = this.analyticsSettingStore.getEmailOnPremise();
        this.password = this.analyticsSettingStore.getPasswordOnPremise();
        this.testOpsServerUrl = this.analyticsSettingStore.getServerEndpointOnPremise();
        this.adminServerUrl = this.analyticsSettingStore.getServerEndpointOnPremise();
        this.organization = this.analyticsSettingStore.getOrganizationOnPremise();
        this.updateTestOpsService();
    }

    private void updateTestOpsService() {
        AnalyticsOrganization org = this.analyticsSettingStore.getOrganizationCloud();
        if (Objects.nonNull(org) && org.isSamlSSO()) {
            return;
        }
        ((TestOpsService)((TestOpsService)this.getTempTestOpsService().setAdminServer(this.adminServerUrl)).setTestOpsServer(this.testOpsServerUrl)).setCredential(this.email, this.password);
    }

    private void hideOverrideAuthenticationIfNotEnterprise() {
        if (!this.featureService.canUse(KSEFeature.OVERRIDE_TESTOPS_AUTHENTICATION)) {
            this.isUseOnPremise = false;
        }
    }

    protected boolean isInitialized() {
        return this.enableAnalyticsIntegration != null;
    }

    public boolean hasDocumentation() {
        return true;
    }

    public String getDocumentationUrl() {
        return DocumentationMessageConstants.SETTINGS_KATALON_ANALYTICS;
    }

    private TestOpsService getTempTestOpsService() {
        if (this.tempTestOpsService == null) {
            this.tempTestOpsService = (TestOpsService)TestOpsService.getActiveInstance().clone();
            this.tempTestOpsService.clearAllTokens();
            this.tempTestOpsService.setAdminServer(this.adminServerUrl);
            this.tempTestOpsService.setTestOpsServer(this.testOpsServerUrl);
            this.tempTestOpsService.setCredential(this.email, this.password);
        }
        return this.tempTestOpsService;
    }

    private TestOpsService getTestOpsService() {
        return this.isUseOnPremise ? this.getTempTestOpsService() : TestOpsService.getInstance();
    }

    static /* synthetic */ void access$0(AnalyticsPreferencesPage analyticsPreferencesPage, String string, boolean bl) {
        analyticsPreferencesPage.setProgressMessage(string, bl);
    }

    static /* synthetic */ List access$1(AnalyticsPreferencesPage analyticsPreferencesPage) {
        return analyticsPreferencesPage.teams;
    }

    static /* synthetic */ Combo access$2(AnalyticsPreferencesPage analyticsPreferencesPage) {
        return analyticsPreferencesPage.cbbTeams;
    }

    static /* synthetic */ boolean access$3(AnalyticsPreferencesPage analyticsPreferencesPage) {
        return analyticsPreferencesPage.canAccessProject;
    }

    static /* synthetic */ AnalyticsTeam access$4(AnalyticsPreferencesPage analyticsPreferencesPage) {
        return analyticsPreferencesPage.selectTeamFromConfig;
    }

    static /* synthetic */ Combo access$5(AnalyticsPreferencesPage analyticsPreferencesPage) {
        return analyticsPreferencesPage.cbbProjects;
    }

    static /* synthetic */ void access$6(AnalyticsPreferencesPage analyticsPreferencesPage, boolean bl) {
        analyticsPreferencesPage.canAccessProject = bl;
    }

    static /* synthetic */ TestOpsService access$7(AnalyticsPreferencesPage analyticsPreferencesPage) {
        return analyticsPreferencesPage.getTestOpsService();
    }

    static /* synthetic */ AnalyticsSettingStore access$8(AnalyticsPreferencesPage analyticsPreferencesPage) {
        return analyticsPreferencesPage.analyticsSettingStore;
    }

    static /* synthetic */ void access$9(AnalyticsPreferencesPage analyticsPreferencesPage, AnalyticsTeam analyticsTeam) {
        analyticsPreferencesPage.fetchOnPremProjects(analyticsTeam);
    }

    static /* synthetic */ void access$10(AnalyticsPreferencesPage analyticsPreferencesPage, AnalyticsTeam analyticsTeam) {
        analyticsPreferencesPage.setProjectsBasedOnTeam(analyticsTeam);
    }

    static /* synthetic */ boolean access$11(AnalyticsPreferencesPage analyticsPreferencesPage) {
        return analyticsPreferencesPage.isOnPremActivation;
    }

    static /* synthetic */ void access$12(AnalyticsPreferencesPage analyticsPreferencesPage) {
        analyticsPreferencesPage.fetchOnCloudProjects();
    }

    static /* synthetic */ List access$13(AnalyticsPreferencesPage analyticsPreferencesPage) {
        return analyticsPreferencesPage.projects;
    }
}

