/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.analytics.utils;

import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.integration.analytics.constants.ComposerIntegrationAnalyticsMessageConstants;
import com.kms.katalon.composer.integration.analytics.exception.DownloadFailedException;
import com.kms.katalon.composer.integration.analytics.exception.ExtractFileFailedException;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.util.internal.ZipUtil;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.integration.analytics.entity.AnalyticsExecution;
import com.kms.katalon.integration.analytics.providers.ApiRequestDownloader;
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.PlatformUI;

public class ReportImporter {
    private static final String EXECUTION_REPORT_DOWNLOAD_TEMPLATE = "api/v1/executions/%d/download-file";
    public static final String JOB_FAMILY_DOWNLOAD_REPORT = "katalon.composer.analytics.testops.report.download";
    private static final String REPORT_FOLDER_NAME = "Reports";
    private static final String DOWNLOADED_REPORT_FOLDER_NAME = "Downloaded From Katalon TestOps";
    private static final Map<Long, Job> activeJobs = new HashMap<Long, Job>();
    private AnalyticsExecution execution;
    private ProjectEntity toProject;
    private IProgressMonitor monitor;
    private ApiRequestDownloader downloader;
    private File reportZipFile;
    private File downloadedReportFolder;

    public AnalyticsExecution getExecution() {
        return this.execution;
    }

    public void setExecution(AnalyticsExecution execution) {
        this.execution = execution;
    }

    public ProjectEntity getToProject() {
        return this.toProject;
    }

    public void setToProject(ProjectEntity toProject) {
        this.toProject = toProject;
    }

    public IProgressMonitor getMonitor() {
        return this.monitor;
    }

    public void setMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public File getReportZipFile() {
        return this.reportZipFile;
    }

    public void setReportZipFile(File reportZipFile) {
        this.reportZipFile = reportZipFile;
    }

    public File getDownloadedReportFolder() {
        return this.downloadedReportFolder;
    }

    public void setDownloadedReportFolder(File downloadedReportFolder) {
        this.downloadedReportFolder = downloadedReportFolder;
    }

    public ReportImporter(AnalyticsExecution execution, ProjectEntity toProject, IProgressMonitor monitor, File reportZipFile, File downloadedReportFolder) {
        this.execution = execution;
        this.toProject = toProject;
        this.monitor = monitor;
        this.reportZipFile = reportZipFile;
        this.downloadedReportFolder = downloadedReportFolder;
    }

    private ReportImporter(AnalyticsExecution execution, ProjectEntity toProject, IProgressMonitor monitor) {
        this.execution = execution;
        this.toProject = toProject;
        this.monitor = monitor;
        this.downloadedReportFolder = Paths.get(toProject.getFolderLocation(), REPORT_FOLDER_NAME, DOWNLOADED_REPORT_FOLDER_NAME).toFile();
    }

    public void start() throws DownloadFailedException, ExtractFileFailedException, FileNotFoundException {
        this.monitor.beginTask(ComposerIntegrationAnalyticsMessageConstants.TASK_IMPORT_REPORT, 100);
        this.reportZipFile = this.downloadReport();
        if (!(this.monitor.isCanceled() || this.reportZipFile != null && this.reportZipFile.exists())) {
            throw new FileNotFoundException(ComposerIntegrationAnalyticsMessageConstants.MSG_FILE_NOT_FOUND);
        }
        this.reportZipFile.deleteOnExit();
        if (!this.monitor.isCanceled() && ProjectController.getInstance().getCurrentProject().getId().equals(this.toProject.getId())) {
            this.monitor.subTask(ComposerIntegrationAnalyticsMessageConstants.TASK_EXTRACTING_FILES);
            if (this.extractReportFiles()) {
                this.monitor.worked(50);
                this.notifyReportChanges();
            }
        }
    }

    public File downloadReport() throws DownloadFailedException {
        AtomicInteger worked = new AtomicInteger(0);
        AtomicBoolean isUndefinedLength = new AtomicBoolean(false);
        this.downloader = new ApiRequestDownloader(this.buildResourcePath(), this.monitor);
        this.downloader.subcribeBeforeDownloadStarted(contentLength -> isUndefinedLength.set(true));
        this.downloader.subcribeDownloadProgressChanged((total, downloaded) -> {
            String sDownloaded = FileUtils.byteCountToDisplaySize((long)downloaded);
            String sTotal = total == -1L ? "" : "/" + FileUtils.byteCountToDisplaySize((long)total);
            this.getMonitor().subTask(String.valueOf(ComposerIntegrationAnalyticsMessageConstants.TASK_DOWNLOAD_FILES) + ": " + sDownloaded + sTotal);
            if (total != -1L) {
                int currrentPercent = (int)((double)downloaded * 1.0 / (double)(total * 2L));
                this.monitor.worked(currrentPercent - worked.get());
                worked.set(currrentPercent);
            }
        });
        try {
            return this.downloader.download();
        }
        catch (Exception e) {
            throw new DownloadFailedException(ComposerIntegrationAnalyticsMessageConstants.MSG_EXCEPTION_DOWNLOAD_FAILED, e);
        }
    }

    public boolean extractReportFiles() throws ExtractFileFailedException {
        File processedReport;
        block5: {
            try {
                File tmpDir = Files.createTempDirectory("katalon_download_", new FileAttribute[0]).toFile();
                ZipUtil.extract((File)this.reportZipFile, (File)tmpDir);
                if (tmpDir.listFiles().length != 1) {
                    throw new Exception(ComposerIntegrationAnalyticsMessageConstants.MSG_FILE_CORRUPTED);
                }
                File reportFolder = tmpDir.listFiles()[0];
                processedReport = new File(String.valueOf(reportFolder.getAbsolutePath()) + "_" + this.execution.getId());
                FileUtils.forceDeleteOnExit((File)tmpDir);
                if (!reportFolder.renameTo(processedReport)) {
                    throw new Exception(ComposerIntegrationAnalyticsMessageConstants.MSG_CANNOT_PROCESS_FILE);
                }
                if (!Files.exists(Paths.get(this.downloadedReportFolder.getAbsolutePath(), processedReport.getName()), new LinkOption[0])) break block5;
                UISynchronizeService.syncExec(() -> {
                    MessageBox confirmBox = new MessageBox(Display.getCurrent().getActiveShell(), 40);
                    confirmBox.setText(ComposerIntegrationAnalyticsMessageConstants.MSG_REPORT_DUPPLICATE_TITLE);
                    confirmBox.setMessage(ComposerIntegrationAnalyticsMessageConstants.MSG_REPORT_DUPPLICATE_MESSAGE);
                    confirmBox.open();
                });
                return false;
            }
            catch (Exception e) {
                throw new ExtractFileFailedException(ComposerIntegrationAnalyticsMessageConstants.MSG_EXEPTION_EXTRACT_FAILED, e);
            }
        }
        FileUtils.moveDirectoryToDirectory((File)processedReport, (File)this.downloadedReportFolder, (boolean)true);
        return true;
    }

    private String buildResourcePath() {
        return String.format(EXECUTION_REPORT_DOWNLOAD_TEMPLATE, this.execution.getId());
    }

    public void notifyReportChanges() {
        EventBrokerSingleton.getInstance().getEventBroker().post("EXPLORER/REFRESH", null);
    }

    public static Job beginImport(final AnalyticsExecution execution, final ProjectEntity toProject) {
        Objects.requireNonNull(execution);
        Objects.requireNonNull(toProject);
        if (activeJobs.containsKey(execution.getId())) {
            try {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.ui.views.ProgressView");
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
            }
            return activeJobs.get(execution.getId());
        }
        Job downloadJob = new Job(MessageFormat.format(ComposerIntegrationAnalyticsMessageConstants.JOB_IMPORT_REPORT, String.valueOf(execution.getOrder()))){

            public boolean belongsTo(Object family) {
                return ReportImporter.JOB_FAMILY_DOWNLOAD_REPORT.equals(family);
            }

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    ReportImporter importer = new ReportImporter(execution, toProject, monitor);
                    importer.start();
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                catch (Exception e) {
                    LoggerSingleton.logError((Throwable)e);
                    UISynchronizeService.syncExec(() -> MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)ComposerIntegrationAnalyticsMessageConstants.MSG_EXCEPTION_IMPORT_FAILED, (String)e.getMessage()));
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                finally {
                    monitor.done();
                    ReportImporter.removeJob(execution);
                }
            }
        };
        downloadJob.setUser(true);
        downloadJob.schedule();
        activeJobs.put(execution.getId(), downloadJob);
        return downloadJob;
    }

    public static Job removeJob(AnalyticsExecution execution) {
        return activeJobs.remove(execution.getId());
    }

    public static void cancelAllJob() {
        activeJobs.values().forEach(job -> {
            boolean bl = job.cancel();
        });
        activeJobs.clear();
    }
}

