/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.providers;

import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.impl.dialogs.ProgressMonitorDialogWithThread;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.integration.analytics.constants.ComposerIntegrationAnalyticsMessageConstants;
import com.kms.katalon.composer.integration.analytics.dialog.KatalonTestOpsIntegrationDialog;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.feature.TestOpsConfiguration;
import com.kms.katalon.integration.analytics.entity.AnalyticsProject;
import com.kms.katalon.integration.analytics.entity.AnalyticsTeam;
import com.kms.katalon.integration.analytics.entity.GitRepositoryEntity;
import com.kms.katalon.integration.analytics.exceptions.AnalyticsApiException;
import com.kms.katalon.integration.analytics.providers.TestOpsService;
import com.kms.katalon.integration.analytics.setting.AnalyticsSettingStore;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;

public class TestOpsConfigurationImpl
implements TestOpsConfiguration {
    public static final String CONFIG_INTEGRATION_OPTION_FOR_NEW_USER_ONLY = "isForNewUserOnly";
    public static final String CONFIG_INTEGRATION_OPTION_FOR_FIRST_QUICK_START = "isForFirstQuickStart";

    public void testOpsQuickIntergration(Map<String, Object> options) {
        this.enableTestOpsIntegration(options);
    }

    public void testOpsPlatformIntergration(Map<String, Object> options) {
        this.enablePlatformProjectIntegration(options);
    }

    public void autoTestOpsIntegration(Map<String, Object> options) {
        this.autoTestopsIntegration(options);
    }

    public void quickIntegrateWithPlatform() {
        UISynchronizeService.syncExec(() -> {
            KatalonTestOpsIntegrationDialog katalogTestOpsIntegrationDialog = new KatalonTestOpsIntegrationDialog(Display.getCurrent().getActiveShell());
            katalogTestOpsIntegrationDialog.open();
        });
    }

    private void enableTestOpsIntegration(Map<String, Object> options) {
        ProgressMonitorDialogWithThread dialog = new ProgressMonitorDialogWithThread(Display.getCurrent().getActiveShell());
        IRunnableWithProgress enableWorker = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                AnalyticsSettingStore analyticsSettingStore = new AnalyticsSettingStore(ProjectController.getInstance().getCurrentProject().getFolderLocation());
                if (analyticsSettingStore.getOrganization() == null) {
                    throw new InvocationTargetException(new Exception(), ComposerIntegrationAnalyticsMessageConstants.ERROR_TESTOPS_INTEGRATION_INVALID_CREDENTIAL);
                }
                try {
                    try {
                        monitor.beginTask(ComposerIntegrationAnalyticsMessageConstants.TASK_MSG_ENABLE_INTEGRATION, 3);
                        monitor.subTask(ComposerIntegrationAnalyticsMessageConstants.TASK_MSG_CHECK_CONNECTION);
                        if (!TestOpsService.getActiveInstance().testTestOpsConnection()) {
                            throw new InvocationTargetException(new Exception(), ComposerIntegrationAnalyticsMessageConstants.ERROR_TESTOPS_INTEGRATION_CONNECTION);
                        }
                        monitor.worked(1);
                        monitor.subTask(ComposerIntegrationAnalyticsMessageConstants.TASK_MSG_GETTING_TESTOPS_INFO);
                        AnalyticsProject project = TestOpsConfigurationImpl.this.getDefaultProject();
                        monitor.subTask(ComposerIntegrationAnalyticsMessageConstants.TASK_MSG_SETTING_INTEGRATION);
                        boolean[] useUserConfig = new boolean[1];
                        UISynchronizeService.syncExec(() -> {
                            KatalonTestOpsIntegrationDialog quickStartDialog = new KatalonTestOpsIntegrationDialog(Display.getCurrent().getActiveShell());
                            if (quickStartDialog.open() == 0) {
                                blArray[0] = true;
                            }
                            EventBrokerSingleton.getInstance().getEventBroker().post("EXPLORER/RELOAD_DATA", (Object)true);
                        });
                        if (useUserConfig[0]) {
                            monitor.worked(2);
                        } else {
                            monitor.worked(1);
                            monitor.subTask(ComposerIntegrationAnalyticsMessageConstants.TASK_MSG_GETTING_TEAMS);
                            List teams = TestOpsService.getActiveInstance().getTeams(analyticsSettingStore.getOrganization().getId());
                            Optional<AnalyticsTeam> defaultTeam = teams.stream().filter(team -> team.getId().equals(project.getTeamId())).findFirst();
                            if (!defaultTeam.isPresent()) {
                                throw new InvocationTargetException(new Exception(), ComposerIntegrationAnalyticsMessageConstants.ERROR_TESTOPS_INTEGRATION_INVALID_DATA);
                            }
                            monitor.worked(1);
                            analyticsSettingStore.enableIntegration(true);
                            analyticsSettingStore.setTeam(defaultTeam.get());
                            analyticsSettingStore.setProject(project);
                            analyticsSettingStore.setAutoSubmit(true);
                            EventBrokerSingleton.getInstance().getEventBroker().post("EXPLORER/RELOAD_DATA", (Object)true);
                        }
                    }
                    catch (AnalyticsApiException e) {
                        throw new InvocationTargetException(e, ComposerIntegrationAnalyticsMessageConstants.ERROR_TESTOPS_INTEGRATION_CONNECTION);
                    }
                    catch (IOException | GeneralSecurityException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            dialog.run(false, false, enableWorker);
        }
        catch (InvocationTargetException e) {
            LoggerSingleton.logError((String)ComposerIntegrationAnalyticsMessageConstants.ERROR_TESTOPS_INTEGRATION);
            LoggerSingleton.logError((Throwable)e);
        }
        catch (InterruptedException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private void autoTestopsIntegration(Map<String, Object> options) {
        Runnable worker = new Runnable(){

            @Override
            public void run() {
                try {
                    AnalyticsSettingStore analyticsSettingStore = new AnalyticsSettingStore(ProjectController.getInstance().getCurrentProject().getFolderLocation());
                    if (analyticsSettingStore.getOrganization() == null) {
                        LoggerSingleton.logError((String)ComposerIntegrationAnalyticsMessageConstants.ERROR_TESTOPS_INTEGRATION);
                        LoggerSingleton.logError((String)ComposerIntegrationAnalyticsMessageConstants.ERROR_TESTOPS_INTEGRATION_INVALID_CREDENTIAL);
                        TestOpsConfigurationImpl.this.showTestopsIntegrationDialog();
                        return;
                    }
                    TestOpsService testOpsService = TestOpsService.getActiveInstance();
                    if (!testOpsService.testTestOpsConnection()) {
                        LoggerSingleton.logError((String)ComposerIntegrationAnalyticsMessageConstants.ERROR_TESTOPS_INTEGRATION);
                        LoggerSingleton.logError((String)ComposerIntegrationAnalyticsMessageConstants.ERROR_TESTOPS_INTEGRATION_CONNECTION);
                    } else {
                        List teams = testOpsService.getTeams(analyticsSettingStore.getOrganization().getId());
                        AnalyticsProject project = TestOpsConfigurationImpl.this.getDefaultProject();
                        if (teams == null || project == null || teams.isEmpty()) {
                            TestOpsConfigurationImpl.this.showTestopsIntegrationDialog();
                        } else {
                            Optional<AnalyticsTeam> defaultTeam = teams.stream().filter(team -> team.getId().equals(project.getTeamId())).findFirst();
                            if (!defaultTeam.isPresent()) {
                                LoggerSingleton.logError((String)ComposerIntegrationAnalyticsMessageConstants.ERROR_TESTOPS_INTEGRATION);
                                LoggerSingleton.logError((String)ComposerIntegrationAnalyticsMessageConstants.ERROR_TESTOPS_INTEGRATION_INVALID_DATA);
                                TestOpsConfigurationImpl.this.showTestopsIntegrationDialog();
                            } else {
                                analyticsSettingStore.enableIntegration(true);
                                analyticsSettingStore.setTeam(defaultTeam.get());
                                analyticsSettingStore.setProject(project);
                                analyticsSettingStore.setAutoSubmit(true);
                                EventBrokerSingleton.getInstance().getEventBroker().post("EXPLORER/RELOAD_DATA", (Object)true);
                            }
                        }
                    }
                }
                catch (AnalyticsApiException analyticsApiException) {
                    LoggerSingleton.logError((String)ComposerIntegrationAnalyticsMessageConstants.ERROR_TESTOPS_INTEGRATION);
                    LoggerSingleton.logError((String)ComposerIntegrationAnalyticsMessageConstants.ERROR_TESTOPS_INTEGRATION_CONNECTION);
                }
                catch (Exception e) {
                    LoggerSingleton.logError((String)ComposerIntegrationAnalyticsMessageConstants.ERROR_TESTOPS_INTEGRATION);
                    LoggerSingleton.logError((Throwable)e);
                }
            }
        };
        Executors.newFixedThreadPool(1).submit(worker);
    }

    public void enablePlatformProjectIntegration(final Map<String, Object> options) {
        ProgressMonitorDialogWithThread dialog = new ProgressMonitorDialogWithThread(Display.getCurrent().getActiveShell());
        IRunnableWithProgress enableWorker = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                AnalyticsSettingStore analyticsSettingStore = new AnalyticsSettingStore(ProjectController.getInstance().getCurrentProject().getFolderLocation());
                if (analyticsSettingStore.getOrganization() == null) {
                    throw new InvocationTargetException(new Exception(), ComposerIntegrationAnalyticsMessageConstants.ERROR_TESTOPS_INTEGRATION_INVALID_CREDENTIAL);
                }
                try {
                    try {
                        monitor.beginTask(ComposerIntegrationAnalyticsMessageConstants.TASK_MSG_ENABLE_INTEGRATION, 3);
                        monitor.subTask(ComposerIntegrationAnalyticsMessageConstants.TASK_MSG_CHECK_CONNECTION);
                        if (!TestOpsService.getActiveInstance().testTestOpsConnection()) {
                            throw new InvocationTargetException(new Exception(), ComposerIntegrationAnalyticsMessageConstants.ERROR_TESTOPS_INTEGRATION_CONNECTION);
                        }
                        monitor.worked(1);
                        monitor.subTask(ComposerIntegrationAnalyticsMessageConstants.TASK_MSG_GETTING_TESTOPS_INFO);
                        AnalyticsProject project = (AnalyticsProject)options.get(ComposerIntegrationAnalyticsMessageConstants.ANALYTICS_PROJECT);
                        GitRepositoryEntity gitRepositoryEntity = (GitRepositoryEntity)options.get(ComposerIntegrationAnalyticsMessageConstants.ANALYTICS_GIT);
                        if (project == null) {
                            throw new InvocationTargetException(new Exception(), ComposerIntegrationAnalyticsMessageConstants.ERROR_TESTOPS_INTEGRATION_INVALID_PROJ);
                        }
                        if (gitRepositoryEntity == null) {
                            throw new InvocationTargetException(new Exception(), ComposerIntegrationAnalyticsMessageConstants.ERROR_TESTOPS_INTEGRATION_INVALID_GIT);
                        }
                        monitor.worked(1);
                        monitor.subTask(ComposerIntegrationAnalyticsMessageConstants.TASK_MSG_GETTING_TEAMS);
                        List teams = TestOpsService.getActiveInstance().getTeams(project.getOrganizationId());
                        Optional<AnalyticsTeam> defaultTeam = teams.stream().filter(team -> team.getId().equals(project.getTeamId())).findFirst();
                        monitor.worked(1);
                        analyticsSettingStore.enableIntegration(true);
                        analyticsSettingStore.setToken(TestOpsService.getActiveInstance().getAdminAccessToken());
                        analyticsSettingStore.setProject(project);
                        analyticsSettingStore.setGitRepositoryEntity(gitRepositoryEntity);
                        analyticsSettingStore.setAutoSubmit(true);
                        analyticsSettingStore.setTeam(defaultTeam.get());
                        EventBrokerSingleton.getInstance().getEventBroker().post("EXPLORER/RELOAD_DATA", (Object)true);
                    }
                    catch (AnalyticsApiException e) {
                        throw new InvocationTargetException(e, ComposerIntegrationAnalyticsMessageConstants.ERROR_TESTOPS_INTEGRATION_CONNECTION);
                    }
                    catch (IOException | GeneralSecurityException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            dialog.run(false, false, enableWorker);
        }
        catch (InvocationTargetException e) {
            LoggerSingleton.logError((String)ComposerIntegrationAnalyticsMessageConstants.ERROR_TESTOPS_INTEGRATION);
            LoggerSingleton.logError((Throwable)e);
        }
        catch (InterruptedException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private AnalyticsProject getDefaultProject() throws AnalyticsApiException, GeneralSecurityException, IOException {
        return TestOpsService.getActiveInstance().getDefaultNewUserProject();
    }

    private void showTestopsIntegrationDialog() throws InvocationTargetException, InterruptedException {
        UISynchronizeService.syncExec(() -> {
            KatalonTestOpsIntegrationDialog quickStartDialog = new KatalonTestOpsIntegrationDialog(Display.getCurrent().getActiveShell());
            quickStartDialog.open();
            EventBrokerSingleton.getInstance().getEventBroker().post("EXPLORER/RELOAD_DATA", (Object)true);
        });
    }
}

