/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.debug.ui;

import java.util.Arrays;
import java.util.regex.Pattern;
import org.codehaus.groovy.eclipse.GroovyPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.internal.debug.ui.JavaDebugOptionsManager;
import org.eclipse.jdt.internal.debug.ui.variables.JavaStackFrameLabelProvider;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.RGB;

class GroovyJavaStackFrameLabelProvider
extends JavaStackFrameLabelProvider
implements IPropertyChangeListener {
    private boolean enabled;
    private String[] filters;
    private final IPreferenceStore preferenceStore = GroovyPlugin.getDefault().getPreferenceStore();
    private static final Pattern LAMBDA_FILTER = Pattern.compile("\\${2}Lambda\\$\\d+(?:\\.|/0x)[0-9a-f]{8,16}$");

    GroovyJavaStackFrameLabelProvider() {
        this.computeEnabled();
        this.computeFilters();
    }

    public void propertyChange(PropertyChangeEvent event) {
        switch (event.getProperty()) {
            case "groovy.debug.filter.stack": {
                this.computeEnabled();
                break;
            }
            case "groovy.debug.filter.list": {
                this.computeFilters();
            }
        }
    }

    protected void retrieveLabel(ILabelUpdate update) throws CoreException {
        Object element;
        super.retrieveLabel(update);
        if (this.enabled && !update.isCanceled() && (element = update.getElement()) instanceof IJavaStackFrame && this.isFiltered(((IJavaStackFrame)element).getReceivingTypeName())) {
            try {
                RGB mutedColor = JFaceResources.getColorRegistry().getRGB("DECORATIONS_COLOR");
                update.setForeground(mutedColor, 0);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    private void computeEnabled() {
        this.enabled = this.preferenceStore.getBoolean("groovy.debug.filter.stack");
    }

    private void computeFilters() {
        String filterList = this.preferenceStore.getString("groovy.debug.filter.list");
        this.filters = filterList != null ? JavaDebugOptionsManager.parseList((String)filterList) : CharOperation.NO_STRINGS;
    }

    private boolean isFiltered(String qualifiedName) {
        return Arrays.stream(this.filters).anyMatch(qualifiedName::startsWith) || LAMBDA_FILTER.matcher(qualifiedName).find();
    }

    void connect() {
        this.preferenceStore.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    void disconnect() {
        this.preferenceStore.removePropertyChangeListener((IPropertyChangeListener)this);
    }
}

