/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.editor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.codehaus.groovy.eclipse.GroovyPlugin;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.groovy.eclipse.editor.GroovyAutoIndentStrategy;
import org.codehaus.groovy.eclipse.editor.GroovyColorManager;
import org.codehaus.groovy.eclipse.editor.GroovyEditor;
import org.codehaus.groovy.eclipse.editor.GroovyStringAutoEditStrategy;
import org.codehaus.groovy.eclipse.editor.GroovyTagScanner;
import org.codehaus.groovy.eclipse.editor.highlighting.HighlightingExtenderRegistry;
import org.codehaus.groovy.eclipse.preferences.PreferenceConstants;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.groovy.core.util.ArrayUtils;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.internal.ui.text.SingleTokenJavaScanner;
import org.eclipse.jdt.internal.ui.text.java.CompletionProposalCategory;
import org.eclipse.jdt.internal.ui.text.java.ContentAssistProcessor;
import org.eclipse.jdt.internal.ui.text.java.JavaAutoIndentStrategy;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProcessor;
import org.eclipse.jdt.internal.ui.text.java.SmartSemicolonAutoEditStrategy;
import org.eclipse.jdt.ui.text.IColorManager;
import org.eclipse.jdt.ui.text.JavaSourceViewerConfiguration;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;

public class GroovyConfiguration
extends JavaSourceViewerConfiguration {
    private static final Pattern GROOVY_CONTENT_ASSIST = Pattern.compile("org.codehaus.groovy.+|org.eclipse.jdt.ui.(default|text)ProposalCategory");

    public GroovyConfiguration(GroovyColorManager colorManager, IPreferenceStore preferenceStore, ITextEditor editor) {
        super((IColorManager)colorManager, preferenceStore, editor, "___java_partitioning");
        SingleTokenJavaScanner stringScanner = new SingleTokenJavaScanner((IColorManager)colorManager, PreferenceConstants.getPreferenceStore(), "java_string");
        ReflectionUtils.setPrivateField(JavaSourceViewerConfiguration.class, (String)"fStringScanner", (Object)((Object)this), (Object)stringScanner);
        try {
            IProject project = null;
            if (editor != null && editor instanceof GroovyEditor && editor.getEditorInput() instanceof FileEditorInput) {
                project = ((FileEditorInput)editor.getEditorInput()).getFile().getProject();
            }
            HighlightingExtenderRegistry registry = GroovyPlugin.getDefault().getTextTools().getHighlightingExtenderRegistry();
            GroovyTagScanner codeScanner = new GroovyTagScanner((IColorManager)colorManager, registry.getInitialAdditionalRulesForProject(project), registry.getAdditionalRulesForProject(project), registry.getExtraGroovyKeywordsForProject(project), registry.getExtraGJDKKeywordsForProject(project));
            ReflectionUtils.setPrivateField(JavaSourceViewerConfiguration.class, (String)"fCodeScanner", (Object)((Object)this), (Object)((Object)codeScanner));
        }
        catch (Exception e) {
            GroovyCore.logException((String)"Error creating and registering GroovyTagScanner", (Throwable)e);
        }
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        switch (contentType) {
            case "__groovy_multiline_string": 
            case "__java_string": {
                return new IAutoEditStrategy[]{new GroovyStringAutoEditStrategy(contentType)};
            }
        }
        Object[] strategies = super.getAutoEditStrategies(sourceViewer, contentType);
        int i = 0;
        int n = strategies.length;
        while (i < n) {
            if (strategies[i] instanceof JavaAutoIndentStrategy) {
                strategies[i] = new GroovyAutoIndentStrategy((JavaAutoIndentStrategy)strategies[i]);
            } else if (strategies[i] instanceof SmartSemicolonAutoEditStrategy) {
                String partitioning = this.getConfiguredDocumentPartitioning(sourceViewer);
                strategies[i] = (document, command) -> {
                    if (";".equals(command.text)) {
                        SmartSemicolonAutoEditStrategy delegate = new SmartSemicolonAutoEditStrategy(partitioning);
                        delegate.customizeDocumentCommand(document, command);
                    }
                };
                strategies = (IAutoEditStrategy[])ArrayUtils.add((Object[])strategies, (document, command) -> {
                    if ("{".equals(command.text)) {
                        Integer prev = (Integer)ReflectionUtils.executePrivateMethod(SmartSemicolonAutoEditStrategy.class, (String)"firstNonWhitespaceBackward", (Class[])new Class[]{IDocument.class, Integer.TYPE, String.class, Integer.TYPE}, SmartSemicolonAutoEditStrategy.class, (Object[])new Object[]{document, command.offset - 1, partitioning, -1});
                        try {
                            if (prev != null && prev != -1) {
                                switch (document.getChar(prev.intValue())) {
                                    case ',': 
                                    case '.': 
                                    case ':': 
                                    case '?': {
                                        return;
                                    }
                                }
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                        SmartSemicolonAutoEditStrategy delegate = new SmartSemicolonAutoEditStrategy(partitioning);
                        delegate.customizeDocumentCommand(document, command);
                    }
                });
            }
            ++i;
        }
        return strategies;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__java_javadoc", "__java_multiline_comment", "__java_singleline_comment", "__java_string", "__java_character", "__groovy_multiline_string"};
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant assistant = (ContentAssistant)super.getContentAssistant(sourceViewer);
        String contentType = "__groovy_multiline_string";
        assistant.setContentAssistProcessor((IContentAssistProcessor)new JavaCompletionProcessor((IEditorPart)this.getEditor(), assistant, contentType), contentType);
        IContentAssistProcessor processor = assistant.getContentAssistProcessor("__dftl_partition_content_type");
        List categories = (List)ReflectionUtils.getPrivateField(ContentAssistProcessor.class, (String)"fCategories", (Object)processor);
        ArrayList<CompletionProposalCategory> newCategories = new ArrayList<CompletionProposalCategory>();
        for (CompletionProposalCategory category : categories) {
            if (!GROOVY_CONTENT_ASSIST.matcher(category.getId()).matches()) continue;
            newCategories.add(category);
        }
        ReflectionUtils.setPrivateField(ContentAssistProcessor.class, (String)"fCategories", (Object)processor, newCategories);
        return assistant;
    }

    protected Map<String, IAdaptable> getHyperlinkDetectorTargets(ISourceViewer sourceViewer) {
        Map targets = super.getHyperlinkDetectorTargets(sourceViewer);
        targets.put("org.codehaus.groovy.eclipse.groovyCode", this.getEditor());
        return targets;
    }

    public IInformationPresenter getOutlinePresenter(ISourceViewer sourceViewer, boolean doCodeResolve) {
        IInformationPresenter presenter = super.getOutlinePresenter(sourceViewer, doCodeResolve);
        if (presenter instanceof InformationPresenter) {
            IInformationProvider provider = presenter.getInformationProvider("__dftl_partition_content_type");
            ((InformationPresenter)presenter).setInformationProvider(provider, "__groovy_multiline_string");
        }
        return presenter;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = (PresentationReconciler)super.getPresentationReconciler(sourceViewer);
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.getStringScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__groovy_multiline_string");
        reconciler.setRepairer((IPresentationRepairer)dr, "__groovy_multiline_string");
        return reconciler;
    }
}

