/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.editor;

import java.lang.reflect.Constructor;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.eclipse.GroovyPlugin;
import org.codehaus.groovy.eclipse.debug.ui.RunToLineAdapter;
import org.codehaus.groovy.eclipse.debug.ui.ToggleBreakpointAdapter;
import org.codehaus.groovy.eclipse.editor.GroovyConfiguration;
import org.codehaus.groovy.eclipse.editor.GroovyTextTools;
import org.codehaus.groovy.eclipse.editor.ISurroundWithFactory;
import org.codehaus.groovy.eclipse.editor.actions.ExpandSelectionAction;
import org.codehaus.groovy.eclipse.editor.actions.GroovyTabAction;
import org.codehaus.groovy.eclipse.editor.highlighting.GroovySemanticReconciler;
import org.codehaus.groovy.eclipse.editor.outline.GroovyOutlinePage;
import org.codehaus.groovy.eclipse.editor.outline.OutlineExtenderRegistry;
import org.codehaus.groovy.eclipse.refactoring.actions.AddImportOnSelectionAction;
import org.codehaus.groovy.eclipse.refactoring.actions.ConvertToPropertyAction;
import org.codehaus.groovy.eclipse.refactoring.actions.FormatAllGroovyAction;
import org.codehaus.groovy.eclipse.refactoring.actions.FormatGroovyAction;
import org.codehaus.groovy.eclipse.refactoring.actions.FormatKind;
import org.codehaus.groovy.eclipse.refactoring.actions.GroovyConvertLocalToFieldAction;
import org.codehaus.groovy.eclipse.refactoring.actions.GroovyExtractConstantAction;
import org.codehaus.groovy.eclipse.refactoring.actions.GroovyExtractLocalAction;
import org.codehaus.groovy.eclipse.refactoring.actions.GroovyExtractMethodAction;
import org.codehaus.groovy.eclipse.refactoring.actions.GroovyRenameAction;
import org.codehaus.groovy.eclipse.refactoring.actions.OrganizeGroovyImportsAction;
import org.codehaus.groovy.eclipse.search.GroovyOccurrencesFinder;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.ui.actions.IRunToLineTarget;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTarget;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.internal.core.manipulation.search.IOccurrencesFinder;
import org.eclipse.jdt.internal.debug.ui.BreakpointMarkerUpdater;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.AllCleanUpsAction;
import org.eclipse.jdt.internal.ui.actions.CompositeActionGroup;
import org.eclipse.jdt.internal.ui.actions.SurroundWithActionGroup;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaOutlinePage;
import org.eclipse.jdt.internal.ui.javaeditor.JavaSourceViewer;
import org.eclipse.jdt.internal.ui.javaeditor.selectionactions.SelectionHistory;
import org.eclipse.jdt.internal.ui.text.JavaHeuristicScanner;
import org.eclipse.jdt.internal.ui.text.JavaWordFinder;
import org.eclipse.jdt.internal.ui.text.java.IJavaReconcilingListener;
import org.eclipse.jdt.ui.actions.GenerateActionGroup;
import org.eclipse.jdt.ui.actions.RefactorActionGroup;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jdt.ui.text.JavaSourceViewerConfiguration;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class GroovyEditor
extends CompilationUnitEditor {
    public static final String EDITOR_ID = "org.codehaus.groovy.eclipse.editor.GroovyEditor";
    private GroovySemanticReconciler semanticReconciler;
    private final GroovyBracketInserter groovyBracketInserter = new GroovyBracketInserter();
    private GroovyOutlinePage page;
    private Action toPropertyAction;

    public VerifyKeyListener getGroovyBracketInserter() {
        return this.groovyBracketInserter;
    }

    public GroovyEditor() {
        this.setRulerContextMenuId("#GroovyCompilationUnitRulerContext");
        this.setEditorContextMenuId("#GroovyCompilationUnitEditorContext");
    }

    protected void setPreferenceStore(IPreferenceStore store) {
        super.setPreferenceStore((IPreferenceStore)new ChainedPreferenceStore(new IPreferenceStore[]{store, GroovyPlugin.getDefault().getPreferenceStore()}));
        this.setSourceViewerConfiguration((SourceViewerConfiguration)this.createJavaSourceViewerConfiguration());
    }

    public GroovyConfiguration getGroovyConfiguration() {
        return (GroovyConfiguration)this.getSourceViewerConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installGroovySemanticHighlighting() {
        try {
            ListenerList list;
            this.semanticReconciler = new GroovySemanticReconciler();
            ListenerList listenerList = list = (ListenerList)ReflectionUtils.throwableGetPrivateField(CompilationUnitEditor.class, (String)"fReconcilingListeners", (Object)((Object)this));
            synchronized (listenerList) {
                Object[] listeners = list.getListeners();
                int i = 0;
                int n = listeners.length;
                while (i < n) {
                    if (listeners[i] == this.fSemanticManager.getReconciler()) {
                        listeners[i] = this.semanticReconciler;
                        break;
                    }
                    ++i;
                }
            }
            this.fSemanticManager.uninstall();
            this.semanticReconciler.install(this, (JavaSourceViewer)this.getSourceViewer());
            ReflectionUtils.throwableExecutePrivateMethod(CompilationUnitEditor.class, (String)"addReconcileListener", (Class[])new Class[]{IJavaReconcilingListener.class}, (Object)((Object)this), (Object[])new Object[]{this.semanticReconciler});
        }
        catch (Exception e) {
            GroovyPlugin.getDefault().logError("GroovyEditor: failed to install semantic reconciler", e);
        }
    }

    private void uninstallGroovySemanticHighlighting() {
        if (this.semanticHighlightingInstalled()) {
            try {
                this.semanticReconciler.uninstall();
                ReflectionUtils.throwableExecutePrivateMethod(CompilationUnitEditor.class, (String)"removeReconcileListener", (Class[])new Class[]{IJavaReconcilingListener.class}, (Object)((Object)this), (Object[])new Object[]{this.semanticReconciler});
                this.semanticReconciler = null;
            }
            catch (Exception e) {
                GroovyPlugin.getDefault().logError("GroovyEditor: failed to uninstall semantic reconciler", e);
            }
        }
    }

    private boolean semanticHighlightingInstalled() {
        return this.semanticReconciler != null;
    }

    public void dispose() {
        this.uninstallGroovySemanticHighlighting();
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer instanceof ITextViewerExtension) {
            ((ITextViewerExtension)sourceViewer).removeVerifyKeyListener((VerifyKeyListener)this.groovyBracketInserter);
        }
        super.dispose();
    }

    public int getCaretOffset() {
        ISourceViewer viewer = this.getSourceViewer();
        return viewer.getTextWidget().getCaretOffset();
    }

    protected void setTitleImage(Image titleImage) {
    }

    private IFile getFile() {
        IEditorInput input = this.getEditorInput();
        if (input instanceof FileEditorInput) {
            return ((FileEditorInput)input).getFile();
        }
        return null;
    }

    public GroovyCompilationUnit getGroovyCompilationUnit() {
        ITypeRoot root = super.getInputJavaElement();
        if (root instanceof GroovyCompilationUnit) {
            return (GroovyCompilationUnit)root;
        }
        return null;
    }

    public ModuleNode getModuleNode() {
        GroovyCompilationUnit unit = this.getGroovyCompilationUnit();
        if (unit != null) {
            return unit.getModuleNode();
        }
        return null;
    }

    public <T> T getAdapter(Class<T> required) {
        if (IFile.class.equals(required) || IResource.class.equals(required)) {
            return (T)this.getFile();
        }
        if (GroovyCompilationUnit.class.equals(required) || org.eclipse.jdt.internal.core.CompilationUnit.class.equals(required) || ICompilationUnit.class.equals(required)) {
            return (T)super.getInputJavaElement();
        }
        if (ModuleNode.class.equals(required)) {
            return (T)this.getModuleNode();
        }
        if (IContentOutlinePage.class.equals(required)) {
            if (this.fOutlinePage == null && this.getSourceViewer() != null) {
                this.fOutlinePage = this.createOutlinePage();
            }
            return (T)this.fOutlinePage;
        }
        if (IRunToLineTarget.class.equals(required)) {
            return (T)new RunToLineAdapter();
        }
        if (IToggleBreakpointsTarget.class.equals(required)) {
            return (T)new ToggleBreakpointAdapter();
        }
        return (T)super.getAdapter(required);
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.unsetJavaBreakpointUpdater();
        this.installGroovySemanticHighlighting();
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        this.groovyBracketInserter.setCloseBracesEnabled(preferenceStore.getBoolean("closeBraces"));
        this.groovyBracketInserter.setCloseStringsEnabled(preferenceStore.getBoolean("closeStrings"));
        this.groovyBracketInserter.setCloseBracketsEnabled(preferenceStore.getBoolean("closeBrackets"));
        this.groovyBracketInserter.setCloseAngularBracketsEnabled(preferenceStore.getString("org.eclipse.jdt.core.compiler.source").compareTo("1.5") >= 0);
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer instanceof ITextViewerExtension) {
            ((ITextViewerExtension)sourceViewer).prependVerifyKeyListener((VerifyKeyListener)this.groovyBracketInserter);
            ((ITextViewerExtension)sourceViewer).removeVerifyKeyListener((VerifyKeyListener)ReflectionUtils.getPrivateField(CompilationUnitEditor.class, (String)"fBracketInserter", (Object)((Object)this)));
        } else {
            Object fBracketInserter = ReflectionUtils.getPrivateField(CompilationUnitEditor.class, (String)"fBracketInserter", (Object)((Object)this));
            Class<?> fBracketInserterClass = fBracketInserter.getClass();
            Class[] bool = new Class[]{Boolean.TYPE};
            Object[] disabled = new Object[]{Boolean.FALSE};
            ReflectionUtils.executePrivateMethod(fBracketInserterClass, (String)"setCloseStringsEnabled", (Class[])bool, (Object)fBracketInserter, (Object[])disabled);
            ReflectionUtils.executePrivateMethod(fBracketInserterClass, (String)"setCloseBracketsEnabled", (Class[])bool, (Object)fBracketInserter, (Object[])disabled);
            ReflectionUtils.executePrivateMethod(fBracketInserterClass, (String)"setCloseAngularBracketsEnabled", (Class[])bool, (Object)fBracketInserter, (Object[])disabled);
        }
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        boolean installed = this.semanticHighlightingInstalled();
        if (installed) {
            this.uninstallGroovySemanticHighlighting();
        }
        super.doSetInput(input);
        this.unsetJavaBreakpointUpdater();
        if (installed) {
            this.installGroovySemanticHighlighting();
        }
    }

    public void doSave(IProgressMonitor progressMonitor) {
        try {
            super.doSave(progressMonitor);
        }
        catch (RuntimeException e) {
            GroovyPlugin.getDefault().logError("GroovyEditor: error saving document", e);
            throw e;
        }
        catch (Error e) {
            GroovyPlugin.getDefault().logError("GroovyEditor: error saving document", e);
            throw e;
        }
    }

    protected void handleExceptionOnSave(CoreException exception, IProgressMonitor progressMonitor) {
        GroovyPlugin.getDefault().logError("GroovyEditor: error saving document", exception);
        super.handleExceptionOnSave(exception, progressMonitor);
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{"org.codehaus.groovy.eclipse.editor.groovyEditorScope"});
    }

    public JavaSourceViewerConfiguration createJavaSourceViewerConfiguration() {
        GroovyTextTools textTools = GroovyPlugin.getDefault().getTextTools();
        return new GroovyConfiguration(textTools.getColorManager(), this.getPreferenceStore(), (ITextEditor)this);
    }

    private void unsetJavaBreakpointUpdater() {
        block4: {
            try {
                IAnnotationModel model;
                ISourceViewer viewer = this.getSourceViewer();
                if (viewer == null || !((model = viewer.getAnnotationModel()) instanceof AbstractMarkerAnnotationModel)) break block4;
                if (ReflectionUtils.getPrivateField(AbstractMarkerAnnotationModel.class, (String)"fMarkerUpdaterSpecifications", (Object)model) == null) {
                    ReflectionUtils.executePrivateMethod(AbstractMarkerAnnotationModel.class, (String)"installMarkerUpdaters", (Object)model);
                }
                List updaterSpecs = (List)ReflectionUtils.getPrivateField(AbstractMarkerAnnotationModel.class, (String)"fMarkerUpdaterSpecifications", (Object)model);
                Iterator specIter = updaterSpecs.iterator();
                while (specIter.hasNext()) {
                    IConfigurationElement spec = (IConfigurationElement)specIter.next();
                    if (!spec.getAttribute("class").equals(BreakpointMarkerUpdater.class.getCanonicalName())) continue;
                    specIter.remove();
                    break;
                }
            }
            catch (RuntimeException e) {
                GroovyPlugin.getDefault().logError("GroovyEditor: failed to remove Java breakpoint updater", e);
            }
        }
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        block13: {
            super.handlePreferenceStoreChanged(event);
            ISourceViewer sv = this.getSourceViewer();
            if (sv == null) break block13;
            switch (event.getProperty()) {
                case "closeBrackets": {
                    this.groovyBracketInserter.setCloseBracketsEnabled(this.getPreferenceStore().getBoolean(event.getProperty()));
                    return;
                }
                case "closeStrings": {
                    this.groovyBracketInserter.setCloseStringsEnabled(this.getPreferenceStore().getBoolean(event.getProperty()));
                    return;
                }
                case "closeBraces": {
                    this.groovyBracketInserter.setCloseBracesEnabled(this.getPreferenceStore().getBoolean(event.getProperty()));
                    return;
                }
            }
        }
    }

    private static char getEscapeCharacter(char character) {
        switch (character) {
            case '\"': 
            case '\'': {
                return '\\';
            }
        }
        return '\u0000';
    }

    private static char getPeerCharacter(char character) {
        switch (character) {
            case '(': {
                return ')';
            }
            case ')': {
                return '(';
            }
            case '<': {
                return '>';
            }
            case '>': {
                return '<';
            }
            case '[': {
                return ']';
            }
            case ']': {
                return '[';
            }
            case '\"': {
                return character;
            }
            case '\'': {
                return character;
            }
            case '{': {
                return '}';
            }
        }
        throw new IllegalArgumentException();
    }

    public GroovyOutlinePage getOutlinePage() {
        IContentOutlinePage outlinePage;
        if (this.page == null && (outlinePage = (IContentOutlinePage)Adapters.adapt((Object)((Object)this), IContentOutlinePage.class)) instanceof GroovyOutlinePage) {
            this.page = (GroovyOutlinePage)outlinePage;
        }
        return this.page;
    }

    protected void synchronizeOutlinePage(ISourceReference element, boolean checkIfOutlinePageActive) {
        if (this.page != null) {
            this.page.refresh();
        }
        super.synchronizeOutlinePage(element, checkIfOutlinePageActive);
    }

    protected ISourceReference computeHighlightRangeSourceReference() {
        return this.page != null ? this.page.getOutlineElmenetAt(this.getCaretOffset()) : super.computeHighlightRangeSourceReference();
    }

    protected JavaOutlinePage createOutlinePage() {
        OutlineExtenderRegistry outlineExtenderRegistry = GroovyPlugin.getDefault().getOutlineTools().getOutlineExtenderRegistry();
        GroovyCompilationUnit unit = this.getGroovyCompilationUnit();
        if (unit != null) {
            try {
                this.page = outlineExtenderRegistry.getGroovyOutlinePageForEditor(unit.getJavaProject().getProject(), this.fOutlinerContextMenuId, this);
            }
            catch (CoreException e) {
                GroovyPlugin.getDefault().logError("GroovyEditor: failed to create Outline page", e);
            }
            if (this.page != null) {
                this.page.setInput(this.page.getOutlineCompilationUnit());
                return this.page;
            }
        }
        return super.createOutlinePage();
    }

    protected void createActions() {
        super.createActions();
        this.updateSourceActions();
        this.updateRefactorActions();
        this.setAction("IndentOnTab", (IAction)new GroovyTabAction((ITextEditor)this));
        this.markAsSelectionDependentAction("IndentOnTab", true);
        this.markAsStateDependentAction("IndentOnTab", true);
        ExpandSelectionAction selectionAction = new ExpandSelectionAction(this, (SelectionHistory)ReflectionUtils.getPrivateField(JavaEditor.class, (String)"fSelectionHistory", (Object)((Object)this)));
        selectionAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.select.enclosing");
        this.setAction("SelectEnclosingElement", (IAction)selectionAction);
        this.setAction("SelectPreviousElement", null);
        this.setAction("SelectNextElement", null);
        ISurroundWithFactory surroundWithFactory = (ISurroundWithFactory)Platform.getAdapterManager().loadAdapter((Object)this, "org.codehaus.groovy.eclipse.quickfix.templates.SurroundWithAdapterFactory");
        if (surroundWithFactory != null) {
            CompositeActionGroup compositActions = (CompositeActionGroup)ReflectionUtils.getPrivateField(CompilationUnitEditor.class, (String)"fContextMenuGroup", (Object)((Object)this));
            ActionGroup[] groups = (ActionGroup[])ReflectionUtils.getPrivateField(CompositeActionGroup.class, (String)"fGroups", (Object)compositActions);
            boolean found = false;
            ActionGroup surroundWithGroup = surroundWithFactory.createSurrundWithGroup(this, "group.edit");
            int i = 0;
            int n = groups.length;
            while (i < n) {
                if (groups[i] instanceof SurroundWithActionGroup) {
                    found = true;
                    groups[i] = surroundWithGroup;
                    break;
                }
                ++i;
            }
            if (!found) {
                GroovyPlugin.trace("Oops...surroundWithActionGroup not found in context menus");
            }
            found = false;
            groups = (ActionGroup[])ReflectionUtils.getPrivateField(CompositeActionGroup.class, (String)"fGroups", (Object)this.fActionGroups);
            i = 0;
            n = groups.length;
            while (i < n) {
                if (groups[i] instanceof SurroundWithActionGroup) {
                    found = true;
                    groups[i] = surroundWithGroup;
                    break;
                }
                ++i;
            }
            if (!found) {
                GroovyPlugin.trace("Oops...surroundWithActionGroup not found");
            }
        } else {
            GroovyPlugin.trace("Oops...surroundWithFactory not initialized");
        }
        this.toPropertyAction = new ConvertToPropertyAction(this);
        this.setAction(this.toPropertyAction.getActionDefinitionId(), (IAction)this.toPropertyAction);
    }

    protected void updateSourceActions() {
        GenerateActionGroup group = this.getGenerateActionGroup();
        FormatGroovyAction indentAction = new FormatGroovyAction((IWorkbenchSite)this.getEditorSite(), FormatKind.INDENT_ONLY);
        indentAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.indent");
        this.setAction("Indent", (IAction)indentAction);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)indentAction, "org.eclipse.jdt.ui.indent_action");
        FormatGroovyAction formatAction = new FormatGroovyAction((IWorkbenchSite)this.getEditorSite(), FormatKind.FORMAT);
        formatAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.format");
        this.setAction("Format", (IAction)formatAction);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)formatAction, "org.eclipse.jdt.ui.format_action");
        FormatAllGroovyAction formatAllAction = new FormatAllGroovyAction((IWorkbenchSite)this.getEditorSite(), FormatKind.FORMAT);
        ReflectionUtils.setPrivateField(GenerateActionGroup.class, (String)"fFormatAll", (Object)group, (Object)((Object)formatAllAction));
        AddImportOnSelectionAction addImportOnSelectionAction = new AddImportOnSelectionAction(this);
        addImportOnSelectionAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.add.import");
        this.setAction("AddImport", (IAction)addImportOnSelectionAction);
        ReflectionUtils.setPrivateField(GenerateActionGroup.class, (String)"fAddImport", (Object)group, (Object)((Object)addImportOnSelectionAction));
        OrganizeGroovyImportsAction organizeGroovyImportsAction = new OrganizeGroovyImportsAction((JavaEditor)this);
        organizeGroovyImportsAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.organize.imports");
        this.setAction("OrganizeImports", (IAction)organizeGroovyImportsAction);
        ReflectionUtils.setPrivateField(GenerateActionGroup.class, (String)"fOrganizeImports", (Object)group, (Object)((Object)organizeGroovyImportsAction));
        AllCleanUpsAction acua = (AllCleanUpsAction)ReflectionUtils.getPrivateField(GenerateActionGroup.class, (String)"fCleanUp", (Object)group);
        acua.setEnabled(false);
    }

    protected void updateRefactorActions() {
        this.removeRefactoringAction("fSelfEncapsulateField");
        this.removeRefactoringAction("fMoveAction");
        this.removeRefactoringAction("fModifyParametersAction");
        this.removeRefactoringAction("fIntroduceParameterAction");
        this.removeRefactoringAction("fIntroduceParameterObjectAction");
        this.removeRefactoringAction("fIntroduceFactoryAction");
        this.removeRefactoringAction("fExtractMethodAction");
        this.removeRefactoringAction("fExtractInterfaceAction");
        this.removeRefactoringAction("fExtractClassAction");
        this.removeRefactoringAction("fExtractSupertypeAction");
        this.removeRefactoringAction("fExtractTempAction");
        this.removeRefactoringAction("fExtractConstantAction");
        this.removeRefactoringAction("fChangeTypeAction");
        this.removeRefactoringAction("fConvertNestedToTopAction");
        this.removeRefactoringAction("fInferTypeArgumentsAction");
        this.removeRefactoringAction("fInlineAction");
        this.removeRefactoringAction("fConvertAnonymousToNestedAction");
        this.removeRefactoringAction("fIntroduceIndirectionAction");
        this.removeRefactoringAction("fUseSupertypeAction");
        GroovyRenameAction renameAction = new GroovyRenameAction((JavaEditor)this);
        renameAction.setActionDefinitionId("org.codehaus.groovy.eclipse.refactoring.command.rename");
        this.setAction("RenameElement", (IAction)renameAction);
        this.replaceRefactoringAction("fRenameAction", (SelectionDispatchAction)renameAction);
        GroovyExtractConstantAction extractConstantAction = new GroovyExtractConstantAction(this);
        extractConstantAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.extract.constant");
        this.setAction("ExtractConstant", (IAction)extractConstantAction);
        this.replaceRefactoringAction("fExtractConstantAction", (SelectionDispatchAction)extractConstantAction);
        GroovyExtractMethodAction extractMethodAction = new GroovyExtractMethodAction(this);
        extractMethodAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.extract.method");
        this.setAction("ExtractMethod", (IAction)extractMethodAction);
        this.replaceRefactoringAction("fExtractMethodAction", (SelectionDispatchAction)extractMethodAction);
        GroovyExtractLocalAction extractLocalAction = new GroovyExtractLocalAction(this);
        extractLocalAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.extract.local.variable");
        this.setAction("ExtractLocalVariable", (IAction)extractLocalAction);
        this.replaceRefactoringAction("fExtractTempAction", (SelectionDispatchAction)extractLocalAction);
        GroovyConvertLocalToFieldAction convertLocalAction = new GroovyConvertLocalToFieldAction(this);
        convertLocalAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.promote.local.variable");
        this.setAction("ConvertLocalToField", (IAction)convertLocalAction);
        this.replaceRefactoringAction("fConvertLocalToFieldAction", (SelectionDispatchAction)convertLocalAction);
    }

    protected final void removeRefactoringAction(String actionFieldName) {
        this.replaceRefactoringAction(actionFieldName, null);
    }

    protected final void replaceRefactoringAction(String actionFieldName, SelectionDispatchAction newAction) {
        RefactorActionGroup group = this.getRefactorActionGroup();
        SelectionDispatchAction action = (SelectionDispatchAction)ReflectionUtils.getPrivateField(RefactorActionGroup.class, (String)actionFieldName, (Object)group);
        if (action != null) {
            this.getSite().getSelectionProvider().removeSelectionChangedListener((ISelectionChangedListener)action);
        }
        ReflectionUtils.setPrivateField(RefactorActionGroup.class, (String)actionFieldName, (Object)group, (Object)newAction);
    }

    public void editorContextMenuAboutToShow(IMenuManager contextMenu) {
        super.editorContextMenuAboutToShow(contextMenu);
        IMenuManager sourceMenu = contextMenu.findMenuUsingPath("org.eclipse.jdt.ui.source.menu");
        if (sourceMenu != null) {
            sourceMenu.appendToGroup("codeGroup", (IAction)this.toPropertyAction);
        }
    }

    protected void updateOccurrenceAnnotations(ITextSelection selection, CompilationUnit astRoot) {
        try {
            IOccurrencesFinder.OccurrenceLocation[] locations;
            if (this.fOccurrencesFinderJob_get() != null) {
                this.fOccurrencesFinderJob_get().cancel();
            }
            if (!this.fMarkOccurrenceAnnotations_get()) {
                return;
            }
            if (astRoot == null || selection == null) {
                return;
            }
            IDocument document = this.getSourceViewer().getDocument();
            if (document == null) {
                return;
            }
            boolean hasChanged = false;
            if (document instanceof IDocumentExtension4) {
                int offset = selection.getOffset();
                long currentModificationStamp = ((IDocumentExtension4)document).getModificationStamp();
                IRegion markOccurrenceTargetRegion = this.fMarkOccurrenceTargetRegion_get();
                boolean bl = hasChanged = currentModificationStamp != this.fMarkOccurrenceModificationStamp_get();
                if (markOccurrenceTargetRegion != null && !hasChanged && markOccurrenceTargetRegion.getOffset() <= offset && offset <= markOccurrenceTargetRegion.getOffset() + markOccurrenceTargetRegion.getLength()) {
                    return;
                }
                this.fMarkOccurrenceTargetRegion_set(this.findMarkOccurrencesRegion(document, offset));
                this.fMarkOccurrenceModificationStamp_set(currentModificationStamp);
            }
            if ((locations = GroovyOccurrencesFinder.findOccurrences(astRoot, selection.getOffset(), selection.getLength())) == null || locations.length == 0) {
                if (!this.fStickyOccurrenceAnnotations_get()) {
                    this.removeOccurrenceAnnotations_call();
                } else if (hasChanged) {
                    this.removeOccurrenceAnnotations_call();
                }
                return;
            }
            this.fOccurrencesFinderJob_new(document, locations, (ISelection)selection);
        }
        catch (Exception e) {
            GroovyPlugin.getDefault().logError("Failure in GroovyEditor.updateOccurrenceAnnotations", e);
        }
    }

    protected IRegion findMarkOccurrencesRegion(IDocument document, int offset) {
        IRegion word = JavaWordFinder.findWord((IDocument)document, (int)offset);
        try {
            if (word != null && word.getLength() > 1 && document.getChar(word.getOffset()) == '$') {
                word = new Region(word.getOffset() + 1, word.getLength() - 1);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return word;
    }

    protected Job fOccurrencesFinderJob_get() throws Exception {
        return (Job)ReflectionUtils.throwableGetPrivateField(JavaEditor.class, (String)"fOccurrencesFinderJob", (Object)((Object)this));
    }

    protected boolean fMarkOccurrenceAnnotations_get() throws Exception {
        return (Boolean)ReflectionUtils.throwableGetPrivateField(JavaEditor.class, (String)"fMarkOccurrenceAnnotations", (Object)((Object)this));
    }

    protected IRegion fMarkOccurrenceTargetRegion_get() throws Exception {
        return (IRegion)ReflectionUtils.throwableGetPrivateField(JavaEditor.class, (String)"fMarkOccurrenceTargetRegion", (Object)((Object)this));
    }

    protected void fMarkOccurrenceTargetRegion_set(IRegion r) throws Exception {
        ReflectionUtils.setPrivateField(JavaEditor.class, (String)"fMarkOccurrenceTargetRegion", (Object)((Object)this), (Object)r);
    }

    protected long fMarkOccurrenceModificationStamp_get() throws Exception {
        return (Long)ReflectionUtils.throwableGetPrivateField(JavaEditor.class, (String)"fMarkOccurrenceModificationStamp", (Object)((Object)this));
    }

    protected void fMarkOccurrenceModificationStamp_set(long s) throws Exception {
        ReflectionUtils.setPrivateField(JavaEditor.class, (String)"fMarkOccurrenceModificationStamp", (Object)((Object)this), (Object)s);
    }

    protected boolean fStickyOccurrenceAnnotations_get() throws Exception {
        return (Boolean)ReflectionUtils.throwableGetPrivateField(JavaEditor.class, (String)"fStickyOccurrenceAnnotations", (Object)((Object)this));
    }

    protected void removeOccurrenceAnnotations_call() throws Exception {
        ReflectionUtils.throwableExecutePrivateMethod(JavaEditor.class, (String)"removeOccurrenceAnnotations", (Class[])new Class[0], (Object)((Object)this), (Object[])new Object[0]);
    }

    protected void fOccurrencesFinderJob_new(IDocument document, Object locations, ISelection selection) throws Exception {
        Constructor ctor = ReflectionUtils.getConstructor(Class.forName("org.eclipse.jdt.internal.ui.javaeditor.JavaEditor$OccurrencesFinderJob"), (Class[])new Class[]{JavaEditor.class, IDocument.class, locations.getClass(), ISelection.class});
        Job ofj = (Job)ReflectionUtils.invokeConstructor((Constructor)ctor, (Object[])new Object[]{this, document, locations, selection});
        ReflectionUtils.setPrivateField(JavaEditor.class, (String)"fOccurrencesFinderJob", (Object)((Object)this), (Object)ofj);
        ReflectionUtils.throwableExecutePrivateMethod(ofj.getClass(), (String)"run", (Class[])new Class[]{IProgressMonitor.class}, (Object)ofj, (Object[])new Object[]{new NullProgressMonitor()});
    }

    private class GroovyBracketInserter
    implements VerifyKeyListener,
    ILinkedModeListener {
        private boolean fCloseBraces = true;
        private boolean fCloseStrings = true;
        private boolean fCloseBrackets = true;
        private boolean fCloseAngularBrackets = true;
        private final String CATEGORY = this.toString();
        private final IPositionUpdater fUpdater = new GroovyExclusivePositionUpdater(this.CATEGORY);
        private final Stack<GroovyBracketLevel> fBracketLevelStack = new Stack();

        private GroovyBracketInserter() {
        }

        public void setCloseBracesEnabled(boolean enabled) {
            this.fCloseBraces = enabled;
        }

        public void setCloseStringsEnabled(boolean enabled) {
            this.fCloseStrings = enabled;
        }

        public void setCloseBracketsEnabled(boolean enabled) {
            this.fCloseBrackets = enabled;
        }

        public void setCloseAngularBracketsEnabled(boolean enabled) {
            this.fCloseAngularBrackets = enabled;
        }

        private boolean isTypeArgumentStart(String identifier) {
            return !identifier.isEmpty() && Character.isUpperCase(identifier.charAt(0));
        }

        private boolean isAngularIntroducer(String identifier) {
            return !identifier.isEmpty() && (Character.isUpperCase(identifier.charAt(0)) || identifier.startsWith("final") || identifier.startsWith("public") || identifier.startsWith("public") || identifier.startsWith("protected") || identifier.startsWith("private"));
        }

        private boolean isMultilineSelection() {
            ISelection selection = GroovyEditor.this.getSelectionProvider().getSelection();
            if (selection instanceof ITextSelection) {
                ITextSelection ts = (ITextSelection)selection;
                return ts.getStartLine() != ts.getEndLine();
            }
            return false;
        }

        public void verifyKey(VerifyEvent event) {
            if (!event.doit || GroovyEditor.this.getInsertMode() != SMART_INSERT || GroovyEditor.this.isBlockSelectionModeEnabled() && this.isMultilineSelection()) {
                return;
            }
            switch (event.character) {
                case '\"': 
                case '\'': 
                case '(': 
                case '<': 
                case '[': 
                case '{': {
                    break;
                }
                default: {
                    return;
                }
            }
            ISourceViewer sourceViewer = GroovyEditor.this.getSourceViewer();
            IDocument document = sourceViewer.getDocument();
            Point selection = sourceViewer.getSelectedRange();
            int offset = selection.x;
            int length = selection.y;
            try {
                ITypedRegion partition;
                IRegion startLine = document.getLineInformationOfOffset(offset);
                IRegion endLine = document.getLineInformationOfOffset(offset + length);
                JavaHeuristicScanner scanner = new JavaHeuristicScanner(document);
                int nextToken = scanner.nextToken(offset + length, endLine.getOffset() + endLine.getLength());
                String next = nextToken == -1 ? null : document.get(offset, scanner.getPosition() - offset).trim();
                int prevToken = scanner.previousToken(offset - 1, startLine.getOffset());
                int prevTokenOffset = scanner.getPosition() + 1;
                String previous = prevToken == -1 ? null : document.get(prevTokenOffset, offset - prevTokenOffset).trim();
                switch (event.character) {
                    case '(': {
                        if (this.fCloseBrackets && nextToken != 5 && nextToken != 2000 && (next == null || next.length() <= 1)) break;
                        return;
                    }
                    case '<': {
                        if (this.fCloseAngularBrackets && this.fCloseBrackets && nextToken != 13 && nextToken != 10 && (nextToken != 2000 || !this.isTypeArgumentStart(next)) && (prevToken == 1 || prevToken == 2 || prevToken == 7 || prevToken == 1022 || prevToken == 1019 || prevToken == 2000 && this.isAngularIntroducer(previous) || prevToken == -1)) break;
                        return;
                    }
                    case '[': {
                        if (this.fCloseBrackets && nextToken != 2000 && (next == null || next.length() <= 1)) break;
                        return;
                    }
                    case '\"': 
                    case '\'': {
                        if (this.fCloseStrings && nextToken != 2000 && (next == null || next.length() <= 1)) break;
                        return;
                    }
                    case '{': {
                        if (this.fCloseBraces && nextToken != 2000 && (next == null || next.length() <= 1)) break;
                        return;
                    }
                    default: {
                        return;
                    }
                }
                if (!"__dftl_partition_content_type".equals((partition = TextUtilities.getPartition((IDocument)document, (String)"___java_partitioning", (int)offset, (boolean)true)).getType()) && event.character != '{' && !this.shouldCloseTripleQuotes(document, offset, partition, GroovyEditor.getPeerCharacter(event.character))) {
                    return;
                }
                if (event.character == '{' && !this.shouldCloseCurly(document, offset, partition, GroovyEditor.getPeerCharacter(event.character))) {
                    return;
                }
                if (!GroovyEditor.this.validateEditorInputState()) {
                    return;
                }
                char character = event.character;
                char closingCharacter = GroovyEditor.getPeerCharacter(character);
                StringBuilder buffer = new StringBuilder();
                buffer.append(character);
                buffer.append(closingCharacter);
                int insertedLength = 1;
                if (this.fCloseStrings && offset > 1) {
                    String start = document.get(offset - 2, 2);
                    boolean doit = false;
                    if (event.character == closingCharacter) {
                        doit = start.equals(String.valueOf(Character.toString(closingCharacter)) + closingCharacter);
                    }
                    if (doit) {
                        buffer.append(closingCharacter);
                        ++insertedLength;
                        ++insertedLength;
                        if (offset > 2 && document.getChar(offset - 3) == closingCharacter) {
                            --offset;
                        } else {
                            buffer.append(closingCharacter);
                        }
                    }
                }
                document.replace(offset, length, buffer.toString());
                GroovyBracketLevel level = new GroovyBracketLevel();
                this.fBracketLevelStack.push(level);
                LinkedPositionGroup group = new LinkedPositionGroup();
                group.addPosition(new LinkedPosition(document, offset + insertedLength, 0, -1));
                LinkedModeModel model = new LinkedModeModel();
                model.addLinkingListener((ILinkedModeListener)this);
                model.addGroup(group);
                model.forceInstall();
                if (this.fBracketLevelStack.size() == 1) {
                    document.addPositionCategory(this.CATEGORY);
                    document.addPositionUpdater(this.fUpdater);
                }
                level.fFirstPosition = new Position(offset, 1);
                level.fSecondPosition = new Position(offset + insertedLength, 1);
                document.addPosition(this.CATEGORY, level.fFirstPosition);
                document.addPosition(this.CATEGORY, level.fSecondPosition);
                level.fUI = new EditorLinkedModeUI(model, (ITextViewer)sourceViewer);
                level.fUI.setSimpleMode(true);
                level.fUI.setExitPolicy((LinkedModeUI.IExitPolicy)new GroovyExitPolicy(closingCharacter, GroovyEditor.getEscapeCharacter(closingCharacter), this.fBracketLevelStack));
                level.fUI.setExitPosition((ITextViewer)sourceViewer, offset + 1 + insertedLength, 0, Integer.MAX_VALUE);
                level.fUI.setCyclingMode(LinkedModeUI.CYCLE_NEVER);
                level.fUI.enter();
                IRegion newSelection = level.fUI.getSelectedRegion();
                sourceViewer.setSelectedRange(newSelection.getOffset() - insertedLength + 1, newSelection.getLength());
                event.doit = false;
            }
            catch (BadLocationException e) {
                JavaPlugin.log((Throwable)e);
            }
            catch (BadPositionCategoryException e) {
                JavaPlugin.log((Throwable)e);
            }
        }

        private boolean shouldCloseCurly(IDocument document, int offset, ITypedRegion partition, char peer) throws BadLocationException {
            if (offset < 2 || !"__java_string".equals(partition.getType()) && !"__groovy_multiline_string".equals(partition.getType())) {
                return false;
            }
            char maybeOpen = document.getChar(offset - 1);
            if (maybeOpen != '$') {
                return false;
            }
            char maybeNext = document.getChar(offset);
            return Character.isWhitespace(maybeNext) || maybeNext == '\"' || maybeNext == '\'';
        }

        private boolean shouldCloseTripleQuotes(IDocument document, int offset, ITypedRegion partition, char quote) throws BadLocationException {
            if (offset < 3 || "__groovy_multiline_string".equals(partition.getType())) {
                return false;
            }
            String maybequotes = document.get(offset - 3, 3);
            return maybequotes.equals(String.valueOf(Character.toString(quote)) + quote + quote);
        }

        public void left(LinkedModeModel environment, int flags) {
            GroovyBracketLevel level = this.fBracketLevelStack.pop();
            if (flags != 8) {
                return;
            }
            ISourceViewer sourceViewer = GroovyEditor.this.getSourceViewer();
            IDocument document = sourceViewer.getDocument();
            if (document instanceof IDocumentExtension) {
                IDocumentExtension extension = (IDocumentExtension)document;
                extension.registerPostNotificationReplace(null, (d, owner) -> {
                    if ((groovyBracketLevel.fFirstPosition.isDeleted || groovyBracketLevel.fFirstPosition.length == 0) && !groovyBracketLevel.fSecondPosition.isDeleted && groovyBracketLevel.fSecondPosition.offset == groovyBracketLevel.fFirstPosition.offset) {
                        try {
                            document.replace(groovyBracketLevel.fSecondPosition.offset, groovyBracketLevel.fSecondPosition.length, "");
                        }
                        catch (BadLocationException e1) {
                            JavaPlugin.log((Throwable)e1);
                        }
                    }
                    if (this.fBracketLevelStack.isEmpty()) {
                        document.removePositionUpdater(this.fUpdater);
                        try {
                            document.removePositionCategory(this.CATEGORY);
                        }
                        catch (BadPositionCategoryException e) {
                            JavaPlugin.log((Throwable)e);
                        }
                    }
                });
            }
        }

        public void suspend(LinkedModeModel environment) {
        }

        public void resume(LinkedModeModel environment, int flags) {
        }
    }

    private static class GroovyBracketLevel {
        LinkedModeUI fUI;
        Position fFirstPosition;
        Position fSecondPosition;

        private GroovyBracketLevel() {
        }
    }

    private static class GroovyExclusivePositionUpdater
    implements IPositionUpdater {
        private final String fCategory;

        public GroovyExclusivePositionUpdater(String category) {
            this.fCategory = category;
        }

        public void update(DocumentEvent event) {
            int eventOffset = event.getOffset();
            int eventOldLength = event.getLength();
            int eventNewLength = event.getText() == null ? 0 : event.getText().length();
            int deltaLength = eventNewLength - eventOldLength;
            try {
                Position[] positions = event.getDocument().getPositions(this.fCategory);
                int i = 0;
                while (i != positions.length) {
                    Position position = positions[i];
                    if (!position.isDeleted()) {
                        int offset = position.getOffset();
                        int length = position.getLength();
                        int end = offset + length;
                        if (offset >= eventOffset + eventOldLength) {
                            position.setOffset(offset + deltaLength);
                        } else if (end > eventOffset) {
                            if (offset <= eventOffset && end >= eventOffset + eventOldLength) {
                                position.setLength(length + deltaLength);
                            } else if (offset < eventOffset) {
                                int newEnd = eventOffset;
                                position.setLength(newEnd - offset);
                            } else if (end > eventOffset + eventOldLength) {
                                int newOffset = eventOffset + eventNewLength;
                                position.setOffset(newOffset);
                                position.setLength(end - newOffset);
                            } else {
                                position.delete();
                            }
                        }
                    }
                    ++i;
                }
            }
            catch (BadPositionCategoryException badPositionCategoryException) {
                // empty catch block
            }
        }
    }

    private class GroovyExitPolicy
    implements LinkedModeUI.IExitPolicy {
        final char fExitCharacter;
        final char fEscapeCharacter;
        final Stack<GroovyBracketLevel> fStack;
        final int fSize;

        public GroovyExitPolicy(char exitCharacter, char escapeCharacter, Stack<GroovyBracketLevel> stack) {
            this.fExitCharacter = exitCharacter;
            this.fEscapeCharacter = escapeCharacter;
            this.fStack = stack;
            this.fSize = this.fStack.size();
        }

        public LinkedModeUI.ExitFlags doExit(LinkedModeModel model, VerifyEvent event, int offset, int length) {
            if (this.fSize == this.fStack.size() && !this.isMasked(offset)) {
                if (event.character == this.fExitCharacter) {
                    GroovyBracketLevel level = this.fStack.peek();
                    if (level.fFirstPosition.offset > offset || level.fSecondPosition.offset < offset) {
                        return null;
                    }
                    if (level.fSecondPosition.offset == offset && length == 0) {
                        return new LinkedModeUI.ExitFlags(2, false);
                    }
                }
                if (event.character == '\r' && offset > 0) {
                    IDocument document = GroovyEditor.this.getSourceViewer().getDocument();
                    try {
                        if (document.getChar(offset - 1) == '{') {
                            return new LinkedModeUI.ExitFlags(1, true);
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }
            return null;
        }

        private boolean isMasked(int offset) {
            IDocument document = GroovyEditor.this.getSourceViewer().getDocument();
            try {
                return this.fEscapeCharacter == document.getChar(offset - 1);
            }
            catch (BadLocationException badLocationException) {
                return false;
            }
        }
    }
}

