/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.launchers;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.codehaus.groovy.eclipse.GroovyPlugin;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.groovy.eclipse.core.compiler.CompilerUtils;
import org.codehaus.groovy.eclipse.launchers.LaunchShortcutHelper;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.codehaus.jdt.groovy.model.GroovyProjectFacade;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.groovy.core.util.ScriptFolderSelector;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.viewsupport.JavaUILabelProvider;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.osgi.framework.Version;

public abstract class AbstractGroovyLaunchShortcut
implements ILaunchShortcut {
    public static final String GROOVY_TYPE_TO_RUN = "org.codehaus.groovy.eclipse.launch.runType";

    protected abstract ILaunchConfigurationType getGroovyLaunchConfigType();

    protected abstract String applicationOrConsole();

    protected abstract boolean canLaunchWithNoType();

    protected String classToRun() {
        throw new IllegalStateException(String.valueOf(this.getClass().getSimpleName()) + " must override classToRun() or mainArgs(IType,IJavaProject)");
    }

    protected String mainArgs(IType runType, IJavaProject javaProject) {
        StringBuilder mainArgs = new StringBuilder(this.classToRun());
        if (runType != null) {
            try {
                mainArgs.append(" \"${workspace_loc:").append(runType.getResource().getFullPath().toOSString().substring(1)).append("}\"");
            }
            catch (NullPointerException e) {
                GroovyCore.logException((String)LaunchShortcutHelper.bind((String)LaunchShortcutHelper.GroovyLaunchShortcut_failureToLaunch, (Object)this.applicationOrConsole()), (Throwable)new IllegalArgumentException(LaunchShortcutHelper.bind((String)LaunchShortcutHelper.GroovyLaunchShortcut_notFound, (Object)runType.getElementName())));
            }
        }
        return mainArgs.toString();
    }

    public void launch(IEditorPart editor, String mode) {
        ICompilationUnit unit = (ICompilationUnit)Adapters.adapt((Object)editor, GroovyCompilationUnit.class);
        if (unit != null) {
            this.launchGroovy(unit, unit.getJavaProject(), mode);
        }
    }

    public void launch(ISelection selection, String mode) {
        IJavaProject javaProject;
        IJavaElement element;
        ICompilationUnit unit = null;
        if (selection instanceof IStructuredSelection && (element = (IJavaElement)Adapters.adapt((Object)((IStructuredSelection)selection).getFirstElement(), IJavaElement.class)) != null) {
            IType type = (IType)element.getAncestor(7);
            if (type != null) {
                this.launchGroovy(type, type.getJavaProject(), mode);
                return;
            }
            unit = (ICompilationUnit)element.getAncestor(5);
        }
        if ((javaProject = unit != null ? unit.getJavaProject() : this.extractJavaProject(selection)) != null && (unit != null || this.canLaunchWithNoType())) {
            this.launchGroovy(unit, javaProject, mode);
        } else {
            MessageDialog.openError((Shell)GroovyPlugin.getActiveWorkbenchShell(), (String)LaunchShortcutHelper.GroovyLaunchShortcut_noSelection, (String)(javaProject != null ? LaunchShortcutHelper.GroovyLaunchShortcut_noSelection0 : LaunchShortcutHelper.GroovyLaunchShortcut_noSelection1));
        }
    }

    private IJavaProject extractJavaProject(ISelection selection) {
        IStructuredSelection struct;
        Object obj;
        if (selection instanceof IStructuredSelection && (obj = (struct = (IStructuredSelection)selection).getFirstElement()) instanceof IAdaptable) {
            IJavaProject javaProject = (IJavaProject)Adapters.adapt((Object)obj, IJavaProject.class);
            if (javaProject != null) {
                return javaProject;
            }
            IProject project = (IProject)Adapters.adapt((Object)obj, IProject.class);
            if (project != null) {
                return JavaCore.create((IProject)project);
            }
        }
        return null;
    }

    protected void launchGroovy(ICompilationUnit unit, IJavaProject javaProject, String mode) {
        IType runType;
        block5: {
            runType = null;
            if (unit != null) {
                try {
                    IType[] types = (IType[])Arrays.stream(unit.getAllTypes()).filter(GroovyProjectFacade::hasGroovyMainMethod).toArray(IType[]::new);
                    if (types.length == 1) {
                        runType = types[0];
                        break block5;
                    }
                    if (types.length > 1) {
                        runType = LaunchShortcutHelper.chooseFromList(Arrays.asList(types), (ILabelProvider)new JavaUILabelProvider(), LaunchShortcutHelper.SelectMainTypeDialog_title, LaunchShortcutHelper.SelectMainTypeDialog_message);
                        break block5;
                    }
                    MessageDialog.openError((Shell)GroovyPlugin.getActiveWorkbenchShell(), (String)LaunchShortcutHelper.GroovyLaunchShortcut_noSelection, (String)LaunchShortcutHelper.bind((String)LaunchShortcutHelper.GroovyLaunchShortcut_notRunnable, (Object)this.applicationOrConsole()));
                    return;
                }
                catch (JavaModelException e) {
                    GroovyCore.logException((String)LaunchShortcutHelper.bind((String)LaunchShortcutHelper.GroovyLaunchShortcut_failureToLaunch, (Object)this.applicationOrConsole()), (Throwable)e);
                    return;
                }
            }
        }
        this.launchGroovy(runType, javaProject, mode);
    }

    protected void launchGroovy(IType runType, IJavaProject javaProject, String mode) {
        try {
            boolean excludeTestCode = runType != null && !AbstractGroovyLaunchShortcut.hasTestAttribute((IJavaElement)runType);
            Map<String, String> launchProperties = this.createLaunchProperties(runType, javaProject);
            String launchName = runType != null ? runType.getElementName() : javaProject.getElementName();
            ILaunchConfigurationWorkingCopy workingCopy = this.findOrCreateLaunchConfig(launchProperties, launchName);
            ArrayList<String> classpath = new ArrayList<String>();
            classpath.add(JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)CompilerUtils.getExportedGroovyAllJar()).getMemento());
            for (IPath jarPath : CompilerUtils.getExtraJarsForClasspath()) {
                classpath.add(JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)jarPath).getMemento());
            }
            Enumeration jarUrls = CompilerUtils.getActiveGroovyBundle().findEntries("lib/" + this.applicationOrConsole().toLowerCase(), "*.jar", false);
            if (jarUrls != null) {
                for (URL jarUrl : Collections.list(jarUrls)) {
                    classpath.add(JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)new Path(FileLocator.toFileURL((URL)jarUrl).getPath())).getMemento());
                }
            }
            ArrayList<String> sourcepath = new ArrayList<String>();
            IRuntimeClasspathEntry[] iRuntimeClasspathEntryArray = JavaRuntime.computeUnresolvedRuntimeClasspath((IJavaProject)javaProject, (boolean)excludeTestCode);
            int n = iRuntimeClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IRuntimeClasspathEntry entry = iRuntimeClasspathEntryArray[n2];
                sourcepath.add(entry.getMemento());
                ++n2;
            }
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, classpath);
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_SOURCE_PATH, sourcepath);
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, false);
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_SOURCE_PATH, false);
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_EXCLUDE_TEST_CODE, excludeTestCode);
            ILaunchConfiguration config = workingCopy.doSave();
            DebugUITools.launch((ILaunchConfiguration)config, (String)mode);
        }
        catch (Exception e) {
            GroovyCore.logException((String)LaunchShortcutHelper.bind((String)LaunchShortcutHelper.GroovyLaunchShortcut_failureToLaunch, (Object)this.applicationOrConsole()), (Throwable)e);
        }
    }

    protected Map<String, String> createLaunchProperties(IType runType, IJavaProject javaProject) {
        HashMap<String, String> launchConfigProperties = new HashMap<String, String>();
        launchConfigProperties.put(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, "org.codehaus.groovy.tools.GroovyStarter");
        launchConfigProperties.put(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, javaProject.getElementName());
        launchConfigProperties.put(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, "-Dgroovy.home=\"${groovy_home}\" -Djava.system.class.loader=groovy.lang.GroovyClassLoader");
        launchConfigProperties.put(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, "--classpath " + this.getRuntimeClasspath(runType, javaProject) + " --main " + this.mainArgs(runType, javaProject));
        launchConfigProperties.put(IJavaLaunchConfigurationConstants.ATTR_WORKING_DIRECTORY, this.getWorkingDirectory(runType, javaProject));
        launchConfigProperties.put(GROOVY_TYPE_TO_RUN, Optional.ofNullable(runType).map(IType::getFullyQualifiedName).orElse(""));
        return launchConfigProperties;
    }

    private String getRuntimeClasspath(IType runType, IJavaProject javaProject) {
        LinkedHashSet<IPath> classpath = new LinkedHashSet<IPath>();
        LinkedHashSet<IJavaProject> done = new LinkedHashSet<IJavaProject>();
        LinkedList<IJavaProject> todo = new LinkedList<IJavaProject>(Arrays.asList(javaProject));
        try {
            boolean excludeTestCode;
            boolean bl = excludeTestCode = runType != null && !AbstractGroovyLaunchShortcut.hasTestAttribute((IJavaElement)runType);
            do {
                IJavaProject nextProject;
                if (!done.add(nextProject = (IJavaProject)todo.removeFirst()) || !nextProject.getProject().isAccessible()) continue;
                IClasspathEntry[] iClasspathEntryArray = nextProject.getRawClasspath();
                int n = iClasspathEntryArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IClasspathEntry entry = iClasspathEntryArray[n2];
                    if (!(excludeTestCode && entry.isTest() || entry.getEntryKind() == 5 && ("GROOVY_DSL_SUPPORT".equals(entry.getPath().segment(0)) || JavaRuntime.JRE_CONTAINER.equals(entry.getPath().segment(0))))) {
                        switch (entry.getEntryKind()) {
                            case 3: {
                                if (entry.getOutputLocation() != null) {
                                    classpath.add(entry.getOutputLocation());
                                } else {
                                    classpath.add(nextProject.getOutputLocation());
                                }
                            }
                            case 1: {
                                classpath.add(entry.getPath());
                                break;
                            }
                            case 4: {
                                entry = JavaCore.getResolvedClasspathEntry((IClasspathEntry)entry);
                                if (entry == null) break;
                                classpath.add(entry.getPath());
                                break;
                            }
                            case 2: {
                                String projectName = entry.getPath().segment(0);
                                todo.add(javaProject.getJavaModel().getJavaProject(projectName));
                                break;
                            }
                            case 5: {
                                IClasspathContainer container = JavaCore.getClasspathContainer((IPath)entry.getPath(), (IJavaProject)nextProject);
                                Arrays.stream(container.getClasspathEntries()).filter(it -> !excludeTestCode || !it.isTest()).map(IClasspathEntry::getPath).forEach(classpath::add);
                            }
                        }
                    }
                    ++n2;
                }
            } while (!todo.isEmpty());
        }
        catch (JavaModelException e) {
            GroovyCore.logException((String)LaunchShortcutHelper.bind((String)LaunchShortcutHelper.GroovyLaunchShortcut_classpathError, (Object)this.applicationOrConsole()), (Throwable)e);
        }
        StringBuilder sb = new StringBuilder();
        for (IPath path : classpath) {
            if (path.isEmpty()) {
                sb.append("${workspace_loc}");
            } else {
                path = path.makeAbsolute();
                if (!ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0)).exists()) {
                    sb.append(path.toOSString());
                } else {
                    sb.append("${workspace_loc:").append(path.segment(0)).append('}');
                    if (path.segmentCount() > 1) {
                        sb.append(File.separatorChar).append(path.removeFirstSegments(1).toOSString());
                    }
                }
            }
            sb.append(File.pathSeparatorChar);
        }
        if (sb.length() > 0) {
            sb.insert(0, '\"').deleteCharAt(sb.length() - 1).append('\"');
        }
        return sb.toString();
    }

    private String getWorkingDirectory(IType runType, IJavaProject javaProject) {
        String workingDirPreference;
        switch (workingDirPreference = GroovyPlugin.getDefault().getPreferenceStore().getString("groovy.scripts.workingdir")) {
            case "eclipse_home": {
                return "${eclipse_home}";
            }
            case "script_loc": {
                if (runType == null) break;
                try {
                    return "${workspace_loc:" + runType.getResource().getParent().getFullPath().toOSString().substring(1) + "}";
                }
                catch (Exception e) {
                    GroovyCore.logException((String)LaunchShortcutHelper.bind((String)LaunchShortcutHelper.GroovyLaunchShortcut_notFound, (Object)runType.getElementName()), (Throwable)e);
                }
            }
        }
        return null;
    }

    protected ILaunchConfigurationWorkingCopy findOrCreateLaunchConfig(Map<String, String> launchProperties, String launchName) throws CoreException {
        ILaunchConfiguration config = this.findConfiguration(launchProperties.get(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME), launchProperties.get(GROOVY_TYPE_TO_RUN));
        if (config == null) {
            return this.createLaunchConfig(launchProperties, launchName);
        }
        ILaunchConfigurationWorkingCopy workingCopy = config.getWorkingCopy();
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, launchProperties.get(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS));
        return workingCopy;
    }

    private ILaunchConfigurationWorkingCopy createLaunchConfig(Map<String, String> launchProperties, String launchName) throws CoreException {
        ILaunchConfigurationWorkingCopy workingCopy = this.getGroovyLaunchConfigType().newInstance(null, AbstractGroovyLaunchShortcut.getLaunchManager().generateLaunchConfigurationName(launchName));
        for (Map.Entry<String, String> entry : launchProperties.entrySet()) {
            workingCopy.setAttribute(entry.getKey(), entry.getValue());
        }
        return workingCopy;
    }

    private ILaunchConfiguration findConfiguration(String projectName, String mainTypeName) throws CoreException {
        ILaunchConfiguration[] configs;
        ILaunchConfiguration returnValue = null;
        ILaunchConfigurationType configType = this.getGroovyLaunchConfigType();
        ArrayList<ILaunchConfiguration> candidateConfigs = new ArrayList<ILaunchConfiguration>();
        ILaunchConfiguration[] iLaunchConfigurationArray = configs = AbstractGroovyLaunchShortcut.getLaunchManager().getLaunchConfigurations(configType);
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfiguration config = iLaunchConfigurationArray[n2];
            if (config.getAttribute(GROOVY_TYPE_TO_RUN, "").equals(mainTypeName) && config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "").equals(projectName)) {
                candidateConfigs.add(config);
            }
            ++n2;
        }
        int candidateCount = candidateConfigs.size();
        if (candidateCount == 1) {
            returnValue = (ILaunchConfiguration)candidateConfigs.get(0);
        } else if (candidateCount > 1) {
            returnValue = this.chooseConfiguration(candidateConfigs);
        }
        return returnValue;
    }

    private ILaunchConfiguration chooseConfiguration(List<ILaunchConfiguration> configList) {
        return LaunchShortcutHelper.chooseFromList(configList, (ILabelProvider)DebugUITools.newDebugModelPresentation(), LaunchShortcutHelper.bind((String)LaunchShortcutHelper.GroovyLaunchShortcut_title, (Object)this.applicationOrConsole()), LaunchShortcutHelper.bind((String)LaunchShortcutHelper.GroovyLaunchShortcut_message, (Object)this.applicationOrConsole()));
    }

    protected static ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    protected static boolean hasTestAttribute(IJavaElement element) throws JavaModelException {
        return element.getJavaProject().isOnClasspath(element) && JavaModelUtil.getPackageFragmentRoot((IJavaElement)element).getResolvedClasspathEntry().isTest();
    }

    protected static boolean isAtLeastGroovy(int major, int minor, int micro) {
        Version target;
        Version active = CompilerUtils.getActiveGroovyBundle().getVersion();
        return active.compareTo(target = new Version(major, minor, micro)) >= 0;
    }

    protected static boolean matchesScriptFilter(IResource resource) {
        return new ScriptFolderSelector(resource.getProject()).isScript(resource);
    }
}

