/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.preferences;

import java.util.Arrays;
import org.codehaus.groovy.eclipse.GroovyPlugin;
import org.codehaus.groovy.eclipse.debug.ui.GroovyDebugOptionsEnforcer;
import org.codehaus.groovy.eclipse.preferences.FieldEditorOverlayPage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.ListEditor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.PreferenceLinkArea;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.ui.progress.UIJob;

public class DebuggerPreferencesPage
extends FieldEditorOverlayPage
implements IWorkbenchPreferencePage {
    private boolean doForceOptions;

    public DebuggerPreferencesPage() {
        super(1);
        this.setPreferenceStore(GroovyPlugin.getDefault().getPreferenceStore());
    }

    protected void createFieldEditors() {
        this.addField((FieldEditor)new BooleanFieldEditor("groovy.debug.filter.stack", "Shade internal Groovy stack frames while debugging", this.getFieldEditorParent()));
        this.addField((FieldEditor)new PackageChooserListEditor("groovy.debug.filter.list", "Prefixes of the filtered packages:", this.getFieldEditorParent()));
        PreferenceLinkArea area = new PreferenceLinkArea(this.getFieldEditorParent(), 64, "org.eclipse.jdt.debug.ui.JavaStepFilterPreferencePage", " \n\nStack frame filtering works best when it is combined with step filters.\nUsing step filters, Groovy internal stack frames are ignored\nwhen stepping through instructions in the debugger.  \n\nYou can <a>edit step filters...</a>\n\nOr you can add step filtering automatically by clicking below.", (IWorkbenchPreferenceContainer)this.getContainer(), null);
        GridData data = new GridData(4, 0x1000000, false, false);
        area.getControl().setLayoutData((Object)data);
        Composite c1 = new Composite(this.getFieldEditorParent(), 0);
        Button forceDebugOptions = new Button(this.getFieldEditorParent(), 8);
        forceDebugOptions.setText("Automatically configure common Groovy step filtering");
        forceDebugOptions.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                DebuggerPreferencesPage.this.doForceOptions = true;
                new GroovyDebugOptionsEnforcer().force();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                DebuggerPreferencesPage.this.doForceOptions = true;
                new GroovyDebugOptionsEnforcer().force();
            }
        });
        Composite c2 = new Composite(this.getFieldEditorParent(), 0);
    }

    @Override
    protected String getPageId() {
        return "org.codehaus.groovy.eclipse.preferences.debugger";
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        if (this.doForceOptions) {
            UIJob job = new UIJob(this.getShell().getDisplay(), "Setting Groovy debug options"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    new GroovyDebugOptionsEnforcer().force();
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
        return super.performOk();
    }

    private class PackageChooserListEditor
    extends ListEditor {
        PackageChooserListEditor(String name, String labelText, Composite parent) {
            super(name, labelText, parent);
            this.setPreferenceStore(DebuggerPreferencesPage.this.getPreferenceStore());
        }

        protected String createList(String[] items) {
            if (items != null && items.length > 0) {
                Arrays.sort(items);
                StringBuilder sb = new StringBuilder();
                int i = 0;
                while (i < items.length) {
                    if (i > 0) {
                        sb.append(",");
                    }
                    sb.append(items[i]);
                    ++i;
                }
                return sb.toString();
            }
            return "";
        }

        public Composite getButtonBoxControl(Composite parent) {
            Composite c = super.getButtonBoxControl(parent);
            this.getUpButton().setVisible(false);
            this.getDownButton().setVisible(false);
            return c;
        }

        protected String getNewInputObject() {
            InputDialog dialog = new InputDialog(DebuggerPreferencesPage.this.getFieldEditorParent().getShell(), "Add new package to filter", "Add a package or a package prefix to grey out in the Debug view", "", (IInputValidator)new PackagePrefixValidator());
            int res = dialog.open();
            if (res == 0) {
                return dialog.getValue();
            }
            return null;
        }

        protected String[] parseString(String stringList) {
            Object[] split = stringList.split(",");
            Arrays.sort(split);
            return split;
        }
    }

    private static class PackagePrefixValidator
    implements IInputValidator {
        private PackagePrefixValidator() {
        }

        public String isValid(String newText) {
            if (newText.trim().length() == 0) {
                return "";
            }
            IStatus s = JavaConventions.validatePackageName((String)newText, (String)"1.3", (String)"1.3");
            if (s.getSeverity() > 0) {
                return s.getMessage();
            }
            return null;
        }
    }
}

