/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.preferences;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.groovy.eclipse.preferences.Messages;
import org.codehaus.jdt.groovy.model.GroovyNature;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.groovy.core.Activator;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.internal.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.CheckedListDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ScriptFolderSelectorPreferences {
    private static final int IDX_ADD = 0;
    private static final int IDX_EDIT = 1;
    private static final int IDX_REMOVE = 2;
    private static final int IDX_CHECKALL = 3;
    private static final int IDX_UNCHECKALL = 4;
    private static final String[] BUTTON_LABELS = new String[]{Messages.getString("GroovyCompilerPreferencesPage.ScriptFolders.Add"), Messages.getString("GroovyCompilerPreferencesPage.ScriptFolders.Edit"), Messages.getString("GroovyCompilerPreferencesPage.ScriptFolders.Remove"), Messages.getString("GroovyCompilerPreferencesPage.ScriptFolders.CheckAll"), Messages.getString("GroovyCompilerPreferencesPage.ScriptFolders.UncheckAll")};
    private static final ImageDescriptor DESCRIPTOR = JavaPluginImages.DESC_OBJS_INCLUSION_FILTER_ATTRIB;
    private final Composite parent;
    private final IEclipsePreferences preferences;
    private final IPreferenceStore store;
    private final IProject project;
    private CheckedListDialogField<String> patternList;
    private BooleanFieldEditor disableButton;
    private boolean hasChanges;

    public ScriptFolderSelectorPreferences(Composite parent, IEclipsePreferences preferences, IPreferenceStore store, IProject project) {
        this.parent = parent;
        this.preferences = preferences;
        this.store = store;
        this.project = project;
    }

    public ListDialogField<String> createListContents() {
        Group group = new Group(this.parent, 32);
        group.setFont(this.parent.getFont());
        group.setLayout((Layout)new GridLayout());
        group.setText(Messages.getString("GroovyCompilerPreferencesPage.ScriptFoldersLabel"));
        GridDataFactory.swtDefaults().align(4, 128).grab(true, false).indent(0, 7).applyTo((Control)group);
        this.disableButton = new BooleanFieldEditor("groovy.script.filters.enabled", Messages.getString("GroovyCompilerPreferencesPage.ScriptFoldersToggle"), new Composite((Composite)group, 0));
        this.disableButton.setPreferenceStore(this.store);
        this.disableButton.setPropertyChangeListener(event -> {
            Object value;
            if (event.getProperty() == "field_editor_value" && (value = event.getNewValue()) instanceof Boolean) {
                this.enablePatternList((Boolean)value);
            }
            this.hasChanges = true;
        });
        this.disableButton.load();
        ScriptPatternAdapter adapter = new ScriptPatternAdapter();
        this.patternList = new CheckedListDialogField((IListAdapter)adapter, BUTTON_LABELS, (ILabelProvider)new ScriptLabelProvider(DESCRIPTOR));
        this.patternList.setDialogFieldListener((IDialogFieldListener)adapter);
        this.patternList.setLabelText(Messages.getString("GroovyCompilerPreferencesPage.ScriptFoldersHelpText"));
        this.patternList.enableButton(0, true);
        this.patternList.enableButton(1, false);
        this.patternList.setRemoveButtonIndex(2);
        this.patternList.setCheckAllButtonIndex(3);
        this.patternList.setUncheckAllButtonIndex(4);
        Composite panel = new Composite((Composite)group, 0);
        panel.setLayout((Layout)new GridLayout(3, false));
        panel.setLayoutData((Object)new GridData(4, 128, true, false));
        this.patternList.doFillIntoGrid(panel, 3);
        GridDataFactory.swtDefaults().align(4, 128).grab(true, false).hint(200, -1).applyTo((Control)this.patternList.getLabelControl(panel));
        this.populatePatternList(Activator.getDefault().getScriptFilters(this.preferences));
        this.patternList.setViewerComparator(new ViewerComparator());
        this.enablePatternList(this.disableButton.getBooleanValue());
        return this.patternList;
    }

    protected void doCustomButtonPressed(ListDialogField<String> field, int index) {
        if (index == 0) {
            this.addEntry(field);
        } else if (index == 1) {
            this.editEntry(field);
        }
    }

    protected void doSelectionChanged(ListDialogField<String> field) {
        List selected = field.getSelectedElements();
        field.enableButton(1, this.canEdit(selected));
    }

    protected void doDoubleClicked(ListDialogField<String> field) {
        this.editEntry(field);
    }

    private boolean canEdit(List<String> selected) {
        return selected.size() == 1;
    }

    private void addEntry(ListDialogField<String> field) {
        InputDialog dialog = this.createInputDialog("");
        if (dialog.open() == 0) {
            field.addElement((Object)dialog.getValue());
        }
    }

    private InputDialog createInputDialog(String initial) {
        InputDialog dialog = new InputDialog(this.parent.getShell(), Messages.getString("GroovyCompilerPreferencesPage.ScriptFolders.New1"), Messages.getString("GroovyCompilerPreferencesPage.ScriptFolders.New2"), initial, null);
        return dialog;
    }

    private void editEntry(ListDialogField<String> field) {
        List selElements = field.getSelectedElements();
        if (selElements.size() != 1) {
            return;
        }
        String entry = (String)selElements.get(0);
        InputDialog dialog = this.createInputDialog(entry);
        if (dialog.open() == 0) {
            field.replaceElement((Object)entry, (Object)dialog.getValue());
        }
    }

    public void applyPreferences() {
        if (!this.hasChanges) {
            return;
        }
        this.hasChanges = false;
        this.disableButton.store();
        List elts = this.patternList.getElements();
        ArrayList<String> result = new ArrayList<String>(elts.size() * 2);
        for (String elt : elts) {
            result.add(elt);
            result.add(this.patternList.isChecked((Object)elt) ? "y" : "n");
        }
        Activator.getDefault().setScriptFilters(this.preferences, result);
        boolean yesNo = MessageDialog.openQuestion((Shell)this.parent.getShell(), (String)Messages.getString("GroovyCompilerPreferencesPage.ScriptFolders.Rebuild1"), (String)Messages.getString("GroovyCompilerPreferencesPage.ScriptFolders.Rebuild2"));
        if (yesNo) {
            if (this.project != null) {
                new BuildJob(this.project).schedule();
            } else {
                new BuildJob(GroovyNature.getAllAccessibleGroovyProjects().toArray(new IProject[0])).schedule();
            }
        }
    }

    public void enableControls() {
        this.enablePatternList(this.disableButton.getBooleanValue());
    }

    public void restoreDefaults() {
        this.populatePatternList(Arrays.asList("**/*.dsld,y,**/*.gradle,n".split(",")));
        this.disableButton.loadDefault();
        this.hasChanges = true;
    }

    private void enablePatternList(boolean enabled) {
        this.patternList.getListControl(null).setEnabled(enabled);
        this.patternList.getLabelControl(null).setEnabled(enabled);
    }

    private void populatePatternList(List<String> elements) {
        ArrayList<String> filteredElements = new ArrayList<String>(elements.size() / 2);
        ArrayList<String> checkedElements = new ArrayList<String>(elements.size() / 2);
        Iterator<String> eltIter = elements.iterator();
        while (eltIter.hasNext()) {
            String elt = eltIter.next();
            filteredElements.add(elt);
            if (!eltIter.hasNext() || !"y".equals(eltIter.next())) continue;
            checkedElements.add(elt);
        }
        this.patternList.setElements(filteredElements);
        this.patternList.setCheckedElements(checkedElements);
    }

    private static class BuildJob
    extends Job {
        private IProject[] projects;

        BuildJob(IProject ... projects) {
            super(BuildJob.getName(projects));
            this.projects = projects;
        }

        private static String getName(IProject ... projects) {
            if (projects.length == 1) {
                return "Building project " + projects[0].getName();
            }
            StringBuilder sb = new StringBuilder();
            sb.append("Building projects ");
            IProject[] iProjectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                sb.append(String.valueOf(project.getName()) + " ");
                ++n2;
            }
            return sb.toString();
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                SubMonitor submon = SubMonitor.convert((IProgressMonitor)monitor, (int)this.projects.length);
                IProject[] iProjectArray = this.projects;
                int n = this.projects.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject project = iProjectArray[n2];
                    project.build(6, (IProgressMonitor)submon);
                    submon.worked(1);
                    ++n2;
                }
                return Status.OK_STATUS;
            }
            catch (CoreException e) {
                GroovyCore.logException((String)"Error building groovy project", (Throwable)e);
                return e.getStatus();
            }
        }
    }

    private static class ScriptLabelProvider
    extends LabelProvider {
        private Image fElementImage;

        ScriptLabelProvider(ImageDescriptor descriptor) {
            ImageDescriptorRegistry registry = JavaPlugin.getImageDescriptorRegistry();
            this.fElementImage = registry.get(descriptor);
        }

        public Image getImage(Object element) {
            return this.fElementImage;
        }

        public String getText(Object element) {
            return BasicElementLabels.getFilePattern((String)((String)element));
        }
    }

    private class ScriptPatternAdapter
    implements IListAdapter<String>,
    IDialogFieldListener {
        private ScriptPatternAdapter() {
        }

        public void customButtonPressed(ListDialogField<String> field, int index) {
            ScriptFolderSelectorPreferences.this.doCustomButtonPressed(field, index);
            ScriptFolderSelectorPreferences.this.hasChanges = true;
        }

        public void selectionChanged(ListDialogField<String> field) {
            ScriptFolderSelectorPreferences.this.doSelectionChanged(field);
        }

        public void doubleClicked(ListDialogField<String> field) {
            ScriptFolderSelectorPreferences.this.doDoubleClicked(field);
            ScriptFolderSelectorPreferences.this.hasChanges = true;
        }

        public void dialogFieldChanged(DialogField field) {
            ScriptFolderSelectorPreferences.this.hasChanges = true;
        }
    }
}

