/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.refactoring.actions;

import java.beans.Introspector;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.MethodCall;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.NamedArgumentListExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.eclipse.GroovyPlugin;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.ASTFragmentKind;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.IASTFragment;
import org.codehaus.groovy.eclipse.codebrowsing.requestor.ASTNodeFinder;
import org.codehaus.groovy.eclipse.codebrowsing.requestor.Region;
import org.codehaus.groovy.eclipse.codebrowsing.selection.FindSurroundingNode;
import org.codehaus.groovy.eclipse.editor.GroovyEditor;
import org.codehaus.groovy.transform.stc.StaticTypesMarker;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.codehaus.jdt.groovy.model.ModuleNodeMapper;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.groovy.search.ITypeRequestor;
import org.eclipse.jdt.groovy.search.TypeInferencingVisitorFactory;
import org.eclipse.jdt.groovy.search.TypeLookupResult;
import org.eclipse.jdt.internal.ui.util.ElementValidator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.UndoEdit;

public class ConvertToPropertyAction
extends Action {
    private final GroovyEditor editor;

    public ConvertToPropertyAction(GroovyEditor editor) {
        this.editor = editor;
        this.setText("Replace Accessor call with Property read/write");
        this.setActionDefinitionId("org.codehaus.groovy.eclipse.ui.convertToProperty");
    }

    public void run() {
        if (!this.editor.validateEditorInputState()) {
            return;
        }
        ISelection selection = this.editor.getSelectionProvider().getSelection();
        if (!(selection instanceof ITextSelection)) {
            return;
        }
        GroovyCompilationUnit gcu = this.editor.getGroovyCompilationUnit();
        if (!ElementValidator.checkValidateEdit((IJavaElement)gcu, (Shell)this.editor.getSite().getShell(), (String)"Convert to Property")) {
            return;
        }
        try {
            TextEdit edit = ConvertToPropertyAction.createEdit(gcu, ((ITextSelection)selection).getOffset(), ((ITextSelection)selection).getLength());
            if (edit != null) {
                gcu.applyTextEdit(edit, null);
            }
        }
        catch (Exception e) {
            GroovyPlugin.getDefault().logError("Failure in convert to property", e);
        }
    }

    public static TextEdit createEdit(GroovyCompilationUnit gcu, int idx, int len) {
        ModuleNodeMapper.ModuleNodeInfo info = gcu.getModuleInfo(true);
        if (!info.isEmpty()) {
            StaticMethodCallExpression call = null;
            ASTNode node = new ASTNodeFinder(new Region(idx, len)).doVisit(info.module);
            if (node instanceof ConstantExpression) {
                MethodCallExpression expr;
                IASTFragment fragment = new FindSurroundingNode(new Region(node)).doVisitSurroundingNode(info.module);
                if (fragment.kind() == ASTFragmentKind.METHOD_CALL && (expr = (MethodCallExpression)fragment.getAssociatedNode()) != null && !expr.isUsingGenerics()) {
                    call = expr;
                }
            } else if (node instanceof StaticMethodCallExpression) {
                call = (StaticMethodCallExpression)node;
            }
            if (call != null && call.getArguments() instanceof TupleExpression) {
                Matcher match;
                TupleExpression args = (TupleExpression)call.getArguments();
                if (args.getExpressions().isEmpty() && (match = Pattern.compile("(?:get|is)(\\p{javaJavaIdentifierPart}+)").matcher(call.getMethodAsString())).matches()) {
                    int offset = node.getStart();
                    int length = args.getEnd() + 1 - offset;
                    String propertyName = match.group(1);
                    ReplaceEdit edit = new ReplaceEdit(offset, length, Introspector.decapitalize(propertyName));
                    if (call.getReceiver().getEnd() < 1 && ConvertToPropertyAction.isTypeChange((TextEdit)edit, node, gcu)) {
                        edit = new ReplaceEdit(offset, length, String.valueOf(ConvertToPropertyAction.getReceiver((MethodCall)call)) + "." + Introspector.decapitalize(propertyName));
                    }
                    return edit;
                }
                if (args.getExpressions().size() == 1 && (match = Pattern.compile("set(\\p{javaJavaIdentifierPart}+)").matcher(call.getMethodAsString())).matches()) {
                    boolean rparen;
                    int offset = node.getStart();
                    int length = args.getStart() - offset;
                    String propertyName = match.group(1);
                    MultiTextEdit edit = new MultiTextEdit();
                    Map options = gcu.getJavaProject().getOptions(true);
                    StringBuilder replacement = new StringBuilder(Introspector.decapitalize(propertyName));
                    if ("insert".equals(options.get("org.eclipse.jdt.core.formatter.insert_space_before_assignment_operator"))) {
                        replacement.append(' ');
                    }
                    replacement.append('=');
                    if ("insert".equals(options.get("org.eclipse.jdt.core.formatter.insert_space_after_assignment_operator"))) {
                        replacement.append(' ');
                    }
                    if (args.getExpression(0) instanceof NamedArgumentListExpression) {
                        replacement.append('[');
                    }
                    edit.addChild((TextEdit)new ReplaceEdit(offset, length, replacement.toString()));
                    boolean bl = rparen = args.getEnd() < gcu.getContents().length && gcu.getContents()[args.getEnd()] == ')';
                    if (args.getExpression(0) instanceof NamedArgumentListExpression) {
                        edit.addChild((TextEdit)(rparen ? new ReplaceEdit(args.getEnd(), 1, "]") : new InsertEdit(args.getEnd(), "]")));
                    } else if (rparen) {
                        edit.addChild((TextEdit)new DeleteEdit(args.getEnd(), 1));
                    }
                    if (call.getReceiver().getEnd() < 1 && ConvertToPropertyAction.isTypeChange((TextEdit)edit, node, gcu)) {
                        edit.removeChild(0);
                        replacement.insert(0, String.valueOf(ConvertToPropertyAction.getReceiver((MethodCall)call)) + ".");
                        edit.addChild((TextEdit)new ReplaceEdit(offset, length, replacement.toString()));
                    }
                    return edit;
                }
            }
        }
        return null;
    }

    private static String getReceiver(MethodCall call) {
        String receiver = (String)((ASTNode)call).getNodeMetaData((Object)StaticTypesMarker.IMPLICIT_RECEIVER);
        if (receiver == null) {
            receiver = call.getReceiver().getText();
        }
        return receiver;
    }

    private static boolean isTypeChange(TextEdit edit, ASTNode node, GroovyCompilationUnit unit) {
        try {
            TypeLookupResult before = ConvertToPropertyAction.lookupNodeType(node, unit);
            UndoEdit undo = unit.applyTextEdit(edit.copy(), null);
            TypeLookupResult after = ConvertToPropertyAction.lookupNodeType(new ASTNodeFinder(new Region(node.getStart(), 0)).doVisit(unit.getModuleNode()), unit);
            unit.applyTextEdit((TextEdit)undo, null);
            if (!before.declaringType.equals((Object)after.declaringType) || after.declaration instanceof Variable && !(after.declaration instanceof FieldNode) && !(after.declaration instanceof PropertyNode)) {
                if (!before.scope.getThis().isDerivedFrom(before.declaringType)) {
                    ASTNode call = node instanceof MethodCall ? node : before.scope.getEnclosingNode();
                    call.getNodeMetaData((Object)StaticTypesMarker.IMPLICIT_RECEIVER, x -> typeLookupResult.declaringType.equals((Object)typeLookupResult.scope.getDelegate()) ? "delegate" : "owner");
                }
                return true;
            }
        }
        catch (Exception e) {
            GroovyPlugin.getDefault().logError("Failure in convert to property type inference", e);
        }
        return false;
    }

    private static TypeLookupResult lookupNodeType(ASTNode node, GroovyCompilationUnit unit) {
        TypeLookupResult[] result = new TypeLookupResult[1];
        new TypeInferencingVisitorFactory().createVisitor(unit).visitCompilationUnit((n, r, x) -> {
            if (n == node) {
                typeLookupResultArray[0] = r;
                return ITypeRequestor.VisitStatus.STOP_VISIT;
            }
            return ITypeRequestor.VisitStatus.CONTINUE;
        });
        return result[0];
    }
}

