/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.refactoring.actions;

import org.codehaus.groovy.eclipse.refactoring.actions.AbstractGroovyCleanUp;
import org.codehaus.groovy.eclipse.refactoring.actions.FormatKind;
import org.codehaus.groovy.eclipse.refactoring.formatter.DefaultGroovyFormatter;
import org.codehaus.groovy.eclipse.refactoring.formatter.FormatterPreferences;
import org.codehaus.groovy.eclipse.refactoring.formatter.IFormatterPreferences;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.internal.corext.fix.TextEditFix;
import org.eclipse.jdt.ui.cleanup.CleanUpContext;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.text.edits.TextEdit;

public class GroovyCodeFormatCleanUp
extends AbstractGroovyCleanUp {
    private final FormatKind kind;

    public GroovyCodeFormatCleanUp(FormatKind kind) {
        this.kind = kind;
    }

    public ICleanUpFix createFix(CleanUpContext context) throws CoreException {
        ICompilationUnit unit = context.getCompilationUnit();
        if (!(unit instanceof GroovyCompilationUnit)) {
            return null;
        }
        GroovyCompilationUnit gunit = (GroovyCompilationUnit)unit;
        char[] contents = gunit.getContents();
        TextSelection sel = new TextSelection(0, contents.length);
        Document doc = new Document(new String(contents));
        boolean isIndentOnly = this.kind == FormatKind.INDENT_ONLY;
        FormatterPreferences preferences = new FormatterPreferences((ICompilationUnit)gunit);
        DefaultGroovyFormatter formatter = new DefaultGroovyFormatter((ITextSelection)sel, (IDocument)doc, (IFormatterPreferences)preferences, isIndentOnly);
        TextEdit edit = formatter.format();
        return new TextEditFix(edit, (ICompilationUnit)gunit, "Format groovy source code.");
    }

    public String[] getStepDescriptions() {
        return new String[]{"Format groovy source code."};
    }
}

