/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.wizards;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.codehaus.groovy.eclipse.GroovyPlugin;
import org.codehaus.groovy.eclipse.refactoring.core.utils.GroovyTypeBuilder;
import org.codehaus.groovy.eclipse.ui.decorators.GroovyPluginImages;
import org.codehaus.groovy.eclipse.wizards.WizardMessages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.groovy.core.util.ContentTypeUtils;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.jdt.internal.corext.refactoring.StubTypeContext;
import org.eclipse.jdt.internal.corext.refactoring.TypeContextChecker;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.jdt.internal.ui.dialogs.TableTextCellEditor;
import org.eclipse.jdt.internal.ui.dialogs.TextFieldNavigationHandler;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.CompletionContextRequestor;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.ControlContentAssistHelper;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.JavaTypeCompletionProcessor;
import org.eclipse.jdt.internal.ui.wizards.NewElementWizard;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.SuperInterfaceSelectionDialog;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogFieldGroup;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.Separator;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.wizards.NewAnnotationWizardPage;
import org.eclipse.jdt.ui.wizards.NewContainerWizardPage;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.contentassist.SubjectControlContentAssistant;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.util.BidiUtils;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.contentassist.ContentAssistHandler;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class NewTypeWizard
extends NewElementWizard {
    private IType fCreatedType;

    public NewTypeWizard() {
        this.setDefaultPageImageDescriptor(GroovyPluginImages.DESC_NEW_GROOVY_ELEMENT);
        this.setDialogSettings(JavaPlugin.getDefault().getDialogSettings());
        this.setWindowTitle(WizardMessages.NewTypeWizard_title);
    }

    public void addPages() {
        this.addPage((IWizardPage)new PageOne(this.getSelection()));
        this.addPage((IWizardPage)new PageTwo());
    }

    protected boolean canRunForked() {
        return false;
    }

    public boolean performFinish() {
        IResource resource;
        this.warnAboutTypeCommentDeprecation();
        boolean result = super.performFinish();
        if (result && (resource = this.fCreatedType.getResource()) != null) {
            this.selectAndReveal(resource);
            this.openResource((IFile)resource);
        }
        return result;
    }

    protected void finishPage(IProgressMonitor monitor) throws CoreException, InterruptedException {
        PageOne pageOne = (PageOne)this.getPage("NewTypeWizard.PageOne");
        PageTwo pageTwo = (PageTwo)this.getPage("NewTypeWizard.PageTwo");
        GroovyTypeBuilder builder = new GroovyTypeBuilder();
        builder.setPackageFragmentRoot(pageOne.getPackageFragmentRoot());
        builder.setPackageFragment(pageOne.getPackageFragment());
        builder.setEnclosingType(pageOne.getEnclosingType());
        builder.setAddComments(pageTwo.isAddComments());
        builder.setTypeFlags(pageTwo.getModifiers());
        builder.setTypeKind(pageTwo.getTypeKind());
        builder.setTypeName(pageOne.getTypeName());
        builder.setSuper(pageTwo.getSuperClass());
        builder.setFaces(pageTwo.getInterfaces());
        SelectionButtonDialogFieldGroup stubs = (SelectionButtonDialogFieldGroup)pageTwo.getActiveControl().getData("StubControls");
        if (stubs != null) {
            IDialogSettings dialogSettings = this.getDialogSettings();
            if (dialogSettings != null) {
                String sectionName = "NewClassWizardPage";
                IDialogSettings sectionSettings = dialogSettings.getSection("NewClassWizardPage");
                if (sectionSettings == null) {
                    sectionSettings = dialogSettings.addNewSection("NewClassWizardPage");
                }
                sectionSettings.put("create_constructor", stubs.isSelected(0));
                sectionSettings.put("create_unimplemented", stubs.isSelected(1));
            }
            builder.setStubs(new boolean[]{stubs.isSelected(0), stubs.isSelected(1), stubs.isSelected(2)});
        }
        this.fCreatedType = builder.build(monitor, this::finishType);
    }

    protected void finishType(IType createdType, IProgressMonitor subMonitor) throws OperationCanceledException {
        NewAnnotationWizardPage delegate = (NewAnnotationWizardPage)((PageTwo)this.getPage("NewTypeWizard.PageTwo")).getActiveControl().getData("AnnotationDelegate");
        if (delegate != null) {
            subMonitor.beginTask(NewWizardMessages.NewAnnotationWizardPage_description, 3);
            CompilationUnit astRoot = (CompilationUnit)ReflectionUtils.executePrivateMethod(NewTypeWizardPage.class, (String)"createASTForImports", (Class[])new Class[]{ICompilationUnit.class}, (Object)delegate, (Object[])new Object[]{createdType.getCompilationUnit()});
            NewTypeWizardPage.ImportsManager imports = (NewTypeWizardPage.ImportsManager)ReflectionUtils.invokeConstructor((Constructor)ReflectionUtils.getConstructor(NewTypeWizardPage.ImportsManager.class, (Class[])new Class[]{CompilationUnit.class}), (Object[])new Object[]{astRoot});
            subMonitor.worked(1);
            if (subMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            ReflectionUtils.executePrivateMethod(NewAnnotationWizardPage.class, (String)"createTypeMembers", (Class[])new Class[]{IType.class, NewTypeWizardPage.ImportsManager.class, IProgressMonitor.class}, (Object)delegate, (Object[])new Object[]{createdType, imports, ((SubMonitor)subMonitor).split(1)});
            ReflectionUtils.executePrivateMethod(NewTypeWizardPage.ImportsManager.class, (String)"create", (Class[])new Class[]{Boolean.TYPE, IProgressMonitor.class}, (Object)imports, (Object[])new Object[]{Boolean.FALSE, ((SubMonitor)subMonitor).split(1)});
        }
    }

    public IJavaElement getCreatedElement() {
        return this.fCreatedType;
    }

    public static class PageOne
    extends NewTypeWizardPage {
        public static final String PAGE_NAME = "NewTypeWizard.PageOne";
        private Runnable enclosingSelectionHandler;
        private final StatusInfo fTypeKindStatus = new StatusInfo();

        public PageOne(IStructuredSelection selection) {
            super(true, PAGE_NAME);
            this.setTitle(WizardMessages.NewTypeWizard_page1_title);
            this.setDescription(WizardMessages.NewTypeWizard_page1_message);
            IJavaElement javaElement = this.getInitialJavaElement(selection);
            this.initContainerPage(javaElement);
            this.initTypePage(javaElement);
            this.updateStatus();
        }

        public void createControl(Composite parent) {
            this.initializeDialogUnits((Control)parent);
            int nColumns = 4;
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout(4, false);
            composite.setLayout((Layout)layout);
            this.createContainerControls(composite, 4);
            this.createPackageControls(composite, 4);
            this.createEnclosingTypeControls(composite, 4);
            this.createSeparator(composite, 4);
            this.createTypeKindControls(composite, 4);
            this.createTypeNameControls(composite, 4);
            this.setControl((Control)composite);
            Dialog.applyDialogFont((Control)composite);
        }

        protected void createTypeKindControls(Composite parent, int nColumns) {
            SelectionButtonDialogFieldGroup typeKindGroup = new SelectionButtonDialogFieldGroup(16, new String[]{WizardMessages.NewTypeWizard_page1_typeKind1, WizardMessages.NewTypeWizard_page1_typeKind2, WizardMessages.NewTypeWizard_page1_typeKind3, WizardMessages.NewTypeWizard_page1_typeKind4, WizardMessages.NewTypeWizard_page1_typeKind5, WizardMessages.NewTypeWizard_page1_typeKind6, WizardMessages.NewTypeWizard_page1_typeKind7}, 4);
            typeKindGroup.setDialogFieldListener(field -> {
                int i = 0;
                while (i < 6) {
                    if (typeKindGroup.isSelected(i)) {
                        Composite nextPage = (Composite)this.getNextPage().getControl();
                        ((StackLayout)nextPage.getLayout()).topControl = nextPage.getChildren()[i];
                        nextPage.layout();
                    }
                    ++i;
                }
                if (!typeKindGroup.isSelected(2)) {
                    this.fTypeKindStatus.setOK();
                    this.updateStatus();
                }
            });
            typeKindGroup.setLabelText(WizardMessages.NewTypeWizard_page1_typeKind);
            Label label = typeKindGroup.getLabelControl(parent);
            GridDataFactory.fillDefaults().span(1, 1).applyTo((Control)label);
            Composite group = typeKindGroup.getSelectionButtonsGroup(parent);
            GridDataFactory.fillDefaults().span(nColumns - 2, 1).applyTo((Control)group);
            DialogField.createEmptySpace((Composite)parent);
            typeKindGroup.enableSelectionButton(1, this.isTraitAvailable());
            typeKindGroup.enableSelectionButton(2, this.isRecordAvailable());
            this.enclosingSelectionHandler = () -> {
                int scriptIndex = 3;
                typeKindGroup.enableSelectionButton(3, !this.isEnclosingTypeSelected());
                if (!typeKindGroup.isEnabled(3) && typeKindGroup.isSelected(3)) {
                    this.fTypeKindStatus.setError(WizardMessages.NewTypeWizard_page1_error_script);
                } else {
                    this.fTypeKindStatus.setOK();
                }
            };
        }

        private boolean isRecordAvailable() {
            IType type = null;
            try {
                type = this.getJavaProject().findType("groovy.transform", "RecordType");
            }
            catch (Exception e) {
                GroovyPlugin.getDefault().logError("Error in New Groovy Type wizard", e);
            }
            return type != null;
        }

        private boolean isTraitAvailable() {
            IType type = null;
            try {
                type = this.getJavaProject().findType("groovy.transform", "Trait");
            }
            catch (Exception e) {
                GroovyPlugin.getDefault().logError("Error in New Groovy Type wizard", e);
            }
            return type != null;
        }

        protected void handleFieldChanged(String fieldName) {
            if (this.getEnclosingType() != null && !ContentTypeUtils.isGroovyLikeFileName((CharSequence)this.getEnclosingType().getResource().getName())) {
                ((StatusInfo)this.fEnclosingTypeStatus).setError(WizardMessages.NewTypeWizard_page1_error_java);
            }
            if ("NewTypeWizardPage.enclosing.selection".equals(fieldName)) {
                this.enclosingSelectionHandler.run();
            }
            super.handleFieldChanged(fieldName);
            this.updateStatus();
        }

        protected IStatus typeNameChanged() {
            IPackageFragmentRoot root;
            StatusInfo status = (StatusInfo)super.typeNameChanged();
            if (status.getSeverity() < 2 && (root = this.getPackageFragmentRoot()) != null) {
                try {
                    String name;
                    if (!this.getJavaProject().getProject().hasNature("org.eclipse.jdt.groovy.core.groovyNature")) {
                        status.setInfo(WizardMessages.bind((String)WizardMessages.NewTypeWizard_page1_info_groovyNature, (Object)this.getJavaProject().getElementName()));
                    }
                    if (ContentTypeUtils.isGroovyLikeFileName((CharSequence)(name = this.getTypeNameText()))) {
                        status.setInfo(WizardMessages.bind((String)WizardMessages.NewTypeWizard_page1_info_fileExtension, (Object)name.substring(name.lastIndexOf(46))));
                    }
                    if (!this.isEnclosingTypeSelected()) {
                        IType type;
                        IPath path;
                        ClasspathEntry entry = (ClasspathEntry)root.getRawClasspathEntry();
                        if (entry != null && Util.isExcluded((IPath)(path = this.getPackageFragment().getResource().getFullPath().append(this.getCompilationUnitName(this.getTypeNameWithoutParameters()))), (char[][])entry.fullInclusionPatternChars(), (char[][])entry.fullExclusionPatternChars(), (boolean)false)) {
                            status.setWarning(WizardMessages.NewTypeWizard_page1_warning_typeExcluded);
                        }
                        if ((type = this.getJavaProject().findType(this.getPackageFragment().getElementName(), this.getTypeNameWithoutParameters())) != null && type.exists()) {
                            status.setError(NewWizardMessages.NewTypeWizardPage_error_TypeNameExists);
                        }
                    }
                }
                catch (Exception e) {
                    GroovyPlugin.getDefault().logError("Error in New Groovy Type wizard", e);
                }
            }
            return status;
        }

        protected void updateStatus() {
            this.updateStatus(new IStatus[]{this.fContainerStatus, this.isEnclosingTypeSelected() ? this.fEnclosingTypeStatus : this.fPackageStatus, this.fTypeKindStatus, this.fTypeNameStatus});
        }

        protected String getCompilationUnitName(String typeName) {
            assert (typeName.indexOf(60) == -1);
            return String.valueOf(typeName) + ".groovy";
        }

        public String getTypeNameWithoutParameters() {
            return (String)ReflectionUtils.executePrivateMethod(NewTypeWizardPage.class, (String)"getTypeNameWithoutParameters", (Object)((Object)this));
        }

        public String getTypeNameText() {
            StringDialogField fTypeNameDialogField = (StringDialogField)ReflectionUtils.getPrivateField(NewTypeWizardPage.class, (String)"fTypeNameDialogField", (Object)((Object)this));
            return fTypeNameDialogField.getText();
        }

        public String getTypeName() {
            String typeName = this.getTypeNameText();
            if (ContentTypeUtils.isGroovyLikeFileName((CharSequence)typeName)) {
                return typeName.substring(0, typeName.lastIndexOf(46));
            }
            return typeName;
        }

        public String getSuperClass() {
            return Optional.ofNullable((PageTwo)this.getNextPage()).map(PageTwo::getSuperClass).orElse("");
        }

        public List<String> getSuperInterfaces() {
            return Optional.ofNullable((PageTwo)this.getNextPage()).map(PageTwo::getInterfaces).map(stringArray -> Arrays.asList(stringArray)).orElse(Collections.emptyList());
        }

        public boolean addSuperInterface(String name) {
            PageTwo pageTwo = (PageTwo)this.getNextPage();
            Function addInterface = (Function)pageTwo.getActiveControl().getData("AddInterface");
            return (Boolean)addInterface.apply(name);
        }

        public void setSuperInterfaces(List<String> names, boolean mutable) {
            PageTwo pageTwo = (PageTwo)this.getNextPage();
            if (pageTwo != null) {
                Consumer setInterfaces = (Consumer)pageTwo.getActiveControl().getData("SetInterfaces");
                setInterfaces.accept(names);
            }
        }

        public void setVisible(boolean visible) {
            super.setVisible(visible);
            if (visible) {
                this.setFocus();
            }
        }
    }

    public static class PageTwo
    extends WizardPage {
        public static final String PAGE_NAME = "NewTypeWizard.PageTwo";
        private Consumer<Boolean> onVisible;

        public PageTwo() {
            super(PAGE_NAME);
        }

        public void createControl(Composite parent) {
            this.initializeDialogUnits((Control)parent);
            this.onVisible = dontCare -> {
                switch (this.getTypeKind()) {
                    case "class": {
                        this.setTitle(WizardMessages.NewTypeWizard_page2_class_title);
                        this.setDescription(WizardMessages.NewTypeWizard_page2_class_message);
                        break;
                    }
                    case "trait": {
                        this.setTitle(WizardMessages.NewTypeWizard_page2_trait_title);
                        this.setDescription(WizardMessages.NewTypeWizard_page2_trait_message);
                        break;
                    }
                    case "record": {
                        this.setTitle(WizardMessages.NewTypeWizard_page2_record_title);
                        this.setDescription(WizardMessages.NewTypeWizard_page2_record_message);
                        break;
                    }
                    case "script": {
                        this.setTitle(WizardMessages.NewTypeWizard_page2_script_title);
                        this.setDescription(WizardMessages.NewTypeWizard_page2_script_message);
                        break;
                    }
                    case "interface": {
                        this.setTitle(WizardMessages.NewTypeWizard_page2_interface_title);
                        this.setDescription(WizardMessages.NewTypeWizard_page2_interface_message);
                        break;
                    }
                    case "@interface": {
                        this.setTitle(WizardMessages.NewTypeWizard_page2_annotation_title);
                        this.setDescription(WizardMessages.NewTypeWizard_page2_annotation_message);
                        break;
                    }
                    case "enum": {
                        this.setTitle(WizardMessages.NewTypeWizard_page2_enumeration_title);
                        this.setDescription(WizardMessages.NewTypeWizard_page2_enumeration_message);
                    }
                }
            };
            Composite composite = new Composite(parent, 0);
            StackLayout layout = new StackLayout();
            composite.setLayout((Layout)layout);
            this.createClassControls(composite);
            this.createTraitControls(composite);
            this.createRecordControls(composite);
            this.createScriptControls(composite);
            this.createInterfaceControls(composite);
            this.createAnnotationControls(composite);
            this.createEnumerationControls(composite);
            this.setControl((Control)composite);
            Dialog.applyDialogFont((Control)composite);
            layout.topControl = composite.getChildren()[0];
        }

        private void createClassControls(Composite parent) {
            int nColumns = 4;
            Composite composite = new Composite(parent, 0);
            composite.setData("TypeKind", (Object)"class");
            GridLayout layout = new GridLayout(4, false);
            composite.setLayout((Layout)layout);
            LinkedHashMap<String, Integer> modifiers = new LinkedHashMap<String, Integer>();
            modifiers.put(NewWizardMessages.NewTypeWizardPage_modifiers_public, 1);
            modifiers.put(NewWizardMessages.NewTypeWizardPage_modifiers_default, 0);
            modifiers.put(NewWizardMessages.NewTypeWizardPage_modifiers_private, 2);
            modifiers.put(NewWizardMessages.NewTypeWizardPage_modifiers_protected, 4);
            modifiers.put(NewWizardMessages.NewTypeWizardPage_modifiers_abstract, 1024);
            modifiers.put(NewWizardMessages.NewTypeWizardPage_modifiers_final, 16);
            modifiers.put(NewWizardMessages.NewTypeWizardPage_modifiers_static, 8);
            this.createModifierControls(composite, 4, modifiers);
            this.createSuperClassControls(composite, 4, NewWizardMessages.NewTypeWizardPage_superclass_label, "java.lang.Object");
            this.createSuperInterfacesControls(composite, 4);
            this.createMethodStubSelectionControls(composite, 4);
            this.createCommentControls(composite, 4);
        }

        private void createTraitControls(Composite parent) {
            int nColumns = 4;
            Composite composite = new Composite(parent, 0);
            composite.setData("TypeKind", (Object)"trait");
            GridLayout layout = new GridLayout();
            layout.numColumns = 4;
            composite.setLayout((Layout)layout);
            LinkedHashMap<String, Integer> modifiers = new LinkedHashMap<String, Integer>();
            modifiers.put(NewWizardMessages.NewTypeWizardPage_modifiers_public, 1);
            modifiers.put(NewWizardMessages.NewTypeWizardPage_modifiers_default, 0);
            modifiers.put(NewWizardMessages.NewTypeWizardPage_modifiers_private, 2);
            modifiers.put(NewWizardMessages.NewTypeWizardPage_modifiers_protected, 4);
            this.createModifierControls(composite, 4, modifiers);
            this.createSuperClassControls(composite, 4, WizardMessages.NewTypeWizard_page2_selftype_label, "java.lang.Object");
            this.createSuperInterfacesControls(composite, 4);
            this.createCommentControls(composite, 4);
        }

        private void createRecordControls(Composite parent) {
            int nColumns = 4;
            Composite composite = new Composite(parent, 0);
            composite.setData("TypeKind", (Object)"record");
            GridLayout layout = new GridLayout();
            layout.numColumns = 4;
            composite.setLayout((Layout)layout);
            LinkedHashMap<String, Integer> modifiers = new LinkedHashMap<String, Integer>();
            modifiers.put(NewWizardMessages.NewTypeWizardPage_modifiers_public, 1);
            modifiers.put(NewWizardMessages.NewTypeWizardPage_modifiers_default, 0);
            modifiers.put(NewWizardMessages.NewTypeWizardPage_modifiers_private, 2);
            modifiers.put(NewWizardMessages.NewTypeWizardPage_modifiers_protected, 4);
            this.createModifierControls(composite, 4, modifiers);
            this.createSuperInterfacesControls(composite, 4);
            this.createCommentControls(composite, 4);
        }

        private void createScriptControls(Composite parent) {
            int nColumns = 4;
            Composite composite = new Composite(parent, 0);
            composite.setData("TypeKind", (Object)"script");
            GridLayout layout = new GridLayout();
            layout.numColumns = 4;
            composite.setLayout((Layout)layout);
            this.createSuperClassControls(composite, 4, WizardMessages.NewTypeWizard_page2_basescript_label, "groovy.lang.Script");
            this.createCommentControls(composite, 4);
        }

        private void createInterfaceControls(Composite parent) {
            int nColumns = 4;
            Composite composite = new Composite(parent, 0);
            composite.setData("TypeKind", (Object)"interface");
            GridLayout layout = new GridLayout();
            layout.numColumns = 4;
            composite.setLayout((Layout)layout);
            LinkedHashMap<String, Integer> modifiers = new LinkedHashMap<String, Integer>();
            modifiers.put(NewWizardMessages.NewTypeWizardPage_modifiers_public, 1);
            modifiers.put(NewWizardMessages.NewTypeWizardPage_modifiers_default, 0);
            modifiers.put(NewWizardMessages.NewTypeWizardPage_modifiers_private, 2);
            modifiers.put(NewWizardMessages.NewTypeWizardPage_modifiers_protected, 4);
            this.createModifierControls(composite, 4, modifiers);
            this.createSuperInterfacesControls(composite, 4);
            this.createCommentControls(composite, 4);
        }

        private void createAnnotationControls(Composite parent) {
            int nColumns = 4;
            Composite composite = new Composite(parent, 0);
            composite.setData("TypeKind", (Object)"@interface");
            GridLayout layout = new GridLayout();
            layout.numColumns = 4;
            composite.setLayout((Layout)layout);
            LinkedHashMap<String, Integer> modifiers = new LinkedHashMap<String, Integer>();
            modifiers.put(NewWizardMessages.NewTypeWizardPage_modifiers_public, 1);
            modifiers.put(NewWizardMessages.NewTypeWizardPage_modifiers_default, 0);
            modifiers.put(NewWizardMessages.NewTypeWizardPage_modifiers_private, 2);
            modifiers.put(NewWizardMessages.NewTypeWizardPage_modifiers_protected, 4);
            this.createModifierControls(composite, 4, modifiers);
            this.createSeparator(composite, 4);
            NewAnnotationWizardPage delegate = new NewAnnotationWizardPage();
            ReflectionUtils.executePrivateMethod(NewAnnotationWizardPage.class, (String)"createAddAnnotationControls", (Class[])new Class[]{Composite.class, Integer.TYPE}, (Object)delegate, (Object[])new Object[]{composite, 4});
            ReflectionUtils.executePrivateMethod(NewAnnotationWizardPage.class, (String)"initAnnotationPage", (Object)delegate);
            this.createSeparator(composite, 4);
            this.createCommentControls(composite, 4);
            composite.setData("AnnotationDelegate", (Object)delegate);
        }

        private void createEnumerationControls(Composite parent) {
            int nColumns = 4;
            Composite composite = new Composite(parent, 0);
            composite.setData("TypeKind", (Object)"enum");
            GridLayout layout = new GridLayout();
            layout.numColumns = 4;
            composite.setLayout((Layout)layout);
            LinkedHashMap<String, Integer> modifiers = new LinkedHashMap<String, Integer>();
            modifiers.put(NewWizardMessages.NewTypeWizardPage_modifiers_public, 1);
            modifiers.put(NewWizardMessages.NewTypeWizardPage_modifiers_default, 0);
            modifiers.put(NewWizardMessages.NewTypeWizardPage_modifiers_private, 2);
            modifiers.put(NewWizardMessages.NewTypeWizardPage_modifiers_protected, 4);
            this.createModifierControls(composite, 4, modifiers);
            this.createSuperInterfacesControls(composite, 4);
            this.createCommentControls(composite, 4);
        }

        private void createModifierControls(Composite composite, int nColumns, Map<String, Integer> modifiers) {
            ArrayList<String> accessFlags = new ArrayList<String>();
            ArrayList<String> otherFlags = new ArrayList<String>();
            for (Map.Entry<String, Integer> entry : modifiers.entrySet()) {
                switch (entry.getValue()) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 4: {
                        accessFlags.add(entry.getKey());
                        break;
                    }
                    default: {
                        otherFlags.add(entry.getKey());
                    }
                }
            }
            SelectionButtonDialogFieldGroup accessFlagsGroup = new SelectionButtonDialogFieldGroup(16, accessFlags.toArray(new String[accessFlags.size()]), 4);
            accessFlagsGroup.setLabelText(NewWizardMessages.NewTypeWizardPage_modifiers_acc_label);
            Label label = accessFlagsGroup.getLabelControl(composite);
            GridDataFactory.fillDefaults().span(1, 1).applyTo((Control)label);
            Composite group = accessFlagsGroup.getSelectionButtonsGroup(composite);
            GridDataFactory.fillDefaults().span(nColumns - 2, 1).applyTo((Control)group);
            DialogField.createEmptySpace((Composite)composite);
            SelectionButtonDialogFieldGroup otherFlagsGroup = new SelectionButtonDialogFieldGroup(32, otherFlags.toArray(new String[otherFlags.size()]), 4);
            if (!otherFlags.isEmpty()) {
                DialogField.createEmptySpace((Composite)composite);
                group = otherFlagsGroup.getSelectionButtonsGroup(composite);
                GridDataFactory.fillDefaults().span(nColumns - 2, 1).applyTo((Control)group);
                DialogField.createEmptySpace((Composite)composite);
            }
            IDialogFieldListener listener = field -> {
                int flags = 0;
                int i = 0;
                int n = accessFlags.size();
                while (i < n) {
                    if (accessFlagsGroup.isEnabled(i) && accessFlagsGroup.isSelected(i)) {
                        flags |= ((Integer)modifiers.get(accessFlags.get(i))).intValue();
                        break;
                    }
                    ++i;
                }
                i = 0;
                n = otherFlags.size();
                while (i < n) {
                    if (otherFlagsGroup.isEnabled(i) && otherFlagsGroup.isSelected(i)) {
                        flags |= ((Integer)modifiers.get(otherFlags.get(i))).intValue();
                    }
                    ++i;
                }
                composite.setData("TypeFlags", (Object)flags);
                StatusInfo status = new StatusInfo();
                if (Flags.isFinal((int)flags) && Flags.isAbstract((int)flags)) {
                    status.setError(NewWizardMessages.NewTypeWizardPage_error_ModifiersFinalAndAbstract);
                }
                this.mergeStatus("TypeFlags", (IStatus)status);
            };
            accessFlagsGroup.setDialogFieldListener(listener);
            otherFlagsGroup.setDialogFieldListener(listener);
            this.onVisible = this.onVisible.andThen(isInner -> {
                for (Map.Entry entry : modifiers.entrySet()) {
                    switch ((Integer)entry.getValue()) {
                        case 2: 
                        case 4: {
                            accessFlagsGroup.enableSelectionButton(accessFlags.indexOf(entry.getKey()), isInner.booleanValue());
                            break;
                        }
                        case 8: {
                            otherFlagsGroup.enableSelectionButton(otherFlags.indexOf(entry.getKey()), isInner.booleanValue());
                        }
                    }
                }
            });
        }

        private void createSuperClassControls(Composite composite, int nColumns, String label, String value) {
            StringButtonDialogField superClassDialogField = new StringButtonDialogField(field -> {
                IType type = (IType)ReflectionUtils.executePrivateMethod(NewTypeWizardPage.class, (String)"chooseSuperClass", (Object)this.getPreviousPage());
                if (type != null) {
                    ((StringButtonDialogField)field).setText(SuperInterfaceSelectionDialog.getNameWithTypeParameters((IType)type));
                }
            });
            superClassDialogField.setDialogFieldListener(field -> {
                StatusInfo status = new StatusInfo();
                String typeName = ((StringButtonDialogField)field).getText();
                if (!typeName.isEmpty()) {
                    Type type = TypeContextChecker.parseSuperClass((String)typeName);
                    if (type == null) {
                        status.setError(NewWizardMessages.NewTypeWizardPage_error_InvalidSuperClassName);
                    } else if (type instanceof ParameterizedType && !JavaModelUtil.is50OrHigher((IJavaProject)this.getJavaProject())) {
                        status.setError(NewWizardMessages.NewTypeWizardPage_error_SuperClassNotParameterized);
                    }
                }
                composite.setData("SuperClass", (Object)typeName);
                this.mergeStatus("SuperClass", (IStatus)status);
            });
            superClassDialogField.setText(value);
            superClassDialogField.setLabelText(label);
            superClassDialogField.setButtonLabel(NewWizardMessages.NewTypeWizardPage_superclass_button);
            superClassDialogField.doFillIntoGrid(composite, nColumns);
            Text text = superClassDialogField.getTextControl(null);
            LayoutUtil.setHorizontalGrabbing((Control)text);
            LayoutUtil.setWidthHint((Control)text, (int)this.getMaxFieldWidth());
            TextFieldNavigationHandler.install((Text)text);
            BidiUtils.applyBidiProcessing((Text)text, (String)"java");
            JavaTypeCompletionProcessor superClassCompletionProcessor = new JavaTypeCompletionProcessor(false, false, true);
            superClassCompletionProcessor.setCompletionContextRequestor(new CompletionContextRequestor(){
                private StubTypeContext fSuperClassStubTypeContext;

                public StubTypeContext getStubTypeContext() {
                    if (this.fSuperClassStubTypeContext == null) {
                        PageOne pageOne = (PageOne)this.getPreviousPage();
                        this.fSuperClassStubTypeContext = TypeContextChecker.createSuperClassStubTypeContext((String)pageOne.getTypeName(), (IType)pageOne.getEnclosingType(), (IPackageFragment)pageOne.getPackageFragment());
                    }
                    return this.fSuperClassStubTypeContext;
                }
            });
            ControlContentAssistHelper.createTextContentAssistant((Text)text, (IContentAssistProcessor)superClassCompletionProcessor);
        }

        private void createSuperInterfacesControls(Composite composite, int nColumns) {
            ListDialogField<Wrapper> superInterfacesDialogField = this.newListField(composite, nColumns);
            superInterfacesDialogField.setDialogFieldListener(field -> {
                StatusInfo status = new StatusInfo();
                ListDialogField listField = (ListDialogField)field;
                for (Wrapper element : listField.getElements()) {
                    String interfaceName = element.string;
                    Type type = TypeContextChecker.parseSuperInterface((String)interfaceName);
                    if (type == null) {
                        status.setError(WizardMessages.bind((String)NewWizardMessages.NewTypeWizardPage_error_InvalidSuperInterfaceName, (Object)BasicElementLabels.getJavaElementName((String)interfaceName)));
                        continue;
                    }
                    if (!(type instanceof ParameterizedType) || JavaModelUtil.is50OrHigher((IJavaProject)this.getJavaProject())) continue;
                    status.setError(WizardMessages.bind((String)NewWizardMessages.NewTypeWizardPage_error_SuperInterfaceNotParameterized, (Object)BasicElementLabels.getJavaElementName((String)interfaceName)));
                }
                this.mergeStatus("Interfaces", (IStatus)status);
            });
            Function<String, Boolean> addInterface = name -> superInterfacesDialogField.addElement((Object)new Wrapper((String)name));
            Consumer<List> setInterfaces = names -> superInterfacesDialogField.setElements((Collection)names.stream().map(Wrapper::new).collect(Collectors.toList()));
            Supplier<List> getInterfaces = () -> superInterfacesDialogField.getElements().stream().map(it -> it.string).collect(Collectors.toList());
            composite.setData("AddInterface", addInterface);
            composite.setData("SetInterfaces", setInterfaces);
            composite.setData("GetInterfaces", getInterfaces);
        }

        private ListDialogField<Wrapper> newListField(Composite composite, int nColumns) {
            String[] stringArray = new String[3];
            stringArray[0] = NewWizardMessages.NewTypeWizardPage_interfaces_add;
            stringArray[2] = NewWizardMessages.NewTypeWizardPage_interfaces_remove;
            String[] buttons = stringArray;
            IListAdapter<Wrapper> addButtonHandler = new IListAdapter<Wrapper>(){

                public void customButtonPressed(ListDialogField<Wrapper> listField, int index) {
                    ReflectionUtils.executePrivateMethod(NewTypeWizardPage.class, (String)"chooseSuperInterfaces", (Object)this.getPreviousPage());
                }

                public void selectionChanged(ListDialogField<Wrapper> field) {
                }

                public void doubleClicked(ListDialogField<Wrapper> field) {
                }
            };
            LabelProvider labelProvider = new LabelProvider(){

                public Image getImage(Object element) {
                    return JavaPluginImages.get((String)"org.eclipse.jdt.ui.int_obj.gif");
                }

                public String getText(Object element) {
                    return BasicElementLabels.getJavaElementName((String)((Wrapper)element).string);
                }
            };
            ListDialogField superInterfacesDialogField = new ListDialogField((IListAdapter)addButtonHandler, buttons, (ILabelProvider)labelProvider);
            superInterfacesDialogField.setLabelText(NewWizardMessages.NewTypeWizardPage_interfaces_class_label);
            superInterfacesDialogField.setTableColumns(new ListDialogField.ColumnsDescription(1, false));
            superInterfacesDialogField.setRemoveButtonIndex(2);
            Control[] controls = superInterfacesDialogField.doFillIntoGrid(composite, nColumns);
            GridData gd = (GridData)controls[1].getLayoutData();
            gd.grabExcessHorizontalSpace = true;
            gd.grabExcessVerticalSpace = false;
            gd.widthHint = this.getMaxFieldWidth();
            gd.heightHint = this.convertHeightInCharsToPixels(3);
            gd = (GridData)controls[2].getLayoutData();
            gd.grabExcessVerticalSpace = false;
            TableViewer tableViewer = superInterfacesDialogField.getTableViewer();
            tableViewer.setColumnProperties(new String[]{"interface"});
            this.setCellEditor((ListDialogField<Wrapper>)superInterfacesDialogField);
            this.setCellModifier((ListDialogField<Wrapper>)superInterfacesDialogField);
            this.setKeyListener((ListDialogField<Wrapper>)superInterfacesDialogField);
            return superInterfacesDialogField;
        }

        private void setCellEditor(ListDialogField<Wrapper> superInterfacesDialogField) {
            TableViewer tableViewer = superInterfacesDialogField.getTableViewer();
            TableTextCellEditor cellEditor = new TableTextCellEditor(tableViewer, 0){

                protected Control createControl(Composite parent) {
                    Control control = super.createControl(parent);
                    BidiUtils.applyBidiProcessing((Text)this.text, (String)"java");
                    return control;
                }

                protected void doSetFocus() {
                    if (this.text != null) {
                        this.text.setFocus();
                        this.text.setSelection(this.text.getText().length());
                        this.checkSelection();
                        this.checkDeleteable();
                        this.checkSelectable();
                    }
                }
            };
            Text cellEditorText = cellEditor.getText();
            TextFieldNavigationHandler.install((Text)cellEditorText);
            JavaTypeCompletionProcessor superInterfaceCompletionProcessor = new JavaTypeCompletionProcessor(false, false, true);
            superInterfaceCompletionProcessor.setCompletionContextRequestor(new CompletionContextRequestor(){
                private StubTypeContext fSuperInterfaceStubTypeContext;

                public StubTypeContext getStubTypeContext() {
                    if (this.fSuperInterfaceStubTypeContext == null) {
                        PageOne pageOne = (PageOne)this.getPreviousPage();
                        this.fSuperInterfaceStubTypeContext = TypeContextChecker.createSuperInterfaceStubTypeContext((String)pageOne.getTypeName(), (IType)pageOne.getEnclosingType(), (IPackageFragment)pageOne.getPackageFragment());
                    }
                    return this.fSuperInterfaceStubTypeContext;
                }
            });
            SubjectControlContentAssistant contentAssistant = ControlContentAssistHelper.createJavaContentAssistant((IContentAssistProcessor)superInterfaceCompletionProcessor);
            ContentAssistHandler.createHandlerForText((Text)cellEditorText, (SubjectControlContentAssistant)contentAssistant);
            cellEditor.setContentAssistant(contentAssistant);
            tableViewer.setCellEditors(new CellEditor[]{cellEditor});
        }

        private void setCellModifier(final ListDialogField<Wrapper> superInterfacesDialogField) {
            TableViewer tableViewer = superInterfacesDialogField.getTableViewer();
            tableViewer.setCellModifier(new ICellModifier(){

                public void modify(Object element, String property, Object value) {
                    if (element instanceof Item) {
                        element = ((Item)element).getData();
                    }
                    ((Wrapper)element).string = (String)value;
                    superInterfacesDialogField.elementChanged((Object)((Wrapper)element));
                }

                public Object getValue(Object element, String property) {
                    return ((Wrapper)element).string;
                }

                public boolean canModify(Object element, String property) {
                    return true;
                }
            });
        }

        private void setKeyListener(ListDialogField<Wrapper> superInterfacesDialogField) {
            final TableViewer tableViewer = superInterfacesDialogField.getTableViewer();
            tableViewer.getTable().addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent event) {
                    ISelection selection;
                    if (event.keyCode == 0x100000B && event.stateMask == 0 && (selection = tableViewer.getSelection()) instanceof IStructuredSelection) {
                        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                        tableViewer.editElement(structuredSelection.getFirstElement(), 0);
                    }
                }
            });
        }

        private void createMethodStubSelectionControls(Composite composite, int nColumns) {
            SelectionButtonDialogFieldGroup methodStubSelector = new SelectionButtonDialogFieldGroup(32, new String[]{NewWizardMessages.NewClassWizardPage_methods_constructors, NewWizardMessages.NewClassWizardPage_methods_inherited, WizardMessages.NewTypeWizard_page2_methods_main}, 1);
            methodStubSelector.setLabelText(NewWizardMessages.NewClassWizardPage_methods_label);
            IDialogSettings dialogSettings = this.getDialogSettings();
            if (dialogSettings != null && (dialogSettings = dialogSettings.getSection("NewClassWizardPage")) != null) {
                methodStubSelector.setSelection(0, dialogSettings.getBoolean("create_constructor"));
                methodStubSelector.setSelection(1, dialogSettings.getBoolean("create_unimplemented"));
            }
            composite.setData("StubControls", (Object)methodStubSelector);
            Label label = methodStubSelector.getLabelControl(composite);
            LayoutUtil.setHorizontalSpan((Control)label, (int)nColumns);
            DialogField.createEmptySpace((Composite)composite);
            Composite checks = methodStubSelector.getSelectionButtonsGroup(composite);
            LayoutUtil.setHorizontalSpan((Control)checks, (int)(nColumns - 1));
        }

        private void createCommentControls(Composite composite, int nColumns) {
            Link link = new Link(composite, 0);
            link.setText(NewWizardMessages.NewTypeWizardPage_addcomment_description);
            link.setLayoutData((Object)new GridData(4, 2, false, false, nColumns, 1));
            link.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent event) {
                    this.widgetSelected(event);
                }

                public void widgetSelected(SelectionEvent event) {
                    IJavaProject javaProject = this.getJavaProject();
                    if (javaProject != null) {
                        PreferenceDialog dialog = PreferencesUtil.createPropertyDialogOn((Shell)this.getShell(), (IAdaptable)javaProject.getProject(), (String)"org.eclipse.jdt.ui.propertyPages.CodeTemplatePreferencePage", null, null);
                        dialog.open();
                    } else {
                        MessageDialog.openInformation((Shell)this.getShell(), (String)NewWizardMessages.NewTypeWizardPage_configure_templates_title, (String)NewWizardMessages.NewTypeWizardPage_configure_templates_message);
                    }
                }
            });
            DialogField.createEmptySpace((Composite)composite);
            SelectionButtonDialogField addCommentCheckbox = new SelectionButtonDialogField(32);
            addCommentCheckbox.setLabelText(NewWizardMessages.NewTypeWizardPage_addcomment_label);
            addCommentCheckbox.setSelection(Boolean.valueOf(PreferenceConstants.getPreference((String)"org.eclipse.jdt.ui.javadoc", (IJavaProject)this.getJavaProject())).booleanValue());
            addCommentCheckbox.doFillIntoGrid(composite, nColumns - 1);
            composite.setData("AddComments", () -> ((SelectionButtonDialogField)addCommentCheckbox).isSelected());
        }

        private void createSeparator(Composite composite, int nColumns) {
            LayoutUtil.setHorizontalGrabbing((Control)new Separator(258).doFillIntoGrid(composite, nColumns, this.convertHeightInCharsToPixels(1))[0]);
        }

        private void mergeStatus(String key, IStatus value) {
            Control panel = this.getControl();
            if (panel != null) {
                HashMap<String, IStatus> map = (HashMap<String, IStatus>)panel.getData("StatusMap");
                if (map == null) {
                    map = new HashMap<String, IStatus>();
                    panel.setData("StatusMap", map);
                }
                map.put(key, value);
                IStatus status = StatusUtil.getMostSevere((IStatus[])map.values().toArray(new IStatus[0]));
                StatusUtil.applyToStatusLine((DialogPage)this, (IStatus)status);
                this.setPageComplete(status.getSeverity() < 4);
            }
        }

        private Control getActiveControl() {
            StackLayout stack = (StackLayout)((Composite)this.getControl()).getLayout();
            return stack.topControl;
        }

        private IJavaProject getJavaProject() {
            return ((PageOne)this.getPreviousPage()).getJavaProject();
        }

        private int getMaxFieldWidth() {
            return (Integer)ReflectionUtils.executePrivateMethod(NewContainerWizardPage.class, (String)"getMaxFieldWidth", (Object)this.getPreviousPage());
        }

        public String getTypeKind() {
            return (String)this.getActiveControl().getData("TypeKind");
        }

        public int getModifiers() {
            Integer modifiers = (Integer)this.getActiveControl().getData("TypeFlags");
            return modifiers != null ? modifiers : 1;
        }

        public String getSuperClass() {
            return (String)this.getActiveControl().getData("SuperClass");
        }

        public String[] getInterfaces() {
            Object getter = this.getActiveControl().getData("GetInterfaces");
            return getter == null ? null : ((List)((Supplier)getter).get()).toArray(new String[0]);
        }

        public boolean isAddComments() {
            return (Boolean)((Supplier)this.getActiveControl().getData("AddComments")).get();
        }

        public void setVisible(boolean visible) {
            if (visible) {
                PageOne pageOne = (PageOne)this.getPreviousPage();
                this.onVisible.accept(pageOne.isEnclosingTypeSelected());
            }
            super.setVisible(visible);
        }

        public static final class Wrapper {
            public String string;

            public Wrapper(String string) {
                this.string = Objects.requireNonNull(string);
            }

            public int hashCode() {
                return this.string.hashCode();
            }

            public boolean equals(Object that) {
                if (that == this) {
                    return true;
                }
                if (!(that instanceof Wrapper)) {
                    return false;
                }
                return ((Wrapper)that).string.equals(this.string);
            }
        }
    }
}

