/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.objectrepository.handler;

import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.WebElementTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.repository.WebElementEntity;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class RefreshTestObjectHandler {
    @Inject
    IEventBroker eventBroker;

    @PostConstruct
    public void registerEventHandler(IEventBroker eventBroker) {
        eventBroker.subscribe("EXPLORER/REFRESH_SELECTED_ITEM", new EventHandler(){

            public void handleEvent(Event event) {
                if (ProjectController.getInstance().getCurrentProject() == null) {
                    return;
                }
                Object object = event.getProperty("org.eclipse.e4.data");
                if (object != null && object instanceof WebElementTreeEntity) {
                    try {
                        RefreshTestObjectHandler.this.excute((WebElementTreeEntity)object);
                    }
                    catch (Exception e) {
                        LoggerSingleton.logError((Throwable)e);
                    }
                }
            }
        });
    }

    private void excute(WebElementTreeEntity testObjectTreeEntity) throws Exception {
        if (testObjectTreeEntity.getObject() == null) {
            ITreeEntity parentEntity = testObjectTreeEntity.getParent();
            if (parentEntity != null && parentEntity instanceof FolderTreeEntity) {
                this.eventBroker.post("EXPLORER/REFRESH_SELECTED_ITEM", (Object)parentEntity);
            } else {
                FolderEntity folder = FolderController.getInstance().getObjectRepositoryRoot(ProjectController.getInstance().getCurrentProject());
                this.eventBroker.post("EXPLORER/REFRESH_SELECTED_ITEM", (Object)new FolderTreeEntity(folder, null));
            }
        } else {
            WebElementEntity webElement = (WebElementEntity)testObjectTreeEntity.getObject();
            FolderController.getInstance().refreshFolder(webElement.getParentFolder());
        }
    }
}

